/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http;

import java.io.EOFException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;
import wvlet.airframe.control.CircuitBreakerOpenException;
import wvlet.airframe.control.ResultClass;
import wvlet.airframe.control.ResultClass$;
import wvlet.airframe.http.HttpClientException;
import wvlet.airframe.http.HttpResponseAdapter;
import wvlet.airframe.http.HttpStatus;
import wvlet.airframe.http.HttpStatus$BadRequest_400$;
import wvlet.airframe.http.HttpStatus$ClientClosedRequest_499$;
import wvlet.airframe.http.HttpStatus$Gone_410$;
import wvlet.airframe.http.HttpStatus$RequestTimeout_408$;
import wvlet.airframe.http.HttpStatus$ServiceUnavailable_503$;
import wvlet.airframe.http.HttpStatus$TooManyRequests_429$;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class HttpClientException$
implements LogSupport {
    public static final HttpClientException$ MODULE$ = new HttpClientException$();
    private static final Set<String> finagleRetryableExceptionClasses;
    private static Logger logger;
    private static volatile boolean bitmap$0;

    static {
        LoggingMethods.$init$((LoggingMethods)MODULE$);
        LazyLogger.$init$((LazyLogger)MODULE$);
        finagleRetryableExceptionClasses = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"com.twitter.finagle.ChannelClosedException", "com.twitter.finagle.ReadTimedOutException", "com.twitter.finagle.WriteTimedOutException"}));
    }

    private Logger logger$lzycompute() {
        HttpClientException$ httpClientException$ = this;
        synchronized (httpClientException$) {
            if (!bitmap$0) {
                logger = LazyLogger.logger$((LazyLogger)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private <Resp> HttpClientException requestFailure(Resp response, HttpResponseAdapter<Resp> adapter) {
        HttpStatus status = adapter.statusOf(response);
        String content = adapter.contentStringOf(response);
        if (content == null || content.isEmpty()) {
            return new HttpClientException(adapter.wrap(response), status);
        }
        return new HttpClientException(adapter.wrap(response), status, new StringBuilder(16).append("Request failed: ").append(content).toString());
    }

    public <Resp> ResultClass classifyHttpResponse(Resp response, HttpResponseAdapter<Resp> adapter) {
        HttpStatus status = adapter.statusOf(response);
        HttpStatus httpStatus = status;
        if (httpStatus.isSuccessful()) {
            return ResultClass.Succeeded$.MODULE$;
        }
        if (httpStatus.isServerError()) {
            ResultClass.Failed f = ResultClass$.MODULE$.retryableFailure((Throwable)this.requestFailure(response, adapter));
            HttpStatus httpStatus2 = status;
            HttpStatus$ServiceUnavailable_503$ httpStatus$ServiceUnavailable_503$ = HttpStatus$ServiceUnavailable_503$.MODULE$;
            if (!(httpStatus2 != null ? !httpStatus2.equals(httpStatus$ServiceUnavailable_503$) : httpStatus$ServiceUnavailable_503$ != null)) {
                return f.withExtraWaitFactor(0.5, f.withExtraWaitFactor$default$2());
            }
            return f;
        }
        if (httpStatus.isClientError()) {
            HttpStatus httpStatus3 = httpStatus;
            if (HttpStatus$BadRequest_400$.MODULE$.equals(httpStatus3) && this.isRetryable400ErrorMessage(adapter.contentStringOf(response))) {
                return ResultClass$.MODULE$.retryableFailure((Throwable)this.requestFailure(response, adapter));
            }
            if (HttpStatus$RequestTimeout_408$.MODULE$.equals(httpStatus3)) {
                return ResultClass$.MODULE$.retryableFailure((Throwable)this.requestFailure(response, adapter));
            }
            if (HttpStatus$Gone_410$.MODULE$.equals(httpStatus3)) {
                return ResultClass$.MODULE$.retryableFailure((Throwable)this.requestFailure(response, adapter));
            }
            if (HttpStatus$TooManyRequests_429$.MODULE$.equals(httpStatus3)) {
                return ResultClass$.MODULE$.retryableFailure((Throwable)this.requestFailure(response, adapter));
            }
            if (HttpStatus$ClientClosedRequest_499$.MODULE$.equals(httpStatus3)) {
                return ResultClass$.MODULE$.retryableFailure((Throwable)this.requestFailure(response, adapter));
            }
            return ResultClass$.MODULE$.nonRetryableFailure((Throwable)this.requestFailure(response, adapter));
        }
        return ResultClass$.MODULE$.nonRetryableFailure((Throwable)this.requestFailure(response, adapter));
    }

    private boolean isRetryable400ErrorMessage(String m) {
        .colon.colon retriable400ErrorMessage = new .colon.colon((Object)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("Idle connections will be closed")), (List)Nil$.MODULE$);
        return retriable400ErrorMessage.find((Function1 & Serializable)pattern -> BoxesRunTime.boxToBoolean((boolean)HttpClientException$.$anonfun$isRetryable400ErrorMessage$1(m, pattern))).isDefined();
    }

    public ResultClass.Failed classifyExecutionFailure(Throwable ex) {
        return (ResultClass.Failed)this.executionFailureClassifier().applyOrElse((Object)ex, this.nonRetryable());
    }

    public ResultClass.Failed classifyExecutionFailureScalaJS(Throwable ex) {
        return (ResultClass.Failed)this.scalajsCompatibleFailureClassifier().orElse(this.rootCauseExceptionClassifierScalaJS()).applyOrElse((Object)ex, this.nonRetryable());
    }

    public PartialFunction<Throwable, ResultClass.Failed> executionFailureClassifier() {
        return this.scalajsCompatibleFailureClassifier().orElse(this.connectionExceptionClassifier()).orElse(this.sslExceptionClassifier()).orElse(this.rootCauseExceptionClassifier());
    }

    public PartialFunction<Throwable, ResultClass.Failed> scalajsCompatibleFailureClassifier() {
        return new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof CircuitBreakerOpenException) {
                    CircuitBreakerOpenException circuitBreakerOpenException = (CircuitBreakerOpenException)A1;
                    return (B1)ResultClass$.MODULE$.nonRetryableFailure((Throwable)circuitBreakerOpenException);
                }
                if (A1 instanceof EOFException) {
                    EOFException eOFException = (EOFException)A1;
                    return (B1)ResultClass$.MODULE$.retryableFailure((Throwable)eOFException);
                }
                if (A1 instanceof TimeoutException) {
                    TimeoutException timeoutException = (TimeoutException)A1;
                    return (B1)ResultClass$.MODULE$.retryableFailure((Throwable)timeoutException);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof CircuitBreakerOpenException) {
                    return true;
                }
                if (throwable instanceof EOFException) {
                    return true;
                }
                return throwable instanceof TimeoutException;
            }
        };
    }

    public PartialFunction<Throwable, ResultClass.Failed> connectionExceptionClassifier() {
        return new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                if (A12 instanceof InterruptedException) {
                    InterruptedException interruptedException = (InterruptedException)A12;
                    return (B1)ResultClass$.MODULE$.retryableFailure((Throwable)interruptedException);
                }
                if (A12 instanceof ProtocolException) {
                    ProtocolException protocolException = (ProtocolException)A12;
                    return (B1)ResultClass$.MODULE$.retryableFailure((Throwable)protocolException);
                }
                if (A12 instanceof ConnectException) {
                    ConnectException connectException = (ConnectException)A12;
                    return (B1)ResultClass$.MODULE$.retryableFailure((Throwable)connectException);
                }
                if (A12 instanceof ClosedChannelException) {
                    ClosedChannelException closedChannelException = (ClosedChannelException)A12;
                    return (B1)ResultClass$.MODULE$.retryableFailure((Throwable)closedChannelException);
                }
                if (A12 instanceof SocketTimeoutException) {
                    SocketTimeoutException socketTimeoutException = (SocketTimeoutException)A12;
                    return (B1)ResultClass$.MODULE$.retryableFailure((Throwable)socketTimeoutException);
                }
                if (A12 instanceof SocketException) {
                    SocketException socketException = (SocketException)A12;
                    SocketException socketException2 = socketException;
                    if (socketException2 instanceof BindException) {
                        return (B1)ResultClass$.MODULE$.retryableFailure((Throwable)socketException);
                    }
                    if (socketException2 instanceof ConnectException) {
                        return (B1)ResultClass$.MODULE$.retryableFailure((Throwable)socketException);
                    }
                    if (socketException2 instanceof NoRouteToHostException) {
                        return (B1)ResultClass$.MODULE$.retryableFailure((Throwable)socketException);
                    }
                    if (socketException2 instanceof PortUnreachableException) {
                        return (B1)ResultClass$.MODULE$.retryableFailure((Throwable)socketException);
                    }
                    String string = socketException2.getMessage();
                    String string2 = "Socket closed";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return (B1)ResultClass$.MODULE$.retryableFailure((Throwable)socketException);
                    }
                    return (B1)ResultClass$.MODULE$.nonRetryableFailure((Throwable)socketException);
                }
                if (A12 != null && HttpClientException$.MODULE$.isRetryableFinagleException(A1 = A12)) {
                    return (B1)ResultClass$.MODULE$.retryableFailure(A1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable;
                Throwable throwable2 = x1;
                if (throwable2 instanceof InterruptedException) {
                    return true;
                }
                if (throwable2 instanceof ProtocolException) {
                    return true;
                }
                if (throwable2 instanceof ConnectException) {
                    return true;
                }
                if (throwable2 instanceof ClosedChannelException) {
                    return true;
                }
                if (throwable2 instanceof SocketTimeoutException) {
                    return true;
                }
                if (throwable2 instanceof SocketException) {
                    return true;
                }
                return throwable2 != null && HttpClientException$.MODULE$.isRetryableFinagleException(throwable = throwable2);
            }
        };
    }

    public Set<String> finagleRetryableExceptionClasses() {
        return finagleRetryableExceptionClasses;
    }

    public boolean isRetryableFinagleException(Throwable e) {
        return this.iter$1(e);
    }

    public PartialFunction<Throwable, ResultClass.Failed> sslExceptionClassifier() {
        return new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof SSLException) {
                    SSLException sSLException = (SSLException)A1;
                    SSLException sSLException2 = sSLException;
                    if (sSLException2 instanceof SSLHandshakeException) {
                        return (B1)ResultClass$.MODULE$.nonRetryableFailure((Throwable)sSLException);
                    }
                    if (sSLException2 instanceof SSLKeyException) {
                        return (B1)ResultClass$.MODULE$.nonRetryableFailure((Throwable)sSLException);
                    }
                    if (sSLException2 instanceof SSLPeerUnverifiedException) {
                        return (B1)ResultClass$.MODULE$.nonRetryableFailure((Throwable)sSLException);
                    }
                    return (B1)ResultClass$.MODULE$.retryableFailure((Throwable)sSLException);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof SSLException;
            }
        };
    }

    public PartialFunction<Throwable, ResultClass.Failed> rootCauseExceptionClassifier() {
        return new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ExecutionException executionException;
                A1 A1 = x1;
                if (A1 instanceof ExecutionException && (executionException = (ExecutionException)A1).getCause() != null) {
                    return (B1)HttpClientException$.MODULE$.classifyExecutionFailure(executionException.getCause());
                }
                if (A1 instanceof InvocationTargetException) {
                    InvocationTargetException invocationTargetException = (InvocationTargetException)A1;
                    return (B1)HttpClientException$.MODULE$.classifyExecutionFailure(invocationTargetException.getTargetException());
                }
                if (A1.getCause() != null) {
                    return (B1)HttpClientException$.MODULE$.classifyExecutionFailure(A1.getCause());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                ExecutionException executionException;
                Throwable throwable = x1;
                if (throwable instanceof ExecutionException && (executionException = (ExecutionException)throwable).getCause() != null) {
                    return true;
                }
                if (throwable instanceof InvocationTargetException) {
                    return true;
                }
                return throwable.getCause() != null;
            }
        };
    }

    public PartialFunction<Throwable, ResultClass.Failed> rootCauseExceptionClassifierScalaJS() {
        return new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ExecutionException executionException;
                A1 A1 = x1;
                if (A1 instanceof ExecutionException && (executionException = (ExecutionException)A1).getCause() != null) {
                    return (B1)HttpClientException$.MODULE$.classifyExecutionFailureScalaJS(executionException.getCause());
                }
                if (A1.getCause() != null) {
                    return (B1)HttpClientException$.MODULE$.classifyExecutionFailureScalaJS(A1.getCause());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                ExecutionException executionException;
                Throwable throwable = x1;
                if (throwable instanceof ExecutionException && (executionException = (ExecutionException)throwable).getCause() != null) {
                    return true;
                }
                return throwable.getCause() != null;
            }
        };
    }

    public Function1<Throwable, ResultClass.Failed> nonRetryable() {
        return (Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            return ResultClass$.MODULE$.nonRetryableFailure(throwable);
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpClientException$.class);
    }

    public static final /* synthetic */ boolean $anonfun$isRetryable400ErrorMessage$1(String m$1, Regex pattern) {
        return pattern.findFirstIn((CharSequence)m$1).isDefined();
    }

    private final boolean iter$1(Object cl) {
        while (true) {
            Class<?> clazz;
            Class<?> clazz2;
            if ((clazz2 = cl) == null) {
                return false;
            }
            if (clazz2 instanceof Throwable) {
                Throwable throwable = (Throwable)((Object)clazz2);
                cl = throwable.getClass();
                continue;
            }
            if (!(clazz2 instanceof Class) || !Throwable.class.isAssignableFrom(clazz = clazz2)) break;
            if (this.finagleRetryableExceptionClasses().contains((Object)clazz.getName())) {
                return true;
            }
            cl = clazz.getSuperclass();
        }
        return false;
    }

    private HttpClientException$() {
    }
}

