/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.control;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicLong;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import wvlet.airframe.control.HealthCheckPolicy;
import wvlet.airframe.control.util.ExponentialMovingAverage;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class HealthCheckPolicy$
implements LogSupport {
    public static final HealthCheckPolicy$ MODULE$ = new HealthCheckPolicy$();
    private static Logger logger;
    private static volatile boolean bitmap$0;

    static {
        LoggingMethods.$init$((LoggingMethods)MODULE$);
        LazyLogger.$init$((LazyLogger)MODULE$);
    }

    private Logger logger$lzycompute() {
        HealthCheckPolicy$ healthCheckPolicy$ = this;
        synchronized (healthCheckPolicy$) {
            if (!bitmap$0) {
                logger = LazyLogger.logger$((LazyLogger)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public HealthCheckPolicy alwaysHealthy() {
        return new HealthCheckPolicy(){

            public boolean isAlive() {
                return HealthCheckPolicy.isAlive$(this);
            }

            public boolean isMarkedDead() {
                return false;
            }

            public void recordSuccess() {
            }

            public void recordFailure() {
            }

            public void recovered() {
            }
            {
                HealthCheckPolicy.$init$(this);
            }
        };
    }

    public HealthCheckPolicy markDeadOnConsecutiveFailures(int numFailures) {
        return new HealthCheckPolicy(numFailures){
            private final AtomicLong consecutiveFailures;
            private final int numFailures$1;

            public boolean isAlive() {
                return HealthCheckPolicy.isAlive$(this);
            }

            private AtomicLong consecutiveFailures() {
                return this.consecutiveFailures;
            }

            public boolean isMarkedDead() {
                return this.consecutiveFailures().get() >= (long)this.numFailures$1;
            }

            public void recordSuccess() {
                this.consecutiveFailures().set(0L);
            }

            public void recordFailure() {
                this.consecutiveFailures().incrementAndGet();
            }

            public void recovered() {
                this.consecutiveFailures().set(0L);
            }
            {
                this.numFailures$1 = numFailures$1;
                HealthCheckPolicy.$init$(this);
                this.consecutiveFailures = new AtomicLong(0L);
            }
        };
    }

    public HealthCheckPolicy markDeadOnRecentFailureRate(double failureRate, long timeWindowMillis) {
        return new HealthCheckPolicy(timeWindowMillis, failureRate){
            private final ExponentialMovingAverage failureRateEMA;
            private final double failureRate$1;

            public boolean isAlive() {
                return HealthCheckPolicy.isAlive$(this);
            }

            private ExponentialMovingAverage failureRateEMA() {
                return this.failureRateEMA;
            }

            public boolean isMarkedDead() {
                return this.failureRateEMA().last() > this.failureRate$1;
            }

            public void recordSuccess() {
                this.failureRateEMA().update(System.currentTimeMillis(), 0.0);
            }

            public void recordFailure() {
                this.failureRateEMA().update(System.currentTimeMillis(), 1.0);
            }

            public void recovered() {
                this.failureRateEMA().reset();
            }
            {
                this.failureRate$1 = failureRate$1;
                HealthCheckPolicy.$init$(this);
                this.failureRateEMA = new ExponentialMovingAverage(timeWindowMillis$1);
            }
        };
    }

    public HealthCheckPolicy markDeadOnFailureThreshold(int numFailures, int numExecutions) {
        Predef$.MODULE$.require(numExecutions > 0, (Function0 & Serializable)() -> new StringBuilder(38).append("numExecusions ").append(numExecutions).append(" should be larger than 0").toString());
        Predef$.MODULE$.require(numFailures <= numExecutions, (Function0 & Serializable)() -> new StringBuilder(47).append("numFailures ").append(numFailures).append(" should be less than numExections(").append(numExecutions).append(")").toString());
        return new HealthCheckPolicy(numExecutions, numFailures){
            private final int arraySize;
            private final long[] executionHistory;
            private long executionCount;
            private final int numExecutions$1;
            private final int numFailures$2;

            public boolean isAlive() {
                return HealthCheckPolicy.isAlive$(this);
            }

            private int arraySize() {
                return this.arraySize;
            }

            private long[] executionHistory() {
                return this.executionHistory;
            }

            private long executionCount() {
                return this.executionCount;
            }

            private void executionCount_$eq(long x$1) {
                this.executionCount = x$1;
            }

            private int failureCount() {
                return BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps(this.executionHistory()), (Function1)(JFunction1.mcIJ.sp & Serializable)x$1 -> Long.bitCount(x$1), (ClassTag)ClassTag$.MODULE$.Int())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }

            public boolean isMarkedDead() {
                if (this.executionCount() < (long)this.numExecutions$1) {
                    return false;
                }
                return this.failureCount() >= this.numFailures$2;
            }

            private void setAndMove(boolean v) {
                int i = (int)(this.executionCount() % (long)this.numExecutions$1);
                long mask = 1L << 63 - i % 64;
                if (v) {
                    int n = i / 64;
                    this.executionHistory()[n] = this.executionHistory()[n] | mask;
                } else {
                    int n = i / 64;
                    this.executionHistory()[n] = this.executionHistory()[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                }
                this.executionCount_$eq(this.executionCount() + 1L);
                if (this.executionCount() < 0L) {
                    this.executionCount_$eq(this.numExecutions$1);
                    return;
                }
            }

            public void recordSuccess() {
                this.setAndMove(false);
            }

            public void recordFailure() {
                this.setAndMove(true);
            }

            public void recovered() {
                this.executionCount_$eq(0L);
            }
            {
                this.numExecutions$1 = numExecutions$1;
                this.numFailures$2 = numFailures$2;
                HealthCheckPolicy.$init$(this);
                this.arraySize = (numExecutions$1 + 64 - 1) / 64;
                this.executionHistory = (long[])Array$.MODULE$.fill(this.arraySize(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long());
                this.executionCount = 0L;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$executionHistory$1(), $anonfun$failureCount$1(long )}, serializedLambda);
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HealthCheckPolicy$.class);
    }

    private HealthCheckPolicy$() {
    }
}

