/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.metrics;

import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import wvlet.airframe.metrics.TimeStampFormatter$;
import wvlet.airframe.metrics.TimeWindow$;
import wvlet.airframe.metrics.TimeWindowBuilder;
import wvlet.airframe.metrics.TimeWindowUnit;
import wvlet.airframe.metrics.TimeWindowUnit$Day$;
import wvlet.airframe.metrics.TimeWindowUnit$Hour$;
import wvlet.airframe.metrics.TimeWindowUnit$Minute$;
import wvlet.airframe.metrics.TimeWindowUnit$Month$;
import wvlet.airframe.metrics.TimeWindowUnit$Quarter$;
import wvlet.airframe.metrics.TimeWindowUnit$Second$;
import wvlet.airframe.metrics.TimeWindowUnit$Week$;
import wvlet.airframe.metrics.TimeWindowUnit$Year$;

@ScalaSignature(bytes="\u0006\u0005\tub\u0001B\u001b7\u0001vB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t;\u0002\u0011\t\u0012)A\u0005+\"Aa\f\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005`\u0001\tE\t\u0015!\u0003V\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u00151\u0007\u0001\"\u0003h\u0011\u0015Y\u0007\u0001\"\u0003h\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u0015\t\b\u0001\"\u0001n\u0011\u0015\u0011\b\u0001\"\u0001n\u0011\u0015\u0019\b\u0001\"\u0001n\u0011\u0015!\b\u0001\"\u0011v\u0011\u0015a\b\u0001\"\u0001~\u0011\u001d\t9\u0001\u0001C\u0005\u0003\u0013Aq!!\t\u0001\t\u0003\t\u0019\u0003C\u0004\u0002&\u0001!\t!a\t\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002$!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005\r\u0002bBA\u0016\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003g\u0001A\u0011AA\u001b\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fAq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002F\u0001!\t!a\u0013\t\r\u0005U\u0003\u0001\"\u0001n\u0011\u0019\t9\u0006\u0001C\u0001[\"1\u0011\u0011\f\u0001\u0005\u00025Da!a\u0017\u0001\t\u0003i\u0007BBA/\u0001\u0011\u0005Q\u000e\u0003\u0004\u0002`\u0001!\t!\u001c\u0005\u0007\u0003C\u0002A\u0011A7\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002f!I\u0011\u0011\u000f\u0001\u0002\u0002\u0013\u0005\u00111\u000f\u0005\n\u0003s\u0002\u0011\u0013!C\u0001\u0003wB\u0011\"!%\u0001#\u0003%\t!a\u001f\t\u0013\u0005M\u0005!!A\u0005B\u0005U\u0005\"CAL\u0001\u0005\u0005I\u0011AAM\u0011%\t\t\u000bAA\u0001\n\u0003\t\u0019\u000bC\u0005\u00020\u0002\t\t\u0011\"\u0011\u00022\"I\u0011q\u0018\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0019\u0005\n\u0003\u000b\u0004\u0011\u0011!C!\u0003\u000fD\u0011\"a3\u0001\u0003\u0003%\t%!4\t\u0013\u0005=\u0007!!A\u0005B\u0005EwaBAkm!\u0005\u0011q\u001b\u0004\u0007kYB\t!!7\t\r\u0001dC\u0011AAt\u0011\u001d\tI\u000f\fC\u0001\u0003WDq!!;-\t\u0003\u0011)\u0001C\u0004\u0003\u00121\"\tAa\u0005\t\u000f\tUA\u0006\"\u0001\u0003\u0014!I!q\u0003\u0017\u0002\u0002\u0013\u0005%\u0011\u0004\u0005\n\u0005?a\u0013\u0011!CA\u0005CA\u0011Ba\r-\u0003\u0003%IA!\u000e\u0003\u0015QKW.Z,j]\u0012|wO\u0003\u00028q\u00059Q.\u001a;sS\u000e\u001c(BA\u001d;\u0003!\t\u0017N\u001d4sC6,'\"A\u001e\u0002\u000b]4H.\u001a;\u0004\u0001M!\u0001A\u0010#H!\ty$)D\u0001A\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"A\u0005\u0019\te.\u001f*fMB\u0011q(R\u0005\u0003\r\u0002\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002I!:\u0011\u0011J\u0014\b\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019r\na\u0001\u0010:p_Rt\u0014\"A!\n\u0005=\u0003\u0015a\u00029bG.\fw-Z\u0005\u0003#J\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!a\u0014!\u0002\u000bM$\u0018M\u001d;\u0016\u0003U\u0003\"AV.\u000e\u0003]S!\u0001W-\u0002\tQLW.\u001a\u0006\u00025\u0006!!.\u0019<b\u0013\tavKA\u0007[_:,G\rR1uKRKW.Z\u0001\u0007gR\f'\u000f\u001e\u0011\u0002\u0007\u0015tG-\u0001\u0003f]\u0012\u0004\u0013A\u0002\u001fj]&$h\bF\u0002cI\u0016\u0004\"a\u0019\u0001\u000e\u0003YBQaU\u0003A\u0002UCQAX\u0003A\u0002U\u000ba\"\u001b8ti\u0006tGo\u00144Ti\u0006\u0014H/F\u0001i!\t1\u0016.\u0003\u0002k/\n9\u0011J\\:uC:$\u0018\u0001D5ogR\fg\u000e^(g\u000b:$\u0017!D:uCJ$XK\\5y)&lW-F\u0001o!\tyt.\u0003\u0002q\u0001\n!Aj\u001c8h\u0003-)g\u000eZ+oSb$\u0016.\\3\u0002!M$\u0018M\u001d;Fa>\u001c\u0007.T5mY&\u001c\u0018AD3oI\u0016\u0003xn\u00195NS2d\u0017n]\u0001\ti>\u001cFO]5oOR\ta\u000f\u0005\u0002xu6\t\u0001P\u0003\u0002z3\u0006!A.\u00198h\u0013\tY\bP\u0001\u0004TiJLgnZ\u0001\u000bi>\u001cFO]5oO\u0006#HC\u0001<\u007f\u0011\u0019yX\u00021\u0001\u0002\u0002\u0005!!p\u001c8f!\r1\u00161A\u0005\u0004\u0003\u000b9&A\u0003.p]\u0016|eMZ:fi\u0006I1\u000f\u001d7ji&sGo\u001c\u000b\u0005\u0003\u0017\t\t\u0002\u0005\u0003I\u0003\u001b\u0011\u0017bAA\b%\n\u00191+Z9\t\u000f\u0005Ma\u00021\u0001\u0002\u0016\u0005!QO\\5u!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000e/\u0006AA/Z7q_J\fG.\u0003\u0003\u0002 \u0005e!AC\"ie>tw.\u00168ji\u0006q1\u000f\u001d7ji&sGo\u001c%pkJ\u001cXCAA\u0006\u00035\u0019\b\u000f\\5u\u0013:$x\u000eR1zg\u0006y1\u000f\u001d7ji&sGo\\'p]RD7/\u0001\bta2LG/\u00138u_^+Wm[:\u0002\u000fM\u0004H.\u001b;BiR!\u00111BA\u0018\u0011\u0019\t\td\u0005a\u0001+\u0006!A-\u0019;f\u0003\u0011\u0001H.^:\u0015\u000b\t\f9$a\u000f\t\r\u0005eB\u00031\u0001o\u0003\u0005q\u0007bBA\n)\u0001\u0007\u0011QC\u0001\u0006[&tWo\u001d\u000b\u0006E\u0006\u0005\u00131\t\u0005\u0007\u0003s)\u0002\u0019\u00018\t\u000f\u0005MQ\u00031\u0001\u0002\u0016\u00059\u0001n\\<NC:LHc\u00018\u0002J!9\u00111\u0003\fA\u0002\u0005UAc\u00018\u0002N!9\u00111C\fA\u0002\u0005=\u0003cA2\u0002R%\u0019\u00111\u000b\u001c\u0003\u001dQKW.Z,j]\u0012|w/\u00168ji\u0006Q1/Z2p]\u0012$\u0015N\u001a4\u0002\u00155Lg.\u001e;f\t&4g-\u0001\u0005i_V\u0014H)\u001b4g\u0003!!\u0017\r^3ES\u001a4\u0017\u0001C<fK.$\u0015N\u001a4\u0002\u00135|g\u000e\u001e5ES\u001a4\u0017\u0001C=fCJ$\u0015N\u001a4\u0002\u001d%tG/\u001a:tK\u000e$8oV5uQR!\u0011qMA7!\ry\u0014\u0011N\u0005\u0004\u0003W\u0002%a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003_z\u0002\u0019\u00012\u0002\u000b=$\b.\u001a:\u0002\t\r|\u0007/\u001f\u000b\u0006E\u0006U\u0014q\u000f\u0005\b'\u0002\u0002\n\u00111\u0001V\u0011\u001dq\u0006\u0005%AA\u0002U\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002~)\u001aQ+a ,\u0005\u0005\u0005\u0005\u0003BAB\u0003\u001bk!!!\"\u000b\t\u0005\u001d\u0015\u0011R\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a#A\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001f\u000b)IA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002m\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u0014\t\u0004\u007f\u0005u\u0015bAAP\u0001\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QUAV!\ry\u0014qU\u0005\u0004\u0003S\u0003%aA!os\"I\u0011QV\u0013\u0002\u0002\u0003\u0007\u00111T\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005M\u0006CBA[\u0003w\u000b)+\u0004\u0002\u00028*\u0019\u0011\u0011\u0018!\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002>\u0006]&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u001a\u0002D\"I\u0011QV\u0014\u0002\u0002\u0003\u0007\u0011QU\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\rF\u0002w\u0003\u0013D\u0011\"!,)\u0003\u0003\u0005\r!a'\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a'\u0002\r\u0015\fX/\u00197t)\u0011\t9'a5\t\u0013\u00055&&!AA\u0002\u0005\u0015\u0016A\u0003+j[\u0016<\u0016N\u001c3poB\u00111\rL\n\u0005Yy\nY\u000e\u0005\u0003\u0002^\u0006\rXBAAp\u0015\r\t\tOO\u0001\u0004Y><\u0017\u0002BAs\u0003?\u0014!\u0002T8h'V\u0004\bo\u001c:u)\t\t9.\u0001\u0007xSRDG+[7f5>tW\r\u0006\u0003\u0002n\u0006M\bcA2\u0002p&\u0019\u0011\u0011\u001f\u001c\u0003#QKW.Z,j]\u0012|wOQ;jY\u0012,'\u000fC\u0004\u0002v:\u0002\r!a>\u0002\u0011i|g.\u001a(b[\u0016\u0004B!!?\u0003\u00029!\u00111`A\u007f!\tQ\u0005)C\u0002\u0002\u0000\u0002\u000ba\u0001\u0015:fI\u00164\u0017bA>\u0003\u0004)\u0019\u0011q !\u0015\t\u00055(q\u0001\u0005\b\u0005\u0013y\u0003\u0019\u0001B\u0006\u0003\u0019QxN\\3JIB\u0019aK!\u0004\n\u0007\t=qK\u0001\u0004[_:,\u0017\nZ\u0001\bo&$\b.\u0016+D+\t\ti/\u0001\nxSRD7+_:uK6$\u0016.\\3[_:,\u0017!B1qa2LH#\u00022\u0003\u001c\tu\u0001\"B*3\u0001\u0004)\u0006\"\u000203\u0001\u0004)\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0005G\u0011y\u0003E\u0003@\u0005K\u0011I#C\u0002\u0003(\u0001\u0013aa\u00149uS>t\u0007#B \u0003,U+\u0016b\u0001B\u0017\u0001\n1A+\u001e9mKJB\u0001B!\r4\u0003\u0003\u0005\rAY\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u001c!\r9(\u0011H\u0005\u0004\u0005wA(AB(cU\u0016\u001cG\u000f")
public class TimeWindow
implements Product,
Serializable {
    private final ZonedDateTime start;
    private final ZonedDateTime end;

    public static Option<Tuple2<ZonedDateTime, ZonedDateTime>> unapply(TimeWindow x$0) {
        return TimeWindow$.MODULE$.unapply(x$0);
    }

    public static TimeWindow apply(ZonedDateTime start, ZonedDateTime end) {
        return TimeWindow$.MODULE$.apply(start, end);
    }

    public static TimeWindowBuilder withSystemTimeZone() {
        return TimeWindow$.MODULE$.withSystemTimeZone();
    }

    public static TimeWindowBuilder withUTC() {
        return TimeWindow$.MODULE$.withUTC();
    }

    public static TimeWindowBuilder withTimeZone(ZoneId zoneId) {
        return TimeWindow$.MODULE$.withTimeZone(zoneId);
    }

    public static TimeWindowBuilder withTimeZone(String zoneName) {
        return TimeWindow$.MODULE$.withTimeZone(zoneName);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public ZonedDateTime start() {
        return this.start;
    }

    public ZonedDateTime end() {
        return this.end;
    }

    private Instant instantOfStart() {
        return this.start().toInstant();
    }

    private Instant instantOfEnd() {
        return this.end().toInstant();
    }

    public long startUnixTime() {
        return this.start().toEpochSecond();
    }

    public long endUnixTime() {
        return this.end().toEpochSecond();
    }

    public long startEpochMillis() {
        return this.instantOfStart().toEpochMilli();
    }

    public long endEpochMillis() {
        return this.instantOfEnd().toEpochMilli();
    }

    public String toString() {
        String s = TimeStampFormatter$.MODULE$.formatTimestamp(this.start());
        String e = TimeStampFormatter$.MODULE$.formatTimestamp(this.end());
        return new StringBuilder(3).append("[").append(s).append(",").append(e).append(")").toString();
    }

    public String toStringAt(ZoneOffset zone) {
        String s = TimeStampFormatter$.MODULE$.formatTimestamp(this.startEpochMillis(), zone);
        String e = TimeStampFormatter$.MODULE$.formatTimestamp(this.endEpochMillis(), zone);
        return new StringBuilder(3).append("[").append(s).append(",").append(e).append(")").toString();
    }

    private Seq<TimeWindow> splitInto(ChronoUnit unit) {
        Builder b = package$.MODULE$.Seq().newBuilder();
        ZonedDateTime cursor = this.start();
        while (cursor.compareTo(this.end()) < 0) {
            ZonedDateTime zonedDateTime;
            ChronoUnit chronoUnit = unit;
            if (ChronoUnit.DAYS.equals(chronoUnit) ? true : (ChronoUnit.HOURS.equals(chronoUnit) ? true : ChronoUnit.MINUTES.equals(chronoUnit))) {
                zonedDateTime = cursor.plus(1L, unit).truncatedTo(unit);
            } else if (ChronoUnit.WEEKS.equals(chronoUnit)) {
                zonedDateTime = cursor.plus(1L, unit).with(DayOfWeek.MONDAY);
            } else if (ChronoUnit.MONTHS.equals(chronoUnit)) {
                zonedDateTime = cursor.plus(1L, unit).withDayOfMonth(1);
            } else if (ChronoUnit.YEARS.equals(chronoUnit)) {
                zonedDateTime = cursor.plus(1L, unit).withDayOfYear(1);
            } else {
                throw new IllegalStateException(new StringBuilder(30).append("Invalid split unit ").append(unit).append(" for range ").append(this.toString()).toString());
            }
            ZonedDateTime e = zonedDateTime;
            Growable growable = e.compareTo(this.end()) <= 0 ? b.$plus$eq((Object)new TimeWindow(cursor, e)) : b.$plus$eq((Object)new TimeWindow(cursor, this.end()));
            cursor = e;
        }
        return (Seq)b.result();
    }

    public Seq<TimeWindow> splitIntoHours() {
        return this.splitInto(ChronoUnit.HOURS);
    }

    public Seq<TimeWindow> splitIntoDays() {
        return this.splitInto(ChronoUnit.DAYS);
    }

    public Seq<TimeWindow> splitIntoMonths() {
        return this.splitInto(ChronoUnit.MONTHS);
    }

    public Seq<TimeWindow> splitIntoWeeks() {
        return this.splitInto(ChronoUnit.WEEKS);
    }

    public Seq<TimeWindow> splitAt(ZonedDateTime date) {
        if (date.compareTo(this.start()) <= 0 || date.compareTo(this.end()) > 0) {
            return new .colon.colon((Object)this, (List)Nil$.MODULE$);
        }
        return new .colon.colon((Object)new TimeWindow(this.start(), date), (List)new .colon.colon((Object)new TimeWindow(date, this.end()), (List)Nil$.MODULE$));
    }

    public TimeWindow plus(long n, ChronoUnit unit) {
        return new TimeWindow(this.start().plus(n, unit), this.end().plus(n, unit));
    }

    public TimeWindow minus(long n, ChronoUnit unit) {
        return this.plus(-n, unit);
    }

    public long howMany(ChronoUnit unit) {
        return unit.between(this.start(), this.end());
    }

    public long howMany(TimeWindowUnit unit) {
        TimeWindowUnit timeWindowUnit = unit;
        if (TimeWindowUnit$Year$.MODULE$.equals(timeWindowUnit)) {
            return this.howMany(ChronoUnit.YEARS);
        }
        if (TimeWindowUnit$Quarter$.MODULE$.equals(timeWindowUnit)) {
            ZonedDateTime startTruncated = unit.truncate(this.start());
            ZonedDateTime endTruncated = unit.truncate(this.end());
            int yearDiff = endTruncated.getYear() - startTruncated.getYear();
            return (endTruncated.getMonthValue() + yearDiff * 12 - startTruncated.getMonthValue()) / 3;
        }
        if (TimeWindowUnit$Month$.MODULE$.equals(timeWindowUnit)) {
            return this.monthDiff();
        }
        if (TimeWindowUnit$Week$.MODULE$.equals(timeWindowUnit)) {
            return this.weekDiff();
        }
        if (TimeWindowUnit$Day$.MODULE$.equals(timeWindowUnit)) {
            return this.dateDiff();
        }
        if (TimeWindowUnit$Hour$.MODULE$.equals(timeWindowUnit)) {
            return this.hourDiff();
        }
        if (TimeWindowUnit$Minute$.MODULE$.equals(timeWindowUnit)) {
            return this.minuteDiff();
        }
        if (TimeWindowUnit$Second$.MODULE$.equals(timeWindowUnit)) {
            return this.secondDiff();
        }
        throw new MatchError((Object)timeWindowUnit);
    }

    public long secondDiff() {
        return this.howMany(ChronoUnit.SECONDS);
    }

    public long minuteDiff() {
        return this.howMany(ChronoUnit.MINUTES);
    }

    public long hourDiff() {
        return this.howMany(ChronoUnit.HOURS);
    }

    public long dateDiff() {
        return this.howMany(ChronoUnit.DAYS);
    }

    public long weekDiff() {
        return this.howMany(ChronoUnit.WEEKS);
    }

    public long monthDiff() {
        return this.howMany(ChronoUnit.MONTHS);
    }

    public long yearDiff() {
        return this.howMany(ChronoUnit.YEARS);
    }

    public boolean intersectsWith(TimeWindow other) {
        return this.start().compareTo(other.end()) < 0 && this.end().compareTo(other.start()) > 0;
    }

    public TimeWindow copy(ZonedDateTime start, ZonedDateTime end) {
        return new TimeWindow(start, end);
    }

    public ZonedDateTime copy$default$1() {
        return this.start();
    }

    public ZonedDateTime copy$default$2() {
        return this.end();
    }

    public String productPrefix() {
        return "TimeWindow";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.start();
            }
            case 1: {
                return this.end();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TimeWindow;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "start";
            }
            case 1: {
                return "end";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TimeWindow)) return false;
        boolean bl = true;
        if (!bl) return false;
        TimeWindow timeWindow = (TimeWindow)x$1;
        ZonedDateTime zonedDateTime = this.start();
        ZonedDateTime zonedDateTime2 = timeWindow.start();
        if (zonedDateTime == null) {
            if (zonedDateTime2 != null) {
                return false;
            }
        } else if (!((Object)zonedDateTime).equals(zonedDateTime2)) return false;
        ZonedDateTime zonedDateTime3 = this.end();
        ZonedDateTime zonedDateTime4 = timeWindow.end();
        if (zonedDateTime3 == null) {
            if (zonedDateTime4 != null) {
                return false;
            }
        } else if (!((Object)zonedDateTime3).equals(zonedDateTime4)) return false;
        if (!timeWindow.canEqual(this)) return false;
        return true;
    }

    public TimeWindow(ZonedDateTime start, ZonedDateTime end) {
        this.start = start;
        this.end = end;
        Product.$init$((Product)this);
        Predef$.MODULE$.require(start.compareTo(end) <= 0, (Function0 & Serializable)() -> new StringBuilder(18).append("invalid range: ").append(TimeStampFormatter$.MODULE$.formatTimestamp(this.start())).append(" > ").append(TimeStampFormatter$.MODULE$.formatTimestamp(this.end())).toString());
    }
}

