/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.client;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;
import wvlet.airframe.codec.MessageCodec;
import wvlet.airframe.codec.PrimitiveCodec;
import wvlet.airframe.control.CircuitBreakerOpenException;
import wvlet.airframe.control.Retry;
import wvlet.airframe.http.Http$;
import wvlet.airframe.http.HttpClient$;
import wvlet.airframe.http.HttpClientException;
import wvlet.airframe.http.HttpClientMaxRetryException;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpMessage$;
import wvlet.airframe.http.HttpMessage$HttpMessageResponseAdapter$;
import wvlet.airframe.http.HttpStatus$BadRequest_400$;
import wvlet.airframe.http.HttpStatus$InternalServerError_500$;
import wvlet.airframe.http.HttpStatus$ServiceUnavailable_503$;
import wvlet.airframe.http.RPCEncoding;
import wvlet.airframe.http.RPCEncoding$JSON$;
import wvlet.airframe.http.RPCEncoding$MsgPack$;
import wvlet.airframe.http.RPCException;
import wvlet.airframe.http.RPCException$;
import wvlet.airframe.http.RPCStatus$DATA_LOSS_I8$;
import wvlet.airframe.http.RPCStatus$INVALID_ARGUMENT_U2$;
import wvlet.airframe.http.client.HttpClientConfig;
import wvlet.airframe.http.internal.HttpResponseBodyCodec;
import wvlet.airframe.surface.Surface;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class HttpClients$
implements LogSupport {
    public static final HttpClients$ MODULE$ = new HttpClients$();
    private static final HttpResponseBodyCodec<HttpMessage.Response> responseBodyCodec;
    private static Logger logger;
    private static volatile boolean bitmap$0;

    static {
        LoggingMethods.$init$((LoggingMethods)MODULE$);
        LazyLogger.$init$((LazyLogger)MODULE$);
        responseBodyCodec = new HttpResponseBodyCodec<HttpMessage.Response>(HttpMessage$HttpMessageResponseAdapter$.MODULE$);
    }

    private Logger logger$lzycompute() {
        HttpClients$ httpClients$ = this;
        synchronized (httpClients$) {
            if (!bitmap$0) {
                logger = LazyLogger.logger$((LazyLogger)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private HttpResponseBodyCodec<HttpMessage.Response> responseBodyCodec() {
        return responseBodyCodec;
    }

    public PartialFunction<Throwable, Nothing$> defaultHttpClientErrorHandler(Option<HttpMessage.Response> lastResponse) {
        return new Serializable(lastResponse){
            private static final long serialVersionUID = 0L;
            private final Option lastResponse$3;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option option;
                A1 A1 = x1;
                if (A1 instanceof HttpClientException) {
                    HttpClientException httpClientException = (HttpClientException)A1;
                    HttpMessage.Response resp = httpClientException.response().toHttpResponse();
                    Option<String> option2 = resp.getHeader("x-airframe-rpc-status");
                    if (option2 instanceof Some) {
                        RPCException ex = RPCException$.MODULE$.fromResponse(httpClientException.response().toHttpResponse());
                        throw new HttpClientException(HttpMessage$.MODULE$.HttpMessageResponseWrapper(resp), ex.status().httpStatus(), ex.message(), ex);
                    }
                    if (None$.MODULE$.equals(option2)) {
                        throw httpClientException;
                    }
                    throw new MatchError(option2);
                }
                if (A1 instanceof CircuitBreakerOpenException) {
                    CircuitBreakerOpenException circuitBreakerOpenException = (CircuitBreakerOpenException)A1;
                    HttpMessage.Response resp = (HttpMessage.Response)this.lastResponse$3.getOrElse((Function0 & Serializable)() -> Http$.MODULE$.response(HttpStatus$ServiceUnavailable_503$.MODULE$));
                    throw new HttpClientException(HttpMessage$.MODULE$.HttpMessageResponseWrapper(resp), resp.status(), circuitBreakerOpenException.getMessage(), (Throwable)circuitBreakerOpenException);
                }
                if (A1 instanceof Retry.MaxRetryException) {
                    Retry.MaxRetryException maxRetryException = (Retry.MaxRetryException)A1;
                    throw new HttpClientMaxRetryException(HttpMessage$.MODULE$.HttpMessageResponseWrapper((HttpMessage.Response)this.lastResponse$3.getOrElse((Function0 & Serializable)() -> Http$.MODULE$.response(HttpStatus$InternalServerError_500$.MODULE$))), maxRetryException.retryContext(), maxRetryException.retryContext().lastError());
                }
                if (A1 != null && !(option = NonFatal$.MODULE$.unapply(A1)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    HttpMessage.Response resp = (HttpMessage.Response)this.lastResponse$3.getOrElse((Function0 & Serializable)() -> Http$.MODULE$.response(HttpStatus$InternalServerError_500$.MODULE$));
                    throw new HttpClientException(HttpMessage$.MODULE$.HttpMessageResponseWrapper(resp), resp.status(), e.getMessage(), e);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Option option;
                Throwable throwable = x1;
                if (throwable instanceof HttpClientException) {
                    return true;
                }
                if (throwable instanceof CircuitBreakerOpenException) {
                    return true;
                }
                if (throwable instanceof Retry.MaxRetryException) {
                    return true;
                }
                return throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
            }
            {
                this.lastResponse$3 = lastResponse$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2(), $anonfun$applyOrElse$3()}, serializedLambda);
            }
        };
    }

    public <Req> HttpMessage.Request prepareRequest(HttpClientConfig config, HttpMessage.Request baseRequest, Surface requestSurface, Req requestBody) {
        HttpMessage.Request request;
        block7: {
            try {
                String string = baseRequest.method();
                switch (string == null ? 0 : string.hashCode()) {
                    case 70454: {
                        if (!"GET".equals(string)) break;
                        String newPath = HttpClient$.MODULE$.buildResourceUri(baseRequest.path(), requestBody, requestSurface);
                        request = baseRequest.withUri(newPath);
                        break block7;
                    }
                }
                MessageCodec requestCodec = config.codecFactory().ofSurface(requestSurface, config.codecFactory().ofSurface$default$2());
                byte[] bytes = config.rpcEncoding().encodeWithCodec(requestBody, requestCodec);
                RPCEncoding rPCEncoding = config.rpcEncoding();
                if (RPCEncoding$MsgPack$.MODULE$.equals(rPCEncoding)) {
                    request = (HttpMessage.Request)baseRequest.withMsgPack(bytes);
                    break block7;
                }
                if (RPCEncoding$JSON$.MODULE$.equals(rPCEncoding)) {
                    request = (HttpMessage.Request)baseRequest.withJson(bytes);
                    break block7;
                }
                throw new MatchError((Object)rPCEncoding);
            }
            catch (Throwable e) {
                throw new HttpClientException(HttpMessage$.MODULE$.HttpMessageResponseWrapper(Http$.MODULE$.response(HttpStatus$BadRequest_400$.MODULE$)), HttpStatus$BadRequest_400$.MODULE$, new StringBuilder(40).append("Failed to encode the HTTP request body: ").append(requestBody).toString(), e);
            }
        }
        return request;
    }

    public <Resp> Resp parseResponse(HttpClientConfig config, Surface responseSurface, HttpMessage.Response resp) {
        Object object;
        if (HttpMessage.Response.class.isAssignableFrom(responseSurface.rawType())) {
            return (Resp)resp;
        }
        try {
            Object responseObject;
            MessageCodec codec;
            byte[] msgpack = this.responseBodyCodec().toMsgPack(HttpMessage$.MODULE$.HttpMessageResponseWrapper(resp));
            MessageCodec messageCodec = codec = config.codecFactory().ofSurface(responseSurface, config.codecFactory().ofSurface$default$2());
            object = PrimitiveCodec.UnitCodec$.MODULE$.equals(messageCodec) ? null : (responseObject = codec.fromMsgPack(msgpack));
        }
        catch (Throwable e) {
            throw new HttpClientException(HttpMessage$.MODULE$.HttpMessageResponseWrapper(resp), resp.status(), new StringBuilder(48).append("Failed to parse the response from the server: ").append(resp).append(": ").append(e.getMessage()).toString(), e);
        }
        return (Resp)object;
    }

    public HttpMessage.Request prepareRPCRequest(HttpClientConfig config, String resourcePath, Surface requestSurface, Object requestContent) {
        HttpMessage.Request request;
        MessageCodec requestEncoder = config.codecFactory().ofSurface(requestSurface, config.codecFactory().ofSurface$default$2());
        try {
            request = (HttpMessage.Request)((HttpMessage)Http$.MODULE$.POST(resourcePath).withContentType(config.rpcEncoding().applicationType())).withContent(config.rpcEncoding().encodeWithCodec(requestContent, requestEncoder));
        }
        catch (Throwable e) {
            throw RPCStatus$INVALID_ARGUMENT_U2$.MODULE$.newException(new StringBuilder(44).append("Failed to encode the RPC request argument ").append(requestContent).append(": ").append(e.getMessage()).toString(), e, RPCStatus$INVALID_ARGUMENT_U2$.MODULE$.newException$default$3(), RPCStatus$INVALID_ARGUMENT_U2$.MODULE$.newException$default$4());
        }
        return request;
    }

    public Object parseRPCResponse(HttpClientConfig config, HttpMessage.Response response, Surface responseSurface) {
        Object object;
        if (HttpMessage.Response.class.isAssignableFrom(responseSurface.rawType())) {
            return response;
        }
        try {
            Object responseObject;
            MessageCodec codec;
            byte[] msgpack = this.responseBodyCodec().toMsgPack(HttpMessage$.MODULE$.HttpMessageResponseWrapper(response));
            MessageCodec messageCodec = codec = config.codecFactory().ofSurface(responseSurface, config.codecFactory().ofSurface$default$2());
            object = PrimitiveCodec.UnitCodec$.MODULE$.equals(messageCodec) ? null : (responseObject = codec.fromMsgPack(msgpack));
        }
        catch (Throwable e) {
            throw RPCStatus$DATA_LOSS_I8$.MODULE$.newException(new StringBuilder(51).append("Failed to parse the RPC response from the server ").append(response).append(": ").append(e.getMessage()).toString(), e, RPCStatus$DATA_LOSS_I8$.MODULE$.newException$default$3(), RPCStatus$DATA_LOSS_I8$.MODULE$.newException$default$4());
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpClients$.class);
    }

    private HttpClients$() {
    }
}

