/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.internal;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ReusableBuilder;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import wvlet.airframe.http.HttpContext;
import wvlet.airframe.http.HttpLogger;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpMultiMap;
import wvlet.airframe.http.HttpServerException;
import wvlet.airframe.http.RPCContext;
import wvlet.airframe.http.RPCException;
import wvlet.airframe.http.RPCMethod;
import wvlet.airframe.http.RPCStatus;
import wvlet.airframe.http.RPCStatus$;
import wvlet.airframe.http.RxHttpEndpoint;
import wvlet.airframe.http.client.HttpClientContext;
import wvlet.airframe.http.internal.RPCCallContext;
import wvlet.airframe.rx.Rx;
import wvlet.airframe.rx.Rx$;
import wvlet.airframe.surface.MethodParameter;
import wvlet.airframe.surface.Parameter;
import wvlet.airframe.surface.Surface;
import wvlet.airframe.ulid.ULID;
import wvlet.log.LogTimestampFormatter$;

public final class HttpLogs$ {
    public static final HttpLogs$ MODULE$ = new HttpLogs$();
    private static final scala.collection.concurrent.Map<String, String> headerSanitizeCache = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();

    public Rx<HttpMessage.Response> reportLog(HttpLogger httpLogger, HttpMultiMap excludeHeaders, HttpMessage.Request request, RxHttpEndpoint next, Option<HttpClientContext> clientContext, Option<RPCContext> rpcContext) {
        long baseTime = System.currentTimeMillis();
        long start = System.nanoTime();
        ReusableBuilder m = ListMap$.MODULE$.newBuilder();
        m.$plus$plus$eq(this.unixTimeLogs(baseTime));
        m.$plus$plus$eq(this.commonRequestLogs(request));
        m.$plus$plus$eq(this.requestHeaderLogs(request, excludeHeaders));
        clientContext.foreach((Function1 & Serializable)x$2 -> x$2.rpcMethod().map((Function1 & Serializable)rpc -> (ReusableBuilder)m.$plus$plus$eq(MODULE$.rpcMethodLogs((RPCMethod)rpc))));
        return next.apply(request).toRx().map((Function1 & Serializable)resp -> {
            m.$plus$plus$eq(MODULE$.durationLogs(baseTime, start));
            HttpLogs$.wvlet$airframe$http$internal$HttpLogs$$rpcCallLogs$1(rpcContext, m);
            m.$plus$plus$eq(MODULE$.commonResponseLogs((HttpMessage.Response)resp));
            m.$plus$plus$eq(MODULE$.responseHeaderLogs((HttpMessage.Response)resp, excludeHeaders));
            HttpLogs$.wvlet$airframe$http$internal$HttpLogs$$reportLogs$1(httpLogger, m);
            return resp;
        }).recoverWith((PartialFunction)new Serializable(m, baseTime, start, rpcContext, httpLogger){
            private static final long serialVersionUID = 0L;
            private final ReusableBuilder m$1;
            private final long baseTime$1;
            private final long start$1;
            private final Option rpcContext$1;
            private final HttpLogger httpLogger$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    this.m$1.$plus$plus$eq(HttpLogs$.MODULE$.durationLogs(this.baseTime$1, this.start$1));
                    HttpLogs$.wvlet$airframe$http$internal$HttpLogs$$rpcCallLogs$1(this.rpcContext$1, this.m$1);
                    this.m$1.$plus$plus$eq(HttpLogs$.MODULE$.errorLogs(A12));
                    HttpLogs$.wvlet$airframe$http$internal$HttpLogs$$reportLogs$1(this.httpLogger$1, this.m$1);
                    return (B1)Rx$.MODULE$.exception(A12);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable != null;
            }
            {
                this.m$1 = m$1;
                this.baseTime$1 = baseTime$1;
                this.start$1 = start$1;
                this.rpcContext$1 = rpcContext$1;
                this.httpLogger$1 = httpLogger$1;
            }
        });
    }

    public Option<HttpClientContext> reportLog$default$5() {
        return None$.MODULE$;
    }

    public Option<RPCContext> reportLog$default$6() {
        return None$.MODULE$;
    }

    public ListMap<String, Object> durationLogs(long baseTime, long sinceNano) {
        long end = System.nanoTime();
        long durationMills = TimeUnit.NANOSECONDS.toMillis(end - sinceNano);
        return (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"end_time_ms"), (Object)BoxesRunTime.boxToLong((long)(baseTime + durationMills))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duration_ms"), (Object)BoxesRunTime.boxToLong((long)durationMills))}));
    }

    public ListMap<String, Object> unixTimeLogs(long currentTimeMillis) {
        return (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"time"), (Object)BoxesRunTime.boxToLong((long)(currentTimeMillis / 1000L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"start_time_ms"), (Object)BoxesRunTime.boxToLong((long)currentTimeMillis)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"event_timestamp"), (Object)LogTimestampFormatter$.MODULE$.formatTimestampWithNoSpaace(currentTimeMillis))}));
    }

    public long unixTimeLogs$default$1() {
        return System.currentTimeMillis();
    }

    public Map<String, Object> commonRequestLogs(HttpMessage.Request request) {
        ReusableBuilder m = ListMap$.MODULE$.newBuilder();
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"method"), (Object)request.method().toString()));
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)request.path()));
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"uri"), (Object)this.sanitize(request.uri())));
        String queryString = this.extractQueryString(request.uri());
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(queryString)) ? m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"query_string"), (Object)queryString)) : BoxedUnit.UNIT;
        request.remoteAddress().foreach((Function1 & Serializable)remoteAddr -> (ReusableBuilder)m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"remote_address"), (Object)remoteAddr.hostAndPort())));
        return (Map)m.result();
    }

    public Map<String, Object> commonResponseLogs(HttpMessage.Response response) {
        ReusableBuilder m = ListMap$.MODULE$.newBuilder();
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"status_code"), (Object)BoxesRunTime.boxToInteger((int)response.statusCode())));
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"status_code_name"), (Object)response.status().reason()));
        response.contentLength().foreach((Function1 & Serializable)x$3 -> HttpLogs$.$anonfun$commonResponseLogs$1(m, BoxesRunTime.unboxToLong((Object)x$3)));
        response.getHeader("x-airframe-rpc-status").foreach((Function1 & Serializable)rpcStatus -> {
            HttpLogs$.$anonfun$commonResponseLogs$2(m, rpcStatus);
            return BoxedUnit.UNIT;
        });
        return (Map)m.result();
    }

    public Map<String, Object> rpcStatusLogs(RPCStatus status) {
        return (Map)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rpc_status"), (Object)BoxesRunTime.boxToInteger((int)status.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rpc_status_name"), (Object)status.name())}));
    }

    public Map<String, Object> requestHeaderLogs(HttpMessage.Request request, HttpMultiMap excludeHeaders) {
        Map<String, Object> m = this.headerLogs(request.header(), excludeHeaders);
        if (m.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_header"), m)}));
    }

    public Map<String, Object> responseHeaderLogs(HttpMessage.Response response, HttpMultiMap excludeHeaders) {
        Map<String, Object> m = this.headerLogs(response.header(), excludeHeaders);
        if (m.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"response_header"), m)}));
    }

    public Map<String, Object> headerLogs(HttpMultiMap headerMap, HttpMultiMap excludeHeaders) {
        ReusableBuilder m = ListMap$.MODULE$.newBuilder();
        headerMap.entries().foreach((Function1 & Serializable)e -> {
            if (!excludeHeaders.contains(e.key().toLowerCase())) {
                String v = headerMap.getAll(e.key()).mkString(";");
                return m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.sanitizeHeader(e.key())), (Object)v));
            }
            return BoxedUnit.UNIT;
        });
        return (Map)m.result();
    }

    public Map<String, Object> rpcMethodLogs(RPCMethod rpcMethod) {
        return rpcMethod.logData();
    }

    public ListMap<String, Object> rpcLogs(RPCCallContext rpcContext) {
        ReusableBuilder m = ListMap$.MODULE$.newBuilder();
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rpc_interface"), (Object)rpcContext.rpcInterfaceName()));
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rpc_class"), (Object)rpcContext.rpcClassName()));
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rpc_method"), (Object)rpcContext.rpcMethodName()));
        ListMap<String, Object> rpcArgs = this.extractRpcArgLog(rpcContext);
        Object object = rpcArgs.nonEmpty() ? m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rpc_args"), rpcArgs)) : BoxedUnit.UNIT;
        return (ListMap)m.result();
    }

    public ListMap<String, Object> extractRpcArgLog(RPCCallContext rpcContext) {
        ReusableBuilder rpcArgsBuilder = ListMap$.MODULE$.newBuilder();
        ((IterableOps)rpcContext.rpcMethodSurface().args().zip(rpcContext.rpcArgs())).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)HttpLogs$.$anonfun$extractRpcArgLog$3(check$ifrefutable$1))).foreach((Function1 & Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 != null) {
                MethodParameter p = (MethodParameter)tuple2._1();
                Object arg = tuple2._2();
                return (ReusableBuilder)rpcArgsBuilder.$plus$plus$eq((IterableOnce)HttpLogs$.traverseParam$1((Parameter)p, arg));
            }
            throw new MatchError((Object)tuple2);
        });
        return (ListMap)rpcArgsBuilder.result();
    }

    public ListMap<String, Object> errorLogs(Throwable e) {
        ReusableBuilder m;
        block1: {
            Throwable throwable;
            block3: {
                block2: {
                    block0: {
                        m = ListMap$.MODULE$.newBuilder();
                        throwable = this.findCause$1(e);
                        if (throwable != null) break block0;
                        break block1;
                    }
                    if (!(throwable instanceof HttpServerException)) break block2;
                    HttpServerException httpServerException = (HttpServerException)throwable;
                    if (httpServerException.getCause() == null) break block1;
                    Throwable rootCause = this.findCause$1(httpServerException.getCause());
                    m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception_message"), (Object)rootCause.getMessage()));
                    m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)rootCause));
                    break block1;
                }
                if (!(throwable instanceof RPCException)) break block3;
                RPCException rPCException = (RPCException)throwable;
                m.$plus$plus$eq(this.rpcStatusLogs(rPCException.status()));
                m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception_message"), (Object)rPCException.getMessage()));
                if (!rPCException.shouldReportStackTrace()) break block1;
                m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)rPCException));
                break block1;
            }
            m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception_message"), (Object)throwable.getMessage()));
            m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)throwable));
        }
        return (ListMap)m.result();
    }

    private String sanitize(String s) {
        return StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)x0$1 -> HttpLogs$.$anonfun$sanitize$1(BoxesRunTime.unboxToChar((Object)x0$1))).mkString();
    }

    private scala.collection.concurrent.Map<String, String> headerSanitizeCache() {
        return headerSanitizeCache;
    }

    private String sanitizeHeader(String h) {
        return (String)this.headerSanitizeCache().getOrElseUpdate((Object)h, (Function0 & Serializable)() -> h.replaceAll("-", "_").toLowerCase());
    }

    public String extractQueryString(String uri) {
        int qPos = uri.indexOf(63);
        if (qPos < 0 || qPos == uri.length() - 1) {
            return "";
        }
        return uri.substring(qPos + 1, uri.length());
    }

    public static final void wvlet$airframe$http$internal$HttpLogs$$reportLogs$1(HttpLogger httpLogger$1, ReusableBuilder m$1) {
        httpLogger$1.write((Map<String, Object>)((Map)httpLogger$1.config().logFilter().apply(m$1.result())));
    }

    public static final void wvlet$airframe$http$internal$HttpLogs$$rpcCallLogs$1(Option rpcContext$1, ReusableBuilder m$1) {
        rpcContext$1.flatMap((Function1 & Serializable)x$1 -> x$1.rpcCallContext()).foreach((Function1 & Serializable)rcc -> (ReusableBuilder)m$1.$plus$plus$eq(MODULE$.rpcLogs((RPCCallContext)rcc)));
    }

    public static final /* synthetic */ ReusableBuilder $anonfun$commonResponseLogs$1(ReusableBuilder m$3, long x$3) {
        return (ReusableBuilder)m$3.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"response_content_length"), (Object)BoxesRunTime.boxToLong((long)x$3)));
    }

    public static final /* synthetic */ void $anonfun$commonResponseLogs$2(ReusableBuilder m$3, String rpcStatus) {
        Try$.MODULE$.apply((Function0 & Serializable)() -> RPCStatus$.MODULE$.ofCode(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(rpcStatus)))).foreach((Function1 & Serializable)status -> (ReusableBuilder)m$3.$plus$plus$eq(MODULE$.rpcStatusLogs((RPCStatus)status)));
    }

    private static final ListMap traverseObject$1(Surface s, Object arg) {
        ReusableBuilder builder = ListMap$.MODULE$.newBuilder();
        s.params().foreach((Function1 & Serializable)p -> Try$.MODULE$.apply((Function0 & Serializable)() -> (ReusableBuilder)builder.$plus$plus$eq((IterableOnce)HttpLogs$.traverseParam$1(p, p.get(arg)))));
        return (ListMap)builder.result();
    }

    private static final ListMap traverseParam$1(Parameter p, Object arg) {
        Object object = arg;
        if (object instanceof HttpMessage.Request) {
            return ListMap$.MODULE$.empty();
        }
        String string = p.surface().fullName();
        String string2 = "com.twitter.finagle.http.Request";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return ListMap$.MODULE$.empty();
        }
        if (object instanceof HttpContext) {
            return ListMap$.MODULE$.empty();
        }
        if (p.isSecret()) {
            return ListMap$.MODULE$.empty();
        }
        if (object instanceof ULID) {
            ULID uLID = (ULID)object;
            return (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.name()), (Object)uLID)}));
        }
        if (p.surface().params().length() > 0) {
            return (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.name()), (Object)HttpLogs$.traverseObject$1(p.surface(), arg))}));
        }
        return (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.name()), arg)}));
    }

    public static final /* synthetic */ boolean $anonfun$extractRpcArgLog$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    private final Throwable findCause$1(Throwable e) {
        while (true) {
            ExecutionException executionException;
            Throwable throwable;
            if ((throwable = e) instanceof Exception) {
                Exception exception = (Exception)throwable;
                String string = exception.getClass().getName();
                String string2 = "java.lang.reflect.InvocationTargetException";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    e = exception.getCause();
                    continue;
                }
            }
            if (!(throwable instanceof ExecutionException) || (executionException = (ExecutionException)throwable).getCause() == null) break;
            e = executionException.getCause();
        }
        return e;
    }

    public static final /* synthetic */ Object $anonfun$sanitize$1(char x0$1) {
        char c = x0$1;
        switch (c) {
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
        }
        return BoxesRunTime.boxToCharacter((char)c);
    }

    private HttpLogs$() {
    }
}

