/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.control;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import wvlet.airframe.control.CircuitBreakerRecoveryPolicy;

public final class CircuitBreakerRecoveryPolicy$ {
    public static final CircuitBreakerRecoveryPolicy$ MODULE$ = new CircuitBreakerRecoveryPolicy$();

    public CircuitBreakerRecoveryPolicy recoverImmediately() {
        return new CircuitBreakerRecoveryPolicy(){

            public void recordSuccess() {
            }

            public void recordFailure() {
            }

            public void reset() {
            }

            public boolean canRecover() {
                return true;
            }
        };
    }

    public CircuitBreakerRecoveryPolicy recoverAfterConsecutiveSuccesses(int numberOfSuccess) {
        return new CircuitBreakerRecoveryPolicy(numberOfSuccess){
            private final AtomicInteger counter;
            private final int numberOfSuccess$1;

            private AtomicInteger counter() {
                return this.counter;
            }

            public void recordSuccess() {
                this.counter().incrementAndGet();
            }

            public void recordFailure() {
                this.counter().set(0);
            }

            public void reset() {
                this.counter().set(0);
            }

            public boolean canRecover() {
                return this.counter().get() >= this.numberOfSuccess$1;
            }
            {
                this.numberOfSuccess$1 = numberOfSuccess$1;
                this.counter = new AtomicInteger(0);
            }
        };
    }

    public CircuitBreakerRecoveryPolicy recoverAfterWait(int elapsedTimeMillis) {
        return new CircuitBreakerRecoveryPolicy(elapsedTimeMillis){
            private final AtomicLong timestamp;
            private final int elapsedTimeMillis$1;

            private AtomicLong timestamp() {
                return this.timestamp;
            }

            public void recordSuccess() {
                this.timestamp().compareAndSet(Long.MAX_VALUE, System.currentTimeMillis());
            }

            public void recordFailure() {
                this.timestamp().set(Long.MAX_VALUE);
            }

            public void reset() {
                this.timestamp().set(Long.MAX_VALUE);
            }

            public boolean canRecover() {
                return this.timestamp().get() <= System.currentTimeMillis() - (long)this.elapsedTimeMillis$1;
            }
            {
                this.elapsedTimeMillis$1 = elapsedTimeMillis$1;
                this.timestamp = new AtomicLong(Long.MAX_VALUE);
            }
        };
    }

    private CircuitBreakerRecoveryPolicy$() {
    }
}

