/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.concurrent.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;
import wvlet.log.ConsoleLogHandler;
import wvlet.log.ConsoleLogHandler$;
import wvlet.log.LogEnv$;
import wvlet.log.LogFormatter;
import wvlet.log.LogLevel;
import wvlet.log.LogLevel$;
import wvlet.log.LogLevel$INFO$;
import wvlet.log.Logger;

public final class Logger$
implements Serializable {
    public static final Logger$ MODULE$;
    private static Map<String, Logger> loggerCache;
    private static List<Tuple2<Regex, LogLevel>> logLevelPatterns;
    private static final Logger rootLogger;
    private static volatile boolean bitmap$0;

    /*
     * WARNING - void declaration
     */
    static {
        void var0_4;
        MODULE$ = new Logger$();
        LogEnv$.MODULE$.initLogManager();
        logLevelPatterns = Nil$.MODULE$;
        String x$1 = "";
        .colon.colon x$2 = new .colon.colon((Object)LogEnv$.MODULE$.defaultHandler(), (List)Nil$.MODULE$);
        Option<LogLevel> x$3 = MODULE$.initLogger$default$2();
        boolean x$4 = MODULE$.initLogger$default$4();
        Logger l = MODULE$.initLogger("", x$3, (Seq<Handler>)x$2, x$4);
        if (LogEnv$.MODULE$.isScalaJS()) {
            l.setLogLevel(LogLevel$INFO$.MODULE$);
        }
        rootLogger = var0_4;
    }

    private Map<String, Logger> loggerCache$lzycompute() {
        Logger$ logger$ = this;
        synchronized (logger$) {
            if (!bitmap$0) {
                loggerCache = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
                bitmap$0 = true;
            }
        }
        return loggerCache;
    }

    private Map<String, Logger> loggerCache() {
        if (!bitmap$0) {
            return this.loggerCache$lzycompute();
        }
        return loggerCache;
    }

    private List<Tuple2<Regex, LogLevel>> logLevelPatterns() {
        return logLevelPatterns;
    }

    private void logLevelPatterns_$eq(List<Tuple2<Regex, LogLevel>> x$1) {
        logLevelPatterns = x$1;
    }

    public Logger rootLogger() {
        return rootLogger;
    }

    public Logger initLogger(String name, Option<LogLevel> level, Seq<Handler> handlers, boolean useParents) {
        Logger logger = this.apply(name);
        logger.clearHandlers();
        level.foreach((Function1 & Serializable)l -> {
            logger.setLogLevel(l);
            return BoxedUnit.UNIT;
        });
        handlers.foreach((Function1 & Serializable)h -> {
            logger.addHandler(h);
            return BoxedUnit.UNIT;
        });
        logger.setUseParentHandlers(useParents);
        return logger;
    }

    public <A> Logger of(ClassTag<A> evidence$1) {
        return this.apply(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass().getName());
    }

    public Logger apply(String loggerName) {
        Logger l = (Logger)this.loggerCache().getOrElseUpdate((Object)loggerName, (Function0 & Serializable)() -> new Logger(loggerName, java.util.logging.Logger.getLogger(loggerName)));
        this.updateLogLevel(l);
        return l;
    }

    private void updateLogLevel(Logger l) {
        this.logLevelPatterns().collectFirst((PartialFunction)new Serializable(l){
            private static final long serialVersionUID = 0L;
            private final Logger l$2;

            public final <A1 extends Tuple2<Regex, LogLevel>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    Regex p = (Regex)A1._1();
                    LogLevel level = (LogLevel)A1._2();
                    if (p.findFirstIn((CharSequence)this.l$2.getName()).isDefined()) {
                        return (B1)level;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Regex, LogLevel> x1) {
                Regex p;
                Tuple2<Regex, LogLevel> tuple2 = x1;
                return tuple2 != null && (p = (Regex)tuple2._1()).findFirstIn((CharSequence)this.l$2.getName()).isDefined();
            }
            {
                this.l$2 = l$2;
            }
        }).foreach((Function1 & Serializable)level -> {
            l.setLogLevel(level);
            return BoxedUnit.UNIT;
        });
    }

    public LogLevel getDefaultLogLevel() {
        return this.rootLogger().getLogLevel();
    }

    public void setDefaultLogLevel(LogLevel level) {
        this.rootLogger().setLogLevel(level);
    }

    public void setLogLevel(String pattern, LogLevel level) {
        if (pattern.contains("*")) {
            String regexPattern = pattern.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*");
            Logger$ logger$ = this;
            synchronized (logger$) {
                Tuple2 tuple2 = new Tuple2((Object)StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(regexPattern)), (Object)level);
                this.logLevelPatterns_$eq((List<Tuple2<Regex, LogLevel>>)this.logLevelPatterns().$colon$colon((Object)tuple2));
            }
            this.loggerCache().values().foreach((Function1 & Serializable)l -> {
                Logger$.MODULE$.updateLogLevel(l);
                return BoxedUnit.UNIT;
            });
            return;
        }
        this.apply(pattern).setLogLevel(level);
    }

    public void resetLogLevel(String pattern) {
        if (pattern.contains("*")) {
            Regex regexPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(pattern.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*")));
            String regexPatternStr = regexPattern.regex();
            Logger$ logger$ = this;
            synchronized (logger$) {
                this.logLevelPatterns_$eq((List<Tuple2<Regex, LogLevel>>)this.logLevelPatterns().filter((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Logger$.$anonfun$resetLogLevel$1(regexPatternStr, x))));
            }
            this.loggerCache().values().foreach((Function1 & Serializable)l -> {
                Logger$.$anonfun$resetLogLevel$2(regexPattern, l);
                return BoxedUnit.UNIT;
            });
            return;
        }
        this.apply(pattern).resetLogLevel();
    }

    public synchronized void setDefaultFormatter(LogFormatter formatter) {
        this.rootLogger().resetHandler(new ConsoleLogHandler(formatter, ConsoleLogHandler$.MODULE$.$lessinit$greater$default$2()));
    }

    public void setDefaultHandler(Handler handler) {
        this.rootLogger().resetHandler(handler);
    }

    public void resetDefaultLogLevel() {
        this.rootLogger().resetLogLevel();
    }

    public void clearAllHandlers() {
        this.rootLogger().clearAllHandlers();
    }

    public void init() {
        this.clearAllHandlers();
        this.resetDefaultLogLevel();
        this.logLevelPatterns_$eq((List<Tuple2<Regex, LogLevel>>)Nil$.MODULE$);
        this.rootLogger().resetHandler(LogEnv$.MODULE$.defaultHandler());
    }

    public Option<LogLevel> initLogger$default$2() {
        return None$.MODULE$;
    }

    public Seq<Handler> initLogger$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public boolean initLogger$default$4() {
        return true;
    }

    public void setLogLevels(Properties logLevels) {
        CollectionConverters$.MODULE$.PropertiesHasAsScala(logLevels).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Logger$.$anonfun$setLogLevels$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$2 -> {
            Logger$.$anonfun$setLogLevels$2(x$2);
            return BoxedUnit.UNIT;
        });
    }

    public void scheduleLogLevelScan() {
        LogEnv$.MODULE$.scheduleLogLevelScan();
    }

    public void stopScheduledLogLevelScan() {
        LogEnv$.MODULE$.stopScheduledLogLevelScan();
    }

    public void scanLogLevels() {
        LogEnv$.MODULE$.scanLogLevels();
    }

    public void scanLogLevels(Seq<String> loglevelFileCandidates) {
        LogEnv$.MODULE$.scanLogLevels(loglevelFileCandidates);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Logger$.class);
    }

    public static final /* synthetic */ boolean $anonfun$resetLogLevel$1(String regexPatternStr$1, Tuple2 x) {
        String string = ((Regex)x._1()).regex();
        String string2 = regexPatternStr$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$resetLogLevel$2(Regex regexPattern$1, Logger l) {
        if (regexPattern$1.findFirstIn((CharSequence)l.getName()).isDefined()) {
            l.resetLogLevel();
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$setLogLevels$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$setLogLevels$2(Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            String loggerName = (String)tuple2._1();
            String level = (String)tuple2._2();
            Option<LogLevel> option = LogLevel$.MODULE$.unapply(level);
            if (option instanceof Some) {
                Some some = (Some)option;
                LogLevel lv = (LogLevel)some.value();
                String string = loggerName;
                String string2 = "_root_";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    MODULE$.rootLogger().setLogLevel(lv);
                } else {
                    MODULE$.apply(loggerName).setLogLevel(lv);
                }
            } else if (None$.MODULE$.equals(option)) {
                Console$.MODULE$.err().println(new StringBuilder(35).append("Unknown loglevel ").append(level).append(" is specified for ").append(loggerName).toString());
            } else {
                throw new MatchError(option);
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private Logger$() {
    }
}

