/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.metrics;

import java.io.Serializable;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import wvlet.airframe.metrics.TimeWindow;
import wvlet.airframe.metrics.TimeWindowBuilder;
import wvlet.airframe.metrics.TimeWindowBuilder$;
import wvlet.airframe.metrics.package$;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class TimeWindow$
implements LogSupport {
    public static final TimeWindow$ MODULE$ = new TimeWindow$();
    private static Logger logger;
    private static volatile boolean bitmap$0;

    static {
        LoggingMethods.$init$((LoggingMethods)MODULE$);
        LazyLogger.$init$((LazyLogger)MODULE$);
    }

    private Logger logger$lzycompute() {
        TimeWindow$ timeWindow$ = this;
        synchronized (timeWindow$) {
            if (!bitmap$0) {
                logger = LazyLogger.logger$((LazyLogger)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public TimeWindowBuilder withTimeZone(String zoneName) {
        Map idMap = (Map)CollectionConverters$.MODULE$.MapHasAsScala(ZoneId.SHORT_IDS).asScala().$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PDT"), (Object)"-07:00"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"EDT"), (Object)"-04:00"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CDT"), (Object)"-05:00"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MDT"), (Object)"-06:00")})));
        ZoneId zoneId = (ZoneId)idMap.get((Object)zoneName).map((Function1 & Serializable)x$1 -> ZoneId.of(x$1)).getOrElse((Function0 & Serializable)() -> ZoneId.of(zoneName));
        return this.withTimeZone(zoneId);
    }

    public TimeWindowBuilder withTimeZone(ZoneId zoneId) {
        ZoneOffset offset = ZonedDateTime.now(zoneId).getOffset();
        return new TimeWindowBuilder(offset, TimeWindowBuilder$.MODULE$.$lessinit$greater$default$2());
    }

    public TimeWindowBuilder withUTC() {
        return this.withTimeZone(package$.MODULE$.UTC());
    }

    public TimeWindowBuilder withSystemTimeZone() {
        return this.withTimeZone(package$.MODULE$.systemTimeZone());
    }

    public TimeWindow apply(ZonedDateTime start, ZonedDateTime end) {
        return new TimeWindow(start, end);
    }

    public Option<Tuple2<ZonedDateTime, ZonedDateTime>> unapply(TimeWindow x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.start(), (Object)x$0.end()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TimeWindow$.class);
    }

    private TimeWindow$() {
    }
}

