/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.internal;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import wvlet.airframe.http.HttpLogger;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpServerException;
import wvlet.airframe.http.RPCContext;
import wvlet.airframe.http.RPCContext$;
import wvlet.airframe.http.RPCException;
import wvlet.airframe.http.RPCStatus;
import wvlet.airframe.http.RPCStatus$;
import wvlet.airframe.http.RPCStatus$INTERNAL_ERROR_I0$;
import wvlet.airframe.http.RxHttpEndpoint;
import wvlet.airframe.http.RxHttpFilter;
import wvlet.airframe.http.client.HttpClientContext;
import wvlet.airframe.http.internal.HttpLogs;
import wvlet.airframe.rx.Rx;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

@ScalaSignature(bytes="\u0006\u0005\u00193A!\u0002\u0004\u0001\u001f!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005C\u0003%\u0001\u0011\u0005Q\u0005C\u0003*\u0001\u0011\u0005#\u0006C\u0003C\u0001\u0011%1IA\tS!\u000e\u0013Vm\u001d9p]N,g)\u001b7uKJT!a\u0002\u0005\u0002\u0011%tG/\u001a:oC2T!!\u0003\u0006\u0002\t!$H\u000f\u001d\u0006\u0003\u00171\t\u0001\"Y5sMJ\fW.\u001a\u0006\u0002\u001b\u0005)qO\u001e7fi\u000e\u00011\u0003\u0002\u0001\u0011-i\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\f\u0019\u001b\u0005A\u0011BA\r\t\u00051\u0011\u0006\u0010\u0013;ua\u001aKG\u000e^3s!\tYb$D\u0001\u001d\u0015\tiB\"A\u0002m_\u001eL!a\b\u000f\u0003\u00151{wmU;qa>\u0014H/\u0001\u0006iiR\u0004Hj\\4hKJ\u0004\"a\u0006\u0012\n\u0005\rB!A\u0003%uiBdunZ4fe\u00061A(\u001b8jiz\"\"A\n\u0015\u0011\u0005\u001d\u0002Q\"\u0001\u0004\t\u000b\u0001\u0012\u0001\u0019A\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007-BT\bE\u0002-_Ej\u0011!\f\u0006\u0003])\t!A\u001d=\n\u0005Aj#A\u0001*y!\t\u0011TG\u0004\u0002\u0018g%\u0011A\u0007C\u0001\f\u0011R$\b/T3tg\u0006<W-\u0003\u00027o\tA!+Z:q_:\u001cXM\u0003\u00025\u0011!)\u0011h\u0001a\u0001u\u00059!/Z9vKN$\bC\u0001\u001a<\u0013\tatGA\u0004SKF,Xm\u001d;\t\u000by\u001a\u0001\u0019A \u0002\t9,\u0007\u0010\u001e\t\u0003/\u0001K!!\u0011\u0005\u0003\u001dIC\b\n\u001e;q\u000b:$\u0007o\\5oi\u0006a1/\u001a;S!\u000e\u001bF/\u0019;vgR\u0011\u0011\u0007\u0012\u0005\u0006\u000b\u0012\u0001\r!M\u0001\u0005e\u0016\u001c\b\u000f")
public class RPCResponseFilter
implements RxHttpFilter,
LogSupport {
    private final HttpLogger httpLogger;
    private Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public RxHttpFilter andThen(RxHttpFilter nextFilter) {
        return RxHttpFilter.andThen$((RxHttpFilter)this, nextFilter);
    }

    @Override
    public RxHttpEndpoint andThen(RxHttpEndpoint endpoint) {
        return RxHttpFilter.andThen$((RxHttpFilter)this, endpoint);
    }

    @Override
    public RxHttpEndpoint andThen(Function1<HttpMessage.Request, Rx<HttpMessage.Response>> body) {
        return RxHttpFilter.andThen$((RxHttpFilter)this, body);
    }

    private Logger logger$lzycompute() {
        RPCResponseFilter rPCResponseFilter = this;
        synchronized (rPCResponseFilter) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$((LazyLogger)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public Rx<HttpMessage.Response> apply(HttpMessage.Request request, RxHttpEndpoint next) {
        return next.apply(request).transform((Function1 & Serializable)x0$1 -> {
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                HttpMessage.Response resp = (HttpMessage.Response)success.value();
                return this.logContext$1(request).logResponse(this.setRPCStatus(resp), (Option<Throwable>)None$.MODULE$);
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                Throwable throwable = e;
                if (throwable instanceof HttpServerException) {
                    HttpServerException httpServerException = (HttpServerException)throwable;
                    RPCStatus qual$1 = RPCStatus$.MODULE$.fromHttpStatus(httpServerException.status());
                    String x$1 = httpServerException.getMessage();
                    Throwable x$2 = httpServerException.getCause();
                    int x$3 = qual$1.newException$default$3();
                    Map<String, Object> x$4 = qual$1.newException$default$4();
                    RPCException re = qual$1.newException(x$1, x$2, x$3, x$4);
                    return this.logContext$1(request).logResponse(re.toResponse(), (Option<Throwable>)new Some((Object)re));
                }
                if (throwable instanceof RPCException) {
                    RPCException rPCException = (RPCException)throwable;
                    return this.logContext$1(request).logResponse(rPCException.toResponse(), (Option<Throwable>)new Some((Object)rPCException));
                }
                RPCException ex = RPCStatus$INTERNAL_ERROR_I0$.MODULE$.newException(throwable.getMessage(), throwable, RPCStatus$INTERNAL_ERROR_I0$.MODULE$.newException$default$3(), RPCStatus$INTERNAL_ERROR_I0$.MODULE$.newException$default$4());
                return this.logContext$1(request).logResponse(ex.toResponse(), (Option<Throwable>)new Some((Object)throwable));
            }
            throw new MatchError((Object)try_);
        });
    }

    private HttpMessage.Response setRPCStatus(HttpMessage.Response resp) {
        Option<String> option = resp.getHeader("x-airframe-rpc-status");
        if (option instanceof Some) {
            return resp;
        }
        if (None$.MODULE$.equals(option)) {
            RPCStatus status = RPCStatus$.MODULE$.fromHttpStatus(resp.status());
            return (HttpMessage.Response)resp.addHeader("x-airframe-rpc-status", Integer.toString(status.code()));
        }
        throw new MatchError(option);
    }

    private final HttpLogs.LogContext logContext$1(HttpMessage.Request request$1) {
        return new HttpLogs.LogContext(request$1, this.httpLogger, (Option<HttpClientContext>)None$.MODULE$, (Option<RPCContext>)new Some((Object)RPCContext$.MODULE$.current()));
    }

    public RPCResponseFilter(HttpLogger httpLogger) {
        this.httpLogger = httpLogger;
        RxHttpFilter.$init$(this);
        LoggingMethods.$init$((LoggingMethods)this);
        LazyLogger.$init$((LazyLogger)this);
    }
}

