/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.router;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import wvlet.airframe.Session;
import wvlet.airframe.codec.MessageCodecFactory;
import wvlet.airframe.http.HttpBackend;
import wvlet.airframe.http.HttpContext;
import wvlet.airframe.http.HttpFilter;
import wvlet.airframe.http.HttpRequestAdapter;
import wvlet.airframe.http.RPCStatus$UNIMPLEMENTED_U8$;
import wvlet.airframe.http.Router;
import wvlet.airframe.http.RxHttpFilter;
import wvlet.airframe.http.router.ControllerProvider;
import wvlet.airframe.http.router.HttpEndpointExecutionContext;
import wvlet.airframe.http.router.HttpRequestDispatcher;
import wvlet.airframe.http.router.ResponseHandler;
import wvlet.airframe.http.router.RouteMatch;
import wvlet.airframe.surface.Surface;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class HttpRequestDispatcher$
implements LogSupport {
    public static final HttpRequestDispatcher$ MODULE$ = new HttpRequestDispatcher$();
    private static Logger logger;
    private static volatile boolean bitmap$0;

    static {
        LoggingMethods.$init$((LoggingMethods)MODULE$);
        LazyLogger.$init$((LazyLogger)MODULE$);
    }

    private Logger logger$lzycompute() {
        HttpRequestDispatcher$ httpRequestDispatcher$ = this;
        synchronized (httpRequestDispatcher$) {
            if (!bitmap$0) {
                logger = LazyLogger.logger$((LazyLogger)this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public <Req, Resp, F> HttpFilter<Req, Resp, F> newDispatcher(Session session, Router router, ControllerProvider controllerProvider, HttpBackend<Req, Resp, F> backend, ResponseHandler<Req, Resp> responseHandler, MessageCodecFactory codecFactory, ExecutionContext executionContext, HttpRequestAdapter<Req> evidence$1) {
        HttpRequestDispatcher.RoutingTable routingTable = this.buildRoutingTable(backend, session, router, backend.defaultFilter(), controllerProvider);
        return backend.newFilter((Function2 & Serializable)(request, context) -> {
            Option<RouteMatch> option = router.findRoute(request, evidence$1);
            if (option instanceof Some) {
                Some some = (Some)option;
                RouteMatch routeMatch = (RouteMatch)some.value();
                HttpRequestDispatcher.RouteFilter routeFilter = routingTable.findFilter(routeMatch.route());
                HttpEndpointExecutionContext context2 = new HttpEndpointExecutionContext(backend, routeMatch, responseHandler, routeFilter.controller(), codecFactory, executionContext, evidence$1);
                HttpContext currentService = routeFilter.filter().andThen(context2);
                return currentService.apply(request);
            }
            if (None$.MODULE$.equals(option)) {
                Option option2 = routingTable.leafFilter();
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    HttpFilter f = (HttpFilter)some.value();
                    return f.apply(request, context);
                }
                if (None$.MODULE$.equals(option2)) {
                    return context.apply(request);
                }
                throw new MatchError(option2);
            }
            throw new MatchError(option);
        });
    }

    public <Req, Resp, F> HttpRequestDispatcher.RoutingTable<Req, Resp, F> buildRoutingTable(HttpBackend<Req, Resp, F> backend, Session session, Router rootRouter, HttpFilter<Req, Resp, F> baseFilter, ControllerProvider controllerProvider) {
        BoxedUnit boxedUnit;
        Builder leafFilters = package$.MODULE$.Seq().newBuilder();
        Map mappings = HttpRequestDispatcher$.buildMappingsFromRouteToFilter$1(rootRouter, baseFilter, controllerProvider, session, backend, leafFilters);
        Seq lf = (Seq)leafFilters.result();
        if (lf.size() > 1) {
            if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("", "HttpRequestDispatcher.scala", 146, 11), (Object)new StringBuilder(68).append("Multiple leaf filters are found in the router. Using the first one: ").append(lf.head()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new HttpRequestDispatcher.RoutingTable(mappings, lf.headOption());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpRequestDispatcher$.class);
    }

    private static final Map buildMappingsFromRouteToFilter$1(Router router, HttpFilter parentFilter, ControllerProvider controllerProvider$1, Session session$1, HttpBackend backend$2, Builder leafFilters$1) {
        Option localFilterOpt = router.filterInstance().orElse((Function0 & Serializable)() -> router.filterSurface().map((Function1 & Serializable)fs -> controllerProvider$1.findController(session$1, (Surface)fs)).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDefined())).map((Function1 & Serializable)x$2 -> x$2.get())).map((Function1 & Serializable)x0$1 -> {
            Object object = x0$1;
            if (object instanceof RxHttpFilter) {
                RxHttpFilter rxHttpFilter = (RxHttpFilter)object;
                return backend$2.rxFilterAdapter(rxHttpFilter);
            }
            if (object instanceof HttpFilter) {
                HttpFilter httpFilter = (HttpFilter)object;
                return backend$2.filterAdapter(httpFilter);
            }
            throw RPCStatus$UNIMPLEMENTED_U8$.MODULE$.newException(new StringBuilder(21).append("Invalid filter type: ").append(object).toString(), RPCStatus$UNIMPLEMENTED_U8$.MODULE$.newException$default$2(), RPCStatus$UNIMPLEMENTED_U8$.MODULE$.newException$default$3(), RPCStatus$UNIMPLEMENTED_U8$.MODULE$.newException$default$4());
        });
        HttpFilter currentFilter = (HttpFilter)localFilterOpt.map((Function1 & Serializable)l -> parentFilter.andThen(l)).getOrElse((Function0 & Serializable)() -> parentFilter);
        Builder m = Predef$.MODULE$.Map().newBuilder();
        router.localRoutes().foreach((Function1 & Serializable)route -> {
            Option controllerOpt = router.controllerInstance().orElse((Function0 & Serializable)() -> controllerProvider$1.findController(session$1, route.controllerSurface()));
            if (controllerOpt.isEmpty()) {
                throw new IllegalStateException(new StringBuilder(38).append("Missing controller. Add ").append(route.controllerSurface()).append(" to the design").toString());
            }
            return (Builder)m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(route), new HttpRequestDispatcher.RouteFilter(currentFilter, controllerOpt.get())));
        });
        router.children().foreach((Function1 & Serializable)c -> (Builder)m.$plus$plus$eq((IterableOnce)HttpRequestDispatcher$.buildMappingsFromRouteToFilter$1(c, currentFilter, controllerProvider$1, session$1, backend$2, leafFilters$1)));
        Object object = router.isLeafFilter() ? leafFilters$1.$plus$eq((Object)currentFilter) : BoxedUnit.UNIT;
        return (Map)m.result();
    }

    private HttpRequestDispatcher$() {
    }
}

