/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.json;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import scala.runtime.Scala3RunTime$;
import wvlet.airframe.json.JSONSource$;

public final class JSONSource {
    private final byte[] b;
    private final int offset;
    private final int size;

    public static JSONSource fromByteBuffer(ByteBuffer byteBuffer) {
        return JSONSource$.MODULE$.fromByteBuffer(byteBuffer);
    }

    public static JSONSource fromBytes(byte[] byArray) {
        return JSONSource$.MODULE$.fromBytes(byArray);
    }

    public static JSONSource fromBytes(byte[] byArray, int n, int n2) {
        return JSONSource$.MODULE$.fromBytes(byArray, n, n2);
    }

    public static JSONSource fromString(String string) {
        return JSONSource$.MODULE$.fromString(string);
    }

    public JSONSource(byte[] b, int offset, int size) {
        this.b = b;
        this.offset = offset;
        this.size = size;
        if (offset < 0) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(25).append("The offset must be >= 0: ").append(offset).toString());
        }
        if (size < 0) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(23).append("The size must be >= 0: ").append(size).toString());
        }
        if (offset + size > b.length) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(32).append("The offset + size must be <= ").append(b.length).append(": ").append(offset).append("+").append(size).toString());
        }
    }

    public int length() {
        return this.size;
    }

    public byte apply(int index) {
        return this.b[index + this.offset];
    }

    public String substring(int start, int end) {
        return new String(this.b, this.offset + start, end - start, StandardCharsets.UTF_8);
    }
}

