/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.metrics;

import java.io.Serializable;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import wvlet.airframe.metrics.DataSize$;
import wvlet.airframe.metrics.DataSize$BYTE$;

public class DataSize
implements Comparable<DataSize>,
Product,
Serializable {
    private final double value;
    private final DataSizeUnit unit;

    public static LongToDataSizeConverter LongToDataSizeConverter(long l) {
        return DataSize$.MODULE$.LongToDataSizeConverter(l);
    }

    public static StrToDataSizeConverter StrToDataSizeConverter(String string) {
        return DataSize$.MODULE$.StrToDataSizeConverter(string);
    }

    public static DataSize apply(double d, DataSizeUnit dataSizeUnit) {
        return DataSize$.MODULE$.apply(d, dataSizeUnit);
    }

    public static DataSize apply(long l) {
        return DataSize$.MODULE$.apply(l);
    }

    public static DataSize apply(String string) {
        return DataSize$.MODULE$.apply(string);
    }

    public static void checkState(boolean bl, String string) {
        DataSize$.MODULE$.checkState(bl, string);
    }

    public static DataSize fromProduct(Product product) {
        return DataSize$.MODULE$.fromProduct(product);
    }

    public static DataSize succinct(long l) {
        return DataSize$.MODULE$.succinct(l);
    }

    public static DataSize unapply(DataSize dataSize) {
        return DataSize$.MODULE$.unapply(dataSize);
    }

    public static List<DataSizeUnit> units() {
        return DataSize$.MODULE$.units();
    }

    public DataSize(double value, DataSizeUnit unit) {
        this.value = value;
        this.unit = unit;
        Predef$.MODULE$.require(!Predef$.MODULE$.double2Double(value).isInfinite(), DataSize::$init$$$anonfun$1);
        Predef$.MODULE$.require(!Predef$.MODULE$.double2Double(value).isNaN(), DataSize::$init$$$anonfun$2);
        Predef$.MODULE$.require(value >= 0.0, () -> DataSize.$init$$$anonfun$3(value, unit));
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.value()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.unit()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DataSize)) return false;
        DataSize dataSize = (DataSize)object;
        if (this.value() != dataSize.value()) return false;
        DataSizeUnit dataSizeUnit = this.unit();
        DataSizeUnit dataSizeUnit2 = dataSize.unit();
        if (dataSizeUnit == null) {
            if (dataSizeUnit2 != null) {
                return false;
            }
        } else if (!dataSizeUnit.equals(dataSizeUnit2)) return false;
        if (!dataSize.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof DataSize;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "DataSize";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return BoxesRunTime.boxToDouble((double)this._1());
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "value";
        }
        if (1 == n2) {
            return "unit";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public double value() {
        return this.value;
    }

    public DataSizeUnit unit() {
        return this.unit;
    }

    public String toString() {
        if (RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(this.value())) == this.value()) {
            return new StringBuilder(0).append((long)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(this.value()))).append(this.unit().unitString()).toString();
        }
        return StringOps$.MODULE$.format$extension("%.2f%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.value()), this.unit().unitString()}));
    }

    public long toBytes() {
        double bytes = this.valueOf(DataSize$BYTE$.MODULE$);
        DataSize$.MODULE$.checkState(bytes <= (double)Long.MAX_VALUE, new StringBuilder(48).append(this).append(" is too large to represent in bytes in Long type").toString());
        return (long)bytes;
    }

    public double valueOf(DataSizeUnit unit) {
        return this.value() * ((double)this.unit().factor() * 1.0 / (double)unit.factor());
    }

    public DataSize convertTo(DataSizeUnit unit) {
        return DataSize$.MODULE$.apply(this.valueOf(unit), unit);
    }

    public DataSize mostSuccinctDataSize() {
        DataSizeUnit targetUnit = this.loop$1(DataSize$BYTE$.MODULE$, (List)DataSize$.MODULE$.units().tail());
        return this.convertTo(targetUnit);
    }

    public long roundTo(DataSizeUnit unit) {
        double rounded = RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(this.valueOf(unit) + 0.5));
        DataSize$.MODULE$.checkState(rounded <= (double)Long.MAX_VALUE, new StringBuilder(43).append(this).append(" is too large to represent in ").append(unit.unitString()).append(" in Long type").toString());
        return (long)rounded;
    }

    @Override
    public int compareTo(DataSize o) {
        return Predef$.MODULE$.double2Double(this.valueOf(DataSize$BYTE$.MODULE$)).compareTo(Predef$.MODULE$.double2Double(o.valueOf(DataSize$BYTE$.MODULE$)));
    }

    public DataSize copy(double value, DataSizeUnit unit) {
        return new DataSize(value, unit);
    }

    public double copy$default$1() {
        return this.value();
    }

    public DataSizeUnit copy$default$2() {
        return this.unit();
    }

    public double _1() {
        return this.value();
    }

    public DataSizeUnit _2() {
        return this.unit();
    }

    private static final Object $init$$$anonfun$1() {
        return "infinite size";
    }

    private static final Object $init$$$anonfun$2() {
        return "size is not a number";
    }

    private static final Object $init$$$anonfun$3(double value$1, DataSizeUnit unit$1) {
        return new StringBuilder(16).append("negative size ").append(value$1).append(", ").append(unit$1).toString();
    }

    private final DataSizeUnit loop$1(DataSizeUnit unit, List remaining) {
        while (!remaining.isEmpty()) {
            DataSizeUnit nextUnit = (DataSizeUnit)remaining.head();
            if (this.valueOf(nextUnit) < 1.0) {
                return unit;
            }
            DataSizeUnit dataSizeUnit = nextUnit;
            List list = (List)remaining.tail();
            unit = dataSizeUnit;
            remaining = list;
        }
        return unit;
    }

    public static abstract class DataSizeUnit {
        private final long factor;
        private final String unitString;

        public DataSizeUnit(long factor, String unitString) {
            this.factor = factor;
            this.unitString = unitString;
        }

        public long factor() {
            return this.factor;
        }

        public String unitString() {
            return this.unitString;
        }
    }

    public static class LongToDataSizeConverter {
        private final long bytes;

        public LongToDataSizeConverter(long bytes) {
            this.bytes = bytes;
        }

        public DataSize toDataSize() {
            return DataSize$.MODULE$.apply(this.bytes);
        }
    }

    public static class StrToDataSizeConverter {
        private final String dataSizeStr;

        public StrToDataSizeConverter(String dataSizeStr) {
            this.dataSizeStr = dataSizeStr;
        }

        public DataSize toDataSize() {
            return DataSize$.MODULE$.apply(this.dataSizeStr);
        }
    }
}

