/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.metrics;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import wvlet.airframe.metrics.ElapsedTime$;

public class ElapsedTime
implements Comparable<ElapsedTime>,
Product,
Serializable {
    private final double value;
    private final TimeUnit unit;

    public static ElapsedTime apply(double d, TimeUnit timeUnit) {
        return ElapsedTime$.MODULE$.apply(d, timeUnit);
    }

    public static ElapsedTime apply(String string) {
        return ElapsedTime$.MODULE$.apply(string);
    }

    public static ElapsedTime fromProduct(Product product) {
        return ElapsedTime$.MODULE$.fromProduct(product);
    }

    public static double millisPerTimeUnit(TimeUnit timeUnit) {
        return ElapsedTime$.MODULE$.millisPerTimeUnit(timeUnit);
    }

    public static ElapsedTime nanosSince(long l) {
        return ElapsedTime$.MODULE$.nanosSince(l);
    }

    public static ElapsedTime parse(String string) {
        return ElapsedTime$.MODULE$.parse(string);
    }

    public static ElapsedTime succinctDuration(double d, TimeUnit timeUnit) {
        return ElapsedTime$.MODULE$.succinctDuration(d, timeUnit);
    }

    public static ElapsedTime succinctMillis(long l) {
        return ElapsedTime$.MODULE$.succinctMillis(l);
    }

    public static ElapsedTime succinctNanos(long l) {
        return ElapsedTime$.MODULE$.succinctNanos(l);
    }

    public static String timeUnitToString(TimeUnit timeUnit) {
        return ElapsedTime$.MODULE$.timeUnitToString(timeUnit);
    }

    public static ElapsedTime unapply(ElapsedTime elapsedTime) {
        return ElapsedTime$.MODULE$.unapply(elapsedTime);
    }

    public static List<TimeUnit> units() {
        return ElapsedTime$.MODULE$.units();
    }

    public static TimeUnit valueOfTimeUnit(String string) {
        return ElapsedTime$.MODULE$.valueOfTimeUnit(string);
    }

    public ElapsedTime(double value, TimeUnit unit) {
        this.value = value;
        this.unit = unit;
        Predef$.MODULE$.require(!Predef$.MODULE$.double2Double(value).isInfinite(), ElapsedTime::$init$$$anonfun$1);
        Predef$.MODULE$.require(!Predef$.MODULE$.double2Double(value).isNaN(), ElapsedTime::$init$$$anonfun$2);
        Predef$.MODULE$.require(value >= 0.0, () -> ElapsedTime.$init$$$anonfun$3(value, unit));
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.value()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)((Object)this.unit())));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ElapsedTime)) return false;
        ElapsedTime elapsedTime = (ElapsedTime)object;
        if (this.value() != elapsedTime.value()) return false;
        TimeUnit timeUnit = this.unit();
        TimeUnit timeUnit2 = elapsedTime.unit();
        if (timeUnit == null) {
            if (timeUnit2 != null) {
                return false;
            }
        } else if (!((Object)((Object)timeUnit)).equals((Object)timeUnit2)) return false;
        if (!elapsedTime.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof ElapsedTime;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "ElapsedTime";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return BoxesRunTime.boxToDouble((double)this._1());
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "value";
        }
        if (1 == n2) {
            return "unit";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public double value() {
        return this.value;
    }

    public TimeUnit unit() {
        return this.unit;
    }

    public double toMillis() {
        return this.roundTo(package$.MODULE$.MILLISECONDS());
    }

    public double valueIn(TimeUnit targetUnit) {
        return this.value() * ElapsedTime$.MODULE$.millisPerTimeUnit(this.unit()) * 1.0 / ElapsedTime$.MODULE$.millisPerTimeUnit(targetUnit);
    }

    public double roundTo(TimeUnit targetUnit) {
        return Math.floor(this.valueIn(targetUnit) + 0.5);
    }

    public ElapsedTime convertTo(TimeUnit targetUnit) {
        return ElapsedTime$.MODULE$.apply(this.valueIn(targetUnit), targetUnit);
    }

    public ElapsedTime convertToMostSuccinctTimeUnit() {
        return this.convertTo(this.unitToUse$1(package$.MODULE$.NANOSECONDS(), ElapsedTime$.MODULE$.units()));
    }

    public String toString() {
        double magnitude = this.valueIn(this.unit());
        String timeUnitAbbreviation = ElapsedTime$.MODULE$.timeUnitToString(this.unit());
        return StringOps$.MODULE$.format$extension("%.2f%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)magnitude), timeUnitAbbreviation}));
    }

    @Override
    public int compareTo(ElapsedTime o) {
        return Predef$.MODULE$.double2Double(this.valueIn(package$.MODULE$.MILLISECONDS())).compareTo(Predef$.MODULE$.double2Double(o.valueIn(package$.MODULE$.MILLISECONDS())));
    }

    public ElapsedTime copy(double value, TimeUnit unit) {
        return new ElapsedTime(value, unit);
    }

    public double copy$default$1() {
        return this.value();
    }

    public TimeUnit copy$default$2() {
        return this.unit();
    }

    public double _1() {
        return this.value();
    }

    public TimeUnit _2() {
        return this.unit();
    }

    private static final Object $init$$$anonfun$1() {
        return "infinite size";
    }

    private static final Object $init$$$anonfun$2() {
        return "value is not a number";
    }

    private static final Object $init$$$anonfun$3(double value$1, TimeUnit unit$1) {
        return new StringBuilder(16).append("negative size ").append(value$1).append(", ").append((Object)unit$1).toString();
    }

    private final TimeUnit unitToUse$1(TimeUnit current, List unitsToTest) {
        while (true) {
            if (unitsToTest.isEmpty()) {
                return current;
            }
            TimeUnit next = (TimeUnit)((Object)unitsToTest.head());
            if (!(this.valueIn(next) > 0.9999)) break;
            TimeUnit timeUnit = next;
            List list = (List)unitsToTest.tail();
            current = timeUnit;
            unitsToTest = list;
        }
        return current;
    }
}

