/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.metrics;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import wvlet.airframe.metrics.TimeParser;
import wvlet.airframe.metrics.TimeParser$TimeParseResult$;
import wvlet.airframe.metrics.TimeWindowUnit$Day$;
import wvlet.airframe.metrics.TimeWindowUnit$Second$;
import wvlet.airframe.metrics.package$;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class TimeParser$
implements LoggingMethods,
LazyLogger,
LogSupport,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(TimeParser$.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private static final DateTimeFormatter localDatePattern;
    private static final DateTimeFormatter localDateTimePattern;
    private static final List zonedDateTimePatterns;
    public static final TimeParser$TimeParseResult$ TimeParseResult;
    public static final TimeParser$ MODULE$;

    private TimeParser$() {
    }

    static {
        MODULE$ = new TimeParser$();
        localDatePattern = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        localDateTimePattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.SSS]");
        zonedDateTimePatterns = ((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"yyyy-MM-dd HH:mm:ss[.SSS][ z][XXXXX][XXXX]['['VV']']", "yyyy-MM-dd'T'HH:mm:ss[.SSS][ z][XXXXX][XXXX]['['VV']']"}))).map((Function1 & Serializable)_$1 -> DateTimeFormatter.ofPattern(_$1));
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TimeParser$.class);
    }

    public DateTimeFormatter localDatePattern() {
        return localDatePattern;
    }

    public DateTimeFormatter localDateTimePattern() {
        return localDateTimePattern;
    }

    public List<DateTimeFormatter> zonedDateTimePatterns() {
        return zonedDateTimePatterns;
    }

    public Option<TimeParser.TimeParseResult> parseLocalDateTime(String s, ZoneOffset zone) {
        return Try$.MODULE$.apply(() -> this.parseLocalDateTime$$anonfun$1(s)).map((Function1 & Serializable)d -> TimeParser$TimeParseResult$.MODULE$.apply(ZonedDateTime.of(d, zone), TimeWindowUnit$Second$.MODULE$)).orElse(() -> this.parseLocalDateTime$$anonfun$3(s, zone)).toOption();
    }

    public Option<TimeParser.TimeParseResult> parseZonedDateTime(String s) {
        return this.loop$1(s, this.zonedDateTimePatterns().toList());
    }

    public Option<ZonedDateTime> parseAtLocalTimeZone(String s) {
        return this.parse(s, package$.MODULE$.systemTimeZone());
    }

    public Option<ZonedDateTime> parse(String s, ZoneOffset zone) {
        return this.parseTimeAndUnit(s, zone).map((Function1 & Serializable)_$2 -> _$2.dateTime());
    }

    public Option<TimeParser.TimeParseResult> parseTimeAndUnit(String s, ZoneOffset zone) {
        return this.parseLocalDateTime(s, zone).orElse(() -> this.parseTimeAndUnit$$anonfun$1(s));
    }

    private final LocalDateTime parseLocalDateTime$$anonfun$1(String s$1) {
        return LocalDateTime.parse(s$1, this.localDateTimePattern());
    }

    private final LocalDate parseLocalDateTime$$anonfun$3$$anonfun$1(String s$3) {
        return LocalDate.parse(s$3, this.localDatePattern());
    }

    private final Try parseLocalDateTime$$anonfun$3(String s$2, ZoneOffset zone$2) {
        return Try$.MODULE$.apply(() -> this.parseLocalDateTime$$anonfun$3$$anonfun$1(s$2)).map((Function1 & Serializable)d -> TimeParser$TimeParseResult$.MODULE$.apply(d.atStartOfDay(zone$2), TimeWindowUnit$Day$.MODULE$));
    }

    private final ZonedDateTime loop$1$$anonfun$1(String s$5, DateTimeFormatter formatter$1) {
        return ZonedDateTime.parse(s$5, formatter$1);
    }

    private final Option loop$1(String s$4, List lst) {
        Try try_;
        while (true) {
            if (lst.isEmpty()) {
                return None$.MODULE$;
            }
            DateTimeFormatter formatter = (DateTimeFormatter)lst.head();
            try_ = Try$.MODULE$.apply(() -> this.loop$1$$anonfun$1(s$4, formatter));
            if (try_ instanceof Success) {
                ZonedDateTime dt = (ZonedDateTime)((Success)try_).value();
                return Some$.MODULE$.apply((Object)TimeParser$TimeParseResult$.MODULE$.apply(dt, TimeWindowUnit$Second$.MODULE$));
            }
            if (!(try_ instanceof Failure)) break;
            Throwable e = ((Failure)try_).exception();
            lst = (List)lst.tail();
        }
        throw new MatchError((Object)try_);
    }

    private final Option parseTimeAndUnit$$anonfun$1(String s$6) {
        return this.parseZonedDateTime(s$6);
    }
}

