/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.metrics;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import scala.runtime.ModuleSerializationProxy;
import wvlet.airframe.metrics.package$;

public final class TimeStampFormatter$
implements Serializable {
    private static final DateTimeFormatter noSpaceTimestampFormat;
    private static final DateTimeFormatter humanReadableTimestampFormatter;
    public static final TimeStampFormatter$ MODULE$;

    private TimeStampFormatter$() {
    }

    static {
        MODULE$ = new TimeStampFormatter$();
        noSpaceTimestampFormat = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('.').appendValue(ChronoField.MILLI_OF_SECOND, 3).appendOffset("+HHMM", "Z").toFormatter(Locale.US);
        humanReadableTimestampFormatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendOffset("+HHMM", "Z").toFormatter(Locale.US);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TimeStampFormatter$.class);
    }

    public DateTimeFormatter noSpaceTimestampFormat() {
        return noSpaceTimestampFormat;
    }

    public DateTimeFormatter humanReadableTimestampFormatter() {
        return humanReadableTimestampFormatter;
    }

    public String formatTimestamp(ZonedDateTime time) {
        return this.humanReadableTimestampFormatter().format(time);
    }

    public String formatTimestamp(long timeMillis, ZoneOffset zone) {
        ZonedDateTime timestamp = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeMillis), zone);
        return this.humanReadableTimestampFormatter().format(timestamp);
    }

    public ZoneOffset formatTimestamp$default$2() {
        return package$.MODULE$.systemTimeZone();
    }

    public String formatTimestampWithNoSpace(long timeMillis) {
        ZonedDateTime timestamp = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeMillis), package$.MODULE$.systemTimeZone());
        return this.noSpaceTimestampFormat().format(timestamp);
    }
}

