/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.metrics;

import java.io.Serializable;
import java.time.ZonedDateTime;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.deriving.Mirror;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichDouble$;
import scala.util.matching.Regex;
import wvlet.airframe.metrics.TimeVector;
import wvlet.airframe.metrics.TimeWindow;
import wvlet.airframe.metrics.TimeWindow$;
import wvlet.airframe.metrics.TimeWindowUnit;
import wvlet.airframe.metrics.TimeWindowUnit$;
import wvlet.airframe.metrics.TimeWindowUnit$Day$;
import wvlet.airframe.metrics.TimeWindowUnit$Hour$;
import wvlet.airframe.metrics.TimeWindowUnit$Month$;
import wvlet.airframe.metrics.TimeWindowUnit$Second$;
import wvlet.airframe.metrics.TimeWindowUnit$Week$;
import wvlet.airframe.metrics.TimeWindowUnit$Year$;

public final class TimeVector$
implements Mirror.Product,
Serializable {
    private static final Regex durationPattern;
    public static final TimeVector$ MODULE$;

    private TimeVector$() {
    }

    static {
        MODULE$ = new TimeVector$();
        durationPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(?<prefix>[+-]|last|next)?(?<num>[0-9]+)(?<unit>s|m|d|h|w|M|q|y)"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TimeVector$.class);
    }

    public TimeVector apply(long x, long offset, TimeWindowUnit unit) {
        return new TimeVector(x, offset, unit);
    }

    public TimeVector unapply(TimeVector x$1) {
        return x$1;
    }

    public String toString() {
        return "TimeVector";
    }

    public TimeVector apply(String s) {
        String string = s;
        switch (string == null ? 0 : string.hashCode()) {
            case -1621979774: {
                if (!"yesterday".equals(string)) break;
                return this.apply(-1L, 0L, TimeWindowUnit$Day$.MODULE$);
            }
            case -1459764838: {
                if (!"lastHour".equals(string)) break;
                return this.apply(-1L, 0L, TimeWindowUnit$Hour$.MODULE$);
            }
            case -1459328086: {
                if (!"lastWeek".equals(string)) break;
                return this.apply(-1L, 0L, TimeWindowUnit$Week$.MODULE$);
            }
            case -1459268621: {
                if (!"lastYear".equals(string)) break;
                return this.apply(-1L, 0L, TimeWindowUnit$Year$.MODULE$);
            }
            case -1037172987: {
                if (!"tomorrow".equals(string)) break;
                return this.apply(1L, 1L, TimeWindowUnit$Day$.MODULE$);
            }
            case -577153406: {
                if (!"thisMonth".equals(string)) break;
                return this.apply(-1L, 1L, TimeWindowUnit$Month$.MODULE$);
            }
            case 110534465: {
                if (!"today".equals(string)) break;
                return this.apply(-1L, 1L, TimeWindowUnit$Day$.MODULE$);
            }
            case 1200457549: {
                if (!"nextMonth".equals(string)) break;
                return this.apply(1L, 1L, TimeWindowUnit$Month$.MODULE$);
            }
            case 1228159394: {
                if (!"thisHour".equals(string)) break;
                return this.apply(-1L, 1L, TimeWindowUnit$Hour$.MODULE$);
            }
            case 1228596146: {
                if (!"thisWeek".equals(string)) break;
                return this.apply(-1L, 1L, TimeWindowUnit$Week$.MODULE$);
            }
            case 1228655611: {
                if (!"thisYear".equals(string)) break;
                return this.apply(-1L, 1L, TimeWindowUnit$Year$.MODULE$);
            }
            case 1424049015: {
                if (!"nextHour".equals(string)) break;
                return this.apply(1L, 1L, TimeWindowUnit$Hour$.MODULE$);
            }
            case 1424485767: {
                if (!"nextWeek".equals(string)) break;
                return this.apply(1L, 1L, TimeWindowUnit$Week$.MODULE$);
            }
            case 1424545232: {
                if (!"nextYear".equals(string)) break;
                return this.apply(1L, 1L, TimeWindowUnit$Year$.MODULE$);
            }
            case 1996541322: {
                if (!"lastMonth".equals(string)) break;
                return this.apply(-1L, 0L, TimeWindowUnit$Month$.MODULE$);
            }
        }
        String other = string;
        Option option = durationPattern.findFirstMatchIn((CharSequence)s);
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(18).append("Invalid duration: ").append(s).toString());
        }
        if (option instanceof Some) {
            Regex.Match m = (Regex.Match)((Some)option).value();
            int length = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(m.group("num")));
            TimeWindowUnit unit = TimeWindowUnit$.MODULE$.of(m.group("unit"));
            String string2 = m.group("prefix");
            if ("-".equals(string2) || "last".equals(string2)) {
                return this.apply(Int$.MODULE$.int2long(-length), 0L, unit);
            }
            if (string2 == null || "+".equals(string2) || "next".equals(string2)) {
                return this.apply(Int$.MODULE$.int2long(length), 0L, unit);
            }
            String other2 = string2;
            throw new IllegalArgumentException(new StringBuilder(25).append("Unknown duration prefix: ").append(other2).toString());
        }
        throw new MatchError((Object)option);
    }

    public TimeVector succinctTimeVector(long startUnixTime, long endUnixTime) {
        TimeWindow r = TimeWindow$.MODULE$.withUTC().fromRange(startUnixTime, endUnixTime);
        double secondDiff = endUnixTime - startUnixTime;
        return this.loop$1(startUnixTime, endUnixTime, r, secondDiff, TimeWindowUnit$.MODULE$.units().reverse());
    }

    public TimeVector fromProduct(Product x$0) {
        return new TimeVector(BoxesRunTime.unboxToLong((Object)x$0.productElement(0)), BoxesRunTime.unboxToLong((Object)x$0.productElement(1)), (TimeWindowUnit)x$0.productElement(2));
    }

    private final TimeVector loop$1(long startUnixTime$1, long endUnixTime$1, TimeWindow r$1, double secondDiff$1, List unitsToUse) {
        while (!unitsToUse.isEmpty()) {
            TimeWindowUnit unit = (TimeWindowUnit)unitsToUse.head();
            long numUnits = r$1.howMany(unit);
            ZonedDateTime startTruncated = unit.truncate(r$1.start());
            ZonedDateTime endTruncated = unit.truncate(r$1.end());
            TimeWindow truncated = TimeWindow$.MODULE$.apply(startTruncated, endTruncated);
            long truncatedSecondDiff = truncated.secondDiff();
            if (numUnits > 0L && RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper((secondDiff$1 - (double)truncatedSecondDiff) / (double)(numUnits * (long)unit.secondsInUnit()))) <= 0.001) {
                return this.apply(numUnits, 0L, unit);
            }
            unitsToUse = (List)unitsToUse.tail();
        }
        return this.apply(endUnixTime$1 - startUnixTime$1, 0L, TimeWindowUnit$Second$.MODULE$);
    }
}

