/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.metrics;

import java.io.Serializable;
import java.time.ZonedDateTime;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import wvlet.airframe.metrics.TimeVector$;
import wvlet.airframe.metrics.TimeWindow;
import wvlet.airframe.metrics.TimeWindow$;
import wvlet.airframe.metrics.TimeWindowUnit;

public class TimeVector
implements Product,
Serializable {
    private final long x;
    private final long offset;
    private final TimeWindowUnit unit;

    public static TimeVector apply(long l, long l2, TimeWindowUnit timeWindowUnit) {
        return TimeVector$.MODULE$.apply(l, l2, timeWindowUnit);
    }

    public static TimeVector apply(String string) {
        return TimeVector$.MODULE$.apply(string);
    }

    public static TimeVector fromProduct(Product product) {
        return TimeVector$.MODULE$.fromProduct(product);
    }

    public static TimeVector succinctTimeVector(long l, long l2) {
        return TimeVector$.MODULE$.succinctTimeVector(l, l2);
    }

    public static TimeVector unapply(TimeVector timeVector) {
        return TimeVector$.MODULE$.unapply(timeVector);
    }

    public TimeVector(long x, long offset, TimeWindowUnit unit) {
        this.x = x;
        this.offset = offset;
        this.unit = unit;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.x()));
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.offset()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.unit()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TimeVector)) return false;
        TimeVector timeVector = (TimeVector)object;
        if (this.x() != timeVector.x()) return false;
        if (this.offset() != timeVector.offset()) return false;
        TimeWindowUnit timeWindowUnit = this.unit();
        TimeWindowUnit timeWindowUnit2 = timeVector.unit();
        if (timeWindowUnit == null) {
            if (timeWindowUnit2 != null) {
                return false;
            }
        } else if (!timeWindowUnit.equals(timeWindowUnit2)) return false;
        if (!timeVector.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof TimeVector;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "TimeVector";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToLong((long)this._1());
            }
            case 1: {
                return BoxesRunTime.boxToLong((long)this._2());
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "x";
            }
            case 1: {
                return "offset";
            }
            case 2: {
                return "unit";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public long x() {
        return this.x;
    }

    public long offset() {
        return this.offset;
    }

    public TimeWindowUnit unit() {
        return this.unit;
    }

    public String toString() {
        return this.toDurationString();
    }

    public String toDurationString() {
        if (this.offset() == 0L) {
            return new StringBuilder(0).append(this.x()).append(this.unit().symbol()).toString();
        }
        return new StringBuilder(1).append(this.x()).append(this.unit().symbol()).append("/").append(this.offset()).append(this.unit().symbol()).toString();
    }

    public TimeWindow timeWindowFrom(ZonedDateTime context) {
        ZonedDateTime start;
        ZonedDateTime grid = this.unit().truncate(context);
        ZonedDateTime startOffset = this.unit().increment(grid, this.offset());
        ZonedDateTime end = this.unit().increment(startOffset, this.x());
        boolean onGrid = grid.compareTo(context) == 0;
        ZonedDateTime zonedDateTime = start = onGrid ? startOffset : context;
        if (start.compareTo(end) <= 0) {
            return TimeWindow$.MODULE$.apply(start, end);
        }
        return TimeWindow$.MODULE$.apply(end, start);
    }

    public TimeVector copy(long x, long offset, TimeWindowUnit unit) {
        return new TimeVector(x, offset, unit);
    }

    public long copy$default$1() {
        return this.x();
    }

    public long copy$default$2() {
        return this.offset();
    }

    public TimeWindowUnit copy$default$3() {
        return this.unit();
    }

    public long _1() {
        return this.x();
    }

    public long _2() {
        return this.offset();
    }

    public TimeWindowUnit _3() {
        return this.unit();
    }
}

