/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.metrics;

import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import wvlet.airframe.metrics.TimeStampFormatter$;
import wvlet.airframe.metrics.TimeWindow$;
import wvlet.airframe.metrics.TimeWindowBuilder;
import wvlet.airframe.metrics.TimeWindowUnit;
import wvlet.airframe.metrics.TimeWindowUnit$Day$;
import wvlet.airframe.metrics.TimeWindowUnit$Hour$;
import wvlet.airframe.metrics.TimeWindowUnit$Minute$;
import wvlet.airframe.metrics.TimeWindowUnit$Month$;
import wvlet.airframe.metrics.TimeWindowUnit$Quarter$;
import wvlet.airframe.metrics.TimeWindowUnit$Second$;
import wvlet.airframe.metrics.TimeWindowUnit$Week$;
import wvlet.airframe.metrics.TimeWindowUnit$Year$;

public class TimeWindow
implements Product,
Serializable {
    private final ZonedDateTime start;
    private final ZonedDateTime end;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(TimeWindow$.class.getDeclaredField("logger$lzy1"));

    public static TimeWindow apply(ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2) {
        return TimeWindow$.MODULE$.apply(zonedDateTime, zonedDateTime2);
    }

    public static TimeWindow fromProduct(Product product) {
        return TimeWindow$.MODULE$.fromProduct(product);
    }

    public static TimeWindow unapply(TimeWindow timeWindow) {
        return TimeWindow$.MODULE$.unapply(timeWindow);
    }

    public static TimeWindowBuilder withSystemTimeZone() {
        return TimeWindow$.MODULE$.withSystemTimeZone();
    }

    public static TimeWindowBuilder withTimeZone(String string) {
        return TimeWindow$.MODULE$.withTimeZone(string);
    }

    public static TimeWindowBuilder withTimeZone(ZoneId zoneId) {
        return TimeWindow$.MODULE$.withTimeZone(zoneId);
    }

    public static TimeWindowBuilder withUTC() {
        return TimeWindow$.MODULE$.withUTC();
    }

    public TimeWindow(ZonedDateTime start, ZonedDateTime end) {
        this.start = start;
        this.end = end;
        Predef$.MODULE$.require(start.compareTo(end) <= 0, () -> TimeWindow.$init$$$anonfun$1(start, end));
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TimeWindow)) return false;
        TimeWindow timeWindow = (TimeWindow)object;
        ZonedDateTime zonedDateTime = this.start();
        ZonedDateTime zonedDateTime2 = timeWindow.start();
        if (zonedDateTime == null) {
            if (zonedDateTime2 != null) {
                return false;
            }
        } else if (!((Object)zonedDateTime).equals(zonedDateTime2)) return false;
        ZonedDateTime zonedDateTime3 = this.end();
        ZonedDateTime zonedDateTime4 = timeWindow.end();
        if (zonedDateTime3 == null) {
            if (zonedDateTime4 != null) {
                return false;
            }
        } else if (!((Object)zonedDateTime3).equals(zonedDateTime4)) return false;
        if (!timeWindow.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof TimeWindow;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "TimeWindow";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "start";
        }
        if (1 == n2) {
            return "end";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ZonedDateTime start() {
        return this.start;
    }

    public ZonedDateTime end() {
        return this.end;
    }

    private Instant instantOfStart() {
        return this.start().toInstant();
    }

    private Instant instantOfEnd() {
        return this.end().toInstant();
    }

    public long startUnixTime() {
        return this.start().toEpochSecond();
    }

    public long endUnixTime() {
        return this.end().toEpochSecond();
    }

    public long startEpochMillis() {
        return this.instantOfStart().toEpochMilli();
    }

    public long endEpochMillis() {
        return this.instantOfEnd().toEpochMilli();
    }

    public String toString() {
        String s = TimeStampFormatter$.MODULE$.formatTimestamp(this.start());
        String e = TimeStampFormatter$.MODULE$.formatTimestamp(this.end());
        return new StringBuilder(3).append("[").append(s).append(",").append(e).append(")").toString();
    }

    public String toStringAt(ZoneOffset zone) {
        String s = TimeStampFormatter$.MODULE$.formatTimestamp(this.startEpochMillis(), zone);
        String e = TimeStampFormatter$.MODULE$.formatTimestamp(this.endEpochMillis(), zone);
        return new StringBuilder(3).append("[").append(s).append(",").append(e).append(")").toString();
    }

    /*
     * Unable to fully structure code
     */
    private Seq<TimeWindow> splitInto(ChronoUnit unit) {
        b = package$.MODULE$.Seq().newBuilder();
        cursor = this.start();
        while (cursor.compareTo(this.end()) < 0) {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                var5_5 = unit;
                                v0 = ChronoUnit.DAYS;
                                var6_6 = var5_5;
                                if (v0 != null) break block9;
                                if (var6_6 == null) ** GOTO lbl-1000
                                break block10;
                            }
                            if (v0.equals(var6_6)) ** GOTO lbl-1000
                        }
                        v1 = ChronoUnit.HOURS;
                        var7_7 = var5_5;
                        if (v1 != null) break block11;
                        if (var7_7 == null) ** GOTO lbl-1000
                        break block12;
                    }
                    if (v1.equals(var7_7)) ** GOTO lbl-1000
                }
                v2 = ChronoUnit.MINUTES;
                var8_8 = var5_5;
                if (v2 != null) break block13;
                if (var8_8 == null) ** GOTO lbl-1000
                ** GOTO lbl-1000
            }
            if (v2.equals(var8_8)) lbl-1000:
            // 6 sources

            {
                v3 = cursor.plus(1L, unit).truncatedTo(unit);
            } else lbl-1000:
            // 2 sources

            {
                v4 = ChronoUnit.WEEKS;
                var9_9 = var5_5;
                if (!(v4 != null ? v4.equals(var9_9) == false : var9_9 != null)) {
                    v3 = cursor.plus(1L, unit).with(DayOfWeek.MONDAY);
                } else {
                    v5 = ChronoUnit.MONTHS;
                    var10_10 = var5_5;
                    if (!(v5 != null ? v5.equals(var10_10) == false : var10_10 != null)) {
                        v3 = cursor.plus(1L, unit).withDayOfMonth(1);
                    } else {
                        v6 = ChronoUnit.YEARS;
                        var11_11 = var5_5;
                        if (!(v6 != null ? v6.equals(var11_11) == false : var11_11 != null)) {
                            v3 = cursor.plus(1L, unit).withDayOfYear(1);
                        } else {
                            other = var5_5;
                            throw new IllegalStateException(new StringBuilder(30).append("Invalid split unit ").append(unit).append(" for range ").append(this.toString()).toString());
                        }
                    }
                }
            }
            e = v3;
            v7 = e.compareTo(this.end()) <= 0 ? (Builder)b.$plus$eq((Object)TimeWindow$.MODULE$.apply(cursor, e)) : (Builder)b.$plus$eq((Object)TimeWindow$.MODULE$.apply(cursor, this.end()));
            cursor = e;
        }
        return (Seq)b.result();
    }

    public Seq<TimeWindow> splitIntoHours() {
        return this.splitInto(ChronoUnit.HOURS);
    }

    public Seq<TimeWindow> splitIntoDays() {
        return this.splitInto(ChronoUnit.DAYS);
    }

    public Seq<TimeWindow> splitIntoMonths() {
        return this.splitInto(ChronoUnit.MONTHS);
    }

    public Seq<TimeWindow> splitIntoWeeks() {
        return this.splitInto(ChronoUnit.WEEKS);
    }

    public Seq<TimeWindow> splitAt(ZonedDateTime date) {
        if (date.compareTo(this.start()) <= 0 || date.compareTo(this.end()) > 0) {
            return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TimeWindow[]{this}));
        }
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TimeWindow[]{TimeWindow$.MODULE$.apply(this.start(), date), TimeWindow$.MODULE$.apply(date, this.end())}));
    }

    public TimeWindow plus(long n, ChronoUnit unit) {
        return TimeWindow$.MODULE$.apply(this.start().plus(n, unit), this.end().plus(n, unit));
    }

    public TimeWindow minus(long n, ChronoUnit unit) {
        return this.plus(-n, unit);
    }

    public long howMany(ChronoUnit unit) {
        return unit.between(this.start(), this.end());
    }

    public long howMany(TimeWindowUnit unit) {
        TimeWindowUnit timeWindowUnit = unit;
        if (TimeWindowUnit$Year$.MODULE$.equals(timeWindowUnit)) {
            return this.howMany(ChronoUnit.YEARS);
        }
        if (TimeWindowUnit$Quarter$.MODULE$.equals(timeWindowUnit)) {
            ZonedDateTime startTruncated = unit.truncate(this.start());
            ZonedDateTime endTruncated = unit.truncate(this.end());
            int yearDiff = endTruncated.getYear() - startTruncated.getYear();
            return Int$.MODULE$.int2long((endTruncated.getMonthValue() + yearDiff * 12 - startTruncated.getMonthValue()) / 3);
        }
        if (TimeWindowUnit$Month$.MODULE$.equals(timeWindowUnit)) {
            return this.monthDiff();
        }
        if (TimeWindowUnit$Week$.MODULE$.equals(timeWindowUnit)) {
            return this.weekDiff();
        }
        if (TimeWindowUnit$Day$.MODULE$.equals(timeWindowUnit)) {
            return this.dateDiff();
        }
        if (TimeWindowUnit$Hour$.MODULE$.equals(timeWindowUnit)) {
            return this.hourDiff();
        }
        if (TimeWindowUnit$Minute$.MODULE$.equals(timeWindowUnit)) {
            return this.minuteDiff();
        }
        if (TimeWindowUnit$Second$.MODULE$.equals(timeWindowUnit)) {
            return this.secondDiff();
        }
        throw new MatchError((Object)timeWindowUnit);
    }

    public long secondDiff() {
        return this.howMany(ChronoUnit.SECONDS);
    }

    public long minuteDiff() {
        return this.howMany(ChronoUnit.MINUTES);
    }

    public long hourDiff() {
        return this.howMany(ChronoUnit.HOURS);
    }

    public long dateDiff() {
        return this.howMany(ChronoUnit.DAYS);
    }

    public long weekDiff() {
        return this.howMany(ChronoUnit.WEEKS);
    }

    public long monthDiff() {
        return this.howMany(ChronoUnit.MONTHS);
    }

    public long yearDiff() {
        return this.howMany(ChronoUnit.YEARS);
    }

    public boolean intersectsWith(TimeWindow other) {
        return this.start().compareTo(other.end()) < 0 && this.end().compareTo(other.start()) > 0;
    }

    public TimeWindow copy(ZonedDateTime start, ZonedDateTime end) {
        return new TimeWindow(start, end);
    }

    public ZonedDateTime copy$default$1() {
        return this.start();
    }

    public ZonedDateTime copy$default$2() {
        return this.end();
    }

    public ZonedDateTime _1() {
        return this.start();
    }

    public ZonedDateTime _2() {
        return this.end();
    }

    private static final Object $init$$$anonfun$1(ZonedDateTime start$1, ZonedDateTime end$1) {
        return new StringBuilder(18).append("invalid range: ").append(TimeStampFormatter$.MODULE$.formatTimestamp(start$1)).append(" > ").append(TimeStampFormatter$.MODULE$.formatTimestamp(end$1)).toString();
    }
}

