/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.metrics;

import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;
import wvlet.airframe.metrics.TimeParser;
import wvlet.airframe.metrics.TimeParser$;
import wvlet.airframe.metrics.TimeVector;
import wvlet.airframe.metrics.TimeVector$;
import wvlet.airframe.metrics.TimeWindow;
import wvlet.airframe.metrics.TimeWindow$;
import wvlet.airframe.metrics.TimeWindowBuilder$;
import wvlet.airframe.metrics.TimeWindowUnit;
import wvlet.airframe.metrics.TimeWindowUnit$Second$;
import wvlet.airframe.metrics.package$;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public class TimeWindowBuilder
implements LoggingMethods,
LazyLogger,
LogSupport {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(TimeWindowBuilder.class.getDeclaredField("logger$lzy2"));
    private volatile Object logger$lzy2;
    private final ZoneOffset zone;
    private final Option<ZonedDateTime> currentTime;

    public static Option<ZonedDateTime> $lessinit$greater$default$2() {
        return TimeWindowBuilder$.MODULE$.$lessinit$greater$default$2();
    }

    public TimeWindowBuilder(ZoneOffset zone, Option<ZonedDateTime> currentTime) {
        this.zone = zone;
        this.currentTime = currentTime;
    }

    public Logger logger() {
        Object object = this.logger$lzy2;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT2();
    }

    private Object logger$lzyINIT2() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy2) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy2;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ZoneOffset zone() {
        return this.zone;
    }

    public TimeWindowBuilder withOffset(ZonedDateTime t) {
        return new TimeWindowBuilder(this.zone(), (Option<ZonedDateTime>)Some$.MODULE$.apply((Object)t));
    }

    public TimeWindowBuilder withOffset(String dateTimeStr) {
        return (TimeWindowBuilder)TimeParser$.MODULE$.parse(dateTimeStr, this.zone()).map((Function1 & Serializable)d -> this.withOffset((ZonedDateTime)d)).getOrElse(() -> TimeWindowBuilder.withOffset$$anonfun$2(dateTimeStr));
    }

    public TimeWindowBuilder withUnixTimeOffset(long unixTime) {
        return this.withOffset(ZonedDateTime.ofInstant(Instant.ofEpochSecond(unixTime), package$.MODULE$.UTC()));
    }

    public ZonedDateTime now() {
        return (ZonedDateTime)this.currentTime.getOrElse(this::now$$anonfun$1);
    }

    public ZonedDateTime beginningOfTheHour() {
        return this.now().truncatedTo(ChronoUnit.HOURS);
    }

    public ZonedDateTime endOfTheHour() {
        return this.beginningOfTheHour().plusHours(1L);
    }

    public ZonedDateTime beginningOfTheDay() {
        return this.now().truncatedTo(ChronoUnit.DAYS);
    }

    public ZonedDateTime endOfTheDay() {
        return this.beginningOfTheDay().plusDays(1L);
    }

    public ZonedDateTime beginningOfTheWeek() {
        return this.now().truncatedTo(ChronoUnit.DAYS).with(DayOfWeek.MONDAY);
    }

    public ZonedDateTime endOfTheWeek() {
        return this.beginningOfTheWeek().plusWeeks(1L);
    }

    public ZonedDateTime beginningOfTheMonth() {
        return this.now().withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS);
    }

    public ZonedDateTime endOfTheMonth() {
        return this.beginningOfTheMonth().plusMonths(1L);
    }

    public ZonedDateTime beginningOfTheYear() {
        return this.now().withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
    }

    public ZonedDateTime endOfTheYear() {
        return this.beginningOfTheYear().plusYears(1L);
    }

    public TimeWindow today() {
        return TimeWindow$.MODULE$.apply(this.beginningOfTheDay(), this.endOfTheDay());
    }

    public TimeWindow thisHour() {
        return TimeWindow$.MODULE$.apply(this.beginningOfTheHour(), this.endOfTheHour());
    }

    public TimeWindow thisWeek() {
        return TimeWindow$.MODULE$.apply(this.beginningOfTheWeek(), this.endOfTheWeek());
    }

    public TimeWindow thisMonth() {
        return TimeWindow$.MODULE$.apply(this.beginningOfTheMonth(), this.endOfTheMonth());
    }

    public TimeWindow thisYear() {
        return TimeWindow$.MODULE$.apply(this.beginningOfTheYear(), this.endOfTheYear());
    }

    public TimeWindow yesterday() {
        return this.today().minus(1L, ChronoUnit.DAYS);
    }

    private ZonedDateTime parseOffset(String o, TimeWindowUnit windowUnit, Seq<TimeVector> adjustments) {
        Regex pattern;
        Option option;
        while ((option = (pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(?<duration>[^/]+)(?<sep>/(?<offset>.+))"))).findFirstMatchIn((CharSequence)o)) instanceof Some) {
            Regex.Match m = (Regex.Match)((Some)option).value();
            String d = m.group("duration");
            TimeVector duration = TimeVector$.MODULE$.apply(d);
            String string = m.group("offset");
            Seq seq = (Seq)adjustments.$plus$colon((Object)duration);
            o = string;
            adjustments = seq;
        }
        if (None$.MODULE$.equals(option)) {
            String string = o;
            if ("now".equals(string)) {
                return this.adjustOffset(this.now(), adjustments);
            }
            String other = string;
            Try try_ = Try$.MODULE$.apply(() -> TimeWindowBuilder.parseOffset$$anonfun$1(o));
            if (try_ instanceof Success) {
                TimeVector x = (TimeVector)((Success)try_).value();
                if (x.x() <= 0L) {
                    return x.timeWindowFrom(this.adjustOffset(this.now(), (Seq<TimeVector>)adjustments)).start();
                }
                return x.timeWindowFrom(this.adjustOffset(this.now(), (Seq<TimeVector>)adjustments)).end();
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                Tuple2 tuple2 = o.endsWith(")") ? Tuple2$.MODULE$.apply((Object)o.substring(0, o.length() - 1), (Object)BoxesRunTime.boxToBoolean((boolean)false)) : Tuple2$.MODULE$.apply((Object)o, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                String timeString = (String)tuple2._1();
                boolean truncate = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                return (ZonedDateTime)TimeParser$.MODULE$.parse(timeString, this.zone()).map((Function1 & Serializable)offset -> this.adjustOffset((ZonedDateTime)offset, (Seq<TimeVector>)adjustments)).map((Function1 & Serializable)offset -> {
                    if (truncate) {
                        return windowUnit.truncate((ZonedDateTime)offset);
                    }
                    return offset;
                }).getOrElse(() -> TimeWindowBuilder.parseOffset$$anonfun$4(o));
            }
            throw new MatchError((Object)try_);
        }
        throw new MatchError((Object)option);
    }

    private Seq<TimeVector> parseOffset$default$3() {
        return scala.package$.MODULE$.Nil();
    }

    private ZonedDateTime adjustOffset(ZonedDateTime offset, Seq<TimeVector> adjustments) {
        return (ZonedDateTime)adjustments.foldLeft((Object)offset, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                ZonedDateTime offset = (ZonedDateTime)tuple2._1();
                TimeVector duration = (TimeVector)tuple2._2();
                return duration.unit().increment(offset, duration.x());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public TimeWindow parse(String str) {
        Regex pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(?<duration>[^/]+)(?<sep>/(?<offset>.*))?"));
        Option option = pattern.findFirstMatchIn((CharSequence)str);
        if (option instanceof Some) {
            Regex.Match m = (Regex.Match)((Some)option).value();
            String d = m.group("duration");
            Option<TimeParser.TimeParseResult> option2 = TimeParser$.MODULE$.parseTimeAndUnit(d, this.zone());
            if (option2 instanceof Some) {
                ZonedDateTime zonedDateTime;
                TimeParser.TimeParseResult exactStartTime = (TimeParser.TimeParseResult)((Some)option2).value();
                String string = m.group("offset");
                if (string == null) {
                    TimeVector thisUnit = TimeVector$.MODULE$.apply(-1L, 1L, exactStartTime.unit());
                    zonedDateTime = thisUnit.timeWindowFrom(exactStartTime.dateTime()).end();
                } else {
                    String offsetStr = string;
                    zonedDateTime = this.parseOffset(offsetStr, TimeWindowUnit$Second$.MODULE$, this.parseOffset$default$3());
                }
                ZonedDateTime offset = zonedDateTime;
                return TimeWindow$.MODULE$.apply(exactStartTime.dateTime(), offset);
            }
            if (None$.MODULE$.equals(option2)) {
                TimeVector duration = TimeVector$.MODULE$.apply(d);
                String string = m.group("offset");
                if (string == null) {
                    ZonedDateTime context = duration.unit().truncate(this.now());
                    return duration.timeWindowFrom(context);
                }
                String offsetStr = string;
                ZonedDateTime offset = this.parseOffset(offsetStr, duration.unit(), this.parseOffset$default$3());
                return duration.timeWindowFrom(offset);
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(14).append("TimeRange.of(").append(str).append(")").toString());
        }
        throw new MatchError((Object)option);
    }

    public TimeWindow fromRange(long startUnixTime, long endUnixTime) {
        return TimeWindow$.MODULE$.apply(Instant.ofEpochSecond(startUnixTime).atZone(this.zone()), Instant.ofEpochSecond(endUnixTime).atZone(this.zone()));
    }

    private static final TimeWindowBuilder withOffset$$anonfun$2(String dateTimeStr$1) {
        throw new IllegalArgumentException(new StringBuilder(18).append("Invalid datetime: ").append(dateTimeStr$1).toString());
    }

    private final ZonedDateTime now$$anonfun$1() {
        return ZonedDateTime.now(this.zone());
    }

    private static final TimeVector parseOffset$$anonfun$1(String o$tailLocal1$1) {
        return TimeVector$.MODULE$.apply(o$tailLocal1$1);
    }

    private static final ZonedDateTime parseOffset$$anonfun$4(String o$tailLocal1$2) {
        throw new IllegalArgumentException(new StringBuilder(23).append("Invalid offset string: ").append(o$tailLocal1$2).toString());
    }
}

