/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.regex.Pattern;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.io.AnsiColor;
import scala.runtime.ModuleSerializationProxy;
import wvlet.airframe.log.AnsiColorPalette;
import wvlet.log.LogFormatter$AppLogFormatter$;
import wvlet.log.LogFormatter$BareFormatter$;
import wvlet.log.LogFormatter$IntelliJLogFormatter$;
import wvlet.log.LogFormatter$PlainSourceCodeLogFormatter$;
import wvlet.log.LogFormatter$SimpleLogFormatter$;
import wvlet.log.LogFormatter$SourceCodeLogFormatter$;
import wvlet.log.LogFormatter$TSVLogFormatter$;
import wvlet.log.LogFormatter$ThreadLogFormatter$;
import wvlet.log.LogLevel;
import wvlet.log.LogLevel$DEBUG$;
import wvlet.log.LogLevel$ERROR$;
import wvlet.log.LogLevel$INFO$;
import wvlet.log.LogLevel$TRACE$;
import wvlet.log.LogLevel$WARN$;
import wvlet.log.LogRecord;

public final class LogFormatter$
implements AnsiColor,
AnsiColorPalette,
Serializable {
    private static final Pattern testFrameworkFilter;
    private static final Function1 DEFAULT_STACKTRACE_FILTER;
    private static Function1<String, Object> stackTraceFilter;
    public static final LogFormatter$TSVLogFormatter$ TSVLogFormatter;
    public static final LogFormatter$SimpleLogFormatter$ SimpleLogFormatter;
    public static final LogFormatter$AppLogFormatter$ AppLogFormatter;
    public static final LogFormatter$SourceCodeLogFormatter$ SourceCodeLogFormatter;
    public static final LogFormatter$ThreadLogFormatter$ ThreadLogFormatter;
    public static final LogFormatter$PlainSourceCodeLogFormatter$ PlainSourceCodeLogFormatter;
    public static final LogFormatter$IntelliJLogFormatter$ IntelliJLogFormatter;
    public static final LogFormatter$BareFormatter$ BareFormatter;
    public static final LogFormatter$ MODULE$;

    private LogFormatter$() {
    }

    static {
        MODULE$ = new LogFormatter$();
        AnsiColor.$init$((AnsiColor)MODULE$);
        AnsiColorPalette.$init$(MODULE$);
        testFrameworkFilter = Pattern.compile("\\s+at (sbt\\.|org\\.scalatest\\.|wvlet\\.airspec\\.).*");
        DEFAULT_STACKTRACE_FILTER = (Function1 & Serializable)line -> !testFrameworkFilter.matcher((CharSequence)line).matches();
        stackTraceFilter = MODULE$.DEFAULT_STACKTRACE_FILTER();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LogFormatter$.class);
    }

    public String currentThreadName() {
        return Thread.currentThread().getName();
    }

    public Function1<String, Object> DEFAULT_STACKTRACE_FILTER() {
        return DEFAULT_STACKTRACE_FILTER;
    }

    public void setStackTraceFilter(Function1<String, Object> filter) {
        stackTraceFilter = filter;
    }

    public String formatStacktrace(Throwable e) {
        Throwable throwable = e;
        if (throwable == null) {
            return "";
        }
        StringWriter trace = new StringWriter();
        e.printStackTrace(new PrintWriter(trace));
        Object[] stackTraceLines = trace.toString().split("\n");
        Object object = Predef$.MODULE$.refArrayOps(stackTraceLines);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, stackTraceFilter));
        Iterator filtered = ArrayOps$.MODULE$.sliding$extension(object2, 2, ArrayOps$.MODULE$.sliding$default$2$extension(object2)).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(String[] x) {
                Object object;
                String[] stringArray = x;
                if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 2) == 0) {
                    String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                    String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                    String a = string;
                    String b = string2;
                    String string3 = a;
                    String string4 = b;
                    if (string3 == null ? string4 != null : !string3.equals(string4)) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(String[] x, Function1 function1) {
                Object object;
                String[] stringArray = x;
                if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 2) == 0) {
                    String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                    String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                    String a = string;
                    String b = string2;
                    String string3 = a;
                    String string4 = b;
                    if (string3 == null ? string4 != null : !string3.equals(string4)) {
                        return b;
                    }
                }
                return function1.apply((Object)x);
            }
        });
        Object object3 = Predef$.MODULE$.refArrayOps(stackTraceLines);
        return ((IterableOnceOps)Option$.MODULE$.option2Iterable(ArrayOps$.MODULE$.headOption$extension(object3)).$plus$plus((IterableOnce)filtered)).mkString("\n");
    }

    public String withColor(String prefix, String s) {
        return new StringBuilder(4).append(prefix).append(s).append("\u001b[0m").toString();
    }

    public String highlightLog(LogLevel level, String message) {
        LogLevel logLevel = level;
        String color = LogLevel$ERROR$.MODULE$.equals(logLevel) ? "\u001b[31m" : (LogLevel$WARN$.MODULE$.equals(logLevel) ? "\u001b[33m" : (LogLevel$INFO$.MODULE$.equals(logLevel) ? "\u001b[36m" : (LogLevel$DEBUG$.MODULE$.equals(logLevel) ? "\u001b[32m" : (LogLevel$TRACE$.MODULE$.equals(logLevel) ? "\u001b[35m" : "\u001b[0m"))));
        return this.withColor(color, message);
    }

    public String appendStackTrace(String m, LogRecord r, boolean coloring) {
        Option<Throwable> option = r.cause();
        if (option instanceof Some) {
            Throwable throwable;
            Throwable ex = throwable = (Throwable)((Some)option).value();
            if (coloring) {
                return new StringBuilder(1).append(m).append("\n").append(this.highlightLog(r.level(), this.formatStacktrace(ex))).toString();
            }
            Throwable ex2 = throwable;
            return new StringBuilder(1).append(m).append("\n").append(this.formatStacktrace(ex2)).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return m;
        }
        throw new MatchError(option);
    }

    public boolean appendStackTrace$default$3() {
        return true;
    }
}

