/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import wvlet.log.LogLevel$WARN$;
import wvlet.log.LogLevelScanner;
import wvlet.log.LogLevelScanner$RUNNING$;
import wvlet.log.LogLevelScanner$STOPPED$;
import wvlet.log.LogLevelScanner$STOPPING$;
import wvlet.log.LogLevelScannerConfig;
import wvlet.log.LogLevelScannerConfig$;
import wvlet.log.Logger;
import wvlet.log.Logger$;
import wvlet.log.io.IOUtil$;
import wvlet.log.io.Resource$;

public final class LogLevelScanner$
implements Serializable {
    private static final Logger logger;
    private static final List DEFAULT_LOGLEVEL_FILE_CANDIDATES;
    private volatile Object logLevelScanner$lzy1;
    public static final LogLevelScanner$RUNNING$ RUNNING;
    public static final LogLevelScanner$STOPPING$ STOPPING;
    public static final LogLevelScanner$STOPPED$ STOPPED;
    public static final LogLevelScanner$ MODULE$;

    private LogLevelScanner$() {
    }

    static {
        MODULE$ = new LogLevelScanner$();
        logger = Logger$.MODULE$.apply("wvlet.log.LogLevelScanner");
        DEFAULT_LOGLEVEL_FILE_CANDIDATES = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"log-test.properties", "log.properties"}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LogLevelScanner$.class);
    }

    public void setLogLevels(File file) {
        Properties logLevels = new Properties();
        IOUtil$.MODULE$.withResource(new FileReader(file), (JProcedure1 & Serializable)in -> logLevels.load((Reader)in));
        Logger$.MODULE$.setLogLevels(logLevels);
    }

    public List<String> DEFAULT_LOGLEVEL_FILE_CANDIDATES() {
        return DEFAULT_LOGLEVEL_FILE_CANDIDATES;
    }

    public void scanLogLevels() {
        this.scanLogLevels((Seq<String>)this.DEFAULT_LOGLEVEL_FILE_CANDIDATES());
    }

    public void scanLogLevels(Seq<String> loglevelFileCandidates) {
        this.scan((List<String>)loglevelFileCandidates.toList(), (Option<Object>)None$.MODULE$);
    }

    public void scheduleLogLevelScan() {
        this.scheduleLogLevelScan(LogLevelScannerConfig$.MODULE$.apply(this.DEFAULT_LOGLEVEL_FILE_CANDIDATES(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.MINUTES)));
    }

    public LogLevelScanner logLevelScanner() {
        Object object = this.logLevelScanner$lzy1;
        if (object instanceof LogLevelScanner) {
            return (LogLevelScanner)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LogLevelScanner)this.logLevelScanner$lzyINIT1();
    }

    private Object logLevelScanner$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logLevelScanner$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, LogLevelScanner.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LogLevelScanner logLevelScanner = null;
                    try {
                        logLevelScanner = new LogLevelScanner();
                        object2 = logLevelScanner == null ? LazyVals.NullValue$.MODULE$ : logLevelScanner;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, LogLevelScanner.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logLevelScanner$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, LogLevelScanner.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logLevelScanner;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, LogLevelScanner.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void scheduleLogLevelScan(LogLevelScannerConfig config) {
        this.logLevelScanner().setConfig(config);
        this.logLevelScanner().start();
    }

    public void scheduleLogLevelScan(Duration duration) {
        this.scheduleLogLevelScan(LogLevelScannerConfig$.MODULE$.apply(this.DEFAULT_LOGLEVEL_FILE_CANDIDATES(), duration));
    }

    public void stopScheduledLogLevelScan() {
        this.logLevelScanner().stop();
    }

    public Option<Object> scan(List<String> logLevelFileCandidates, Option<Object> lastScannedMillis) {
        Option<Object> option;
        try {
            Option logFileURL = this.findLogLevelFile$1(logLevelFileCandidates);
            option = (Option<Object>)logFileURL.map((Function1 & Serializable)url -> {
                String string = url.getProtocol();
                if ("file".equals(string)) {
                    File f = new File(url.toURI());
                    long lastModified = f.lastModified();
                    if (lastScannedMillis.isEmpty() || BoxesRunTime.unboxToLong((Object)lastScannedMillis.get()) < lastModified) {
                        this.setLogLevels(f);
                        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()));
                    }
                    return lastScannedMillis;
                }
                String other = string;
                if (lastScannedMillis.isEmpty()) {
                    return (Option)IOUtil$.MODULE$.withResource(url.openStream(), (Function1 & Serializable)in -> {
                        Properties p = new Properties();
                        p.load((InputStream)in);
                        Logger$.MODULE$.setLogLevels(p);
                        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()));
                    });
                }
                return None$.MODULE$;
            }).getOrElse(() -> this.scan$$anonfun$2(lastScannedMillis));
        }
        catch (Throwable e) {
            logger.wrapped().log(LogLevel$WARN$.MODULE$.jlLevel(), new StringBuilder(46).append("Error occurred while scanning log properties: ").append(e.getMessage()).toString(), e);
            option = lastScannedMillis;
        }
        return option;
    }

    private final Option findLogLevelFile$1(List candidates) {
        Option<URL> option;
        while (true) {
            if (candidates.isEmpty()) {
                return None$.MODULE$;
            }
            option = Resource$.MODULE$.find((String)candidates.head());
            if (option instanceof Some) {
                Some x = (Some)option;
                return x;
            }
            if (!None$.MODULE$.equals(option)) break;
            candidates = (List)candidates.tail();
        }
        throw new MatchError(option);
    }

    private final Option scan$$anonfun$2(Option lastScannedMillis$2) {
        return lastScannedMillis$2;
    }
}

