/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import wvlet.log.Guard;
import wvlet.log.LogLevelScanner$;
import wvlet.log.LogLevelScanner$RUNNING$;
import wvlet.log.LogLevelScanner$STOPPED$;
import wvlet.log.LogLevelScanner$STOPPING$;
import wvlet.log.LogLevelScannerConfig;
import wvlet.log.LogLevelScannerConfig$;

public class LogLevelScanner
implements Guard {
    private ReentrantLock wvlet$log$Guard$$lock;
    private final AtomicReference<LogLevelScannerConfig> config;
    private final Condition configChanged;
    private final AtomicLong scanCount;
    private final AtomicReference<ScannerState> state;
    private Option<Object> lastScheduledMillis;
    private Option<Object> lastScannedMillis;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(LogLevelScanner$.class.getDeclaredField("logLevelScanner$lzy1"));

    public static List<String> DEFAULT_LOGLEVEL_FILE_CANDIDATES() {
        return LogLevelScanner$.MODULE$.DEFAULT_LOGLEVEL_FILE_CANDIDATES();
    }

    public static LogLevelScanner logLevelScanner() {
        return LogLevelScanner$.MODULE$.logLevelScanner();
    }

    public static Option<Object> scan(List<String> list, Option<Object> option) {
        return LogLevelScanner$.MODULE$.scan(list, option);
    }

    public static void scanLogLevels() {
        LogLevelScanner$.MODULE$.scanLogLevels();
    }

    public static void scanLogLevels(Seq<String> seq) {
        LogLevelScanner$.MODULE$.scanLogLevels(seq);
    }

    public static void scheduleLogLevelScan() {
        LogLevelScanner$.MODULE$.scheduleLogLevelScan();
    }

    public static void scheduleLogLevelScan(Duration duration) {
        LogLevelScanner$.MODULE$.scheduleLogLevelScan(duration);
    }

    public static void scheduleLogLevelScan(LogLevelScannerConfig logLevelScannerConfig) {
        LogLevelScanner$.MODULE$.scheduleLogLevelScan(logLevelScannerConfig);
    }

    public static void setLogLevels(File file) {
        LogLevelScanner$.MODULE$.setLogLevels(file);
    }

    public static void stopScheduledLogLevelScan() {
        LogLevelScanner$.MODULE$.stopScheduledLogLevelScan();
    }

    public LogLevelScanner() {
        Guard.$init$(this);
        this.config = new AtomicReference<LogLevelScannerConfig>(LogLevelScannerConfig$.MODULE$.apply((List<String>)scala.package$.MODULE$.List().empty(), LogLevelScannerConfig$.MODULE$.$lessinit$greater$default$2()));
        this.configChanged = this.newCondition();
        this.scanCount = new AtomicLong(0L);
        this.state = new AtomicReference<LogLevelScanner$STOPPED$>(LogLevelScanner$STOPPED$.MODULE$);
        this.lastScheduledMillis = None$.MODULE$;
        this.lastScannedMillis = None$.MODULE$;
        Statics.releaseFence();
    }

    @Override
    public ReentrantLock wvlet$log$Guard$$lock() {
        return this.wvlet$log$Guard$$lock;
    }

    @Override
    public void wvlet$log$Guard$_setter_$wvlet$log$Guard$$lock_$eq(ReentrantLock x$0) {
        this.wvlet$log$Guard$$lock = x$0;
    }

    public AtomicLong scanCount() {
        return this.scanCount;
    }

    public LogLevelScannerConfig getConfig() {
        return this.config.get();
    }

    public void setConfig(LogLevelScannerConfig config) {
        this.guard((Function0 & Serializable)() -> {
            this.setConfig$$anonfun$1(config);
            return BoxedUnit.UNIT;
        });
    }

    public void start() {
        this.guard((Function0 & Serializable)() -> {
            this.start$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public void stop() {
        this.guard((Function0 & Serializable)() -> {
            this.stop$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public void wvlet$log$LogLevelScanner$$run() {
        while (!this.state.compareAndSet(LogLevelScanner$STOPPING$.MODULE$, LogLevelScanner$STOPPED$.MODULE$)) {
            long currentTimeMillis = System.currentTimeMillis();
            long scanIntervalMillis = this.getConfig().scanInterval().toMillis();
            if (this.lastScheduledMillis.isEmpty() || currentTimeMillis - BoxesRunTime.unboxToLong((Object)this.lastScheduledMillis.get()) > scanIntervalMillis) {
                Option<Object> updatedLastScannedMillis = LogLevelScanner$.MODULE$.scan(this.getConfig().logLevelFileCandidates(), this.lastScannedMillis);
                this.scanCount().incrementAndGet();
                this.guard((Function0 & Serializable)() -> {
                    this.run$$anonfun$1(updatedLastScannedMillis);
                    return BoxedUnit.UNIT;
                });
                this.lastScheduledMillis = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)currentTimeMillis));
            }
            long sleepTime = scanIntervalMillis - package$.MODULE$.max(0L, package$.MODULE$.min(scanIntervalMillis, currentTimeMillis - BoxesRunTime.unboxToLong((Object)this.lastScheduledMillis.get())));
            this.guard((Function0 & Serializable)() -> {
                this.run$$anonfun$2(sleepTime);
                return BoxedUnit.UNIT;
            });
        }
    }

    private final void setConfig$$anonfun$1(LogLevelScannerConfig config$1) {
        LogLevelScannerConfig prev = this.config.get();
        List<String> list = prev.logLevelFileCandidates();
        List<String> list2 = config$1.logLevelFileCandidates();
        if (list == null ? list2 != null : !list.equals(list2)) {
            this.lastScannedMillis = None$.MODULE$;
        }
        this.config.set(config$1);
        this.configChanged.signalAll();
    }

    private final void start$$anonfun$1() {
        this.state.compareAndSet(LogLevelScanner$STOPPING$.MODULE$, LogLevelScanner$RUNNING$.MODULE$);
        if (this.state.compareAndSet(LogLevelScanner$STOPPED$.MODULE$, LogLevelScanner$RUNNING$.MODULE$)) {
            new LogLevelScannerThread().start();
            return;
        }
    }

    private final void stop$$anonfun$1() {
        this.state.set(LogLevelScanner$STOPPING$.MODULE$);
    }

    private final void run$$anonfun$1(Option updatedLastScannedMillis$1) {
        this.lastScannedMillis = updatedLastScannedMillis$1;
    }

    private final void run$$anonfun$2(long sleepTime$1) {
        if (this.configChanged.await(sleepTime$1, TimeUnit.MILLISECONDS)) {
            return;
        }
    }

    public class LogLevelScannerThread
    extends Thread {
        public LogLevelScannerThread() {
            if (LogLevelScanner.this == null) {
                throw new NullPointerException();
            }
            this.setName("AirframeLogLevelScanner");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            LogLevelScanner.this.wvlet$log$LogLevelScanner$$run();
        }

        public final /* synthetic */ LogLevelScanner wvlet$log$LogLevelScanner$LogLevelScannerThread$$$outer() {
            return LogLevelScanner.this;
        }
    }

    public static interface ScannerState {
    }
}

