/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.EncoderBase;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.util.FileSize;
import java.io.File;
import java.io.Flushable;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import wvlet.log.LogFormatter;
import wvlet.log.LogRotationHandler$;

public class LogRotationHandler
extends Handler
implements AutoCloseable,
Flushable {
    private final LogFormatter formatter;
    private final String logFileExt;
    private final String tempFileExt;
    private final RollingFileAppender<String> fileAppender;

    public static int $lessinit$greater$default$2() {
        return LogRotationHandler$.MODULE$.$lessinit$greater$default$2();
    }

    public static long $lessinit$greater$default$3() {
        return LogRotationHandler$.MODULE$.$lessinit$greater$default$3();
    }

    public static LogFormatter $lessinit$greater$default$4() {
        return LogRotationHandler$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$5() {
        return LogRotationHandler$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$6() {
        return LogRotationHandler$.MODULE$.$lessinit$greater$default$6();
    }

    public LogRotationHandler(String fileName, int maxNumberOfFiles, long maxSizeInBytes, LogFormatter formatter, String logFileExt, String tempFileExt) {
        this.formatter = formatter;
        this.logFileExt = logFileExt;
        this.tempFileExt = tempFileExt;
        this.recoverTempFiles(fileName);
        this.setFormatter((Formatter)((Object)formatter));
        ContextBase context = new ContextBase();
        RollingFileAppender fileAppender = new RollingFileAppender();
        TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
        SizeAndTimeBasedFNATP triggeringPolicy = new SizeAndTimeBasedFNATP();
        rollingPolicy.setContext((Context)context);
        String fileNameStem = fileName.endsWith(logFileExt) ? fileName.substring(0, fileName.length() - logFileExt.length()) : fileName;
        rollingPolicy.setFileNamePattern(new StringBuilder(21).append(fileNameStem).append("-%d{yyyy-MM-dd}.%i").append(logFileExt).append(".gz").toString());
        rollingPolicy.setMaxHistory(maxNumberOfFiles);
        rollingPolicy.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)triggeringPolicy);
        rollingPolicy.setParent((FileAppender)fileAppender);
        triggeringPolicy.setContext((Context)context);
        triggeringPolicy.setTimeBasedRollingPolicy(rollingPolicy);
        triggeringPolicy.setMaxFileSize(new FileSize(maxSizeInBytes));
        fileAppender.setContext((Context)context);
        fileAppender.setFile(fileName);
        fileAppender.setAppend(true);
        fileAppender.setEncoder((Encoder)new StringEncoder());
        fileAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
        rollingPolicy.start();
        triggeringPolicy.start();
        fileAppender.start();
        this.fileAppender = fileAppender;
    }

    @Override
    public void flush() {
    }

    private Exception toException(Throwable t) {
        return new Exception(t.getMessage(), t);
    }

    @Override
    public void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            Try try_ = Try$.MODULE$.apply(() -> this.publish$$anonfun$1(record));
            if (try_ instanceof Success) {
                String message = (String)((Success)try_).value();
                Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.publish$$anonfun$2(message);
                    return BoxedUnit.UNIT;
                });
                if (try_2 instanceof Success) {
                    BoxedUnit x = (BoxedUnit)((Success)try_2).value();
                    return;
                }
                if (try_2 instanceof Failure) {
                    Throwable e = ((Failure)try_2).exception();
                    this.reportError(null, this.toException(e), 1);
                    return;
                }
                throw new MatchError((Object)try_2);
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                this.reportError(null, this.toException(e), 5);
                return;
            }
            throw new MatchError((Object)try_);
        }
    }

    @Override
    public void close() {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.close$$anonfun$1();
            return BoxedUnit.UNIT;
        });
        if (try_ instanceof Success) {
            BoxedUnit x = (BoxedUnit)((Success)try_).value();
            return;
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            this.reportError(null, this.toException(e), 3);
            return;
        }
        throw new MatchError((Object)try_);
    }

    private void recoverTempFiles(String logPath) {
        Option$.MODULE$.apply((Object)new File(logPath).getParentFile()).foreach((Function1)(JProcedure1 & Serializable)logPathFile -> Option$.MODULE$.apply((Object)logPathFile.listFiles()).foreach((Function1)(JProcedure1 & Serializable)fileList -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])fileList);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$1 -> _$1.getName().endsWith(this.tempFileExt)));
            ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)tempFile -> {
                String newName = tempFile.getName().substring(0, tempFile.getName().length() - StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(this.tempFileExt)));
                File newFile = new File(tempFile.getParent(), new StringBuilder(0).append(newName).append(this.logFileExt).toString());
                if (!tempFile.renameTo(newFile)) {
                    this.reportError(new StringBuilder(31).append("Failed to rename temp file ").append(tempFile).append(" to ").append(newFile).toString(), null, 4);
                    return;
                }
            });
        }));
    }

    private final String publish$$anonfun$1(LogRecord record$1) {
        return this.formatter.format(record$1);
    }

    private final void publish$$anonfun$2(String message$1) {
        this.fileAppender.doAppend((Object)new StringBuilder(1).append(message$1).append("\n").toString());
    }

    private final void close$$anonfun$1() {
        this.fileAppender.stop();
    }

    public static class StringEncoder
    extends EncoderBase<String> {
        public byte[] encode(String event) {
            return event.getBytes(StandardCharsets.UTF_8);
        }

        public byte[] headerBytes() {
            return Array$.MODULE$.emptyByteArray();
        }

        public byte[] footerBytes() {
            return Array$.MODULE$.emptyByteArray();
        }
    }
}

