/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import scala.Console$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.concurrent.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import wvlet.log.ConsoleLogHandler;
import wvlet.log.ConsoleLogHandler$;
import wvlet.log.LogEnv$;
import wvlet.log.LogFormatter;
import wvlet.log.LogLevel;
import wvlet.log.LogLevel$;
import wvlet.log.LogLevel$INFO$;
import wvlet.log.Logger;

public final class Logger$
implements Serializable {
    private volatile Object loggerCache$lzy1;
    private static final Logger rootLogger;
    public static final Logger$ MODULE$;

    private Logger$() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0_3;
        MODULE$ = new Logger$();
        LogEnv$.MODULE$.initLogManager();
        Seq seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Handler[]{LogEnv$.MODULE$.defaultHandler()}));
        Option<LogLevel> option = MODULE$.initLogger$default$2();
        boolean bl = MODULE$.initLogger$default$4();
        Logger l = MODULE$.initLogger("", option, (Seq<Handler>)seq, bl);
        if (LogEnv$.MODULE$.isScalaJS()) {
            l.setLogLevel(LogLevel$INFO$.MODULE$);
        }
        rootLogger = var0_3;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Logger$.class);
    }

    private Map<String, Logger> loggerCache() {
        Object object = this.loggerCache$lzy1;
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Map)this.loggerCache$lzyINIT1();
    }

    private Object loggerCache$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.loggerCache$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Logger.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Map map = null;
                    try {
                        map = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
                        object2 = map == null ? LazyVals.NullValue$.MODULE$ : map;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, Logger.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.loggerCache$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, Logger.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return map;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, Logger.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Logger rootLogger() {
        return rootLogger;
    }

    public Logger initLogger(String name, Option<LogLevel> level, Seq<Handler> handlers, boolean useParents) {
        Logger logger = this.apply(name);
        logger.clearHandlers();
        level.foreach((Function1)(JProcedure1 & Serializable)l -> logger.setLogLevel((LogLevel)l));
        handlers.foreach((Function1)(JProcedure1 & Serializable)h -> logger.addHandler((Handler)h));
        logger.setUseParentHandlers(useParents);
        return logger;
    }

    public Option<LogLevel> initLogger$default$2() {
        return None$.MODULE$;
    }

    public Seq<Handler> initLogger$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public boolean initLogger$default$4() {
        return true;
    }

    public <A> Logger of(ClassTag<A> evidence$1) {
        return this.apply(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass().getName());
    }

    public Logger apply(String loggerName) {
        return (Logger)this.loggerCache().getOrElseUpdate((Object)loggerName, () -> this.apply$$anonfun$1(loggerName));
    }

    public LogLevel getDefaultLogLevel() {
        return this.rootLogger().getLogLevel();
    }

    public void setDefaultLogLevel(LogLevel level) {
        this.rootLogger().setLogLevel(level);
    }

    public void setDefaultFormatter(LogFormatter formatter) {
        Logger$ logger$ = this;
        synchronized (logger$) {
            this.rootLogger().resetHandler(new ConsoleLogHandler(formatter, ConsoleLogHandler$.MODULE$.$lessinit$greater$default$2()));
        }
    }

    public void setDefaultHandler(Handler handler) {
        this.rootLogger().resetHandler(handler);
    }

    public void resetDefaultLogLevel() {
        this.rootLogger().resetLogLevel();
    }

    public void clearAllHandlers() {
        this.rootLogger().clearAllHandlers();
    }

    public void init() {
        this.clearAllHandlers();
        this.resetDefaultLogLevel();
        this.rootLogger().resetHandler(LogEnv$.MODULE$.defaultHandler());
    }

    public void setLogLevels(Properties logLevels) {
        CollectionConverters$.MODULE$.PropertiesHasAsScala(logLevels).asScala().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String loggerName = (String)tuple2._1();
                String level = (String)tuple2._2();
                return true;
            }
            return false;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String loggerName = (String)tuple2._1();
                String level = (String)tuple2._2();
                Option<LogLevel> option = LogLevel$.MODULE$.unapply(level);
                if (option instanceof Some) {
                    LogLevel lv = (LogLevel)((Some)option).value();
                    String string = loggerName;
                    String string2 = "_root_";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        this.rootLogger().setLogLevel(lv);
                        return;
                    }
                    this.apply(loggerName).setLogLevel(lv);
                    return;
                }
                if (None$.MODULE$.equals(option)) {
                    Console$.MODULE$.err().println(new StringBuilder(35).append("Unknown loglevel ").append(level).append(" is specified for ").append(loggerName).toString());
                    return;
                }
                throw new MatchError(option);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void scheduleLogLevelScan() {
        LogEnv$.MODULE$.scheduleLogLevelScan();
    }

    public void stopScheduledLogLevelScan() {
        LogEnv$.MODULE$.stopScheduledLogLevelScan();
    }

    public void scanLogLevels() {
        LogEnv$.MODULE$.scanLogLevels();
    }

    public void scanLogLevels(Seq<String> loglevelFileCandidates) {
        LogEnv$.MODULE$.scanLogLevels(loglevelFileCandidates);
    }

    private final Logger apply$$anonfun$1(String loggerName$1) {
        return new Logger(loggerName$1, java.util.logging.Logger.getLogger(loggerName$1));
    }
}

