/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import java.io.Serializable;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals$;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.util.Try;
import scala.util.Try$;
import wvlet.log.ConsoleLogHandler;
import wvlet.log.ConsoleLogHandler$;
import wvlet.log.LogFormatter;
import wvlet.log.LogFormatter$;
import wvlet.log.LogLevel;
import wvlet.log.LogLevel$;
import wvlet.log.LogLevel$ERROR$;
import wvlet.log.LogLevel$INFO$;
import wvlet.log.LogLevel$OFF$;
import wvlet.log.LogRecord;
import wvlet.log.LogRecord$;
import wvlet.log.LogSource;
import wvlet.log.Logger$;
import wvlet.log.LoggerBase;

public class Logger
implements LoggerBase,
Serializable {
    private final String name;
    private transient java.util.logging.Logger wrapped;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Logger$.class.getDeclaredField("loggerCache$lzy1"));

    public static Logger apply(String string) {
        return Logger$.MODULE$.apply(string);
    }

    public static LogLevel getDefaultLogLevel() {
        return Logger$.MODULE$.getDefaultLogLevel();
    }

    public static void init() {
        Logger$.MODULE$.init();
    }

    public static Logger initLogger(String string, Option<LogLevel> option, Seq<Handler> seq, boolean bl) {
        return Logger$.MODULE$.initLogger(string, option, seq, bl);
    }

    public static <A> Logger of(ClassTag<A> classTag) {
        return Logger$.MODULE$.of(classTag);
    }

    public static void resetDefaultLogLevel() {
        Logger$.MODULE$.resetDefaultLogLevel();
    }

    public static Logger rootLogger() {
        return Logger$.MODULE$.rootLogger();
    }

    public static void scanLogLevels() {
        Logger$.MODULE$.scanLogLevels();
    }

    public static void scanLogLevels(Seq<String> seq) {
        Logger$.MODULE$.scanLogLevels(seq);
    }

    public static void scheduleLogLevelScan() {
        Logger$.MODULE$.scheduleLogLevelScan();
    }

    public static void setDefaultFormatter(LogFormatter logFormatter) {
        Logger$.MODULE$.setDefaultFormatter(logFormatter);
    }

    public static void setDefaultHandler(Handler handler) {
        Logger$.MODULE$.setDefaultHandler(handler);
    }

    public static void setDefaultLogLevel(LogLevel logLevel) {
        Logger$.MODULE$.setDefaultLogLevel(logLevel);
    }

    public static void setLogLevels(Properties properties) {
        Logger$.MODULE$.setLogLevels(properties);
    }

    public static void stopScheduledLogLevelScan() {
        Logger$.MODULE$.stopScheduledLogLevelScan();
    }

    public static Option<LogLevel> initLogger$default$2() {
        return Logger$.MODULE$.initLogger$default$2();
    }

    public static Seq<Handler> initLogger$default$3() {
        return Logger$.MODULE$.initLogger$default$3();
    }

    public static boolean initLogger$default$4() {
        return Logger$.MODULE$.initLogger$default$4();
    }

    public Logger(String name, java.util.logging.Logger wrapped) {
        this.name = name;
        this.wrapped = wrapped;
    }

    private String name() {
        return this.name;
    }

    public java.util.logging.Logger wrapped() {
        return this.wrapped;
    }

    public void wrapped_$eq(java.util.logging.Logger x$1) {
        this.wrapped = x$1;
    }

    private java.util.logging.Logger _log() {
        if (this.wrapped() == null) {
            this.wrapped_$eq(java.util.logging.Logger.getLogger(this.name()));
        }
        return this.wrapped();
    }

    public String getName() {
        return this.name();
    }

    public LogLevel getLogLevel() {
        return Logger.getLogLevelOf$1(this._log());
    }

    public void setLogLevel(LogLevel l) {
        this._log().setLevel(l.jlLevel());
    }

    public void setFormatter(LogFormatter formatter) {
        this.resetHandler(new ConsoleLogHandler(formatter, ConsoleLogHandler$.MODULE$.$lessinit$greater$default$2()));
    }

    public void resetHandler(Handler h) {
        this.clearHandlers();
        this._log().addHandler(h);
        this.setUseParentHandlers(false);
    }

    public Option<Logger> getParent() {
        return Option$.MODULE$.apply((Object)this.wrapped().getParent()).map((Function1 & Serializable)x -> Logger$.MODULE$.apply(x.getName()));
    }

    public void addHandler(Handler h) {
        this._log().addHandler(h);
    }

    public void setUseParentHandlers(boolean use) {
        this._log().setUseParentHandlers(use);
    }

    public void clear() {
        this.clearHandlers();
        this.resetLogLevel();
    }

    public void clearHandlers() {
        Logger logger = this;
        synchronized (logger) {
            Option$.MODULE$.apply((Object)this._log().getHandlers()).foreach((Function1)(JProcedure1 & Serializable)lst -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])lst);
                ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)h -> this._log().removeHandler((Handler)h));
            });
        }
    }

    public void clearAllHandlers() {
        ObjectRef l = ObjectRef.create((Object)Some$.MODULE$.apply((Object)this));
        Logger logger = this;
        synchronized (logger) {
            while (((Option)l.elem).isDefined()) {
                ((Option)l.elem).map((Function1)(JProcedure1 & Serializable)x -> {
                    Option option;
                    x.clearHandlers();
                    l$1.elem = option = x.getParent();
                    option = null;
                });
            }
        }
    }

    public Seq<Handler> getHandlers() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.wrapped().getHandlers());
        return ArrayOps$.MODULE$.toSeq$extension(object);
    }

    public void resetLogLevel() {
        this._log().setLevel(null);
    }

    public boolean isEnabled(LogLevel level) {
        return this._log().isLoggable(level.jlLevel());
    }

    public void log(LogRecord record) {
        record.setLoggerName(this.name());
        this._log().log(record);
    }

    public void log(LogLevel level, LogSource source, Object message) {
        this.log(LogRecord$.MODULE$.apply(level, source, this.formatLog(message)));
    }

    public void logWithCause(LogLevel level, LogSource source, Object message, Throwable cause) {
        this.log(LogRecord$.MODULE$.apply(level, source, this.formatLog(message), cause));
    }

    public boolean isMultiLine(String str) {
        return str.contains("\n");
    }

    public String formatLog(Object message) {
        String formatted;
        String string;
        Object object = message;
        if (object == null) {
            string = "";
        } else if (object instanceof Error) {
            Error e = (Error)object;
            string = LogFormatter$.MODULE$.formatStacktrace(e);
        } else if (object instanceof Exception) {
            Exception e = (Exception)object;
            string = LogFormatter$.MODULE$.formatStacktrace(e);
        } else {
            string = formatted = message.toString();
        }
        if (this.isMultiLine(formatted)) {
            return new StringBuilder(1).append("\n").append(formatted).toString();
        }
        return formatted;
    }

    public <U> U suppressWarnings(Function0<U> f) {
        Object object;
        LogLevel prev = this.getLogLevel();
        try {
            this.setLogLevel(LogLevel$ERROR$.MODULE$);
            object = f.apply();
        }
        finally {
            this.setLogLevel(prev);
        }
        return (U)object;
    }

    public <U> U suppressLogs(Function0<U> f) {
        Object object;
        LogLevel prev = this.getLogLevel();
        try {
            this.setLogLevel(LogLevel$OFF$.MODULE$);
            object = f.apply();
        }
        finally {
            this.setLogLevel(prev);
        }
        return (U)object;
    }

    public <U> Future<U> suppressLogAroundFuture(Function0<Future<U>> body, ExecutionContext ec) {
        LogLevel prev = this.getLogLevel();
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            this.suppressLogAroundFuture$$anonfun$1();
            return BoxedUnit.UNIT;
        }, ec).flatMap((Function1 & Serializable)_$1 -> (Future)body.apply(), ec).transform((Function1 & Serializable)x$1 -> {
            Try try_;
            Try any = try_ = x$1;
            Try$.MODULE$.apply((Function0 & Serializable)() -> {
                this.suppressLogAroundFuture$$anonfun$3$$anonfun$1(prev);
                return BoxedUnit.UNIT;
            });
            return any;
        }, ec);
    }

    private static final LogLevel getLogLevelOf$1(java.util.logging.Logger l) {
        while (l != null) {
            Level jlLevel = l.getLevel();
            if (jlLevel != null) {
                return LogLevel$.MODULE$.apply(jlLevel);
            }
            l = l.getParent();
        }
        return LogLevel$INFO$.MODULE$;
    }

    private final void suppressLogAroundFuture$$anonfun$1() {
        this.setLogLevel(LogLevel$OFF$.MODULE$);
    }

    private final void suppressLogAroundFuture$$anonfun$3$$anonfun$1(LogLevel prev$2) {
        this.setLogLevel(prev$2);
    }
}

