/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import wvlet.log.io.Resource$;

public final class IOUtil$
implements Serializable {
    public static final IOUtil$ MODULE$ = new IOUtil$();

    private IOUtil$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IOUtil$.class);
    }

    public <Resource extends AutoCloseable, U> U withResource(Resource resource, Function1<Resource, U> body) {
        Object object;
        try {
            object = body.apply(resource);
        }
        finally {
            resource.close();
        }
        return (U)object;
    }

    public <U> U withTempFile(String name, String suffix, String dir, Function1<File, U> body) {
        Object object;
        File d = new File(dir);
        d.mkdirs();
        File f = File.createTempFile(name, suffix, d);
        try {
            object = body.apply((Object)f);
        }
        finally {
            f.delete();
        }
        return (U)object;
    }

    public <U> String withTempFile$default$2() {
        return ".tmp";
    }

    public <U> String withTempFile$default$3() {
        return "target";
    }

    public int randomPort() {
        return this.unusedPort();
    }

    public int unusedPort() {
        return BoxesRunTime.unboxToInt(this.withResource(new ServerSocket(0), (Function1 & Serializable)socket -> socket.getLocalPort()));
    }

    public Option<File> findPath(String path) {
        return this.findPath(new File(path));
    }

    public Option<File> findPath(File path) {
        if (path.exists()) {
            return Some$.MODULE$.apply((Object)path);
        }
        File defaultPath = new File(new File(System.getProperty("prog.home", "")), path.getPath());
        if (defaultPath.exists()) {
            return Some$.MODULE$.apply((Object)defaultPath);
        }
        return None$.MODULE$;
    }

    public String readAsString(File f) {
        return this.readAsString(f.toURI().toURL());
    }

    public String readAsString(URL url) {
        return (String)this.withResource(url.openStream(), (Function1 & Serializable)in -> this.readAsString((InputStream)in));
    }

    public String readAsString(String resourcePath) {
        Predef$.MODULE$.require(resourcePath != null, this::readAsString$$anonfun$2);
        return (String)Resource$.MODULE$.find(resourcePath).map((Function1 & Serializable)_$1 -> this.readAsString((URL)_$1)).getOrElse(() -> this.readAsString$$anonfun$4(resourcePath));
    }

    public String readAsString(InputStream in) {
        return (String)this.readFully(in, (Function1 & Serializable)data -> new String((byte[])data, StandardCharsets.UTF_8));
    }

    public <U> U readFully(InputStream in, Function1<byte[], U> f) {
        byte[] byteArray = (byte[])this.withResource(new ByteArrayOutputStream(), (Function1 & Serializable)b -> {
            byte[] buf = new byte[8192];
            this.withResource((AutoCloseable)in, (Function1)(JProcedure1 & Serializable)src -> {
                int readBytes = 0;
                while ((readBytes = src.read(buf)) != -1) {
                    b.write(buf, 0, readBytes);
                }
            });
            return b.toByteArray();
        });
        return (U)f.apply((Object)byteArray);
    }

    private final Object readAsString$$anonfun$2() {
        return "resourcePath is null";
    }

    private final String readAsString$$anonfun$4(String resourcePath$1) {
        Option<File> file = this.findPath(new File(resourcePath$1));
        if (file.isEmpty()) {
            throw new FileNotFoundException(new StringBuilder(10).append("Not found ").append(resourcePath$1).toString());
        }
        return this.readAsString(new FileInputStream((File)file.get()));
    }
}

