/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import wvlet.log.io.Resource;
import wvlet.log.io.Resource$FileInJar$;
import wvlet.log.io.Resource$SystemFile$;

public final class Resource$
implements Serializable {
    public static final Resource$SystemFile$ SystemFile;
    public static final Resource$FileInJar$ FileInJar;
    public static final Resource$ MODULE$;

    private Resource$() {
    }

    static {
        MODULE$ = new Resource$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Resource$.class);
    }

    public <U> U open(Class<?> referenceClass, String resourceFileName, Function1<BufferedInputStream, U> body) {
        Object object;
        Option<URL> u = this.find(referenceClass, resourceFileName);
        if (u.isEmpty()) {
            throw scala.sys.package$.MODULE$.error(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Resource %s (in %s) not found"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{resourceFileName, referenceClass.getSimpleName()})));
        }
        try (BufferedInputStream s = new BufferedInputStream(((URL)u.get()).openStream());){
            object = body.apply((Object)s);
        }
        return (U)object;
    }

    private String packagePath(Class<?> referenceClass) {
        return this.packagePath(referenceClass.getPackage());
    }

    private String packagePath(Package basePackage) {
        return this.packagePath(basePackage.getName());
    }

    private String packagePath(String packageName) {
        String packageAsPath = packageName.replaceAll("\\.", "/");
        if (packageAsPath.endsWith("/")) {
            return packageAsPath;
        }
        return new StringBuilder(1).append(packageAsPath).append("/").toString();
    }

    private ClassLoader currentClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private Option<URLClassLoader> findNextURLClassLoader(ClassLoader cl) {
        while (true) {
            ClassLoader classLoader;
            if ((classLoader = cl) instanceof URLClassLoader) {
                URLClassLoader u = (URLClassLoader)classLoader;
                return Some$.MODULE$.apply((Object)u);
            }
            if (classLoader == null) {
                return None$.MODULE$;
            }
            ClassLoader other = classLoader;
            cl = other.getParent();
        }
    }

    private String resolveResourcePath(String packageName, String resourceFileName) {
        String path = this.packagePath(packageName);
        return this.prependSlash(new StringBuilder(0).append(path).append(resourceFileName).toString());
    }

    private String prependSlash(String name) {
        if (name.startsWith("/")) {
            return name;
        }
        return new StringBuilder(1).append("/").append(name).toString();
    }

    public Option<URL> find(Class<?> referenceClass, String resourceFileName) {
        return this.find(this.packagePath(referenceClass), resourceFileName);
    }

    public Option<URL> find(String absoluteResourcePath) {
        return this.find("", absoluteResourcePath.startsWith("/") ? absoluteResourcePath.substring(1) : absoluteResourcePath);
    }

    public Option<URL> find(String packageName, String resourceFileName) {
        String resourcePath = this.resolveResourcePath(packageName, resourceFileName);
        return this.loop$1(resourcePath, this.currentClassLoader()).orElse(() -> this.find$$anonfun$1(resourcePath));
    }

    private String extractLogicalName(String packagePath, String resourcePath) {
        String p = !packagePath.endsWith("/") ? new StringBuilder(1).append(packagePath).append("/").toString() : packagePath;
        int pos = resourcePath.indexOf(p);
        if (pos < 0) {
            return null;
        }
        String logicalName = resourcePath.substring(pos + p.length());
        return logicalName;
    }

    private Seq<Resource.VirtualFile> collectFileResources(String resourceURLString, String packagePath, Function1<String, Object> resourceFilter) {
        String logicalName = this.extractLogicalName(packagePath, resourceURLString);
        if (logicalName == null) {
            throw new IllegalArgumentException(new StringBuilder(26).append("packagePath=").append(packagePath).append(", resourceURL=").append(resourceURLString).toString());
        }
        Builder b = package$.MODULE$.Seq().newBuilder();
        File file = new File(new URL(resourceURLString).toURI());
        if (BoxesRunTime.unboxToBoolean((Object)resourceFilter.apply((Object)file.getPath()))) {
            b.$plus$eq((Object)Resource$SystemFile$.MODULE$.apply(file, logicalName));
        }
        if (file.isDirectory()) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])file.listFiles());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)childFile -> {
                String childResourceURL = new StringBuilder(0).append(resourceURLString).append(resourceURLString.endsWith("/") ? "" : "/").append(childFile.getName()).toString();
                return (Builder)b.$plus$plus$eq(this.collectFileResources(childResourceURL, packagePath, resourceFilter));
            });
        }
        return (Seq)b.result();
    }

    private Seq<Resource.VirtualFile> listResources(URL resourceURL, String packageName, Function1<String, Object> resourceFilter) {
        Growable growable;
        String protocol;
        String pkgPath = this.packagePath(packageName);
        Builder fileList = package$.MODULE$.Seq().newBuilder();
        if (resourceURL == null) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        String string = protocol = resourceURL.getProtocol();
        String string2 = "file";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String resourceURLString = resourceURL.toString();
            growable = fileList.$plus$plus$eq(this.collectFileResources(resourceURLString, pkgPath, resourceFilter));
        } else {
            String string3 = protocol;
            String string4 = "jar";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                String path = resourceURL.getPath();
                int pos = path.indexOf("!");
                if (pos < 0) {
                    throw new IllegalArgumentException(new StringBuilder(22).append("invalid resource URL: ").append(resourceURL).toString());
                }
                String jarPath = path.substring(0, pos).replaceAll("%20", " ");
                String filePath = path.substring(0, pos).replaceAll("%20", " ").replaceAll("%25", "%").replace("file:", "");
                String jarURLString = new StringBuilder(4).append("jar:").append(jarPath).toString();
                JarFile jf = new JarFile(filePath);
                Enumeration<JarEntry> entryEnum = jf.entries();
                while (entryEnum.hasMoreElements()) {
                    JarEntry jarEntry = entryEnum.nextElement();
                    String physicalURL = new StringBuilder(2).append(jarURLString).append("!/").append(jarEntry.getName()).toString();
                    URL jarFileURL = new URL(physicalURL);
                    String logicalName = this.extractLogicalName(pkgPath, jarEntry.getName());
                    if (logicalName == null || !BoxesRunTime.unboxToBoolean((Object)resourceFilter.apply((Object)logicalName))) continue;
                    fileList.$plus$eq((Object)Resource$FileInJar$.MODULE$.apply(jarFileURL, logicalName, jarEntry.isDirectory()));
                }
                growable = BoxedUnit.UNIT;
            } else {
                throw new UnsupportedOperationException(new StringBuilder(52).append("resources other than file or jar are not supported: ").append(resourceURL).toString());
            }
        }
        return (Seq)fileList.result();
    }

    public Seq<Resource.VirtualFile> listResources(String packageName) {
        return this.listResources(packageName, (Function1<String, Object>)(Function1 & Serializable)f -> true, this.listResources$default$3());
    }

    public Seq<Resource.VirtualFile> listResources(String packageName, Function1<String, Object> resourceFilter, ClassLoader classLoader) {
        Builder b = package$.MODULE$.Seq().newBuilder();
        this.findResourceURLs(classLoader, packageName).foreach((Function1 & Serializable)u -> (Builder)b.$plus$plus$eq(this.listResources((URL)u, packageName, resourceFilter)));
        return (Seq)b.result();
    }

    public ClassLoader listResources$default$3() {
        return Thread.currentThread().getContextClassLoader();
    }

    public Seq<URL> findResourceURLs(ClassLoader cl, String name) {
        String path = this.packagePath(name);
        Builder b = package$.MODULE$.Seq().newBuilder();
        this.loop$2(path, b, this.currentClassLoader());
        return (Seq)b.result();
    }

    public <A> Seq<Class<A>> findClasses(String packageName, Class<A> toSearch, ClassLoader classLoader) {
        Seq<Resource.VirtualFile> classFileList = this.listResources(packageName, (Function1<String, Object>)(Function1 & Serializable)f -> f.endsWith(".class"), classLoader);
        Builder b = package$.MODULE$.Seq().newBuilder();
        classFileList.foreach((Function1)(JProcedure1 & Serializable)vf -> this.componentName$1(vf.logicalPath()).foreach((Function1)(JProcedure1 & Serializable)cn -> {
            String className = new StringBuilder(1).append(packageName).append(".").append((String)cn).toString();
            this.findClass$1(classLoader, className).foreach((Function1)(JProcedure1 & Serializable)cl -> {
                if (!Modifier.isAbstract(cl.getModifiers()) && toSearch.isAssignableFrom((Class<?>)cl)) {
                    b.$plus$eq(cl);
                    return;
                }
            });
        }));
        return (Seq)b.result();
    }

    public <A> ClassLoader findClasses$default$3() {
        return Thread.currentThread().getContextClassLoader();
    }

    public <A> Seq<Class<A>> findClasses(Package searchPath, Class<A> toSearch, ClassLoader classLoader) {
        return this.findClasses(searchPath.getName(), toSearch, classLoader);
    }

    private final Option loop$1(String resourcePath$1, ClassLoader cl) {
        Option<URLClassLoader> option;
        while ((option = this.findNextURLClassLoader(cl)) instanceof Some) {
            URLClassLoader urlClassLoader = (URLClassLoader)((Some)option).value();
            URL uRL = urlClassLoader.getResource(resourcePath$1);
            if (uRL != null) {
                URL path = uRL;
                return Some$.MODULE$.apply((Object)path);
            }
            if (uRL == null) {
                cl = urlClassLoader.getParent();
                continue;
            }
            throw new MatchError((Object)uRL);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    private final Option find$$anonfun$1(String resourcePath$2) {
        return Option$.MODULE$.apply((Object)this.getClass().getResource(resourcePath$2));
    }

    private final void loop$2(String path$1, Builder b$3, ClassLoader cl) {
        Option<URLClassLoader> option;
        while ((option = this.findNextURLClassLoader(cl)) instanceof Some) {
            URLClassLoader urlClassLoader = (URLClassLoader)((Some)option).value();
            Enumeration<URL> e = urlClassLoader.findResources(path$1);
            while (e.hasMoreElements()) {
                URL elem = e.nextElement();
                b$3.$plus$eq((Object)elem);
            }
            cl = urlClassLoader.getParent();
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    private final Option componentName$1(String path) {
        int dot = path.lastIndexOf(".");
        if (dot <= 0) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)path.substring(0, dot).replaceAll("/", "."));
    }

    private final Option findClass$1(ClassLoader classLoader$1, String name) {
        None$ none$;
        try {
            none$ = Some$.MODULE$.apply(Class.forName(name, false, classLoader$1));
        }
        catch (ClassNotFoundException e) {
            none$ = None$.MODULE$;
        }
        return none$;
    }
}

