/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log.io;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.LinkedHashMap;
import scala.math.Ordered;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import wvlet.log.io.StopWatch;

public interface TimeReport
extends Ordered<TimeReport> {
    public static void $init$(TimeReport $this) {
        $this.wvlet$log$io$TimeReport$_setter_$s_$eq(new StopWatch());
        $this.wvlet$log$io$TimeReport$$_executionCount_$eq(0);
        $this.wvlet$log$io$TimeReport$$maxInterval_$eq(0.0);
        $this.wvlet$log$io$TimeReport$$minInterval_$eq(Double.MAX_VALUE);
        $this.wvlet$log$io$TimeReport$_setter_$wvlet$log$io$TimeReport$$timeReport_$eq(scala.package$.MODULE$.Seq().newBuilder());
        $this.s().stop();
        $this.s().reset();
    }

    public String name();

    public void body();

    public StopWatch s();

    public void wvlet$log$io$TimeReport$_setter_$s_$eq(StopWatch var1);

    public static LinkedHashMap wvlet$log$io$TimeReport$$subMeasure$(TimeReport $this) {
        return $this.wvlet$log$io$TimeReport$$subMeasure();
    }

    default public LinkedHashMap<String, TimeReport> wvlet$log$io$TimeReport$$subMeasure() {
        return new LinkedHashMap();
    }

    public int wvlet$log$io$TimeReport$$_executionCount();

    public void wvlet$log$io$TimeReport$$_executionCount_$eq(int var1);

    public int repeat();

    public int blockRepeat();

    public double wvlet$log$io$TimeReport$$maxInterval();

    public void wvlet$log$io$TimeReport$$maxInterval_$eq(double var1);

    public double wvlet$log$io$TimeReport$$minInterval();

    public void wvlet$log$io$TimeReport$$minInterval_$eq(double var1);

    public Builder<Object, Seq<Object>> wvlet$log$io$TimeReport$$timeReport();

    public void wvlet$log$io$TimeReport$_setter_$wvlet$log$io$TimeReport$$timeReport_$eq(Builder var1);

    public static boolean containsBlock$(TimeReport $this, String name) {
        return $this.containsBlock(name);
    }

    default public boolean containsBlock(String name) {
        return this.wvlet$log$io$TimeReport$$subMeasure().contains((Object)name);
    }

    public static TimeReport apply$(TimeReport $this, String name) {
        return $this.apply(name);
    }

    default public TimeReport apply(String name) {
        return (TimeReport)this.wvlet$log$io$TimeReport$$subMeasure().apply((Object)name);
    }

    public static TimeReport getOrElseUpdate$(TimeReport $this, String name, Function0 t) {
        return $this.getOrElseUpdate(name, (Function0<TimeReport>)t);
    }

    default public TimeReport getOrElseUpdate(String name, Function0<TimeReport> t) {
        return (TimeReport)this.wvlet$log$io$TimeReport$$subMeasure().getOrElseUpdate((Object)name, t);
    }

    public static int executionCount$(TimeReport $this) {
        return $this.executionCount();
    }

    default public int executionCount() {
        return this.wvlet$log$io$TimeReport$$_executionCount();
    }

    public static TimeReport measure$(TimeReport $this) {
        return $this.measure();
    }

    default public TimeReport measure() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.repeat()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            this.s().resume();
            try {
                this.body();
            }
            finally {
                double intervalTime = this.s().stop();
                this.wvlet$log$io$TimeReport$$timeReport().$plus$eq((Object)BoxesRunTime.boxToDouble((double)intervalTime));
                this.wvlet$log$io$TimeReport$$_executionCount_$eq(this.wvlet$log$io$TimeReport$$_executionCount() + 1);
                this.wvlet$log$io$TimeReport$$maxInterval_$eq(package$.MODULE$.max(this.wvlet$log$io$TimeReport$$maxInterval(), intervalTime));
                this.wvlet$log$io$TimeReport$$minInterval_$eq(package$.MODULE$.min(this.wvlet$log$io$TimeReport$$minInterval(), intervalTime));
            }
        });
        return this;
    }

    public static int compare$(TimeReport $this, TimeReport that) {
        return $this.compare(that);
    }

    default public int compare(TimeReport that) {
        return Predef$.MODULE$.double2Double(this.elapsedSeconds()).compareTo(Predef$.MODULE$.double2Double(that.elapsedSeconds()));
    }

    public static double min$(TimeReport $this) {
        return $this.min();
    }

    default public double min() {
        return this.wvlet$log$io$TimeReport$$minInterval();
    }

    public static double max$(TimeReport $this) {
        return $this.max();
    }

    default public double max() {
        return this.wvlet$log$io$TimeReport$$maxInterval();
    }

    public static double averageWithoutMinMax$(TimeReport $this) {
        return $this.averageWithoutMinMax();
    }

    default public double averageWithoutMinMax() {
        if (this.executionCount() > 2) {
            return (this.s().getElapsedTime() - this.min() - this.max()) / (double)(this.wvlet$log$io$TimeReport$$_executionCount() - 2);
        }
        return this.average();
    }

    public static double median$(TimeReport $this) {
        return $this.median();
    }

    default public double median() {
        Seq r = (Seq)this.wvlet$log$io$TimeReport$$timeReport().result();
        r.length();
        return BoxesRunTime.unboxToDouble((Object)((SeqOps)r.sorted((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)).apply(r.length() / 2));
    }

    public static double average$(TimeReport $this) {
        return $this.average();
    }

    default public double average() {
        return this.s().getElapsedTime() / (double)this.wvlet$log$io$TimeReport$$_executionCount();
    }

    public static double elapsedSeconds$(TimeReport $this) {
        return $this.elapsedSeconds();
    }

    default public double elapsedSeconds() {
        return this.s().getElapsedTime();
    }

    public static String toHumanReadableFormat$(TimeReport $this, double time) {
        return $this.toHumanReadableFormat(time);
    }

    default public String toHumanReadableFormat(double time) {
        int u;
        Seq symbol = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "m", "n"}));
        double digits = package$.MODULE$.log10(time);
        int unitIndex = Predef$.MODULE$.double2Double(digits).isNaN() || RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(digits)) || digits >= -2.0 ? 0 : ((u = -((int)((digits - 1.0) / 3.0))) >= symbol.length() ? symbol.length() - 1 : u);
        Predef$.MODULE$.require(unitIndex >= 0 && unitIndex < symbol.length(), () -> TimeReport.toHumanReadableFormat$$anonfun$1(digits, unitIndex));
        double v = time * package$.MODULE$.pow(10.0, Int$.MODULE$.int2double(unitIndex * 3));
        String str = StringOps$.MODULE$.format$extension("%.3f %ssec.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)v), symbol.apply(unitIndex)}));
        return StringOps$.MODULE$.format$extension("%-11s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{str}));
    }

    public static String genReportLine$(TimeReport $this) {
        return $this.genReportLine();
    }

    default public String genReportLine() {
        return StringOps$.MODULE$.format$extension("-%-15s\ttotal:%s, count:%,5d, avg:%s, min:%s, median:%s, max:%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), this.toHumanReadableFormat(this.s().getElapsedTime()), BoxesRunTime.boxToInteger((int)this.executionCount()), this.toHumanReadableFormat(this.average()), this.toHumanReadableFormat(this.wvlet$log$io$TimeReport$$minInterval()), this.toHumanReadableFormat(this.median()), this.toHumanReadableFormat(this.wvlet$log$io$TimeReport$$maxInterval())}));
    }

    public static String report$(TimeReport $this) {
        return $this.report();
    }

    default public String report() {
        Builder lines = scala.package$.MODULE$.Seq().newBuilder();
        lines.$plus$eq((Object)TimeReport.indent$1(0, this.genReportLine()));
        this.wvlet$log$io$TimeReport$$subMeasure().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                TimeReport v = (TimeReport)tuple2._2();
                return true;
            }
            return false;
        }).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                TimeReport v = (TimeReport)tuple2._2();
                return (Builder)lines.$plus$eq((Object)TimeReport.indent$1(1, v.genReportLine()));
            }
            throw new MatchError((Object)tuple2);
        });
        return ((IterableOnceOps)lines.result()).mkString("\n");
    }

    public static String toString$(TimeReport $this) {
        return $this.toString();
    }

    default public String toString() {
        return this.report();
    }

    private static Object toHumanReadableFormat$$anonfun$1(double digits$1, int unitIndex$1) {
        return new StringBuilder(43).append("unitIndex must be between 0 to 2: ").append(unitIndex$1).append(", digits:").append(digits$1).toString();
    }

    private static /* synthetic */ char indent$1$$anonfun$1(int i) {
        return ' ';
    }

    private static String indent$1(int level, String s) {
        return new StringBuilder(0).append(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), level * 2).map((Function1 & Serializable)i -> TimeReport.indent$1$$anonfun$1(BoxesRunTime.unboxToInt((Object)i))).mkString()).append(s).toString();
    }
}

