/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.surface.reflect;

import java.io.Serializable;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.package$;
import scala.runtime.LazyVals$;
import wvlet.airframe.surface.reflect.Path$;
import wvlet.airframe.surface.reflect.Path$Current$;

public interface Path
extends Iterable<String> {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Path$.class.getDeclaredField("logger$lzy1"));

    public static Path apply(String string) {
        return Path$.MODULE$.apply(string);
    }

    public static Path current() {
        return Path$.MODULE$.current();
    }

    public static Path root() {
        return Path$.MODULE$.root();
    }

    public static String toString$(Path $this) {
        return $this.toString();
    }

    default public String toString() {
        return this.fullPath();
    }

    public String name();

    public String fullPath();

    public Path $div(String var1);

    public boolean isRelative();

    public static boolean isAbsolute$(Path $this) {
        return $this.isAbsolute();
    }

    default public boolean isAbsolute() {
        return !this.isRelative();
    }

    public Option<Path> parent();

    public static boolean isLeaf$(Path $this) {
        return $this.isLeaf();
    }

    default public boolean isLeaf() {
        return this.size() == 1;
    }

    public static Path tailPath$(Path $this) {
        return $this.tailPath();
    }

    default public Path tailPath() {
        if (this.isEmpty()) {
            return Path$Current$.MODULE$;
        }
        return (Path)((IterableOnceOps)this.drop(1)).foldLeft((Object)Path$Current$.MODULE$, (Function2 & Serializable)(p, c) -> p.$div((String)c));
    }

    public static Iterator iterator$(Path $this) {
        return $this.iterator();
    }

    default public Iterator<String> iterator() {
        Option<Path> option = this.parent();
        if (option instanceof Some) {
            Path p = (Path)((Some)option).value();
            return p.iterator().$plus$plus(this::iterator$$anonfun$1);
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Iterator().single((Object)this.name());
        }
        throw new MatchError(option);
    }

    public static int hashCode$(Path $this) {
        return $this.hashCode();
    }

    default public int hashCode() {
        return this.fullPath().hashCode();
    }

    public static boolean equals$(Path $this, Object other) {
        return $this.equals(other);
    }

    default public boolean equals(Object other) {
        Object o = other;
        if (this == o) {
            return true;
        }
        if (Path.class.isAssignableFrom(o.getClass())) {
            String string = this.fullPath();
            String string2 = ((Path)other).fullPath();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
        return false;
    }

    private IterableOnce iterator$$anonfun$1() {
        return package$.MODULE$.Iterator().single((Object)this.name());
    }

    public static class AbsolutePath
    implements IterableOnce,
    IterableOnceOps,
    IterableOps,
    IterableFactoryDefaults,
    Iterable,
    Path {
        private final Option parent;
        private final String name;

        public AbsolutePath(Option<Path> parent, String name) {
            this.parent = parent;
            this.name = name;
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            IterableOps.$init$((IterableOps)this);
            IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
            Iterable.$init$((Iterable)this);
        }

        @Override
        public Option<Path> parent() {
            return this.parent;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String fullPath() {
            return new StringBuilder(1).append("/").append(this.mkString("/")).toString();
        }

        @Override
        public Path $div(String child) {
            return new AbsolutePath((Option<Path>)Some$.MODULE$.apply((Object)this), child);
        }

        @Override
        public boolean isRelative() {
            return false;
        }
    }

    public static class RelativePath
    implements IterableOnce,
    IterableOnceOps,
    IterableOps,
    IterableFactoryDefaults,
    Iterable,
    Path {
        private final Option parent;
        private final String name;

        public RelativePath(Option<Path> parent, String name) {
            this.parent = parent;
            this.name = name;
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            IterableOps.$init$((IterableOps)this);
            IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
            Iterable.$init$((Iterable)this);
        }

        @Override
        public Option<Path> parent() {
            return this.parent;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String fullPath() {
            return this.mkString("/");
        }

        @Override
        public Path $div(String child) {
            return new RelativePath((Option<Path>)Some$.MODULE$.apply((Object)this), child);
        }

        @Override
        public boolean isRelative() {
            return true;
        }

        public Option<Path> getParent() {
            return this.parent();
        }
    }
}

