/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.launcher;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import wvlet.airframe.codec.MessageCodec;
import wvlet.airframe.codec.MessageContext;
import wvlet.airframe.codec.ParamListCodec;
import wvlet.airframe.launcher.ClassOptionSchema;
import wvlet.airframe.launcher.CommandLauncherBaseCompat;
import wvlet.airframe.launcher.LauncherConfig;
import wvlet.airframe.launcher.LauncherInfo;
import wvlet.airframe.launcher.LauncherInfo$;
import wvlet.airframe.launcher.LauncherInstance;
import wvlet.airframe.launcher.LauncherInstance$;
import wvlet.airframe.launcher.LauncherResult;
import wvlet.airframe.launcher.LauncherResult$;
import wvlet.airframe.launcher.MethodOptionSchema;
import wvlet.airframe.launcher.OptionParser;
import wvlet.airframe.launcher.OptionSchema;
import wvlet.airframe.msgpack.spi.MessagePack$;
import wvlet.airframe.surface.CName;
import wvlet.airframe.surface.CName$;
import wvlet.airframe.surface.MethodSurface;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource$;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public class CommandLauncher
implements CommandLauncherBaseCompat,
LoggingMethods,
LazyLogger,
LogSupport {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CommandLauncher.class.getDeclaredField("logger$lzy2"));
    private volatile Object logger$lzy2;
    private final LauncherInfo launcherInfo;
    private final OptionParser optionParser;
    private final Seq subCommands;
    private final Option<Function1<LauncherInstance, Object>> defaultCommand;

    public CommandLauncher(LauncherInfo launcherInfo, OptionParser optionParser, Seq<CommandLauncher> subCommands, Option<Function1<LauncherInstance, Object>> defaultCommand) {
        this.launcherInfo = launcherInfo;
        this.optionParser = optionParser;
        this.subCommands = subCommands;
        this.defaultCommand = defaultCommand;
    }

    public Logger logger() {
        Object object = this.logger$lzy2;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT2();
    }

    private Object logger$lzyINIT2() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy2) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy2;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public LauncherInfo launcherInfo() {
        return this.launcherInfo;
    }

    public OptionParser optionParser() {
        return this.optionParser;
    }

    public Seq<CommandLauncher> subCommands() {
        return this.subCommands;
    }

    public String name() {
        return this.launcherInfo().name();
    }

    public String description() {
        return this.launcherInfo().description();
    }

    public String usage() {
        return this.launcherInfo().usage();
    }

    public CommandLauncher withLauncherInfo(String name, String description) {
        return new CommandLauncher(LauncherInfo$.MODULE$.apply(name, description, this.launcherInfo().usage(), LauncherInfo$.MODULE$.$lessinit$greater$default$4()), this.optionParser(), this.subCommands(), this.defaultCommand);
    }

    public Seq<OptionParser.CLOption> optionList() {
        return this.optionParser().optionList();
    }

    public CommandLauncher add(String name, String description, CommandLauncher commandLauncher) {
        return new CommandLauncher(this.launcherInfo(), this.optionParser(), (Seq<CommandLauncher>)((Seq)this.subCommands().$colon$plus((Object)commandLauncher.withLauncherInfo(name, description))), this.defaultCommand);
    }

    public void printHelp(LauncherConfig launcherConfig, List<LauncherInstance> stack) {
        this.printHelpInternal(launcherConfig, (List<CommandLauncher>)stack.map((Function1 & Serializable)_$7 -> _$7.launcher()));
    }

    public void printMethodHelp(LauncherConfig launcherConfig, MethodOptionSchema m, List<LauncherInstance> stack) {
        LauncherInstance h = (LauncherInstance)stack.head();
        List globalOptions = ((List)stack.tail()).flatMap((Function1 & Serializable)_$8 -> _$8.launcher().optionParser().optionList());
        LauncherInfo li = h.launcher().launcherInfo();
        String help = launcherConfig.helpMessagePrinter().render(li.name(), m.args(), (Option<String>)(li.usage().isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply((Object)li.usage())), li.description(), m.options(), (Seq<OptionParser.CLOption>)globalOptions, (Seq<CommandLauncher>)((Seq)package$.MODULE$.Seq().empty()));
        Predef$.MODULE$.print((Object)help);
    }

    public void printHelpInternal(LauncherConfig launcherConfig, List<CommandLauncher> stack) {
        CommandLauncher l = (CommandLauncher)stack.head();
        OptionSchema schema = l.optionParser().schema();
        List globalOptions = ((List)stack.tail()).flatMap((Function1 & Serializable)_$9 -> _$9.optionParser().optionList());
        String help = launcherConfig.helpMessagePrinter().render(l.name(), schema.args(), (Option<String>)(l.usage().isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply((Object)l.usage())), l.description(), schema.options(), (Seq<OptionParser.CLOption>)globalOptions, (Seq<CommandLauncher>)((Seq)l.subCommands().filterNot((Function1 & Serializable)x -> x.launcherInfo().isDefault())));
        Predef$.MODULE$.print((Object)help);
    }

    public LauncherResult execute(LauncherConfig launcherConfig, List<LauncherInstance> stack, Seq<String> args2, boolean showHelp) {
        OptionParser.OptionParserResult result = this.optionParser().parse((String[])args2.toArray(ClassTag$.MODULE$.apply(String.class)));
        CommandLauncher LoggingMethods_this = this;
        if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
            LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.TRACE$.MODULE$, LogSource$.MODULE$.apply("", "Launcher.scala", 264, 17), (Object)result);
        }
        boolean showHelpMessage = result.showHelp() | showHelp;
        OptionSchema optionSchema = this.optionParser().schema();
        if (optionSchema instanceof ClassOptionSchema) {
            ClassOptionSchema c = (ClassOptionSchema)optionSchema;
            byte[] parseTree_mp = result.parseTree().toMsgPack();
            MessageCodec codec = launcherConfig.codecFactory().withMapOutput().of(c.surface());
            MessageContext h = new MessageContext();
            codec.unpack(MessagePack$.MODULE$.newUnpacker(parseTree_mp), h);
            h.getError().map((Function1 & Serializable)e -> {
                throw new IllegalArgumentException(new StringBuilder(31).append("Error occurered in launching ").append(c.surface()).append(": ").append(e.getMessage()).toString());
            });
            Object obj = h.getLastValue();
            LauncherInstance head = LauncherInstance$.MODULE$.apply(this, obj);
            List nextStack = stack.$colon$colon((Object)head);
            Object object = Predef$.MODULE$.refArrayOps((Object[])result.unusedArgument());
            if (ArrayOps$.MODULE$.isEmpty$extension(object)) {
                if (showHelpMessage) {
                    this.printHelp(launcherConfig, (List<LauncherInstance>)nextStack);
                    return LauncherResult$.MODULE$.apply((List<LauncherInstance>)nextStack, (Option<Object>)None$.MODULE$);
                }
                return (LauncherResult)this.defaultCommand.map((Function1 & Serializable)defaultCommand -> defaultCommand.apply((Object)head)).map((Function1 & Serializable)x -> LauncherResult$.MODULE$.apply((List<LauncherInstance>)nextStack, (Option<Object>)Some$.MODULE$.apply(x))).getOrElse(() -> CommandLauncher.execute$$anonfun$4(nextStack));
            }
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])result.unusedArgument());
            String subCommandName = (String)ArrayOps$.MODULE$.head$extension(object2);
            Option<CommandLauncher> option2 = this.findSubCommand(subCommandName);
            if (option2 instanceof Some) {
                CommandLauncher subCommand = (CommandLauncher)((Some)option2).value();
                Object object3 = Predef$.MODULE$.refArrayOps((Object[])result.unusedArgument());
                Object object4 = Predef$.MODULE$.refArrayOps((Object[])((String[])ArrayOps$.MODULE$.tail$extension(object3)));
                return subCommand.execute(launcherConfig, (List<LauncherInstance>)nextStack, (Seq<String>)ArrayOps$.MODULE$.toIndexedSeq$extension(object4), showHelpMessage);
            }
            if (None$.MODULE$.equals(option2)) {
                throw new IllegalArgumentException(new StringBuilder(21).append("Unknown sub command: ").append(subCommandName).toString());
            }
            throw new MatchError(option2);
        }
        if (optionSchema instanceof MethodOptionSchema) {
            LauncherResult launcherResult;
            MethodOptionSchema m = (MethodOptionSchema)optionSchema;
            Object object = Predef$.MODULE$.refArrayOps((Object[])result.unusedArgument());
            if (ArrayOps$.MODULE$.nonEmpty$extension(object)) {
                throw new IllegalArgumentException(new StringBuilder(31).append("Unknown arguments are found: [").append(Predef$.MODULE$.wrapRefArray((Object[])result.unusedArgument()).mkString(", ")).append("]").toString());
            }
            Object parentObj = stack.headOption().map((Function1 & Serializable)_$10 -> _$10.instance()).getOrElse(CommandLauncher::$anonfun$22);
            if (showHelpMessage) {
                LauncherInstance launcherInstance = LauncherInstance$.MODULE$.apply(this, parentObj);
                this.printMethodHelp(launcherConfig, m, (List<LauncherInstance>)stack.$colon$colon((Object)launcherInstance));
                return LauncherResult$.MODULE$.apply(stack, (Option<Object>)None$.MODULE$);
            }
            try {
                MethodSurface methodSurface = m.method();
                Seq paramCodecs = (Seq)methodSurface.args().map((Function1 & Serializable)x -> launcherConfig.codecFactory().of(x.surface()));
                ParamListCodec methodArgCodec = new ParamListCodec(methodSurface.name(), methodSurface.args().toIndexedSeq(), paramCodecs, (Option)Some$.MODULE$.apply(parentObj));
                byte[] msgpack = result.parseTree().toMsgPack();
                launcherResult = (LauncherResult)methodArgCodec.unpackMsgPack(msgpack).map((Function1 & Serializable)args -> {
                    CommandLauncher LoggingMethods_this = this;
                    if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
                        LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.TRACE$.MODULE$, LogSource$.MODULE$.apply("", "Launcher.scala", 338, 91), (Object)new StringBuilder(27).append("calling method ").append(methodSurface).append(" with args: ").append(args.mkString(", ")).toString());
                    }
                    Object methodResult = methodSurface.call(parentObj, args);
                    return LauncherResult$.MODULE$.apply(stack, (Option<Object>)Some$.MODULE$.apply(methodResult));
                }).getOrElse(() -> CommandLauncher.execute$$anonfun$6(result, methodSurface));
            }
            catch (InvocationTargetException e2) {
                throw e2.getTargetException();
            }
            catch (Throwable other) {
                throw other;
            }
            return launcherResult;
        }
        throw new MatchError((Object)optionSchema);
    }

    private Option<CommandLauncher> findSubCommand(String name) {
        CName cname = CName$.MODULE$.apply(name);
        return this.subCommands().find((Function1 & Serializable)x -> {
            CName cName = CName$.MODULE$.apply(x.name());
            CName cName2 = cname;
            return !(cName != null ? !cName.equals(cName2) : cName2 != null);
        });
    }

    private static final LauncherResult execute$$anonfun$4(List nextStack$2) {
        return LauncherResult$.MODULE$.apply((List<LauncherInstance>)nextStack$2, (Option<Object>)None$.MODULE$);
    }

    private static final Object $anonfun$22() {
        throw new IllegalStateException("parent should not be empty");
    }

    private static final LauncherResult execute$$anonfun$6(OptionParser.OptionParserResult result$1, MethodSurface methodSurface$2) {
        throw new IllegalArgumentException(new StringBuilder(17).append("Failed to call ").append(methodSurface$2).append(": ").append(result$1.parseTree()).toString());
    }
}

