/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.lifecycle;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import wvlet.airframe.AirframeSession;
import wvlet.airframe.lifecycle.AFTER_START$;
import wvlet.airframe.lifecycle.BEFORE_SHUTDOWN$;
import wvlet.airframe.lifecycle.CloseHook;
import wvlet.airframe.lifecycle.INIT$;
import wvlet.airframe.lifecycle.Injectee;
import wvlet.airframe.lifecycle.LifeCycleEventHandler;
import wvlet.airframe.lifecycle.LifeCycleHook;
import wvlet.airframe.lifecycle.LifeCycleHookType;
import wvlet.airframe.lifecycle.LifeCycleManager$;
import wvlet.airframe.lifecycle.LifeCycleManager$LifeCycleHookHolder$;
import wvlet.airframe.lifecycle.LifeCycleStage;
import wvlet.airframe.lifecycle.ON_INIT$;
import wvlet.airframe.lifecycle.ON_INJECT$;
import wvlet.airframe.lifecycle.ON_SHUTDOWN$;
import wvlet.airframe.lifecycle.ON_START$;
import wvlet.airframe.lifecycle.STARTED$;
import wvlet.airframe.lifecycle.STARTING$;
import wvlet.airframe.lifecycle.STOPPED$;
import wvlet.airframe.lifecycle.STOPPING$;
import wvlet.airframe.surface.Surface;
import wvlet.airframe.tracing.Tracer;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource$;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public class LifeCycleManager
implements LoggingMethods,
LazyLogger,
LogSupport {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LifeCycleManager.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private final LifeCycleEventHandler eventHandler;
    private final LifeCycleEventHandler coreEventHandler;
    private final AtomicReference state;
    private AirframeSession session;
    private Tracer tracer;
    private LifeCycleHookHolder initHookHolder;
    private LifeCycleHookHolder startHookHolder;
    private LifeCycleHookHolder afterStartHookHolder;
    private LifeCycleHookHolder preShutdownHookHolder;
    private LifeCycleHookHolder shutdownHookHolder;

    public static LifeCycleEventHandler defaultLifeCycleEventHandler() {
        return LifeCycleManager$.MODULE$.defaultLifeCycleEventHandler();
    }

    public LifeCycleManager(LifeCycleEventHandler eventHandler, LifeCycleEventHandler coreEventHandler) {
        this.eventHandler = eventHandler;
        this.coreEventHandler = coreEventHandler;
        this.state = new AtomicReference<INIT$>(INIT$.MODULE$);
        this.initHookHolder = new LifeCycleHookHolder(LifeCycleManager$LifeCycleHookHolder$.MODULE$.$lessinit$greater$default$1());
        this.startHookHolder = new LifeCycleHookHolder(LifeCycleManager$LifeCycleHookHolder$.MODULE$.$lessinit$greater$default$1());
        this.afterStartHookHolder = new LifeCycleHookHolder(LifeCycleManager$LifeCycleHookHolder$.MODULE$.$lessinit$greater$default$1());
        this.preShutdownHookHolder = new LifeCycleHookHolder(LifeCycleManager$LifeCycleHookHolder$.MODULE$.$lessinit$greater$default$1());
        this.shutdownHookHolder = new LifeCycleHookHolder(LifeCycleManager$LifeCycleHookHolder$.MODULE$.$lessinit$greater$default$1());
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public LifeCycleEventHandler eventHandler() {
        return this.eventHandler;
    }

    public LifeCycleEventHandler coreEventHandler() {
        return this.coreEventHandler;
    }

    private AtomicReference<LifeCycleStage> state() {
        return this.state;
    }

    public LifeCycleStage currentState() {
        return this.state().get();
    }

    public void onInit(Surface t, Object injectee) {
        this.eventHandler().onInit(this, t, injectee);
    }

    public AirframeSession session() {
        return this.session;
    }

    public void session_$eq(AirframeSession x$1) {
        this.session = x$1;
    }

    public Tracer tracer() {
        return this.tracer;
    }

    public void tracer_$eq(Tracer x$1) {
        this.tracer = x$1;
    }

    public void setSession(AirframeSession s) {
        this.session_$eq(s);
        this.tracer_$eq(this.session().tracer());
    }

    public String sessionName() {
        return this.session().name();
    }

    public void start() {
        if (!this.state().compareAndSet(INIT$.MODULE$, STARTING$.MODULE$)) {
            throw new IllegalStateException("LifeCycle is already starting");
        }
        this.tracer().onSessionStart(this.session());
        this.eventHandler().beforeStart(this);
        this.state().set(STARTED$.MODULE$);
        this.eventHandler().afterStart(this);
    }

    public void shutdown() {
        if (this.state().compareAndSet(STARTED$.MODULE$, STOPPING$.MODULE$) || this.state().compareAndSet(INIT$.MODULE$, STOPPING$.MODULE$) || this.state().compareAndSet(STARTING$.MODULE$, STOPPING$.MODULE$)) {
            this.tracer().beforeSessionShutdown(this.session());
            this.eventHandler().beforeShutdown(this);
            this.state().set(STOPPED$.MODULE$);
            this.tracer().onSessionShutdown(this.session());
            this.eventHandler().afterShutdown(this);
            this.tracer().onSessionEnd(this.session());
            return;
        }
    }

    public LifeCycleHookHolder initHookHolder() {
        return this.initHookHolder;
    }

    public void initHookHolder_$eq(LifeCycleHookHolder x$1) {
        this.initHookHolder = x$1;
    }

    public LifeCycleHookHolder startHookHolder() {
        return this.startHookHolder;
    }

    public void startHookHolder_$eq(LifeCycleHookHolder x$1) {
        this.startHookHolder = x$1;
    }

    public LifeCycleHookHolder afterStartHookHolder() {
        return this.afterStartHookHolder;
    }

    public void afterStartHookHolder_$eq(LifeCycleHookHolder x$1) {
        this.afterStartHookHolder = x$1;
    }

    public LifeCycleHookHolder preShutdownHookHolder() {
        return this.preShutdownHookHolder;
    }

    public void preShutdownHookHolder_$eq(LifeCycleHookHolder x$1) {
        this.preShutdownHookHolder = x$1;
    }

    public LifeCycleHookHolder shutdownHookHolder() {
        return this.shutdownHookHolder;
    }

    public void shutdownHookHolder_$eq(LifeCycleHookHolder x$1) {
        this.shutdownHookHolder = x$1;
    }

    public Seq<LifeCycleHook> startHooks() {
        return this.startHookHolder().list();
    }

    public Seq<LifeCycleHook> afterStartHooks() {
        return this.afterStartHookHolder().list();
    }

    public Seq<LifeCycleHook> preShutdownHooks() {
        return this.preShutdownHookHolder().list();
    }

    public Seq<LifeCycleHook> shutdownHooks() {
        return this.shutdownHookHolder().list();
    }

    public <U> U findLifeCycleManagerFor(Surface s, Function1<LifeCycleManager, U> body) {
        Option<AirframeSession> option = this.session().findOwnerSessionOf(s);
        if (option instanceof Some) {
            AirframeSession s2 = (AirframeSession)((Some)option).value();
            return (U)body.apply((Object)s2.lifeCycleManager());
        }
        if (None$.MODULE$.equals(option)) {
            return (U)body.apply((Object)this);
        }
        throw new MatchError(option);
    }

    public boolean hasHooksFor(Surface s, LifeCycleHookType lifeCycleHookType) {
        return BoxesRunTime.unboxToBoolean(this.findLifeCycleManagerFor(s, (Function1 & Serializable)l -> {
            LifeCycleHookType lifeCycleHookType = lifeCycleHookType;
            if (ON_INIT$.MODULE$.equals(lifeCycleHookType)) {
                return l.initHookHolder().hasHooksFor(s);
            }
            if (ON_INJECT$.MODULE$.equals(lifeCycleHookType)) {
                return false;
            }
            if (ON_START$.MODULE$.equals(lifeCycleHookType)) {
                return l.startHookHolder().hasHooksFor(s);
            }
            if (AFTER_START$.MODULE$.equals(lifeCycleHookType)) {
                return l.afterStartHookHolder().hasHooksFor(s);
            }
            if (BEFORE_SHUTDOWN$.MODULE$.equals(lifeCycleHookType)) {
                return l.preShutdownHookHolder().hasHooksFor(s);
            }
            if (ON_SHUTDOWN$.MODULE$.equals(lifeCycleHookType)) {
                return l.shutdownHookHolder().hasHooksFor(s);
            }
            throw new MatchError((Object)lifeCycleHookType);
        }));
    }

    public boolean hasShutdownHooksFor(Surface s) {
        return this.hasHooksFor(s, ON_SHUTDOWN$.MODULE$);
    }

    public void addLifeCycleHook(LifeCycleHookType lifeCycleHookType, LifeCycleHook h) {
        LifeCycleHookType lifeCycleHookType2;
        LifeCycleManager LoggingMethods_this = this;
        if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
            LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.TRACE$.MODULE$, LogSource$.MODULE$.apply("", "LifeCycleManager.scala", 136, 77), (Object)new StringBuilder(31).append("Adding a life cycle hook for ").append(lifeCycleHookType).append(": ").append(h.surface()).toString());
        }
        if (ON_INIT$.MODULE$.equals(lifeCycleHookType2 = lifeCycleHookType)) {
            this.addInitHook(h);
            return;
        }
        if (ON_INJECT$.MODULE$.equals(lifeCycleHookType2)) {
            this.addInjectHook(h);
            return;
        }
        if (ON_START$.MODULE$.equals(lifeCycleHookType2)) {
            this.addStartHook(h);
            return;
        }
        if (AFTER_START$.MODULE$.equals(lifeCycleHookType2)) {
            this.addAfterStartHook(h);
            return;
        }
        if (BEFORE_SHUTDOWN$.MODULE$.equals(lifeCycleHookType2)) {
            this.addPreShutdownHook(h);
            return;
        }
        if (ON_SHUTDOWN$.MODULE$.equals(lifeCycleHookType2)) {
            this.addShutdownHook(h);
            return;
        }
        throw new MatchError((Object)lifeCycleHookType2);
    }

    public void addInitHook(LifeCycleHook h) {
        this.findLifeCycleManagerFor(h.surface(), (Function1)(JProcedure1 & Serializable)l -> {
            if (l.initHookHolder().registerOnlyOnce(h)) {
                LifeCycleManager LoggingMethods_this = this;
                if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.DEBUG$.MODULE$)) {
                    LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.DEBUG$.MODULE$, LogSource$.MODULE$.apply("", "LifeCycleManager.scala", 156, 67), (Object)new StringBuilder(21).append("[").append(l.sessionName()).append("] Add an init hook: ").append(h.surface()).toString());
                }
                h.execute();
                return;
            }
            LifeCycleManager LoggingMethods_this = this;
            if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
                LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.TRACE$.MODULE$, LogSource$.MODULE$.apply("", "LifeCycleManager.scala", 159, 73), (Object)new StringBuilder(26).append("[").append(l.sessionName()).append("] ").append(h.injectee()).append(" is already initialized").toString());
                return;
            }
        });
    }

    public void addInjectHook(LifeCycleHook h) {
        this.findLifeCycleManagerFor(h.surface(), (Function1)(JProcedure1 & Serializable)l -> {
            LifeCycleManager LoggingMethods_this = this;
            if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.DEBUG$.MODULE$)) {
                LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.DEBUG$.MODULE$, LogSource$.MODULE$.apply("", "LifeCycleManager.scala", 166, 71), (Object)new StringBuilder(27).append("[").append(l.sessionName()).append("] Running an inject hook: ").append(h.surface()).toString());
            }
            h.execute();
        });
    }

    public void addStartHook(LifeCycleHook h) {
        this.findLifeCycleManagerFor(h.surface(), (Function1)(JProcedure1 & Serializable)l -> {
            LifeCycleManager lifeCycleManager = l;
            synchronized (lifeCycleManager) {
                BoxedUnit boxedUnit;
                if (l.startHookHolder().registerOnlyOnce(h)) {
                    LifeCycleStage s;
                    LifeCycleManager LoggingMethods_this = this;
                    if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.DEBUG$.MODULE$)) {
                        LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.DEBUG$.MODULE$, LogSource$.MODULE$.apply("", "LifeCycleManager.scala", 176, 72), (Object)new StringBuilder(24).append("[").append(l.sessionName()).append("] Add a start hook for ").append(h.surface()).toString());
                    }
                    LifeCycleStage lifeCycleStage = s = l.state().get();
                    STARTED$ sTARTED$ = STARTED$.MODULE$;
                    if (!(lifeCycleStage != null ? !lifeCycleStage.equals(sTARTED$) : sTARTED$ != null)) {
                        this.tracer().onStartInstance(this.session(), h.injectee());
                        h.execute();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        });
    }

    private void addAfterStartHook(LifeCycleHook h) {
        this.findLifeCycleManagerFor(h.surface(), (Function1)(JProcedure1 & Serializable)l -> {
            LifeCycleManager lifeCycleManager = l;
            synchronized (lifeCycleManager) {
                BoxedUnit boxedUnit;
                if (l.afterStartHookHolder().registerOnlyOnce(h)) {
                    LifeCycleStage s;
                    LifeCycleManager LoggingMethods_this = this;
                    if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.DEBUG$.MODULE$)) {
                        LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.DEBUG$.MODULE$, LogSource$.MODULE$.apply("", "LifeCycleManager.scala", 192, 77), (Object)new StringBuilder(29).append("[").append(l.sessionName()).append("] Add a afterStart hook for ").append(h.surface()).toString());
                    }
                    LifeCycleStage lifeCycleStage = s = l.state().get();
                    STARTED$ sTARTED$ = STARTED$.MODULE$;
                    if (!(lifeCycleStage != null ? !lifeCycleStage.equals(sTARTED$) : sTARTED$ != null)) {
                        this.tracer().afterStartInstance(this.session(), h.injectee());
                        h.execute();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        });
    }

    public void addPreShutdownHook(LifeCycleHook h) {
        this.findLifeCycleManagerFor(h.surface(), (Function1)(JProcedure1 & Serializable)l -> {
            LifeCycleManager lifeCycleManager = l;
            synchronized (lifeCycleManager) {
                BoxedUnit boxedUnit;
                if (l.preShutdownHookHolder().registerOnlyOnce(h)) {
                    LifeCycleManager LoggingMethods_this = this;
                    if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.DEBUG$.MODULE$)) {
                        LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.DEBUG$.MODULE$, LogSource$.MODULE$.apply("", "LifeCycleManager.scala", 208, 79), (Object)new StringBuilder(31).append("[").append(l.sessionName()).append("] Add a pre-shutdown hook for ").append(h.surface()).toString());
                    }
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        });
    }

    public void addShutdownHook(LifeCycleHook h) {
        this.findLifeCycleManagerFor(h.surface(), (Function1)(JProcedure1 & Serializable)l -> {
            LifeCycleManager lifeCycleManager = l;
            synchronized (lifeCycleManager) {
                BoxedUnit boxedUnit;
                if (l.shutdownHookHolder().registerOnlyOnce(h)) {
                    LifeCycleManager LoggingMethods_this = this;
                    if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.DEBUG$.MODULE$)) {
                        LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.DEBUG$.MODULE$, LogSource$.MODULE$.apply("", "LifeCycleManager.scala", 218, 75), (Object)new StringBuilder(27).append("[").append(l.sessionName()).append("] Add a shutdown hook for ").append(h.surface()).toString());
                    }
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    Seq<LifeCycleHook> previousHooks = l.shutdownHookHolder().hooksFor(h.injectee());
                    ((IterableOnceOps)previousHooks.collect((PartialFunction)new Serializable(){

                        public final boolean isDefinedAt(LifeCycleHook x) {
                            LifeCycleHook lifeCycleHook = x;
                            if (lifeCycleHook instanceof CloseHook) {
                                CloseHook c = (CloseHook)lifeCycleHook;
                                return true;
                            }
                            return false;
                        }

                        public final Object applyOrElse(LifeCycleHook x, Function1 function1) {
                            LifeCycleHook lifeCycleHook = x;
                            if (lifeCycleHook instanceof CloseHook) {
                                CloseHook c = (CloseHook)lifeCycleHook;
                                return c;
                            }
                            return function1.apply((Object)x);
                        }
                    })).foreach((Function1)(JProcedure1 & Serializable)c -> l.shutdownHookHolder().remove((LifeCycleHook)c));
                    if (l.shutdownHookHolder().registerOnlyOnce(h)) {
                        LifeCycleManager LoggingMethods_this = this;
                        if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.DEBUG$.MODULE$)) {
                            LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.DEBUG$.MODULE$, LogSource$.MODULE$.apply("", "LifeCycleManager.scala", 229, 96), (Object)new StringBuilder(46).append("[").append(l.sessionName()).append("] Override CloseHook of ").append(h.surface()).append(" with a shtudown hook").toString());
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
        });
    }

    public static class LifeCycleHookHolder {
        private Vector holder;

        public static Vector<LifeCycleHook> $lessinit$greater$default$1() {
            return LifeCycleManager$LifeCycleHookHolder$.MODULE$.$lessinit$greater$default$1();
        }

        public LifeCycleHookHolder(Vector<LifeCycleHook> holder) {
            this.holder = holder;
        }

        private Vector<LifeCycleHook> holder() {
            return this.holder;
        }

        private void holder_$eq(Vector<LifeCycleHook> x$0) {
            this.holder = x$0;
        }

        public Seq<LifeCycleHook> list() {
            return this.holder();
        }

        public boolean hasHooksFor(Surface s) {
            boolean bl;
            LifeCycleHookHolder lifeCycleHookHolder = this;
            synchronized (lifeCycleHookHolder) {
                bl = this.list().exists((Function1 & Serializable)_$3 -> {
                    Surface surface = _$3.surface();
                    Surface surface2 = s;
                    return !(surface != null ? !surface.equals(surface2) : surface2 != null);
                });
            }
            return bl;
        }

        public void remove(LifeCycleHook x) {
            LifeCycleHookHolder lifeCycleHookHolder = this;
            synchronized (lifeCycleHookHolder) {
                this.holder_$eq((Vector<LifeCycleHook>)((Vector)this.holder().filter((Function1 & Serializable)_$4 -> _$4 != x)));
            }
        }

        public Seq<LifeCycleHook> hooksFor(Injectee x) {
            Seq seq;
            LifeCycleHookHolder lifeCycleHookHolder = this;
            synchronized (lifeCycleHookHolder) {
                seq = (Seq)this.list().filter((Function1 & Serializable)_$5 -> {
                    Injectee injectee = _$5.injectee();
                    Injectee injectee2 = x;
                    return !(injectee != null ? !((Object)injectee).equals(injectee2) : injectee2 != null);
                });
            }
            return seq;
        }

        public boolean registerOnlyOnce(LifeCycleHook x) {
            boolean bl;
            LifeCycleHookHolder lifeCycleHookHolder = this;
            synchronized (lifeCycleHookHolder) {
                boolean bl2;
                if (this.list().exists((Function1 & Serializable)_$6 -> {
                    Injectee injectee = _$6.injectee();
                    Injectee injectee2 = x.injectee();
                    return !(injectee != null ? !((Object)injectee).equals(injectee2) : injectee2 != null);
                })) {
                    bl2 = false;
                } else {
                    this.holder_$eq((Vector<LifeCycleHook>)((Vector)this.holder().$colon$plus((Object)x)));
                    bl2 = true;
                }
                bl = bl2;
            }
            return bl;
        }
    }
}

