/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.tracing;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import wvlet.airframe.Design;
import wvlet.airframe.Session;
import wvlet.airframe.surface.Surface;
import wvlet.airframe.tracing.DIStatsReport;
import wvlet.airframe.tracing.DIStatsReport$;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public class DIStats
implements LoggingMethods,
LazyLogger,
LogSupport {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DIStats.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private final scala.collection.concurrent.Map<Surface, AtomicLong> injectCountTable = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
    private final scala.collection.concurrent.Map<Surface, AtomicLong> initCountTable = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
    private final long baseNano = System.nanoTime();
    private final scala.collection.concurrent.Map<Surface, Object> firstSeen = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void observe(Surface s) {
        this.firstSeen.getOrElseUpdate((Object)s, this::observe$$anonfun$1);
    }

    public void incrementInjectCount(Session session, Surface surface) {
        this.observe(surface);
        AtomicLong counter = (AtomicLong)this.injectCountTable.getOrElseUpdate((Object)surface, DIStats::$anonfun$1);
        counter.incrementAndGet();
    }

    public void incrementInitCount(Session session, Surface surface) {
        this.observe(surface);
        AtomicLong counter = (AtomicLong)this.initCountTable.getOrElseUpdate((Object)surface, DIStats::$anonfun$2);
        counter.incrementAndGet();
    }

    private long getInjectCount(Surface surface) {
        return BoxesRunTime.unboxToLong((Object)this.injectCountTable.get((Object)surface).map((Function1 & Serializable)_$1 -> _$1.get()).getOrElse(DIStats::getInjectCount$$anonfun$2));
    }

    public DIStatsReport coverageReportFor(Design design) {
        IntRef bindingCount = IntRef.create((int)0);
        IntRef usedBindingCount = IntRef.create((int)0);
        Builder unusedBindings = package$.MODULE$.Seq().newBuilder();
        design.binding().map((Function1 & Serializable)b -> {
            int n;
            bindingCount$1.elem = n = bindingCount$1.elem + 1;
            Surface surface = b.from();
            long injectCount = this.getInjectCount(surface);
            if (injectCount > 0L) {
                int n2;
                usedBindingCount$1.elem = n2 = usedBindingCount$1.elem + 1;
                return BoxedUnit.UNIT;
            }
            return unusedBindings.$plus$eq((Object)surface);
        });
        double coverage = bindingCount.elem == 0 ? 1.0 : (double)usedBindingCount.elem / (double)bindingCount.elem;
        return DIStatsReport$.MODULE$.apply(coverage, (Seq<Surface>)((Seq)((IterableOps)this.firstSeen.toSeq().sortBy((Function1 & Serializable)_$2 -> BoxesRunTime.unboxToLong((Object)_$2._2()), (Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable)_$3 -> (Surface)_$3._1())).toSeq(), (Map<Surface, Object>)this.initCountTable.map((Function1 & Serializable)x -> {
            Surface surface = (Surface)Predef$.MODULE$.ArrowAssoc(x._1());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)surface, (Object)BoxesRunTime.boxToLong((long)((AtomicLong)x._2()).get()));
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Map<Surface, Object>)this.injectCountTable.map((Function1 & Serializable)x -> {
            Surface surface = (Surface)Predef$.MODULE$.ArrowAssoc(x._1());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)surface, (Object)BoxesRunTime.boxToLong((long)((AtomicLong)x._2()).get()));
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Seq<Surface>)((Seq)unusedBindings.result()));
    }

    private final long observe$$anonfun$1() {
        return System.nanoTime() - this.baseNano;
    }

    private static final AtomicLong $anonfun$1() {
        return new AtomicLong(0L);
    }

    private static final AtomicLong $anonfun$2() {
        return new AtomicLong(0L);
    }

    private static final long getInjectCount$$anonfun$2() {
        return 0L;
    }
}

