/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.codec;

import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import wvlet.airframe.codec.JSONCodec$;
import wvlet.airframe.codec.JSONValueCodec$;
import wvlet.airframe.codec.MessageCodec$;
import wvlet.airframe.codec.MessageContext;
import wvlet.airframe.codec.PackAsMapSupport;
import wvlet.airframe.codec.PrimitiveCodec$StringCodec$;
import wvlet.airframe.json.JSON;
import wvlet.airframe.json.UnexpectedEOF;
import wvlet.airframe.msgpack.spi.BufferPacker;
import wvlet.airframe.msgpack.spi.InsufficientBufferException;
import wvlet.airframe.msgpack.spi.MessagePack$;
import wvlet.airframe.msgpack.spi.Packer;
import wvlet.airframe.msgpack.spi.Unpacker;
import wvlet.airframe.surface.Alias$;
import wvlet.airframe.surface.AnyRefSurface$;
import wvlet.airframe.surface.GenericSurface;
import wvlet.airframe.surface.GenericSurface$;
import wvlet.airframe.surface.Primitive;
import wvlet.airframe.surface.Surface;
import wvlet.airframe.surface.package$;
import wvlet.log.LogLevel;
import wvlet.log.LogSource$;
import wvlet.log.LogSupport;

public interface MessageCodec<A>
extends LogSupport {
    public static MessageCodec<?> ofSurface(Surface surface) {
        return MessageCodec$.MODULE$.ofSurface(surface);
    }

    public static byte[] pack$(MessageCodec $this, Object v) {
        return $this.pack(v);
    }

    default public byte[] pack(A v) {
        return this.toMsgPack(v);
    }

    public static Object unpack$(MessageCodec $this, byte[] msgpack) {
        return $this.unpack(msgpack);
    }

    default public A unpack(byte[] msgpack) {
        Unpacker unpacker = MessagePack$.MODULE$.newUnpacker(msgpack);
        MessageContext v = new MessageContext();
        try {
            this.unpack(unpacker, v);
        }
        catch (Throwable e) {
            throw this.unpackError(e);
        }
        Option<Throwable> option = v.getError();
        if (option instanceof Some) {
            Throwable err = (Throwable)((Some)option).value();
            throw this.unpackError(err);
        }
        if (None$.MODULE$.equals(option)) {
            return (A)v.getLastValue();
        }
        throw new MatchError(option);
    }

    private Throwable unpackError(Throwable e) {
        return new IllegalArgumentException(new StringBuilder(50).append("Failed to read the input msgpack data with codec: ").append(this).toString(), e);
    }

    public void pack(Packer var1, A var2);

    public void unpack(Unpacker var1, MessageContext var2);

    public static byte[] toMsgPack$(MessageCodec $this, Object v) {
        return $this.toMsgPack(v);
    }

    default public byte[] toMsgPack(A v) {
        BufferPacker packer = MessagePack$.MODULE$.newBufferPacker();
        MessageCodec messageCodec = this;
        if (messageCodec instanceof PackAsMapSupport) {
            MessageCodec c = (MessageCodec)((Object)((PackAsMapSupport)((Object)messageCodec)));
            ((PackAsMapSupport)((Object)c)).packAsMap((Packer)packer, v);
        } else {
            this.pack((Packer)packer, v);
        }
        return packer.toByteArray();
    }

    private byte[] toMsgpackMap(A v) {
        BufferPacker packer = MessagePack$.MODULE$.newBufferPacker();
        MessageCodec messageCodec = this;
        if (messageCodec instanceof PackAsMapSupport) {
            MessageCodec c = (MessageCodec)((Object)((PackAsMapSupport)((Object)messageCodec)));
            ((PackAsMapSupport)((Object)c)).packAsMap((Packer)packer, v);
        } else {
            this.pack((Packer)packer, v);
        }
        return packer.toByteArray();
    }

    public static String toJson$(MessageCodec $this, Object v) {
        return $this.toJson(v);
    }

    default public String toJson(A v) {
        return JSONCodec$.MODULE$.toJson(this.toMsgpackMap(v));
    }

    public static JSON.JSONObject toJSONObject$(MessageCodec $this, Object v) {
        return $this.toJSONObject(v);
    }

    default public JSON.JSONObject toJSONObject(A v) {
        JSON.JSONValue jSONValue;
        Option option = JSONValueCodec$.MODULE$.unpackMsgPack(this.toMsgpackMap(v));
        if (option instanceof Some && (jSONValue = (JSON.JSONValue)((Some)option).value()) instanceof JSON.JSONObject) {
            Seq seq;
            JSON.JSONObject jSONObject = (JSON.JSONObject)jSONValue;
            JSON.JSONObject jSONObject2 = JSON.JSONObject$.MODULE$.unapply(jSONObject);
            Seq o = seq = jSONObject2._1();
            JSON.JSONObject j = jSONObject;
            return j;
        }
        throw new IllegalArgumentException(new StringBuilder(30).append("Failed to read as JSONObject: ").append(v).toString());
    }

    public static Option unpackBytes$(MessageCodec $this, byte[] msgpack) {
        return $this.unpackBytes(msgpack);
    }

    default public Option<A> unpackBytes(byte[] msgpack) {
        return this.unpackMsgPack(msgpack);
    }

    public static Option unpackBytes$(MessageCodec $this, byte[] msgpack, int offset, int len) {
        return $this.unpackBytes(msgpack, offset, len);
    }

    default public Option<A> unpackBytes(byte[] msgpack, int offset, int len) {
        return this.unpackMsgPack(msgpack, offset, len);
    }

    public static Object fromMsgPack$(MessageCodec $this, byte[] msgpack) {
        return $this.fromMsgPack(msgpack);
    }

    default public A fromMsgPack(byte[] msgpack) {
        return this.unpack(msgpack);
    }

    public static Option unpackMsgPack$(MessageCodec $this, byte[] msgpack) {
        return $this.unpackMsgPack(msgpack);
    }

    default public Option<A> unpackMsgPack(byte[] msgpack) {
        return this.unpackMsgPack(msgpack, 0, msgpack.length);
    }

    public static Option unpackMsgPack$(MessageCodec $this, byte[] msgpack, int offset, int len) {
        return $this.unpackMsgPack(msgpack, offset, len);
    }

    default public Option<A> unpackMsgPack(byte[] msgpack, int offset, int len) {
        None$ none$;
        block5: {
            Unpacker unpacker = MessagePack$.MODULE$.newUnpacker(msgpack, offset, len);
            MessageContext v = new MessageContext();
            try {
                this.unpack(unpacker, v);
                if (v.isNull()) {
                    none$ = None$.MODULE$;
                    break block5;
                }
                none$ = Some$.MODULE$.apply(v.getLastValue());
            }
            catch (InsufficientBufferException e) {
                MessageCodec LoggingMethods_this;
                MessageCodec LoggingMethods_this2 = this;
                if (LoggingMethods_this2.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                    LoggingMethods_this2.wvlet$log$LoggingMethods$$inline$logger().logWithCause((LogLevel)LogLevel.WARN$.MODULE$, LogSource$.MODULE$.apply("", "MessageCodec.scala", 115, 29), (Object)e.getMessage(), (Throwable)e);
                }
                if ((LoggingMethods_this = this).wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
                    LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.TRACE$.MODULE$, LogSource$.MODULE$.apply("", "MessageCodec.scala", 116, 16), (Object)e);
                }
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public static Option unpackJson$(MessageCodec $this, String json) {
        return $this.unpackJson(json);
    }

    default public Option<A> unpackJson(String json) {
        Some some;
        try {
            some = Some$.MODULE$.apply(this.fromJson(json));
        }
        catch (UnexpectedEOF e) {
            MessageCodec LoggingMethods_this = this;
            if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
                LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.WARN$.MODULE$, LogSource$.MODULE$.apply("", "MessageCodec.scala", 126, 49), (Object)new StringBuilder(10).append(e.getMessage()).append(" in json: ").append(json).toString());
            }
            some = None$.MODULE$;
        }
        return some;
    }

    public static Object fromJson$(MessageCodec $this, String json) {
        return $this.fromJson(json);
    }

    default public A fromJson(String json) {
        byte[] msgpack = MessagePack$.MODULE$.fromJSON(json);
        Unpacker unpacker = MessagePack$.MODULE$.newUnpacker(msgpack);
        MessageContext v = new MessageContext();
        this.unpack(unpacker, v);
        if (v.hasError()) {
            throw this.unpackError((Throwable)v.getError().get());
        }
        if (v.isNull()) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Invalid JSON data for ").append(this).append(":\n").append(json).toString());
        }
        return (A)v.getLastValue();
    }

    public static Object fromJson$(MessageCodec $this, byte[] json) {
        return $this.fromJson(json);
    }

    default public A fromJson(byte[] json) {
        byte[] msgpack = MessagePack$.MODULE$.fromJSON(json);
        Unpacker unpacker = MessagePack$.MODULE$.newUnpacker(msgpack);
        MessageContext v = new MessageContext();
        this.unpack(unpacker, v);
        if (v.hasError()) {
            throw this.unpackError((Throwable)v.getError().get());
        }
        if (v.isNull()) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Invalid JSON data for ").append(this).append(":\n").append(json).toString());
        }
        return (A)v.getLastValue();
    }

    public static Object fromMap$(MessageCodec $this, Map m) {
        return $this.fromMap((Map<String, Object>)m);
    }

    default public A fromMap(Map<String, Object> m) {
        String key = "Map[String,Any]";
        if (!package$.MODULE$.surfaceCache().contains((Object)key)) {
            scala.collection.concurrent.Map map = package$.MODULE$.surfaceCache();
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
            Object[] objectArray = new Surface[2];
            String key2 = "String";
            if (!package$.MODULE$.surfaceCache().contains((Object)key2)) {
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)key2);
                package$.MODULE$.surfaceCache().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Primitive.String$.MODULE$));
            }
            objectArray[0] = (Surface)package$.MODULE$.surfaceCache().apply((Object)key2);
            String key3 = "Any";
            if (!package$.MODULE$.surfaceCache().contains((Object)key3)) {
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)key3);
                package$.MODULE$.surfaceCache().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Alias$.MODULE$.apply("Any", "scala.Any", (Surface)AnyRefSurface$.MODULE$)));
            }
            objectArray[1] = (Surface)package$.MODULE$.surfaceCache().apply((Object)key3);
            map.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new GenericSurface(Map.class, (Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray).toIndexedSeq(), GenericSurface$.MODULE$.$lessinit$greater$default$3(), GenericSurface$.MODULE$.$lessinit$greater$default$4())));
        }
        MessageCodec<?> mapCodec = MessageCodec$.MODULE$.ofSurface((Surface)package$.MODULE$.surfaceCache().apply((Object)key));
        byte[] msgpack = mapCodec.toMsgPack(m);
        return this.fromMsgPack(msgpack);
    }

    public static Object fromString$(MessageCodec $this, String s) {
        return $this.fromString(s);
    }

    default public A fromString(String s) {
        return this.fromMsgPack(PrimitiveCodec$StringCodec$.MODULE$.toMsgPack(s));
    }
}

