/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.codec;

import java.io.Serializable;
import scala.Byte$;
import scala.Char$;
import scala.Float$;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Short$;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import wvlet.airframe.codec.DataType;
import wvlet.airframe.codec.DataType$ANY$;
import wvlet.airframe.codec.DataType$BOOLEAN$;
import wvlet.airframe.codec.DataType$FLOAT$;
import wvlet.airframe.codec.DataType$INTEGER$;
import wvlet.airframe.codec.DataType$NIL$;
import wvlet.airframe.codec.DataType$STRING$;
import wvlet.airframe.codec.INVALID_DATA$;
import wvlet.airframe.codec.MessageCodec;
import wvlet.airframe.codec.MessageCodecException;
import wvlet.airframe.codec.MessageContext$;

public class MessageContext
implements Product,
Serializable {
    private DataType dataType = DataType$NIL$.MODULE$;
    private Option<Object> value = None$.MODULE$;
    private Option<Throwable> err = None$.MODULE$;
    private long l = 0L;
    private boolean b = false;
    private double d = 0.0;
    private String s = "";

    public static MessageContext apply() {
        return MessageContext$.MODULE$.apply();
    }

    public static MessageContext fromProduct(Product product) {
        return MessageContext$.MODULE$.fromProduct(product);
    }

    public static boolean unapply(MessageContext messageContext) {
        return MessageContext$.MODULE$.unapply(messageContext);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof MessageContext)) return false;
        MessageContext messageContext = (MessageContext)object;
        boolean bl = messageContext.canEqual(this);
        if (!bl) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof MessageContext;
    }

    public int productArity() {
        return 0;
    }

    public String productPrefix() {
        return "MessageContext";
    }

    public Object productElement(int n) {
        int n2 = n;
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public boolean isNull() {
        return this.value.isEmpty();
    }

    public boolean hasError() {
        return this.err.isDefined();
    }

    public Option<Throwable> getError() {
        return this.err;
    }

    public void setNull() {
        this.dataType = DataType$NIL$.MODULE$;
        this.value = None$.MODULE$;
    }

    public void setBoolean(boolean v) {
        this.setValue(DataType$BOOLEAN$.MODULE$, BoxesRunTime.boxToBoolean((boolean)v));
        this.b = v;
    }

    public void setByte(byte v) {
        this.setValue(DataType$INTEGER$.MODULE$, BoxesRunTime.boxToByte((byte)v));
        this.l = Byte$.MODULE$.byte2long(v);
    }

    public void setChar(char v) {
        this.setValue(DataType$INTEGER$.MODULE$, BoxesRunTime.boxToCharacter((char)v));
        this.l = Char$.MODULE$.char2long(v);
    }

    public void setShort(short v) {
        this.setValue(DataType$INTEGER$.MODULE$, BoxesRunTime.boxToShort((short)v));
        this.l = Short$.MODULE$.short2long(v);
    }

    public void setInt(int v) {
        this.setValue(DataType$INTEGER$.MODULE$, BoxesRunTime.boxToInteger((int)v));
        this.l = Int$.MODULE$.int2long(v);
    }

    public void setLong(long v) {
        this.setValue(DataType$INTEGER$.MODULE$, BoxesRunTime.boxToLong((long)v));
        this.l = v;
    }

    public void setFloat(float v) {
        this.setValue(DataType$FLOAT$.MODULE$, BoxesRunTime.boxToFloat((float)v));
        this.d = Float$.MODULE$.float2double(v);
    }

    public void setDouble(double v) {
        this.setValue(DataType$FLOAT$.MODULE$, BoxesRunTime.boxToDouble((double)v));
        this.d = v;
    }

    public void setString(String v) {
        this.setValue(DataType$STRING$.MODULE$, v);
        this.s = v;
    }

    public void setObject(Object v) {
        if (v == null) {
            this.setNull();
            return;
        }
        this.setValue(DataType$ANY$.MODULE$, v);
    }

    public void setValue(DataType dataType, Object v) {
        this.dataType = dataType;
        if (v != null) {
            this.value = Some$.MODULE$.apply(v);
            return;
        }
        this.value = None$.MODULE$;
    }

    public byte getByte() {
        DataType dataType = this.dataType;
        if (DataType$INTEGER$.MODULE$.equals(dataType) && RichLong$.MODULE$.isValidByte$extension(Predef$.MODULE$.longWrapper(this.l))) {
            return (byte)this.l;
        }
        return 0;
    }

    public int getInt() {
        DataType dataType = this.dataType;
        if (DataType$INTEGER$.MODULE$.equals(dataType) && RichLong$.MODULE$.isValidInt$extension(Predef$.MODULE$.longWrapper(this.l))) {
            return (int)this.l;
        }
        return 0;
    }

    public short getShort() {
        DataType dataType = this.dataType;
        if (DataType$INTEGER$.MODULE$.equals(dataType) && RichLong$.MODULE$.isValidShort$extension(Predef$.MODULE$.longWrapper(this.l))) {
            return (short)this.l;
        }
        return 0;
    }

    public char getChar() {
        DataType dataType = this.dataType;
        if (DataType$INTEGER$.MODULE$.equals(dataType) && RichLong$.MODULE$.isValidChar$extension(Predef$.MODULE$.longWrapper(this.l))) {
            return (char)this.l;
        }
        return '\u0000';
    }

    public long getLong() {
        DataType dataType = this.dataType;
        if (DataType$INTEGER$.MODULE$.equals(dataType)) {
            return this.l;
        }
        return 0L;
    }

    public boolean getBoolean() {
        DataType dataType = this.dataType;
        if (DataType$BOOLEAN$.MODULE$.equals(dataType)) {
            return this.b;
        }
        return false;
    }

    public double getDouble() {
        DataType dataType = this.dataType;
        if (DataType$FLOAT$.MODULE$.equals(dataType)) {
            return this.d;
        }
        return 0.0;
    }

    public float getFloat() {
        DataType dataType = this.dataType;
        if (DataType$FLOAT$.MODULE$.equals(dataType)) {
            return (float)this.d;
        }
        return 0.0f;
    }

    public String getString() {
        DataType dataType = this.dataType;
        if (DataType$STRING$.MODULE$.equals(dataType)) {
            return this.s;
        }
        return (String)this.value.map((Function1 & Serializable)_$1 -> _$1.toString()).getOrElse(MessageContext::getString$$anonfun$2);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Object getLastValue() {
        return this.value.getOrElse(MessageContext::getLastValue$$anonfun$1);
    }

    public <A> void setError(Throwable e) {
        this.setNull();
        this.err = Option$.MODULE$.apply((Object)e);
    }

    public void setIncompatibleFormatException(MessageCodec<?> codec, String message) {
        this.setError(new MessageCodecException(INVALID_DATA$.MODULE$, codec, message));
    }

    public MessageContext copy() {
        return new MessageContext();
    }

    private static final String getString$$anonfun$2() {
        return "";
    }

    private static final Object getLastValue$$anonfun$1() {
        return null;
    }
}

