/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.codec;

import java.io.Serializable;
import java.time.Instant;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import wvlet.airframe.codec.Compat$;
import wvlet.airframe.codec.JSONCodec$;
import wvlet.airframe.codec.JSONValueCodec$;
import wvlet.airframe.codec.MessageCodec;
import wvlet.airframe.codec.MessageCodecFactory;
import wvlet.airframe.codec.MessageContext;
import wvlet.airframe.codec.PackSupport;
import wvlet.airframe.codec.PrefixedULIDCodec$;
import wvlet.airframe.codec.PrimitiveCodec$;
import wvlet.airframe.codec.PrimitiveCodec$AnyCodec$;
import wvlet.airframe.codec.PrimitiveCodec$BooleanArrayCodec$;
import wvlet.airframe.codec.PrimitiveCodec$BooleanCodec$;
import wvlet.airframe.codec.PrimitiveCodec$ByteArrayCodec$;
import wvlet.airframe.codec.PrimitiveCodec$ByteCodec$;
import wvlet.airframe.codec.PrimitiveCodec$CharArrayCodec$;
import wvlet.airframe.codec.PrimitiveCodec$CharCodec$;
import wvlet.airframe.codec.PrimitiveCodec$DoubleArrayCodec$;
import wvlet.airframe.codec.PrimitiveCodec$DoubleCodec$;
import wvlet.airframe.codec.PrimitiveCodec$FloatArrayCodec$;
import wvlet.airframe.codec.PrimitiveCodec$FloatCodec$;
import wvlet.airframe.codec.PrimitiveCodec$IntArrayCodec$;
import wvlet.airframe.codec.PrimitiveCodec$IntCodec$;
import wvlet.airframe.codec.PrimitiveCodec$LongArrayCodec$;
import wvlet.airframe.codec.PrimitiveCodec$LongCodec$;
import wvlet.airframe.codec.PrimitiveCodec$ShortArrayCodec$;
import wvlet.airframe.codec.PrimitiveCodec$ShortCodec$;
import wvlet.airframe.codec.PrimitiveCodec$StringArrayCodec$;
import wvlet.airframe.codec.PrimitiveCodec$StringCodec$;
import wvlet.airframe.codec.PrimitiveCodec$ValueCodec$;
import wvlet.airframe.codec.ThrowableCodec$;
import wvlet.airframe.codec.ULIDCodec$;
import wvlet.airframe.json.JSON;
import wvlet.airframe.msgpack.spi.ExtTypeHeader;
import wvlet.airframe.msgpack.spi.MessagePack$;
import wvlet.airframe.msgpack.spi.Packer;
import wvlet.airframe.msgpack.spi.Unpacker;
import wvlet.airframe.msgpack.spi.Value;
import wvlet.airframe.msgpack.spi.ValueType;
import wvlet.airframe.surface.Surface;
import wvlet.airframe.ulid.PrefixedULID;
import wvlet.airframe.ulid.ULID;
import wvlet.log.LazyLogger;
import wvlet.log.Logger;

public final class PrimitiveCodec {
    public static Map<Surface, MessageCodec<? extends Object>> primitiveArrayCodec() {
        return PrimitiveCodec$.MODULE$.primitiveArrayCodec();
    }

    public static Map<Surface, MessageCodec<?>> primitiveCodec() {
        return PrimitiveCodec$.MODULE$.primitiveCodec();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class AnyCodec
    implements MessageCodec<Object> {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AnyCodec.class.getDeclaredField("logger$lzy25"));
        private volatile Object logger$lzy25;
        private final MessageCodecFactory codecFactory;
        private final Map<Class<?>, Surface> knownSurfaceTable;

        public static AnyCodec default() {
            return PrimitiveCodec$AnyCodec$.MODULE$.default();
        }

        public static MessageCodecFactory $lessinit$greater$default$1() {
            return PrimitiveCodec$AnyCodec$.MODULE$.$lessinit$greater$default$1();
        }

        public static Seq<Surface> $lessinit$greater$default$2() {
            return PrimitiveCodec$AnyCodec$.MODULE$.$lessinit$greater$default$2();
        }

        public AnyCodec(MessageCodecFactory codecFactory, Seq<Surface> knownSurfaces) {
            this.codecFactory = codecFactory;
            this.knownSurfaceTable = ((IterableOnceOps)knownSurfaces.map((Function1 & Serializable)s -> {
                Class clazz = (Class)Predef$.MODULE$.ArrowAssoc((Object)s.rawType());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, s);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public Logger logger() {
            Object object = this.logger$lzy25;
            if (object instanceof Logger) {
                return (Logger)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Logger)this.logger$lzyINIT25();
        }

        private Object logger$lzyINIT25() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.logger$lzy25) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Logger logger = null;
                        try {
                            logger = LazyLogger.logger$((LazyLogger)this);
                            object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy25;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return logger;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public void pack(Packer p, Object v) {
            Object object = v;
            if (object == null) {
                p.packNil();
                return;
            }
            if (object instanceof String) {
                String v2 = (String)object;
                PrimitiveCodec$StringCodec$.MODULE$.pack(p, v2);
                return;
            }
            if (object instanceof Boolean) {
                boolean v3 = BoxesRunTime.unboxToBoolean((Object)object);
                PrimitiveCodec$BooleanCodec$.MODULE$.pack(p, v3);
                return;
            }
            if (object instanceof Integer) {
                int v4 = BoxesRunTime.unboxToInt((Object)object);
                PrimitiveCodec$IntCodec$.MODULE$.pack(p, v4);
                return;
            }
            if (object instanceof Long) {
                long v5 = BoxesRunTime.unboxToLong((Object)object);
                PrimitiveCodec$LongCodec$.MODULE$.pack(p, v5);
                return;
            }
            if (object instanceof Float) {
                float v6 = BoxesRunTime.unboxToFloat((Object)object);
                PrimitiveCodec$FloatCodec$.MODULE$.pack(p, v6);
                return;
            }
            if (object instanceof Double) {
                double v7 = BoxesRunTime.unboxToDouble((Object)object);
                PrimitiveCodec$DoubleCodec$.MODULE$.pack(p, v7);
                return;
            }
            if (object instanceof Byte) {
                byte v8 = BoxesRunTime.unboxToByte((Object)object);
                PrimitiveCodec$ByteCodec$.MODULE$.pack(p, v8);
                return;
            }
            if (object instanceof Short) {
                short v9 = BoxesRunTime.unboxToShort((Object)object);
                PrimitiveCodec$ShortCodec$.MODULE$.pack(p, v9);
                return;
            }
            if (object instanceof Character) {
                char v10 = BoxesRunTime.unboxToChar((Object)object);
                PrimitiveCodec$CharCodec$.MODULE$.pack(p, v10);
                return;
            }
            if (object instanceof JSON.JSONValue) {
                JSON.JSONValue v11 = (JSON.JSONValue)object;
                JSONValueCodec$.MODULE$.pack(p, v11);
                return;
            }
            if (object instanceof Value) {
                Value v12 = (Value)object;
                PrimitiveCodec$ValueCodec$.MODULE$.pack(p, v12);
                return;
            }
            if (object instanceof Instant) {
                Instant v13 = (Instant)object;
                p.packTimestamp(v13);
                return;
            }
            if (object instanceof PackSupport) {
                PackSupport ps = (PackSupport)object;
                ps.pack(p);
                return;
            }
            if (object instanceof ULID) {
                ULID v14 = (ULID)object;
                ULIDCodec$.MODULE$.pack(p, v14);
                return;
            }
            if (object instanceof PrefixedULID) {
                PrefixedULID v15 = (PrefixedULID)object;
                PrefixedULIDCodec$.MODULE$.pack(p, v15);
                return;
            }
            if (object instanceof String[]) {
                String[] v16 = (String[])object;
                PrimitiveCodec$StringArrayCodec$.MODULE$.pack(p, v16);
                return;
            }
            if (object instanceof boolean[]) {
                boolean[] v17 = (boolean[])object;
                PrimitiveCodec$BooleanArrayCodec$.MODULE$.pack(p, v17);
                return;
            }
            if (object instanceof int[]) {
                int[] v18 = (int[])object;
                PrimitiveCodec$IntArrayCodec$.MODULE$.pack(p, v18);
                return;
            }
            if (object instanceof long[]) {
                long[] v19 = (long[])object;
                PrimitiveCodec$LongArrayCodec$.MODULE$.pack(p, v19);
                return;
            }
            if (object instanceof float[]) {
                float[] v20 = (float[])object;
                PrimitiveCodec$FloatArrayCodec$.MODULE$.pack(p, v20);
                return;
            }
            if (object instanceof double[]) {
                double[] v21 = (double[])object;
                PrimitiveCodec$DoubleArrayCodec$.MODULE$.pack(p, v21);
                return;
            }
            if (object instanceof byte[]) {
                byte[] v22 = (byte[])object;
                PrimitiveCodec$ByteArrayCodec$.MODULE$.pack(p, v22);
                return;
            }
            if (object instanceof short[]) {
                short[] v23 = (short[])object;
                PrimitiveCodec$ShortArrayCodec$.MODULE$.pack(p, v23);
                return;
            }
            if (object instanceof char[]) {
                char[] v24 = (char[])object;
                PrimitiveCodec$CharArrayCodec$.MODULE$.pack(p, v24);
                return;
            }
            if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                Object v25 = object;
                p.packArrayHeader(ScalaRunTime$.MODULE$.array_length(v25));
                Object object2 = Predef$.MODULE$.genericArrayOps(v25);
                ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)x -> this.pack(p, x));
                return;
            }
            if (object instanceof Option) {
                Option v26 = (Option)object;
                if (v26.isEmpty()) {
                    p.packNil();
                    return;
                }
                this.pack(p, v26.get());
                return;
            }
            if (object instanceof Seq) {
                Seq v27 = (Seq)object;
                p.packArrayHeader(v27.length());
                v27.foreach((Function1)(JProcedure1 & Serializable)x -> this.pack(p, x));
                return;
            }
            if (object instanceof Map) {
                Map m = (Map)object;
                p.packMapHeader(m.size());
                m.withFilter((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        return true;
                    }
                    return false;
                }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        this.pack(p, k);
                        this.pack(p, v);
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                });
                return;
            }
            if (object instanceof Either) {
                Either e = (Either)object;
                p.packArrayHeader(2);
                Either either = e;
                if (either instanceof Left) {
                    Object l = ((Left)either).value();
                    this.pack(p, l);
                    p.packNil();
                    return;
                }
                if (either instanceof Right) {
                    Object r = ((Right)either).value();
                    p.packNil();
                    this.pack(p, r);
                    return;
                }
                throw new MatchError((Object)either);
            }
            if (object instanceof Throwable) {
                Throwable v28 = (Throwable)object;
                ThrowableCodec$.MODULE$.pack(p, v28);
                return;
            }
            Class<?> cl = v.getClass();
            Option option = this.knownSurfaceTable.get(cl);
            if (option instanceof Some) {
                Surface surface = (Surface)((Some)option).value();
                MessageCodec<?> codec = this.codecFactory.ofSurface(surface, this.codecFactory.ofSurface$default$2());
                codec.pack(p, v);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                Option<MessageCodec<?>> option2 = Compat$.MODULE$.codecOfClass(cl, this.codecFactory);
                if (option2 instanceof Some) {
                    MessageCodec codec = (MessageCodec)((Some)option2).value();
                    codec.pack(p, v);
                    return;
                }
                if (None$.MODULE$.equals(option2)) {
                    PrimitiveCodec$StringCodec$.MODULE$.pack(p, v.toString());
                    return;
                }
                throw new MatchError(option2);
            }
            throw new MatchError((Object)option);
        }

        @Override
        public void unpack(Unpacker u, MessageContext v) {
            ValueType valueType = u.getNextValueType();
            if (ValueType.NIL$.MODULE$.equals(valueType)) {
                u.unpackNil();
                v.setNull();
                return;
            }
            if (ValueType.BOOLEAN$.MODULE$.equals(valueType)) {
                v.setBoolean(u.unpackBoolean());
                return;
            }
            if (ValueType.INTEGER$.MODULE$.equals(valueType)) {
                v.setLong(u.unpackLong());
                return;
            }
            if (ValueType.FLOAT$.MODULE$.equals(valueType)) {
                v.setDouble(u.unpackDouble());
                return;
            }
            if (ValueType.STRING$.MODULE$.equals(valueType)) {
                v.setString(u.unpackString());
                return;
            }
            if (ValueType.BINARY$.MODULE$.equals(valueType)) {
                int len = u.unpackBinaryHeader();
                v.setObject(u.readPayload(len));
                return;
            }
            if (ValueType.ARRAY$.MODULE$.equals(valueType)) {
                int len = u.unpackArrayHeader();
                Builder b = package$.MODULE$.Seq().newBuilder();
                b.sizeHint(len);
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach((Function1 & Serializable)i -> this.unpack$$anonfun$58(u, v, b, BoxesRunTime.unboxToInt((Object)i)));
                v.setObject(b.result());
                return;
            }
            if (ValueType.MAP$.MODULE$.equals(valueType)) {
                int len = u.unpackMapHeader();
                Builder b = Predef$.MODULE$.Map().newBuilder();
                b.sizeHint(len);
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach((Function1 & Serializable)i -> this.unpack$$anonfun$59(u, v, b, BoxesRunTime.unboxToInt((Object)i)));
                v.setObject(b.result());
                return;
            }
            if (ValueType.EXTENSION$.MODULE$.equals(valueType)) {
                ExtTypeHeader ext = u.unpackExtTypeHeader();
                if (ext.extType() == -1) {
                    v.setObject(u.unpackTimestamp(ext));
                    return;
                }
                byte[] extBody = u.readPayload(ext.byteLength());
                v.setObject(Value.ExtensionValue$.MODULE$.apply(ext.extType(), extBody));
                return;
            }
            throw new MatchError((Object)valueType);
        }

        private final /* synthetic */ Builder unpack$$anonfun$58(Unpacker u$67, MessageContext v$30, Builder b$10, int i) {
            this.unpack(u$67, v$30);
            if (v$30.isNull()) {
                return (Builder)b$10.$plus$eq(null);
            }
            return (Builder)b$10.$plus$eq(v$30.getLastValue());
        }

        private final /* synthetic */ Builder unpack$$anonfun$59(Unpacker u$68, MessageContext v$31, Builder b$11, int i) {
            this.unpack(u$68, v$31);
            Object key = v$31.getLastValue();
            this.unpack(u$68, v$31);
            Object value = v$31.getLastValue();
            Object object = Predef$.MODULE$.ArrowAssoc(key);
            return (Builder)b$11.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, value));
        }
    }

    public static interface PrimitiveArrayCodec {
        public static void unpackArray$(PrimitiveArrayCodec $this, Unpacker u, MessageContext v, Function0 unpackRawArray) {
            $this.unpackArray(u, v, (Function0<BoxedUnit>)unpackRawArray);
        }

        default public void unpackArray(Unpacker u, MessageContext v, Function0<BoxedUnit> unpackRawArray) {
            ValueType valueType = u.getNextFormat().getValueType();
            if (ValueType.STRING$.MODULE$.equals(valueType)) {
                String jsonArray = u.unpackString();
                byte[] msgpack = JSONCodec$.MODULE$.toMsgPack(jsonArray);
                Unpacker unpacker = MessagePack$.MODULE$.newUnpacker(msgpack);
                ((MessageCodec)((Object)this)).unpack(unpacker, v);
                return;
            }
            if (ValueType.ARRAY$.MODULE$.equals(valueType)) {
                unpackRawArray.apply$mcV$sp();
                return;
            }
            ValueType other = valueType;
            v.setIncompatibleFormatException((MessageCodec)((Object)this), new StringBuilder(47).append("STRING or ARRAY type ie expected, but ").append(other).append(" is found").toString());
            u.skipValue();
        }
    }

    public static interface PrimitiveCodec<A>
    extends MessageCodec<A> {
        public Surface surface();
    }

    public static class RichBoolean {
        private final boolean b;

        public RichBoolean(boolean b) {
            this.b = b;
        }

        public int toInt() {
            if (this.b) {
                return 1;
            }
            return 0;
        }

        public char toChar() {
            if (this.b) {
                return '\u0001';
            }
            return '\u0000';
        }

        public byte toByte() {
            if (this.b) {
                return 1;
            }
            return 0;
        }

        public short toShort() {
            if (this.b) {
                return 1;
            }
            return 0;
        }
    }
}

