/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Hashing$;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Set;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.generic.BitOperations;
import scala.collection.immutable.AbstractSet;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.OldHashSet$;
import scala.collection.immutable.SetOps;
import scala.collection.immutable.TrieIterator;
import scala.collection.mutable.Builder;
import scala.math.Integral;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.sys.package$;

public abstract class OldHashSet<A>
extends AbstractSet<A>
implements StrictOptimizedIterableOps<A, OldHashSet, OldHashSet<A>>,
Serializable {
    public static Object fill(int n, Function0 function0) {
        return OldHashSet$.MODULE$.fill(n, function0);
    }

    public static Object fill(int n, int n2, Function0 function0) {
        return OldHashSet$.MODULE$.fill(n, n2, function0);
    }

    public static Object fill(int n, int n2, int n3, Function0 function0) {
        return OldHashSet$.MODULE$.fill(n, n2, n3, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, Function0 function0) {
        return OldHashSet$.MODULE$.fill(n, n2, n3, n4, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, int n5, Function0 function0) {
        return OldHashSet$.MODULE$.fill(n, n2, n3, n4, n5, function0);
    }

    public static <A> OldHashSet<A> from(IterableOnce<A> iterableOnce) {
        return OldHashSet$.MODULE$.from((IterableOnce)iterableOnce);
    }

    public static Object iterate(Object object, int n, Function1 function1) {
        return OldHashSet$.MODULE$.iterate(object, n, function1);
    }

    public static <A> Builder<A, OldHashSet<A>> newBuilder() {
        return OldHashSet$.MODULE$.newBuilder();
    }

    public static Object range(Object object, Object object2, Integral integral) {
        return OldHashSet$.MODULE$.range(object, object2, integral);
    }

    public static Object range(Object object, Object object2, Object object3, Integral integral) {
        return OldHashSet$.MODULE$.range(object, object2, object3, integral);
    }

    public static Object tabulate(int n, Function1 function1) {
        return OldHashSet$.MODULE$.tabulate(n, function1);
    }

    public static Object tabulate(int n, int n2, Function2 function2) {
        return OldHashSet$.MODULE$.tabulate(n, n2, function2);
    }

    public static Object tabulate(int n, int n2, int n3, Function3 function3) {
        return OldHashSet$.MODULE$.tabulate(n, n2, n3, function3);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, Function4 function4) {
        return OldHashSet$.MODULE$.tabulate(n, n2, n3, n4, function4);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, int n5, Function5 function5) {
        return OldHashSet$.MODULE$.tabulate(n, n2, n3, n4, n5, function5);
    }

    public static Object unfold(Object object, Function1 function1) {
        return OldHashSet$.MODULE$.unfold(object, function1);
    }

    public OldHashSet() {
        StrictOptimizedIterableOps.$init$((StrictOptimizedIterableOps)this);
    }

    public String className() {
        return "OldHashSet";
    }

    public IterableFactory<OldHashSet> iterableFactory() {
        return OldHashSet$.MODULE$;
    }

    public boolean contains(A elem) {
        return this.get0(elem, Hashing$.MODULE$.computeHash(elem), 0);
    }

    public OldHashSet<A> incl(A elem) {
        return this.updated0(elem, Hashing$.MODULE$.computeHash(elem), 0);
    }

    public OldHashSet<A> excl(A elem) {
        return OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$nullToEmpty(this.removed0(elem, Hashing$.MODULE$.computeHash(elem), 0));
    }

    public boolean subsetOf(Set<A> that) {
        boolean bl;
        Set<A> set = that;
        if (set instanceof OldHashSet) {
            OldHashSet that2 = (OldHashSet)set;
            bl = this.subsetOf0(that2, 0);
        } else {
            bl = scala.collection.SetOps.subsetOf$((scala.collection.SetOps)this, that);
        }
        return bl;
    }

    public OldHashSet<A> concat(IterableOnce<A> that) {
        OldHashSet<A> oldHashSet;
        IterableOnce<A> iterableOnce = that;
        if (iterableOnce instanceof OldHashSet) {
            OldHashSet that2 = (OldHashSet)iterableOnce;
            OldHashSet[] buffer = new OldHashSet[OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$bufferSize(this.size() + that2.size())];
            oldHashSet = OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$nullToEmpty(this.union0(that2, 0, buffer, 0));
        } else {
            oldHashSet = (OldHashSet<A>)scala.collection.SetOps.concat$((scala.collection.SetOps)this, that);
        }
        return oldHashSet;
    }

    public OldHashSet<A> intersect(Set<A> that) {
        OldHashSet<A> oldHashSet;
        Set<A> set = that;
        if (set instanceof OldHashSet) {
            OldHashSet that2 = (OldHashSet)set;
            OldHashSet[] buffer = new OldHashSet[OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$bufferSize(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.size()), that2.size()))];
            oldHashSet = OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$nullToEmpty(this.intersect0(that2, 0, buffer, 0));
        } else {
            oldHashSet = (OldHashSet<A>)scala.collection.SetOps.intersect$((scala.collection.SetOps)this, that);
        }
        return oldHashSet;
    }

    public OldHashSet<A> diff(Set<A> that) {
        OldHashSet<A> oldHashSet;
        Set<A> set = that;
        if (set instanceof OldHashSet) {
            OldHashSet that2 = (OldHashSet)set;
            OldHashSet[] buffer = new OldHashSet[OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$bufferSize(this.size())];
            oldHashSet = OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$nullToEmpty(this.diff0(that2, 0, buffer, 0));
        } else {
            oldHashSet = (OldHashSet<A>)SetOps.diff$((SetOps)this, that);
        }
        return oldHashSet;
    }

    public OldHashSet<A> filter(Function1<A, Object> p) {
        OldHashSet[] buffer = new OldHashSet[OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$bufferSize(this.size())];
        return OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$nullToEmpty(this.filter0(p, false, 0, buffer, 0));
    }

    public OldHashSet<A> filterNot(Function1<A, Object> p) {
        OldHashSet[] buffer = new OldHashSet[OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$bufferSize(this.size())];
        return OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$nullToEmpty(this.filter0(p, true, 0, buffer, 0));
    }

    public OldHashSet<A> tail() {
        return (OldHashSet)this.$minus(this.head());
    }

    public OldHashSet<A> init() {
        return (OldHashSet)this.$minus(this.last());
    }

    public abstract boolean get0(A var1, int var2, int var3);

    public abstract OldHashSet<A> updated0(A var1, int var2, int var3);

    public abstract OldHashSet<A> removed0(A var1, int var2, int var3);

    public abstract OldHashSet<A> filter0(Function1<A, Object> var1, boolean var2, int var3, OldHashSet<A>[] var4, int var5);

    public abstract boolean subsetOf0(OldHashSet<A> var1, int var2);

    public abstract OldHashSet<A> union0(LeafOldHashSet<A> var1, int var2);

    public abstract OldHashSet<A> union0(OldHashSet<A> var1, int var2, OldHashSet<A>[] var3, int var4);

    public abstract OldHashSet<A> intersect0(OldHashSet<A> var1, int var2, OldHashSet<A>[] var3, int var4);

    public abstract OldHashSet<A> diff0(OldHashSet<A> var1, int var2, OldHashSet<A>[] var3, int var4);

    public static final class HashTrieSet<A>
    extends OldHashSet<A> {
        private final int bitmap;
        private final OldHashSet[] elems;
        private final int size0;

        public HashTrieSet(int bitmap, OldHashSet<A>[] elems, int size0) {
            this.bitmap = bitmap;
            this.elems = elems;
            this.size0 = size0;
            if (Integer.bitCount(bitmap) != elems.length) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
        }

        private int bitmap() {
            return this.bitmap;
        }

        public OldHashSet<A>[] elems() {
            return this.elems;
        }

        private int size0() {
            return this.size0;
        }

        public int size() {
            return this.size0();
        }

        public boolean isEmpty() {
            return false;
        }

        public int knownSize() {
            return this.size();
        }

        public Iterator<A> iterator() {
            return new TrieIterator<A>(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super($outer.scala$collection$immutable$OldHashSet$HashTrieSet$$_$$anon$superArg$1$1());
                }

                public final Object getElem(Object cc) {
                    return ((OldHashSet1)cc).key();
                }
            };
        }

        public <U> void foreach(Function1<A, U> f) {
            for (int i = 0; i < this.elems().length; ++i) {
                this.elems()[i].foreach(f);
            }
        }

        @Override
        public boolean get0(A key, int hash, int level) {
            boolean bl;
            int index = hash >>> level & 0x1F;
            int mask = 1 << index;
            if (this.bitmap() == -1) {
                bl = this.elems()[index & 0x1F].get0(key, hash, level + 5);
            } else if ((this.bitmap() & mask) != 0) {
                int offset = Integer.bitCount(this.bitmap() & mask - 1);
                bl = this.elems()[offset].get0(key, hash, level + 5);
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public OldHashSet<A> updated0(A key, int hash, int level) {
            HashTrieSet hashTrieSet;
            int index = hash >>> level & 0x1F;
            int mask = 1 << index;
            int offset = Integer.bitCount(this.bitmap() & mask - 1);
            if ((this.bitmap() & mask) != 0) {
                OldHashSet<A> subNew;
                OldHashSet<A> sub = this.elems()[offset];
                if (sub == (subNew = sub.updated0(key, hash, level + 5))) {
                    hashTrieSet = this;
                } else {
                    OldHashSet<A>[] elemsNew = Arrays.copyOf(this.elems(), this.elems().length);
                    elemsNew[offset] = subNew;
                    hashTrieSet = new HashTrieSet<A>(this.bitmap(), elemsNew, this.size() + (subNew.size() - sub.size()));
                }
            } else {
                OldHashSet[] elemsNew = new OldHashSet[this.elems().length + 1];
                Array$.MODULE$.copy(this.elems(), 0, (Object)elemsNew, 0, offset);
                elemsNew[offset] = new OldHashSet1<A>(key, hash);
                Array$.MODULE$.copy(this.elems(), offset, (Object)elemsNew, offset + 1, this.elems().length - offset);
                int bitmapNew = this.bitmap() | mask;
                hashTrieSet = new HashTrieSet<A>(bitmapNew, elemsNew, this.size() + 1);
            }
            return hashTrieSet;
        }

        @Override
        public OldHashSet<A> removed0(A key, int hash, int level) {
            OldHashSet oldHashSet;
            int index = hash >>> level & 0x1F;
            int mask = 1 << index;
            int offset = Integer.bitCount(this.bitmap() & mask - 1);
            if ((this.bitmap() & mask) != 0) {
                OldHashSet<A> subNew;
                OldHashSet<A> sub = this.elems()[offset];
                if (sub == (subNew = sub.removed0(key, hash, level + 5))) {
                    oldHashSet = this;
                } else if (subNew == null) {
                    int bitmapNew = this.bitmap() ^ mask;
                    if (bitmapNew != 0) {
                        OldHashSet[] elemsNew = new OldHashSet[this.elems().length - 1];
                        Array$.MODULE$.copy(this.elems(), 0, (Object)elemsNew, 0, offset);
                        Array$.MODULE$.copy(this.elems(), offset + 1, (Object)elemsNew, offset, this.elems().length - offset - 1);
                        int sizeNew = this.size() - sub.size();
                        oldHashSet = elemsNew.length == 1 && !(elemsNew[0] instanceof HashTrieSet) ? elemsNew[0] : new HashTrieSet<A>(bitmapNew, elemsNew, sizeNew);
                    } else {
                        oldHashSet = null;
                    }
                } else if (this.elems().length == 1 && !(subNew instanceof HashTrieSet)) {
                    oldHashSet = subNew;
                } else {
                    OldHashSet<A>[] elemsNew = Arrays.copyOf(this.elems(), this.elems().length);
                    elemsNew[offset] = subNew;
                    int sizeNew = this.size() + (subNew.size() - sub.size());
                    oldHashSet = new HashTrieSet<A>(this.bitmap(), elemsNew, sizeNew);
                }
            } else {
                oldHashSet = this;
            }
            return oldHashSet;
        }

        @Override
        public OldHashSet<A> union0(LeafOldHashSet<A> that, int level) {
            HashTrieSet hashTrieSet;
            int index = that.hash() >>> level & 0x1F;
            int mask = 1 << index;
            int offset = Integer.bitCount(this.bitmap() & mask - 1);
            if ((this.bitmap() & mask) != 0) {
                OldHashSet<A> sub1;
                OldHashSet<A> sub = this.elems()[offset];
                if (sub == (sub1 = sub.union0(that, level + 5))) {
                    hashTrieSet = this;
                } else {
                    OldHashSet[] elems1 = new OldHashSet[this.elems().length];
                    Array$.MODULE$.copy(this.elems(), 0, (Object)elems1, 0, this.elems().length);
                    elems1[offset] = sub1;
                    hashTrieSet = new HashTrieSet<A>(this.bitmap(), elems1, this.size() + (sub1.size() - sub.size()));
                }
            } else {
                OldHashSet[] elems1 = new OldHashSet[this.elems().length + 1];
                Array$.MODULE$.copy(this.elems(), 0, (Object)elems1, 0, offset);
                elems1[offset] = that;
                Array$.MODULE$.copy(this.elems(), offset, (Object)elems1, offset + 1, this.elems().length - offset);
                int bitmap1 = this.bitmap() | mask;
                hashTrieSet = new HashTrieSet<A>(bitmap1, elems1, this.size() + that.size());
            }
            return hashTrieSet;
        }

        @Override
        public OldHashSet<A> union0(OldHashSet<A> that, int level, OldHashSet<A>[] buffer, int offset0) {
            OldHashSet oldHashSet;
            OldHashSet<A> oldHashSet2 = that;
            OldHashSet<A> that2 = oldHashSet2;
            if (that2 == this) {
                oldHashSet = this;
            } else if (oldHashSet2 instanceof LeafOldHashSet) {
                LeafOldHashSet that3 = (LeafOldHashSet)oldHashSet2;
                oldHashSet = this.union0(that3, level);
            } else if (oldHashSet2 instanceof HashTrieSet) {
                HashTrieSet that4 = (HashTrieSet)oldHashSet2;
                OldHashSet<A>[] a = this.elems();
                int abm = this.bitmap();
                int ai = 0;
                OldHashSet<A>[] b = that4.elems();
                int bbm = that4.bitmap();
                int bi = 0;
                int offset = offset0;
                int rs = 0;
                while ((abm | bbm) != 0) {
                    int alsb = abm ^ abm & abm - 1;
                    int blsb = bbm ^ bbm & bbm - 1;
                    if (alsb == blsb) {
                        OldHashSet<A> sub1 = a[ai].union0(b[bi], level + 5, buffer, offset);
                        rs += sub1.size();
                        buffer[offset] = sub1;
                        ++offset;
                        abm &= ~alsb;
                        ++ai;
                        bbm &= ~blsb;
                        ++bi;
                        continue;
                    }
                    if (BitOperations.Int$.MODULE$.unsignedCompare(alsb - 1, blsb - 1)) {
                        OldHashSet<A> sub1 = a[ai];
                        rs += sub1.size();
                        buffer[offset] = sub1;
                        ++offset;
                        abm &= ~alsb;
                        ++ai;
                        continue;
                    }
                    OldHashSet<A> sub1 = b[bi];
                    rs += sub1.size();
                    buffer[offset] = sub1;
                    ++offset;
                    bbm &= ~blsb;
                    ++bi;
                }
                if (rs == this.size()) {
                    oldHashSet = this;
                } else if (rs == that4.size()) {
                    oldHashSet = that4;
                } else {
                    int length = offset - offset0;
                    OldHashSet[] elems = new OldHashSet[length];
                    System.arraycopy(buffer, offset0, elems, 0, length);
                    oldHashSet = new HashTrieSet<A>(this.bitmap() | that4.bitmap(), elems, rs);
                }
            } else {
                oldHashSet = this;
            }
            return oldHashSet;
        }

        @Override
        public OldHashSet<A> intersect0(OldHashSet<A> that, int level, OldHashSet<A>[] buffer, int offset0) {
            OldHashSet oldHashSet;
            OldHashSet<A> oldHashSet2 = that;
            OldHashSet<A> that2 = oldHashSet2;
            if (that2 == this) {
                oldHashSet = this;
            } else if (oldHashSet2 instanceof LeafOldHashSet) {
                LeafOldHashSet that3 = (LeafOldHashSet)oldHashSet2;
                oldHashSet = that3.intersect0(this, level, buffer, offset0);
            } else if (oldHashSet2 instanceof HashTrieSet) {
                HashTrieSet that4 = (HashTrieSet)oldHashSet2;
                OldHashSet<A>[] a = this.elems();
                int abm = this.bitmap();
                int ai = 0;
                OldHashSet<A>[] b = that4.elems();
                int bbm = that4.bitmap();
                int bi = 0;
                if ((abm & bbm) == 0) {
                    return null;
                }
                int offset = offset0;
                int rs = 0;
                int rbm = 0;
                while ((abm & bbm) != 0) {
                    int alsb = abm ^ abm & abm - 1;
                    int blsb = bbm ^ bbm & bbm - 1;
                    if (alsb == blsb) {
                        OldHashSet<A> sub1 = a[ai].intersect0(b[bi], level + 5, buffer, offset);
                        if (sub1 != null) {
                            rs += sub1.size();
                            rbm |= alsb;
                            buffer[offset] = sub1;
                            ++offset;
                        }
                        abm &= ~alsb;
                        ++ai;
                        bbm &= ~blsb;
                        ++bi;
                        continue;
                    }
                    if (BitOperations.Int$.MODULE$.unsignedCompare(alsb - 1, blsb - 1)) {
                        abm &= ~alsb;
                        ++ai;
                        continue;
                    }
                    bbm &= ~blsb;
                    ++bi;
                }
                if (rbm == 0) {
                    oldHashSet = null;
                } else if (rs == this.size0()) {
                    oldHashSet = this;
                } else if (rs == that4.size0()) {
                    oldHashSet = that4;
                } else {
                    int length = offset - offset0;
                    if (length == 1 && !(buffer[offset0] instanceof HashTrieSet)) {
                        oldHashSet = buffer[offset0];
                    } else {
                        OldHashSet[] elems = new OldHashSet[length];
                        System.arraycopy(buffer, offset0, elems, 0, length);
                        oldHashSet = new HashTrieSet<A>(rbm, elems, rs);
                    }
                }
            } else {
                oldHashSet = null;
            }
            return oldHashSet;
        }

        @Override
        public OldHashSet<A> diff0(OldHashSet<A> that, int level, OldHashSet<A>[] buffer, int offset0) {
            OldHashSet oldHashSet;
            OldHashSet<A> oldHashSet2 = that;
            OldHashSet<A> that2 = oldHashSet2;
            if (that2 == this) {
                oldHashSet = null;
            } else if (oldHashSet2 instanceof OldHashSet1) {
                OldHashSet1 that3 = (OldHashSet1)oldHashSet2;
                oldHashSet = this.removed0(that3.key(), that3.hash(), level);
            } else if (oldHashSet2 instanceof HashTrieSet) {
                HashTrieSet that4 = (HashTrieSet)oldHashSet2;
                OldHashSet<A>[] a = this.elems();
                int abm = this.bitmap();
                int ai = 0;
                OldHashSet<A>[] b = that4.elems();
                int bbm = that4.bitmap();
                int bi = 0;
                int offset = offset0;
                int rs = 0;
                int rbm = 0;
                while (abm != 0) {
                    int alsb = abm ^ abm & abm - 1;
                    int blsb = bbm ^ bbm & bbm - 1;
                    if (alsb == blsb) {
                        OldHashSet<A> sub1 = a[ai].diff0(b[bi], level + 5, buffer, offset);
                        if (sub1 != null) {
                            rs += sub1.size();
                            rbm |= alsb;
                            buffer[offset] = sub1;
                            ++offset;
                        }
                        abm &= ~alsb;
                        ++ai;
                        bbm &= ~blsb;
                        ++bi;
                        continue;
                    }
                    if (BitOperations.Int$.MODULE$.unsignedCompare(alsb - 1, blsb - 1)) {
                        OldHashSet<A> sub1 = a[ai];
                        rs += sub1.size();
                        rbm |= alsb;
                        buffer[offset] = sub1;
                        ++offset;
                        abm &= ~alsb;
                        ++ai;
                        continue;
                    }
                    bbm &= ~blsb;
                    ++bi;
                }
                if (rbm == 0) {
                    oldHashSet = null;
                } else if (rs == this.size0()) {
                    oldHashSet = this;
                } else {
                    int length = offset - offset0;
                    if (length == 1 && !(buffer[offset0] instanceof HashTrieSet)) {
                        oldHashSet = buffer[offset0];
                    } else {
                        OldHashSet[] elems = new OldHashSet[length];
                        System.arraycopy(buffer, offset0, elems, 0, length);
                        oldHashSet = new HashTrieSet<A>(rbm, elems, rs);
                    }
                }
            } else if (oldHashSet2 instanceof OldHashSetCollision1) {
                OldHashSetCollision1 that5 = (OldHashSetCollision1)oldHashSet2;
                oldHashSet = this.removeAll$1(level, that5, this, that5.ks());
            } else {
                oldHashSet = this;
            }
            return oldHashSet;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean subsetOf0(OldHashSet<A> that, int level) {
            if (that == this) {
                return true;
            }
            OldHashSet<A> oldHashSet = that;
            if (!(oldHashSet instanceof HashTrieSet)) return false;
            HashTrieSet that2 = (HashTrieSet)oldHashSet;
            if (this.size0() > that2.size0()) return false;
            int abm = this.bitmap();
            OldHashSet<A>[] a = this.elems();
            int ai = 0;
            OldHashSet<A>[] b = that2.elems();
            int bbm = that2.bitmap();
            int bi = 0;
            if ((abm & bbm) != abm) return false;
            while (abm != 0) {
                int alsb = abm ^ abm & abm - 1;
                int blsb = bbm ^ bbm & bbm - 1;
                if (alsb == blsb) {
                    if (!a[ai].subsetOf0(b[bi], level + 5)) {
                        return false;
                    }
                    abm &= ~alsb;
                    ++ai;
                }
                bbm &= ~blsb;
                ++bi;
            }
            return true;
        }

        @Override
        public OldHashSet<A> filter0(Function1<A, Object> p, boolean negate, int level, OldHashSet<A>[] buffer, int offset0) {
            OldHashSet oldHashSet;
            int offset = offset0;
            int rs = 0;
            int kept = 0;
            for (int i = 0; i < this.elems().length; ++i) {
                OldHashSet<A> result = this.elems()[i].filter0(p, negate, level + 5, buffer, offset);
                if (result == null) continue;
                buffer[offset] = result;
                ++offset;
                rs += result.size();
                kept |= 1 << i;
            }
            if (offset == offset0) {
                oldHashSet = null;
            } else if (rs == this.size0()) {
                oldHashSet = this;
            } else if (offset == offset0 + 1 && !(buffer[offset0] instanceof HashTrieSet)) {
                oldHashSet = buffer[offset0];
            } else {
                int length = offset - offset0;
                OldHashSet[] elems1 = new OldHashSet[length];
                System.arraycopy(buffer, offset0, elems1, 0, length);
                int bitmap1 = length == this.elems().length ? this.bitmap() : Hashing$.MODULE$.keepBits(this.bitmap(), kept);
                oldHashSet = new HashTrieSet<A>(bitmap1, elems1, rs);
            }
            return oldHashSet;
        }

        public final Iterable[] scala$collection$immutable$OldHashSet$HashTrieSet$$_$$anon$superArg$1$1() {
            return (Iterable[])this.elems();
        }

        private final OldHashSet removeAll$1(int level$4, OldHashSetCollision1 that$4, OldHashSet s, ListSet r) {
            ListSet listSet = r;
            OldHashSet<Object> oldHashSet = s;
            while (!listSet.isEmpty() && oldHashSet != null) {
                OldHashSet<Object> oldHashSet2 = oldHashSet.removed0(listSet.head(), that$4.hash(), level$4);
                ListSet listSet2 = (ListSet)listSet.tail();
                oldHashSet = oldHashSet2;
                listSet = listSet2;
            }
            return oldHashSet;
        }
    }

    public static abstract class LeafOldHashSet<A>
    extends OldHashSet<A> {
        public abstract int hash();
    }

    public static final class OldHashSet1<A>
    extends LeafOldHashSet<A> {
        private final Object key;
        private final int hash;

        public OldHashSet1(A key, int hash) {
            this.key = key;
            this.hash = hash;
        }

        public A key() {
            return (A)this.key;
        }

        @Override
        public int hash() {
            return this.hash;
        }

        public boolean isEmpty() {
            return false;
        }

        public int knownSize() {
            return 1;
        }

        public Iterator<A> iterator() {
            return Iterator$.MODULE$.single(this.key());
        }

        public <U> void foreach(Function1<A, U> f) {
            f.apply(this.key());
        }

        public A head() {
            return this.key();
        }

        public Some<A> headOption() {
            return Some$.MODULE$.apply(this.key());
        }

        @Override
        public OldHashSet<A> tail() {
            return OldHashSet$.MODULE$.empty();
        }

        public A last() {
            return this.key();
        }

        @Override
        public OldHashSet<A> init() {
            return OldHashSet$.MODULE$.empty();
        }

        public int size() {
            return 1;
        }

        @Override
        public boolean get0(A key, int hash, int level) {
            return hash == this.hash() && BoxesRunTime.equals(key, this.key());
        }

        @Override
        public OldHashSet<A> updated0(A key, int hash, int level) {
            return hash == this.hash() && BoxesRunTime.equals(key, this.key()) ? this : (hash != this.hash() ? OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$makeHashTrieSet(this.hash(), this, hash, new OldHashSet1<A>(key, hash), level) : new OldHashSetCollision1(hash, (ListSet)ListSet$.MODULE$.empty().$plus(this.key()).$plus(key)));
        }

        @Override
        public OldHashSet<A> removed0(A key, int hash, int level) {
            return hash == this.hash() && BoxesRunTime.equals(key, this.key()) ? null : this;
        }

        @Override
        public boolean subsetOf0(OldHashSet<A> that, int level) {
            return that.get0(this.key(), this.hash(), level);
        }

        @Override
        public OldHashSet<A> union0(LeafOldHashSet<A> that, int level) {
            OldHashSet oldHashSet;
            LeafOldHashSet<A> leafOldHashSet = that;
            LeafOldHashSet<A> that2 = leafOldHashSet;
            if (that2.hash() != this.hash()) {
                oldHashSet = OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$makeHashTrieSet(this.hash(), this, that2.hash(), that2, level);
            } else if (leafOldHashSet instanceof OldHashSet1) {
                OldHashSet1 that3 = (OldHashSet1)leafOldHashSet;
                oldHashSet = BoxesRunTime.equals(this.key(), that3.key()) ? this : new OldHashSetCollision1(this.hash(), (ListSet)ListSet$.MODULE$.empty().$plus(this.key()).$plus(that3.key()));
            } else if (leafOldHashSet instanceof OldHashSetCollision1) {
                OldHashSetCollision1 that4 = (OldHashSetCollision1)leafOldHashSet;
                ListSet ks1 = (ListSet)that4.ks().$plus(this.key());
                oldHashSet = ks1.size() == that4.ks().size() ? that4 : new OldHashSetCollision1(this.hash(), ks1);
            } else {
                throw new MatchError(leafOldHashSet);
            }
            return oldHashSet;
        }

        @Override
        public OldHashSet<A> union0(OldHashSet<A> that, int level, OldHashSet<A>[] buffer, int offset0) {
            return that.union0(this, level);
        }

        @Override
        public OldHashSet<A> intersect0(OldHashSet<A> that, int level, OldHashSet<A>[] buffer, int offset0) {
            return that.get0(this.key(), this.hash(), level) ? this : null;
        }

        @Override
        public OldHashSet<A> diff0(OldHashSet<A> that, int level, OldHashSet<A>[] buffer, int offset0) {
            return that.get0(this.key(), this.hash(), level) ? null : this;
        }

        @Override
        public OldHashSet<A> filter0(Function1<A, Object> p, boolean negate, int level, OldHashSet<A>[] buffer, int offset0) {
            return negate ^ BoxesRunTime.unboxToBoolean((Object)p.apply(this.key())) ? this : null;
        }
    }

    public static final class OldHashSetCollision1<A>
    extends LeafOldHashSet<A> {
        private final int hash;
        private final ListSet ks;

        public OldHashSetCollision1(int hash, ListSet<A> ks) {
            this.hash = hash;
            this.ks = ks;
        }

        @Override
        public int hash() {
            return this.hash;
        }

        public ListSet<A> ks() {
            return this.ks;
        }

        public boolean isEmpty() {
            return false;
        }

        public int size() {
            return this.ks().size();
        }

        public Iterator<A> iterator() {
            return this.ks().iterator();
        }

        public <U> void foreach(Function1<A, U> f) {
            this.ks().foreach(f);
        }

        @Override
        public boolean get0(A key, int hash, int level) {
            return hash == this.hash() ? this.ks().contains(key) : false;
        }

        @Override
        public OldHashSet<A> updated0(A key, int hash, int level) {
            return hash == this.hash() ? new OldHashSetCollision1<A>(hash, (ListSet)this.ks().$plus(key)) : OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$makeHashTrieSet(this.hash(), this, hash, new OldHashSet1<A>(key, hash), level);
        }

        @Override
        public OldHashSet<A> removed0(A key, int hash, int level) {
            int size;
            ListSet ks1;
            int n;
            return hash == this.hash() ? (0 == (n = (ks1 = (ListSet)this.ks().$minus(key)).size()) ? null : (1 == n ? new OldHashSet1<Object>(ks1.head(), hash) : ((size = n) == this.ks().size() ? this : new OldHashSetCollision1<A>(hash, ks1)))) : this;
        }

        private void writeObject(ObjectOutputStream out) {
            throw package$.MODULE$.error("cannot serialize an immutable.OldHashSet where all items have the same 32-bit hash code");
        }

        private void readObject(ObjectInputStream in) {
            throw package$.MODULE$.error("cannot deserialize an immutable.OldHashSet where all items have the same 32-bit hash code");
        }

        @Override
        public OldHashSet<A> filter0(Function1<A, Object> p, boolean negate, int level, OldHashSet<A>[] buffer, int offset0) {
            int x;
            ListSet ks1 = negate ? (ListSet)this.ks().filterNot(p) : (ListSet)this.ks().filter(p);
            int n = ks1.size();
            LeafOldHashSet leafOldHashSet = 0 == n ? null : (1 == n ? new OldHashSet1<Object>(ks1.head(), this.hash()) : ((x = n) == this.ks().size() ? this : new OldHashSetCollision1<A>(this.hash(), ks1)));
            return leafOldHashSet;
        }

        @Override
        public boolean subsetOf0(OldHashSet<A> that, int level) {
            return this.ks().forall((Function1 & Serializable)key -> that.get0(key, this.hash(), level));
        }

        @Override
        public OldHashSet<A> union0(LeafOldHashSet<A> that, int level) {
            OldHashSet oldHashSet;
            LeafOldHashSet<A> leafOldHashSet = that;
            LeafOldHashSet<A> that2 = leafOldHashSet;
            if (that2.hash() != this.hash()) {
                oldHashSet = OldHashSet$.MODULE$.scala$collection$immutable$OldHashSet$$$makeHashTrieSet(this.hash(), this, that2.hash(), that2, level);
            } else if (leafOldHashSet instanceof OldHashSet1) {
                OldHashSet1 that3 = (OldHashSet1)leafOldHashSet;
                ListSet ks1 = (ListSet)this.ks().$plus(that3.key());
                oldHashSet = ks1.size() == this.ks().size() ? this : new OldHashSetCollision1<A>(this.hash(), ks1);
            } else if (leafOldHashSet instanceof OldHashSetCollision1) {
                int size;
                OldHashSetCollision1 that4 = (OldHashSetCollision1)leafOldHashSet;
                ListSet ks1 = (ListSet)this.ks().$plus$plus(that4.ks());
                int n = ks1.size();
                int size2 = n;
                oldHashSet = size2 == this.ks().size() ? this : ((size = n) == that4.ks().size() ? that4 : new OldHashSetCollision1<A>(this.hash(), ks1));
            } else {
                throw new MatchError(leafOldHashSet);
            }
            return oldHashSet;
        }

        @Override
        public OldHashSet<A> union0(OldHashSet<A> that, int level, OldHashSet<A>[] buffer, int offset0) {
            OldHashSet oldHashSet;
            OldHashSet<A> oldHashSet2 = that;
            if (oldHashSet2 instanceof LeafOldHashSet) {
                LeafOldHashSet that2 = (LeafOldHashSet)oldHashSet2;
                oldHashSet = this.union0(that2, level);
            } else if (oldHashSet2 instanceof HashTrieSet) {
                HashTrieSet that3 = (HashTrieSet)oldHashSet2;
                oldHashSet = that3.union0(this, level);
            } else {
                oldHashSet = this;
            }
            return oldHashSet;
        }

        @Override
        public OldHashSet<A> intersect0(OldHashSet<A> that, int level, OldHashSet<A>[] buffer, int offset0) {
            int size;
            int size2;
            ListSet ks1 = (ListSet)this.ks().filter((Function1 & Serializable)_$1 -> that.get0(_$1, this.hash(), level));
            int n = ks1.size();
            OldHashSet oldHashSet = 0 == n ? null : ((size2 = n) == this.size() ? this : ((size = n) == that.size() ? that : (1 == n ? new OldHashSet1<Object>(ks1.head(), this.hash()) : new OldHashSetCollision1<A>(this.hash(), ks1))));
            return oldHashSet;
        }

        @Override
        public OldHashSet<A> diff0(OldHashSet<A> that, int level, OldHashSet<A>[] buffer, int offset0) {
            int size;
            ListSet ks1 = (ListSet)this.ks().filterNot((Function1 & Serializable)_$2 -> that.get0(_$2, this.hash(), level));
            int n = ks1.size();
            LeafOldHashSet leafOldHashSet = 0 == n ? null : ((size = n) == this.size() ? this : (1 == n ? new OldHashSet1<Object>(ks1.head(), this.hash()) : new OldHashSetCollision1<A>(this.hash(), ks1)));
            return leafOldHashSet;
        }
    }
}

