/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.ulid;

import java.io.Serializable;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;
import scala.util.Random$;
import wvlet.airframe.ulid.CrockfordBase32$;
import wvlet.airframe.ulid.ULID;
import wvlet.airframe.ulid.compat$;

public final class ULID$
implements Serializable {
    private static final ULID MaxValue;
    private static final long MinTime;
    private static final long MaxTime;
    private static ULID.ULIDGenerator _generator;
    public static final ULID$ MODULE$;

    private ULID$() {
    }

    static {
        MODULE$ = new ULID$();
        MaxValue = MODULE$.apply("7ZZZZZZZZZZZZZZZZZZZZZZZZZ");
        MinTime = 0L;
        MaxTime = 0xFFFFFFFFFFFFL;
        _generator = MODULE$.defaultULIDGenerator();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ULID$.class);
    }

    public ULID MaxValue() {
        return MaxValue;
    }

    public long MinTime() {
        return MinTime;
    }

    public long MaxTime() {
        return MaxTime;
    }

    public ULID.ULIDGenerator defaultULIDGenerator() {
        Random random = compat$.MODULE$.random();
        Function0 & Serializable randGen = (Function0 & Serializable)() -> {
            byte[] r = new byte[10];
            random.nextBytes(r);
            return r;
        };
        return new ULID.ULIDGenerator((Function0<byte[]>)randGen);
    }

    public ULID.ULIDGenerator nonSecureRandomULIDGenerator() {
        Function0 & Serializable randGen = (Function0 & Serializable)() -> {
            byte[] r = new byte[10];
            Random$.MODULE$.nextBytes(r);
            return r;
        };
        return new ULID.ULIDGenerator((Function0<byte[]>)randGen);
    }

    public void setDefaultULIDGenerator(ULID.ULIDGenerator newGenerator) {
        Predef$.MODULE$.require(newGenerator != null, this::setDefaultULIDGenerator$$anonfun$1);
        _generator = newGenerator;
    }

    public void useNonSecureRandomULIDGenerator() {
        this.setDefaultULIDGenerator(this.nonSecureRandomULIDGenerator());
    }

    public void useDefaultULIDGenerator() {
        this.setDefaultULIDGenerator(this.defaultULIDGenerator());
    }

    public ULID newULID() {
        return _generator.newULID();
    }

    public String newULIDString() {
        return _generator.newULIDString();
    }

    public ULID ofMillis(long unixTimeMillis) {
        return this.apply(_generator.newULIDFromMillis(unixTimeMillis));
    }

    public ULID apply(String ulidString) {
        return this.fromString(ulidString);
    }

    public ULID fromString(String ulid) {
        Predef$.MODULE$.require(ulid != null, this::fromString$$anonfun$1);
        Predef$.MODULE$.require(ulid.length() == 26, () -> this.fromString$$anonfun$2(ulid));
        Predef$.MODULE$.require(CrockfordBase32$.MODULE$.isValidBase32(ulid), () -> this.fromString$$anonfun$3(ulid));
        return new ULID(ulid);
    }

    public ULID of(long unixTimeMillis, long randHi, long randLow) {
        if (unixTimeMillis < 0L || unixTimeMillis > this.MaxTime()) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("unixtime must be between 0 to %,d: %,d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.MaxTime()), BoxesRunTime.boxToLong((long)unixTimeMillis)})));
        }
        long hi = unixTimeMillis << 16 | randHi & 0xFFFFL;
        long low = randLow;
        return new ULID(CrockfordBase32$.MODULE$.encode128bits(hi, low));
    }

    public ULID fromBytes(byte[] bytes) {
        return this.fromBytes(bytes, 0);
    }

    public ULID fromBytes(byte[] bytes, int offset) {
        int i;
        Predef$.MODULE$.require(offset + 16 <= bytes.length, () -> this.fromBytes$$anonfun$1(bytes, offset));
        long hi = 0L;
        for (i = 0; i < 8; ++i) {
            hi <<= 8;
            hi |= (long)bytes[offset + i] & 0xFFL;
        }
        long low = 0L;
        while (i < 16) {
            low <<= 8;
            low |= (long)bytes[offset + i] & 0xFFL;
            ++i;
        }
        return new ULID(CrockfordBase32$.MODULE$.encode128bits(hi, low));
    }

    public Option<ULID> unapply(String ulidString) {
        if (this.isValid(ulidString)) {
            return Some$.MODULE$.apply((Object)new ULID(ulidString));
        }
        return None$.MODULE$;
    }

    public boolean isValid(String ulid) {
        return ulid.length() == 26 && CrockfordBase32$.MODULE$.isValidBase32(ulid);
    }

    private final Object setDefaultULIDGenerator$$anonfun$1() {
        return "ULIDGenerator is null";
    }

    private final Object fromString$$anonfun$1() {
        return "The input ULID string was null";
    }

    private final Object fromString$$anonfun$2(String ulid$1) {
        return new StringBuilder(41).append("ULID must have 26 characters: ").append(ulid$1).append(" (length: ").append(ulid$1.length()).append(")").toString();
    }

    private final Object fromString$$anonfun$3(String ulid$2) {
        return new StringBuilder(37).append("Invalid Base32 character is found in ").append(ulid$2).toString();
    }

    private final Object fromBytes$$anonfun$1(byte[] bytes$1, int offset$1) {
        return new StringBuilder(35).append("ULID needs 16 bytes. offset:").append(offset$1).append(", size:").append(bytes$1.length).toString();
    }
}

