/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.msgpack.io;

import scala.Array$;
import scala.Int$;
import scala.Predef$;
import wvlet.airframe.msgpack.io.ByteArrayBuffer;
import wvlet.airframe.msgpack.spi.InsufficientBufferException;
import wvlet.airframe.msgpack.spi.ReadBuffer;
import wvlet.airframe.msgpack.spi.WriteBuffer;

public abstract class ByteArrayBufferBase
implements ReadBuffer,
WriteBuffer {
    private byte[] a;
    private final int offset;
    private int capacity;

    public ByteArrayBufferBase(byte[] a, int offset, int capacity) {
        this.a = a;
        this.offset = offset;
        this.capacity = capacity;
        Predef$.MODULE$.require(offset >= 0, () -> ByteArrayBufferBase.$init$$$anonfun$1(offset));
        Predef$.MODULE$.require(offset + this.capacity() <= this.a().length, () -> this.$init$$$anonfun$2(offset));
    }

    public byte[] a() {
        return this.a;
    }

    public void a_$eq(byte[] x$1) {
        this.a = x$1;
    }

    public int capacity() {
        return this.capacity;
    }

    public void capacity_$eq(int x$1) {
        this.capacity = x$1;
    }

    @Override
    public int size() {
        return this.capacity();
    }

    public byte[] toByteArray(int position, int arraySize) {
        Predef$.MODULE$.require(arraySize >= 0);
        Predef$.MODULE$.require(position + arraySize <= this.capacity(), () -> this.toByteArray$$anonfun$1(position, arraySize));
        if (this.a().length == this.offset + position + arraySize) {
            return this.a();
        }
        byte[] newArray = new byte[arraySize];
        Array$.MODULE$.copy((Object)this.a(), this.offset + position, (Object)newArray, 0, arraySize);
        return newArray;
    }

    @Override
    public ReadBuffer slice(int position, int newSize) {
        Predef$.MODULE$.require(position + newSize <= this.capacity(), () -> this.slice$$anonfun$1(position, newSize));
        return new ByteArrayBuffer(this.a(), this.offset + position, newSize);
    }

    @Override
    public boolean hasCapacity(int position, int byteLength) {
        return position + byteLength <= this.capacity();
    }

    @Override
    public void ensureCapacity(int position, int requestedLength) {
        if (!this.hasCapacity(position, requestedLength)) {
            throw new InsufficientBufferException(Int$.MODULE$.int2long(position), Int$.MODULE$.int2long(requestedLength));
        }
    }

    @Override
    public byte readByte(int position) {
        this.ensureCapacity(position, 1);
        int pos = this.offset + position;
        return this.a()[pos];
    }

    @Override
    public short readShort(int position) {
        this.ensureCapacity(position, 2);
        int pos = this.offset + position;
        return (short)(this.a()[pos] << 8 | this.a()[pos + 1] & 0xFF);
    }

    @Override
    public int readInt(int position) {
        this.ensureCapacity(position, 4);
        int pos = this.offset + position;
        return this.a()[pos] << 24 | (this.a()[pos + 1] & 0xFF) << 16 | (this.a()[pos + 2] & 0xFF) << 8 | this.a()[pos + 3] & 0xFF;
    }

    @Override
    public long readLong(int position) {
        this.ensureCapacity(position, 8);
        int pos = this.offset + position;
        return (long)this.a()[pos] << 56 | ((long)this.a()[pos + 1] & 0xFFL) << 48 | ((long)this.a()[pos + 2] & 0xFFL) << 40 | ((long)this.a()[pos + 3] & 0xFFL) << 32 | ((long)this.a()[pos + 4] & 0xFFL) << 24 | ((long)this.a()[pos + 5] & 0xFFL) << 16 | ((long)this.a()[pos + 6] & 0xFFL) << 8 | (long)this.a()[pos + 7] & 0xFFL;
    }

    @Override
    public byte[] readBytes(int position, int length) {
        this.ensureCapacity(position, length);
        byte[] dest = new byte[length];
        Array$.MODULE$.copy((Object)this.a(), this.offset + position, (Object)dest, 0, length);
        return dest;
    }

    @Override
    public void readBytes(int position, int length, byte[] dest, int destOffset) {
        this.ensureCapacity(position, length);
        Array$.MODULE$.copy((Object)this.a(), this.offset + position, (Object)dest, destOffset, length);
    }

    @Override
    public void readBytes(int position, int length, WriteBuffer dest, int destIndex) {
        this.ensureCapacity(position, length);
        dest.writeBytes(destIndex, this.a(), this.offset + position, length);
    }

    @Override
    public int writeByte(int position, byte v) {
        this.ensureCapacity(position, 1);
        int pos = this.offset + position;
        this.a()[pos] = v;
        return 1;
    }

    @Override
    public int writeBytes(int position, byte[] source, int sourceOffset, int length) {
        Predef$.MODULE$.require(source != null, ByteArrayBufferBase::writeBytes$$anonfun$1);
        Predef$.MODULE$.require(sourceOffset + length <= source.length, () -> ByteArrayBufferBase.writeBytes$$anonfun$2(source, sourceOffset, length));
        this.ensureCapacity(position, length);
        Array$.MODULE$.copy((Object)source, sourceOffset, (Object)this.a(), this.offset + position, length);
        return length;
    }

    @Override
    public int writeBytes(int position, ReadBuffer src, int srcPosition, int length) {
        Predef$.MODULE$.require(src != null, ByteArrayBufferBase::writeBytes$$anonfun$3);
        this.ensureCapacity(position, length);
        src.readBytes(srcPosition, length, this.a(), this.offset + position);
        return length;
    }

    @Override
    public int writeShort(int position, short v) {
        this.ensureCapacity(position, 2);
        int pos = this.offset + position;
        this.a()[pos] = (byte)((v & 0xFF00) >> 8);
        this.a()[pos + 1] = (byte)(v & 0xFF);
        return 2;
    }

    @Override
    public int writeInt(int position, int v) {
        this.ensureCapacity(position, 4);
        int pos = this.offset + position;
        this.a()[pos] = (byte)((v & 0xFF000000) >> 24);
        this.a()[pos + 1] = (byte)((v & 0xFF0000) >> 16);
        this.a()[pos + 2] = (byte)((v & 0xFF00) >> 8);
        this.a()[pos + 3] = (byte)(v & 0xFF);
        return 4;
    }

    @Override
    public int writeLong(int position, long v) {
        this.ensureCapacity(position, 8);
        int pos = this.offset + position;
        this.a()[pos] = (byte)((v & 0xFF00000000000000L) >> 56);
        this.a()[pos + 1] = (byte)((v & 0xFF000000000000L) >> 48);
        this.a()[pos + 2] = (byte)((v & 0xFF0000000000L) >> 40);
        this.a()[pos + 3] = (byte)((v & 0xFF00000000L) >> 32);
        this.a()[pos + 4] = (byte)((v & 0xFF000000L) >> 24);
        this.a()[pos + 5] = (byte)((v & 0xFF0000L) >> 16);
        this.a()[pos + 6] = (byte)((v & 0xFF00L) >> 8);
        this.a()[pos + 7] = (byte)(v & 0xFFL);
        return 8;
    }

    private static final Object $init$$$anonfun$1(int offset$2) {
        return new StringBuilder(15).append("baseOffset ").append(offset$2).append(" < 0").toString();
    }

    private final Object $init$$$anonfun$2(int offset$3) {
        return new StringBuilder(64).append("insufficient buffer size. baseOffset:").append(offset$3).append(" + capacity:").append(this.capacity()).append(" <= array size:").append(this.a().length).toString();
    }

    private final Object toByteArray$$anonfun$1(int position$1, int arraySize$1) {
        return new StringBuilder(58).append("Insufficient array length (").append(this.a().length).append(", offset:").append(this.offset).append(", size:").append(this.capacity()).append(") for slice(").append(position$1).append(", ").append(arraySize$1).append(")").toString();
    }

    private final Object slice$$anonfun$1(int position$2, int newSize$1) {
        return new StringBuilder(58).append("Insufficient array length (").append(this.a().length).append(", offset:").append(this.offset).append(", size:").append(this.size()).append(") for slice(").append(position$2).append(", ").append(newSize$1).append(")").toString();
    }

    private static final Object writeBytes$$anonfun$1() {
        return "source is null";
    }

    private static final Object writeBytes$$anonfun$2(byte[] source$1, int sourceOffset$1, int length$1) {
        return new StringBuilder(51).append("Insufficient input buffer size ").append(source$1.length).append(" for reading ").append(sourceOffset$1).append("+").append(length$1).append(" bytes").toString();
    }

    private static final Object writeBytes$$anonfun$3() {
        return "source is nul";
    }
}

