/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.msgpack.json;

import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import wvlet.airframe.json.JSONContext;
import wvlet.airframe.json.JSONSource;
import wvlet.airframe.msgpack.json.LocalStructureContext;
import wvlet.airframe.msgpack.json.NestedMessagePackBuilder$;
import wvlet.airframe.msgpack.spi.BufferPacker;
import wvlet.airframe.msgpack.spi.MessagePack$;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;

public class NestedMessagePackBuilder
implements JSONContext<Seq<byte[]>>,
LogSupport {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(NestedMessagePackBuilder.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private final BufferPacker packer = MessagePack$.MODULE$.newBufferPacker();
    private Option<Seq<byte[]>> cachedResult = None$.MODULE$;

    public static byte[] fromJSON(JSONSource jSONSource) {
        return NestedMessagePackBuilder$.MODULE$.fromJSON(jSONSource);
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public BufferPacker packer() {
        return this.packer;
    }

    public byte[] mergedResult() {
        Seq<byte[]> buffers = this.result();
        if (buffers.length() == 1) {
            return (byte[])buffers.head();
        }
        int size = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)buffers.map((Function1 & Serializable)_$1 -> ((byte[])_$1).length)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        byte[] result = new byte[size];
        IntRef offset = IntRef.create((int)0);
        buffers.foreach((Function1)(JProcedure1 & Serializable)x -> {
            int n;
            Array$.MODULE$.copy(x, 0, (Object)result, offset$1.elem, ((byte[])x).length);
            offset$1.elem = n = offset$1.elem + ((byte[])x).length;
        });
        return result;
    }

    public Seq<byte[]> result() {
        Seq seq;
        NestedMessagePackBuilder nestedMessagePackBuilder = this;
        synchronized (nestedMessagePackBuilder) {
            if (this.cachedResult.isEmpty()) {
                this.cachedResult = Some$.MODULE$.apply((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new byte[][]{this.packer().toByteArray()})));
            }
            seq = (Seq)this.cachedResult.get();
        }
        return seq;
    }

    public boolean isObjectContext() {
        return false;
    }

    public void add(Seq<byte[]> v) {
        v.foreach((Function1 & Serializable)b -> (BufferPacker)this.packer().writePayload((byte[])b));
    }

    public void closeContext(JSONSource s, int end) {
    }

    public void addNull(JSONSource s, int start, int end) {
        this.packer().packNil();
    }

    public void addString(JSONSource s, int start, int end) {
        this.packer().packString(s.substring(start, end));
    }

    public void addUnescapedString(String s) {
        this.packer().packString(s);
    }

    public void addNumber(JSONSource s, int start, int end, int dotIndex, int expIndex) {
        String v = s.substring(start, end);
        if (dotIndex >= 0 || expIndex >= 0) {
            this.packer().packDouble(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(v)));
            return;
        }
        Try try_ = Try$.MODULE$.apply(() -> NestedMessagePackBuilder.addNumber$$anonfun$1(v));
        if (try_ instanceof Success) {
            long l = BoxesRunTime.unboxToLong((Object)((Success)try_).value());
            this.packer().packLong(l);
            return;
        }
        this.packer().packString(v);
    }

    public void addBoolean(JSONSource s, boolean v, int start, int end) {
        this.packer().packBoolean(v);
    }

    public JSONContext<Seq<byte[]>> singleContext(JSONSource s, int start) {
        return new LocalStructureContext();
    }

    public JSONContext<Seq<byte[]>> objectContext(JSONSource s, int start) {
        return new LocalStructureContext(this){
            private final /* synthetic */ NestedMessagePackBuilder $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public boolean isObjectContext() {
                return true;
            }

            public void closeContext(JSONSource s, int end) {
                this.$outer.add((Seq<byte[]>)this.result());
            }

            public Seq result() {
                int mapElementCount = this.getElementCount() / 2;
                return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new byte[][]{((BufferPacker)MessagePack$.MODULE$.newBufferPacker().packMapHeader(mapElementCount)).toByteArray(), this.packer().toByteArray()}));
            }
        };
    }

    public JSONContext<Seq<byte[]>> arrayContext(JSONSource s, int start) {
        return new LocalStructureContext(this){
            private final /* synthetic */ NestedMessagePackBuilder $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void closeContext(JSONSource s, int end) {
                this.$outer.add((Seq<byte[]>)this.result());
            }

            public Seq result() {
                return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new byte[][]{((BufferPacker)MessagePack$.MODULE$.newBufferPacker().packArrayHeader(this.getElementCount())).toByteArray(), this.packer().toByteArray()}));
            }
        };
    }

    private static final long addNumber$$anonfun$1(String v$1) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(v$1));
    }
}

