/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.msgpack.json;

import scala.Array$;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import wvlet.airframe.json.JSONContext;
import wvlet.airframe.json.JSONSource;
import wvlet.airframe.msgpack.io.ByteArrayBuffer;
import wvlet.airframe.msgpack.io.ByteArrayBuffer$;
import wvlet.airframe.msgpack.json.StreamMessagePackBuilder$;
import wvlet.airframe.msgpack.spi.BufferPacker;
import wvlet.airframe.msgpack.spi.MessagePack$;
import wvlet.airframe.msgpack.spi.OffsetPacker$;
import wvlet.airframe.msgpack.spi.WriteCursor;
import wvlet.airframe.msgpack.spi.WriteCursor$;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;

public class StreamMessagePackBuilder
implements JSONContext<byte[]>,
LogSupport {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(StreamMessagePackBuilder.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private final BufferPacker packer = MessagePack$.MODULE$.newBufferPacker();
    private List contextStack = package$.MODULE$.Nil();
    private List finishedContextStack = package$.MODULE$.Nil();
    private ParseContext context = new SingleContext();

    public static byte[] fromJSON(JSONSource jSONSource) {
        return StreamMessagePackBuilder$.MODULE$.fromJSON(jSONSource);
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public BufferPacker packer() {
        return this.packer;
    }

    public List<ParseContext> contextStack() {
        return this.contextStack;
    }

    public void contextStack_$eq(List<ParseContext> x$1) {
        this.contextStack = x$1;
    }

    public List<ParseContext> finishedContextStack() {
        return this.finishedContextStack;
    }

    public void finishedContextStack_$eq(List<ParseContext> x$1) {
        this.finishedContextStack = x$1;
    }

    public ParseContext context() {
        return this.context;
    }

    public void context_$eq(ParseContext x$1) {
        this.context = x$1;
    }

    public void addNull(JSONSource s, int start, int end) {
        this.context().increment();
        this.packer().packNil();
    }

    public void addString(JSONSource s, int start, int end) {
        this.context().increment();
        this.packer().packString(s.substring(start, end));
    }

    public void addUnescapedString(String s) {
        this.context().increment();
        this.packer().packString(s);
    }

    public void addNumber(JSONSource s, int start, int end, int dotIndex, int expIndex) {
        this.context().increment();
        String v = s.substring(start, end);
        if (dotIndex >= 0 || expIndex >= 0) {
            this.packer().packDouble(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(v)));
            return;
        }
        Try try_ = Try$.MODULE$.apply(() -> StreamMessagePackBuilder.addNumber$$anonfun$1(v));
        if (try_ instanceof Success) {
            long l = BoxesRunTime.unboxToLong((Object)((Success)try_).value());
            this.packer().packLong(l);
            return;
        }
        this.packer().packString(v);
    }

    public void addBoolean(JSONSource s, boolean v, int start, int end) {
        this.context().increment();
        this.packer().packBoolean(v);
    }

    private void addContext(ParseContext newContext) {
        ParseContext parseContext = this.context();
        this.contextStack_$eq((List<ParseContext>)this.contextStack().$colon$colon((Object)parseContext));
        this.context_$eq(newContext);
    }

    public void add(byte[] v) {
    }

    public boolean isObjectContext() {
        return this.context().isObject();
    }

    public byte[] result() {
        if (this.contextStack().length() > 1) {
            return Array$.MODULE$.emptyByteArray();
        }
        byte[] src = this.packer().toByteArray();
        ByteArrayBuffer buf = ByteArrayBuffer$.MODULE$.apply(src);
        WriteCursor cursor = WriteCursor$.MODULE$.apply(buf, 0);
        StreamMessagePackBuilder.loop$1(cursor, this.finishedContextStack());
        return src;
    }

    public void closeContext(JSONSource s, int end) {
        long currentOffset = this.packer().totalByteSize();
        ParseContext parseContext = this.context();
        this.finishedContextStack_$eq((List<ParseContext>)this.finishedContextStack().$colon$colon((Object)parseContext));
        this.context_$eq((ParseContext)this.contextStack().head());
        this.contextStack_$eq((List<ParseContext>)((List)this.contextStack().tail()));
    }

    public JSONContext<byte[]> singleContext(JSONSource s, int start) {
        return this;
    }

    public JSONContext<byte[]> objectContext(JSONSource s, int start) {
        this.context().increment();
        this.addContext(new ObjectContext(this.packer().totalByteSize()));
        this.packer().writePayload(StreamMessagePackBuilder$.wvlet$airframe$msgpack$json$StreamMessagePackBuilder$$$collectionPlaceHolder);
        return this;
    }

    public JSONContext<byte[]> arrayContext(JSONSource s, int start) {
        this.context().increment();
        this.addContext(new ArrayContext(this.packer().totalByteSize()));
        this.packer().writePayload(StreamMessagePackBuilder$.wvlet$airframe$msgpack$json$StreamMessagePackBuilder$$$collectionPlaceHolder);
        return this;
    }

    private static final long addNumber$$anonfun$1(String v$1) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(v$1));
    }

    private static final void loop$1(WriteCursor cursor$1, List stack) {
        List list;
        while (true) {
            list = stack;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                return;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            ParseContext c = (ParseContext)colon2.head();
            List remainings = list3;
            ParseContext parseContext = c;
            if (parseContext instanceof ObjectContext) {
                ObjectContext o = (ObjectContext)parseContext;
                int numMapElements = o.numElements() / 2;
                cursor$1.setOffset((int)o.offset());
                OffsetPacker$.MODULE$.packMap32Header(cursor$1, numMapElements);
            } else if (parseContext instanceof ArrayContext) {
                ArrayContext a = (ArrayContext)parseContext;
                int numArrayElements = a.numElements();
                cursor$1.setOffset((int)a.offset());
                OffsetPacker$.MODULE$.packArray32Header(cursor$1, numArrayElements);
            } else if (parseContext instanceof SingleContext) {
                SingleContext s = (SingleContext)parseContext;
            } else {
                throw new MatchError((Object)parseContext);
            }
            stack = remainings;
        }
        throw new MatchError((Object)list);
    }

    public static class ArrayContext
    extends ParseContext {
        public ArrayContext(long offset) {
            super(offset);
        }

        private long offset$accessor() {
            return super.offset();
        }
    }

    public static class ObjectContext
    extends ParseContext {
        public ObjectContext(long offset) {
            super(offset);
        }

        private long offset$accessor() {
            return super.offset();
        }

        @Override
        public boolean isObject() {
            return true;
        }
    }

    public static abstract class ParseContext {
        private final long offset;
        private int elementCount;

        public ParseContext(long offset) {
            this.offset = offset;
            this.elementCount = 0;
        }

        public long offset() {
            return this.offset;
        }

        public boolean isObject() {
            return false;
        }

        public void increment() {
            ++this.elementCount;
        }

        public int numElements() {
            return this.elementCount;
        }
    }

    public static class SingleContext
    extends ParseContext {
        public SingleContext() {
            super(0L);
        }
    }
}

