/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.msgpack.spi;

import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import wvlet.airframe.msgpack.spi.Code$;
import wvlet.airframe.msgpack.spi.ExtTypeHeader;
import wvlet.airframe.msgpack.spi.Value;
import wvlet.airframe.msgpack.spi.Value$ArrayValue$;
import wvlet.airframe.msgpack.spi.Value$BigIntegerValue$;
import wvlet.airframe.msgpack.spi.Value$BinaryValue$;
import wvlet.airframe.msgpack.spi.Value$BooleanValue$;
import wvlet.airframe.msgpack.spi.Value$DoubleValue$;
import wvlet.airframe.msgpack.spi.Value$ExtensionValue$;
import wvlet.airframe.msgpack.spi.Value$LongValue$;
import wvlet.airframe.msgpack.spi.Value$MapValue$;
import wvlet.airframe.msgpack.spi.Value$NilValue$;
import wvlet.airframe.msgpack.spi.Value$StringValue$;
import wvlet.airframe.msgpack.spi.Value$TimestampValue$;
import wvlet.airframe.msgpack.spi.WriteCursor;

public final class OffsetPacker$
implements Serializable {
    private static final long NANOS_PER_SECOND;
    public static final OffsetPacker$ MODULE$;

    private OffsetPacker$() {
    }

    static {
        MODULE$ = new OffsetPacker$();
        NANOS_PER_SECOND = 1000000000L;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(OffsetPacker$.class);
    }

    public void packValue(WriteCursor cursor, Value v) {
        Value value = v;
        if (Value$NilValue$.MODULE$.equals(value)) {
            this.packNil(cursor);
            return;
        }
        if (value instanceof Value.BooleanValue) {
            boolean bl;
            Value.BooleanValue booleanValue = Value$BooleanValue$.MODULE$.unapply((Value.BooleanValue)value);
            boolean v2 = bl = booleanValue._1();
            this.packBoolean(cursor, v2);
            return;
        }
        if (value instanceof Value.LongValue) {
            long l;
            Value.LongValue longValue = Value$LongValue$.MODULE$.unapply((Value.LongValue)value);
            long v3 = l = longValue._1();
            this.packLong(cursor, v3);
            return;
        }
        if (value instanceof Value.BigIntegerValue) {
            BigInteger bigInteger;
            Value.BigIntegerValue bigIntegerValue = Value$BigIntegerValue$.MODULE$.unapply((Value.BigIntegerValue)value);
            BigInteger v4 = bigInteger = bigIntegerValue._1();
            this.packBigInteger(cursor, v4);
            return;
        }
        if (value instanceof Value.DoubleValue) {
            double d;
            Value.DoubleValue doubleValue = Value$DoubleValue$.MODULE$.unapply((Value.DoubleValue)value);
            double v5 = d = doubleValue._1();
            this.packDouble(cursor, v5);
            return;
        }
        if (value instanceof Value.StringValue) {
            String string;
            Value.StringValue stringValue = Value$StringValue$.MODULE$.unapply((Value.StringValue)value);
            String v6 = string = stringValue._1();
            this.packString(cursor, v6);
            return;
        }
        if (value instanceof Value.BinaryValue) {
            byte[] byArray;
            Value.BinaryValue binaryValue = Value$BinaryValue$.MODULE$.unapply((Value.BinaryValue)value);
            byte[] v7 = byArray = binaryValue._1();
            this.packBinaryHeader(cursor, v7.length);
            this.writePayload(cursor, v7);
            return;
        }
        if (value instanceof Value.ExtensionValue) {
            Value.ExtensionValue extensionValue = Value$ExtensionValue$.MODULE$.unapply((Value.ExtensionValue)value);
            byte by = extensionValue._1();
            byte[] byArray = extensionValue._2();
            byte extType = by;
            byte[] v8 = byArray;
            this.packExtTypeHeader(cursor, extType, v8.length);
            this.writePayload(cursor, v8);
            return;
        }
        if (value instanceof Value.TimestampValue) {
            Instant instant;
            Value.TimestampValue timestampValue = Value$TimestampValue$.MODULE$.unapply((Value.TimestampValue)value);
            Instant v9 = instant = timestampValue._1();
            this.packTimestamp(cursor, v9);
            return;
        }
        if (value instanceof Value.ArrayValue) {
            IndexedSeq<Value> indexedSeq;
            Value.ArrayValue arrayValue = (Value.ArrayValue)value;
            Value.ArrayValue arrayValue2 = Value$ArrayValue$.MODULE$.unapply(arrayValue);
            IndexedSeq<Value> elems = indexedSeq = arrayValue2._1();
            Value.ArrayValue a = arrayValue;
            this.packArrayHeader(cursor, a.size());
            elems.foreach((Function1)(JProcedure1 & Serializable)_$1 -> this.packValue(cursor, (Value)_$1));
            return;
        }
        if (value instanceof Value.MapValue) {
            Map<Value, Value> map;
            Value.MapValue mapValue = (Value.MapValue)value;
            Value.MapValue mapValue2 = Value$MapValue$.MODULE$.unapply(mapValue);
            Map<Value, Value> entries = map = mapValue2._1();
            Value.MapValue m = mapValue;
            this.packMapHeader(cursor, m.size());
            entries.toIndexedSeq().foreach((Function1)(JProcedure1 & Serializable)x -> {
                this.packValue(cursor, (Value)x._1());
                this.packValue(cursor, (Value)x._2());
            });
            return;
        }
        throw new MatchError((Object)value);
    }

    public void packNil(WriteCursor cursor) {
        cursor.writeByte(Code$.MODULE$.NIL());
    }

    public void packBoolean(WriteCursor cursor, boolean v) {
        cursor.writeByte(v ? Code$.MODULE$.TRUE() : Code$.MODULE$.FALSE());
    }

    public void packFIXNUM(WriteCursor cursor, byte v) {
        cursor.writeByte(v);
    }

    public void packINT8(WriteCursor cursor, byte v) {
        cursor.writeByteAndByte(Code$.MODULE$.INT8(), v);
    }

    public void packINT16(WriteCursor cursor, short v) {
        cursor.writeByteAndShort(Code$.MODULE$.INT16(), v);
    }

    public void packINT32(WriteCursor cursor, int v) {
        cursor.writeByteAndInt(Code$.MODULE$.INT32(), v);
    }

    public void packINT64(WriteCursor cursor, long v) {
        cursor.writeByteAndLong(Code$.MODULE$.INT64(), v);
    }

    public void packUINT8(WriteCursor cursor, byte v) {
        cursor.writeByteAndByte(Code$.MODULE$.UINT8(), v);
    }

    public void packUINT16(WriteCursor cursor, short v) {
        cursor.writeByteAndShort(Code$.MODULE$.UINT16(), v);
    }

    public void packUINT32(WriteCursor cursor, int v) {
        cursor.writeByteAndInt(Code$.MODULE$.UINT32(), v);
    }

    public void packUINT64(WriteCursor cursor, long v) {
        cursor.writeByteAndLong(Code$.MODULE$.UINT64(), v);
    }

    public void packFLOAT32(WriteCursor cursor, float v) {
        cursor.writeByteAndFloat(Code$.MODULE$.FLOAT32(), v);
    }

    public void packFLOAT64(WriteCursor cursor, double v) {
        cursor.writeByteAndDouble(Code$.MODULE$.FLOAT64(), v);
    }

    public void packByte(WriteCursor cursor, byte v) {
        if (v < -32) {
            this.packINT8(cursor, v);
            return;
        }
        this.packFIXNUM(cursor, v);
    }

    public void packShort(WriteCursor cursor, short v) {
        if (v < -32) {
            if (v < -128) {
                this.packINT16(cursor, v);
                return;
            }
            this.packINT8(cursor, (byte)v);
            return;
        }
        if (v < 128) {
            cursor.writeByte((byte)v);
            return;
        }
        if (v < 256) {
            this.packUINT8(cursor, (byte)v);
            return;
        }
        this.packUINT16(cursor, v);
    }

    public void packInt(WriteCursor cursor, int r) {
        if (r < -32) {
            if (r < Short.MIN_VALUE) {
                this.packINT32(cursor, r);
                return;
            }
            if (r < -128) {
                this.packINT16(cursor, (short)r);
                return;
            }
            this.packINT8(cursor, (byte)r);
            return;
        }
        if (r < 128) {
            this.packFIXNUM(cursor, (byte)r);
            return;
        }
        if (r < 256) {
            this.packUINT8(cursor, (byte)r);
            return;
        }
        if (r < 65536) {
            this.packUINT16(cursor, (short)r);
            return;
        }
        this.packUINT32(cursor, r);
    }

    public void packLong(WriteCursor cursor, long v) {
        if (v < -32L) {
            if (v < -32768L) {
                if (v < Integer.MIN_VALUE) {
                    this.packINT64(cursor, v);
                    return;
                }
                this.packINT32(cursor, (int)v);
                return;
            }
            if (v < -128L) {
                this.packINT16(cursor, (short)v);
                return;
            }
            this.packINT8(cursor, (byte)v);
            return;
        }
        if (v < 128L) {
            this.packFIXNUM(cursor, (byte)v);
            return;
        }
        if (v < 65536L) {
            if (v < 256L) {
                this.packUINT8(cursor, (byte)v);
                return;
            }
            this.packUINT16(cursor, (short)v);
            return;
        }
        if (v < 0x100000000L) {
            this.packUINT32(cursor, (int)v);
            return;
        }
        this.packUINT64(cursor, v);
    }

    public void packBigInteger(WriteCursor cursor, BigInteger bi) {
        if (bi.bitLength() <= 63) {
            this.packLong(cursor, bi.longValue());
            return;
        }
        if (bi.bitLength() == 64 && bi.signum() == 1) {
            this.packUINT64(cursor, bi.longValue());
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(60).append("MessagePack cannot serialize BigInteger larger than 2^64-1: ").append(bi).toString());
    }

    public void packFloat(WriteCursor cursor, float v) {
        this.packFLOAT32(cursor, v);
    }

    public void packDouble(WriteCursor cursor, double v) {
        this.packFLOAT64(cursor, v);
    }

    public void packString(WriteCursor cursor, String s) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        this.packRawStringHeader(cursor, bytes.length);
        this.writePayload(cursor, bytes);
    }

    public void packTimestamp(WriteCursor cursor, Instant v) {
        this.packTimestampEpochSecond(cursor, v.getEpochSecond(), v.getNano());
    }

    public void packTimestampEpochSecond(WriteCursor cursor, long epochSecond, int nanoAdjustment) {
        long sec = Math.addExact(epochSecond, Math.floorDiv(Int$.MODULE$.int2long(nanoAdjustment), NANOS_PER_SECOND));
        long nsec = Math.floorMod((long)nanoAdjustment, NANOS_PER_SECOND);
        if (sec >>> 34 == 0L) {
            long data64 = nsec << 34 | sec;
            if ((data64 & 0xFFFFFFFF00000000L) == 0L) {
                this.packTimestamp32(cursor, (int)sec);
                return;
            }
            this.packTimestamp64(cursor, data64);
            return;
        }
        this.packTimestamp96(cursor, sec, (int)nsec);
    }

    public void packTimestamp32(WriteCursor cursor, int sec) {
        cursor.ensureCapacity(6);
        cursor.writeByte(Code$.MODULE$.FIXEXT4());
        cursor.writeByte(Code$.MODULE$.EXT_TIMESTAMP());
        cursor.writeInt(sec);
    }

    public void packTimestamp64(WriteCursor cursor, long data64) {
        cursor.ensureCapacity(10);
        cursor.writeByte(Code$.MODULE$.FIXEXT8());
        cursor.writeByte(Code$.MODULE$.EXT_TIMESTAMP());
        cursor.writeLong(data64);
    }

    public void packTimestamp96(WriteCursor cursor, long sec, int nsec) {
        cursor.ensureCapacity(15);
        cursor.writeByte(Code$.MODULE$.EXT8());
        cursor.writeByte((byte)12);
        cursor.writeByte(Code$.MODULE$.EXT_TIMESTAMP());
        cursor.writeInt(nsec);
        cursor.writeLong(sec);
    }

    public void packRawStringHeader(WriteCursor cursor, int len) {
        if (len < 32) {
            cursor.writeByte((byte)(Code$.MODULE$.FIXSTR_PREFIX() | len));
            return;
        }
        if (len < 256) {
            cursor.writeByteAndByte(Code$.MODULE$.STR8(), (byte)len);
            return;
        }
        if (len < 65536) {
            cursor.writeByteAndShort(Code$.MODULE$.STR16(), (short)len);
            return;
        }
        cursor.writeByteAndInt(Code$.MODULE$.STR32(), len);
    }

    public void packArrayHeader(WriteCursor cursor, int arraySize) {
        if (arraySize < 0) {
            throw new IllegalArgumentException("array size must be >= 0");
        }
        if (arraySize < 16) {
            cursor.writeByte((byte)(Code$.MODULE$.FIXARRAY_PREFIX() | arraySize));
            return;
        }
        if (arraySize < 65536) {
            cursor.writeByteAndShort(Code$.MODULE$.ARRAY16(), (short)arraySize);
            return;
        }
        cursor.writeByteAndInt(Code$.MODULE$.ARRAY32(), arraySize);
    }

    public void packArray32Header(WriteCursor cursor, int arraySize) {
        cursor.writeByteAndInt(Code$.MODULE$.ARRAY32(), arraySize);
    }

    public void packMapHeader(WriteCursor cursor, int mapSize) {
        if (mapSize < 0) {
            throw new IllegalArgumentException("map size must be >= 0");
        }
        if (mapSize < 16) {
            cursor.writeByte((byte)(Code$.MODULE$.FIXMAP_PREFIX() | mapSize));
            return;
        }
        if (mapSize < 65536) {
            cursor.writeByteAndShort(Code$.MODULE$.MAP16(), (short)mapSize);
            return;
        }
        cursor.writeByteAndInt(Code$.MODULE$.MAP32(), mapSize);
    }

    public void packMap32Header(WriteCursor cursor, int mapSize) {
        cursor.writeByteAndInt(Code$.MODULE$.MAP32(), mapSize);
    }

    public void packExtTypeHeader(WriteCursor cursor, ExtTypeHeader extTypeHeader) {
        this.packExtTypeHeader(cursor, extTypeHeader.extType(), extTypeHeader.byteLength());
    }

    public void packExtTypeHeader(WriteCursor cursor, byte extType, int payloadLen) {
        if (payloadLen < 256) {
            if (payloadLen > 0 && (payloadLen & payloadLen - 1) == 0) {
                if (payloadLen == 1) {
                    cursor.writeByteAndByte(Code$.MODULE$.FIXEXT1(), extType);
                    return;
                }
                if (payloadLen == 2) {
                    cursor.writeByteAndByte(Code$.MODULE$.FIXEXT2(), extType);
                    return;
                }
                if (payloadLen == 4) {
                    cursor.writeByteAndByte(Code$.MODULE$.FIXEXT4(), extType);
                    return;
                }
                if (payloadLen == 8) {
                    cursor.writeByteAndByte(Code$.MODULE$.FIXEXT8(), extType);
                    return;
                }
                if (payloadLen == 16) {
                    cursor.writeByteAndByte(Code$.MODULE$.FIXEXT16(), extType);
                    return;
                }
                cursor.writeByteAndByte(Code$.MODULE$.EXT8(), (byte)payloadLen);
                cursor.writeByte(extType);
                return;
            }
            cursor.writeByteAndByte(Code$.MODULE$.EXT8(), (byte)payloadLen);
            cursor.writeByte(extType);
            return;
        }
        if (payloadLen < 65536) {
            cursor.writeByteAndShort(Code$.MODULE$.EXT16(), (short)payloadLen);
            cursor.writeByte(extType);
            return;
        }
        cursor.writeByteAndInt(Code$.MODULE$.EXT32(), payloadLen);
        cursor.writeByte(extType);
    }

    public void packBinaryHeader(WriteCursor cursor, int len) {
        if (len < 256) {
            cursor.writeByteAndByte(Code$.MODULE$.BIN8(), (byte)len);
            return;
        }
        if (len < 65536) {
            cursor.writeByteAndShort(Code$.MODULE$.BIN16(), (short)len);
            return;
        }
        cursor.writeByteAndInt(Code$.MODULE$.BIN32(), len);
    }

    public void writePayload(WriteCursor cursor, byte[] v) {
        cursor.writeBytes(v);
    }

    public void writePayload(WriteCursor cursor, byte[] v, int vOffset, int length) {
        cursor.writeBytes(v, vOffset, length);
    }
}

