/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.msgpack.spi;

import java.io.Serializable;
import scala.Product;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import wvlet.airframe.msgpack.spi.ReadBuffer;
import wvlet.airframe.msgpack.spi.ReadCursor$;
import wvlet.airframe.msgpack.spi.WriteBuffer;

public class ReadCursor
implements Product,
Serializable {
    private ReadBuffer buf;
    private int position;
    private int offset;

    public static ReadCursor apply(ReadBuffer readBuffer, int n) {
        return ReadCursor$.MODULE$.apply(readBuffer, n);
    }

    public static ReadCursor fromProduct(Product product) {
        return ReadCursor$.MODULE$.fromProduct(product);
    }

    public static ReadCursor unapply(ReadCursor readCursor) {
        return ReadCursor$.MODULE$.unapply(readCursor);
    }

    public ReadCursor(ReadBuffer buf, int position) {
        this.buf = buf;
        this.position = position;
        this.offset = 0;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.buf()));
        n = Statics.mix((int)n, (int)this.position());
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ReadCursor)) return false;
        ReadCursor readCursor = (ReadCursor)object;
        if (this.position() != readCursor.position()) return false;
        ReadBuffer readBuffer = this.buf();
        ReadBuffer readBuffer2 = readCursor.buf();
        if (readBuffer == null) {
            if (readBuffer2 != null) {
                return false;
            }
        } else if (!readBuffer.equals(readBuffer2)) return false;
        if (!readCursor.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ReadCursor;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "ReadCursor";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return BoxesRunTime.boxToInteger((int)this._2());
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "buf";
        }
        if (1 == n2) {
            return "position";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ReadBuffer buf() {
        return this.buf;
    }

    public void buf_$eq(ReadBuffer x$1) {
        this.buf = x$1;
    }

    public int position() {
        return this.position;
    }

    public void position_$eq(int x$1) {
        this.position = x$1;
    }

    public int lastReadLength() {
        return this.offset;
    }

    public void reverseCursor() {
        --this.offset;
    }

    public int proceedCursor() {
        int diff = this.offset;
        this.position_$eq(this.position() + diff);
        this.offset = 0;
        return diff;
    }

    public void skipBytes(int n) {
        this.offset += n;
    }

    public byte peekByte() {
        return this.buf().readByte(this.position() + this.offset);
    }

    public byte readByte() {
        byte v = this.buf().readByte(this.position() + this.offset);
        ++this.offset;
        return v;
    }

    public short readShort() {
        short v = this.buf().readShort(this.position() + this.offset);
        this.offset += 2;
        return v;
    }

    public int readInt() {
        int v = this.buf().readInt(this.position() + this.offset);
        this.offset += 4;
        return v;
    }

    public long readLong() {
        long v = this.buf().readLong(this.position() + this.offset);
        this.offset += 8;
        return v;
    }

    public float readFloat() {
        float v = this.buf().readFloat(this.position() + this.offset);
        this.offset += 4;
        return v;
    }

    public double readDouble() {
        double v = this.buf().readDouble(this.position() + this.offset);
        this.offset += 8;
        return v;
    }

    public byte[] readBytes(int len) {
        byte[] v = this.buf().readBytes(this.position() + this.offset, len);
        this.offset += len;
        return v;
    }

    public void readBytes(int len, byte[] dest, int destOffset) {
        this.buf().readBytes(this.position() + this.offset, len, dest, destOffset);
        BoxedUnit v = BoxedUnit.UNIT;
        this.offset += len;
    }

    public void readBytes(int len, WriteBuffer dest, int destOffset) {
        this.buf().readBytes(this.position() + this.offset, len, dest, destOffset);
        this.offset += len;
    }

    public ReadCursor copy(ReadBuffer buf, int position) {
        return new ReadCursor(buf, position);
    }

    public ReadBuffer copy$default$1() {
        return this.buf();
    }

    public int copy$default$2() {
        return this.position();
    }

    public ReadBuffer _1() {
        return this.buf();
    }

    public int _2() {
        return this.position();
    }
}

