/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.msgpack.spi;

import java.io.Serializable;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import wvlet.airframe.msgpack.spi.BufferPacker;
import wvlet.airframe.msgpack.spi.MessageException$;
import wvlet.airframe.msgpack.spi.MessageFormat;
import wvlet.airframe.msgpack.spi.MessageFormat$INT16$;
import wvlet.airframe.msgpack.spi.MessageFormat$INT32$;
import wvlet.airframe.msgpack.spi.MessageFormat$INT64$;
import wvlet.airframe.msgpack.spi.MessageFormat$INT8$;
import wvlet.airframe.msgpack.spi.MessageFormat$UINT64$;
import wvlet.airframe.msgpack.spi.MessagePack$;
import wvlet.airframe.msgpack.spi.Packer;
import wvlet.airframe.msgpack.spi.Value$;
import wvlet.airframe.msgpack.spi.Value$ArrayValue$;
import wvlet.airframe.msgpack.spi.Value$BigIntegerValue$;
import wvlet.airframe.msgpack.spi.Value$BinaryValue$;
import wvlet.airframe.msgpack.spi.Value$BooleanValue$;
import wvlet.airframe.msgpack.spi.Value$DoubleValue$;
import wvlet.airframe.msgpack.spi.Value$ExtensionValue$;
import wvlet.airframe.msgpack.spi.Value$LongValue$;
import wvlet.airframe.msgpack.spi.Value$MapValue$;
import wvlet.airframe.msgpack.spi.Value$StringValue$;
import wvlet.airframe.msgpack.spi.Value$TimestampValue$;
import wvlet.airframe.msgpack.spi.ValueType;
import wvlet.airframe.msgpack.spi.ValueType$ARRAY$;
import wvlet.airframe.msgpack.spi.ValueType$BINARY$;
import wvlet.airframe.msgpack.spi.ValueType$BOOLEAN$;
import wvlet.airframe.msgpack.spi.ValueType$EXTENSION$;
import wvlet.airframe.msgpack.spi.ValueType$FLOAT$;
import wvlet.airframe.msgpack.spi.ValueType$INTEGER$;
import wvlet.airframe.msgpack.spi.ValueType$MAP$;
import wvlet.airframe.msgpack.spi.ValueType$STRING$;

public interface Value {
    public static void appendJsonString(StringBuilder stringBuilder, String string) {
        Value$.MODULE$.appendJsonString(stringBuilder, string);
    }

    public static void escapeChar(StringBuilder stringBuilder, int n) {
        Value$.MODULE$.escapeChar(stringBuilder, n);
    }

    public static String toString$(Value $this) {
        return $this.toString();
    }

    default public String toString() {
        return this.toJson();
    }

    public String toJson();

    public ValueType valueType();

    public void writeTo(Packer var1);

    public static byte[] toMsgpack$(Value $this) {
        return $this.toMsgpack();
    }

    default public byte[] toMsgpack() {
        BufferPacker p = MessagePack$.MODULE$.newBufferPacker();
        this.writeTo(p);
        return p.toByteArray();
    }

    public static class ArrayValue
    implements Value,
    Product,
    Serializable {
        private final IndexedSeq elems;

        public static ArrayValue fromProduct(Product product) {
            return Value$ArrayValue$.MODULE$.fromProduct(product);
        }

        public static ArrayValue unapply(ArrayValue arrayValue) {
            return Value$ArrayValue$.MODULE$.unapply(arrayValue);
        }

        public ArrayValue(IndexedSeq<Value> elems) {
            this.elems = elems;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ArrayValue)) return false;
            ArrayValue arrayValue = (ArrayValue)object;
            IndexedSeq<Value> indexedSeq = this.elems();
            IndexedSeq<Value> indexedSeq2 = arrayValue.elems();
            if (indexedSeq == null) {
                if (indexedSeq2 != null) {
                    return false;
                }
            } else if (!indexedSeq.equals(indexedSeq2)) return false;
            if (!arrayValue.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof ArrayValue;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ArrayValue";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "elems";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public IndexedSeq<Value> elems() {
            return this.elems;
        }

        public Value apply(int i) {
            return (Value)this.elems().apply(i);
        }

        public int size() {
            return this.elems().size();
        }

        public boolean isEmpty() {
            return this.elems().isEmpty();
        }

        public boolean nonEmpty() {
            return this.elems().nonEmpty();
        }

        @Override
        public String toJson() {
            return new java.lang.StringBuilder(2).append("[").append(((IterableOnceOps)this.elems().map((Function1 & Serializable)_$1 -> _$1.toJson())).mkString(",")).append("]").toString();
        }

        @Override
        public ValueType valueType() {
            return ValueType$ARRAY$.MODULE$;
        }

        @Override
        public void writeTo(Packer packer) {
            packer.packArrayHeader(this.elems().length());
            this.elems().foreach((Function1)(JProcedure1 & Serializable)x -> x.writeTo(packer));
        }

        public ArrayValue copy(IndexedSeq<Value> elems) {
            return new ArrayValue(elems);
        }

        public IndexedSeq<Value> copy$default$1() {
            return this.elems();
        }

        public IndexedSeq<Value> _1() {
            return this.elems();
        }
    }

    public static class BigIntegerValue
    implements Value,
    IntegerValue,
    Product,
    Serializable {
        private final BigInteger v;

        public static BigIntegerValue apply(BigInteger bigInteger) {
            return Value$BigIntegerValue$.MODULE$.apply(bigInteger);
        }

        public static BigIntegerValue fromProduct(Product product) {
            return Value$BigIntegerValue$.MODULE$.fromProduct(product);
        }

        public static BigIntegerValue unapply(BigIntegerValue bigIntegerValue) {
            return Value$BigIntegerValue$.MODULE$.unapply(bigIntegerValue);
        }

        public BigIntegerValue(BigInteger v) {
            this.v = v;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BigIntegerValue)) return false;
            BigIntegerValue bigIntegerValue = (BigIntegerValue)object;
            if (!BoxesRunTime.equals((Object)this.v(), (Object)bigIntegerValue.v())) return false;
            if (!bigIntegerValue.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof BigIntegerValue;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "BigIntegerValue";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "v";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public BigInteger v() {
            return this.v;
        }

        @Override
        public String toJson() {
            return this.v().toString();
        }

        private boolean within(BigInteger min, BigInteger max) {
            return this.v().compareTo(min) >= 0 && this.v().compareTo(max) <= 0;
        }

        @Override
        public boolean isValidByte() {
            return this.within(Value$.wvlet$airframe$msgpack$spi$Value$$$BYTE_MIN, Value$.wvlet$airframe$msgpack$spi$Value$$$BYTE_MAX);
        }

        @Override
        public boolean isValidShort() {
            return this.within(Value$.wvlet$airframe$msgpack$spi$Value$$$SHORT_MIN, Value$.wvlet$airframe$msgpack$spi$Value$$$SHORT_MAX);
        }

        @Override
        public boolean isValidInt() {
            return this.within(Value$.wvlet$airframe$msgpack$spi$Value$$$INT_MIN, Value$.wvlet$airframe$msgpack$spi$Value$$$INT_MAX);
        }

        @Override
        public boolean isValidLong() {
            return this.within(Value$.wvlet$airframe$msgpack$spi$Value$$$LONG_MIN, Value$.wvlet$airframe$msgpack$spi$Value$$$LONG_MAX);
        }

        public byte asByte() {
            if (this.isValidByte()) {
                return this.v().byteValue();
            }
            throw MessageException$.MODULE$.overflow(this.v());
        }

        public short asShort() {
            if (this.isValidShort()) {
                return this.v().shortValue();
            }
            throw MessageException$.MODULE$.overflow(this.v());
        }

        public int asInt() {
            if (this.isValidInt()) {
                return this.v().intValue();
            }
            throw MessageException$.MODULE$.overflow(this.v());
        }

        public long asLong() {
            if (this.isValidLong()) {
                return this.v().longValue();
            }
            throw MessageException$.MODULE$.overflow(this.v());
        }

        public BigInteger asBigInteger() {
            return this.v();
        }

        @Override
        public void writeTo(Packer packer) {
            packer.packBigInteger(this.v());
        }

        public BigIntegerValue copy(BigInteger v) {
            return new BigIntegerValue(v);
        }

        public BigInteger copy$default$1() {
            return this.v();
        }

        public BigInteger _1() {
            return this.v();
        }
    }

    public static class BinaryValue
    extends RawValue
    implements Product,
    Serializable {
        private final byte[] v;
        private transient String decodedStringCache;

        public static BinaryValue apply(byte[] byArray) {
            return Value$BinaryValue$.MODULE$.apply(byArray);
        }

        public static BinaryValue fromProduct(Product product) {
            return Value$BinaryValue$.MODULE$.fromProduct(product);
        }

        public static BinaryValue unapply(BinaryValue binaryValue) {
            return Value$BinaryValue$.MODULE$.unapply(binaryValue);
        }

        public BinaryValue(byte[] v) {
            this.v = v;
            this.decodedStringCache = null;
        }

        public boolean canEqual(Object that) {
            return that instanceof BinaryValue;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "BinaryValue";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "v";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public byte[] v() {
            return this.v;
        }

        @Override
        public ValueType valueType() {
            return ValueType$BINARY$.MODULE$;
        }

        @Override
        public void writeTo(Packer packer) {
            packer.packBinaryHeader(this.v().length);
            packer.writePayload(this.v());
        }

        @Override
        public String toRawString() {
            BinaryValue binaryValue = this;
            synchronized (binaryValue) {
                BoxedUnit boxedUnit;
                if (this.decodedStringCache == null) {
                    this.decodedStringCache = Base64.getEncoder().encodeToString(this.v());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return this.decodedStringCache;
        }

        public boolean equals(Object obj) {
            Object object = obj;
            if (object instanceof BinaryValue) {
                BinaryValue other = (BinaryValue)object;
                return Predef$.MODULE$.wrapByteArray(this.v()).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(other.v()));
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.v());
        }

        public BinaryValue copy(byte[] v) {
            return new BinaryValue(v);
        }

        public byte[] copy$default$1() {
            return this.v();
        }

        public byte[] _1() {
            return this.v();
        }
    }

    public static class BooleanValue
    implements Value,
    Product,
    Serializable {
        private final boolean v;

        public static BooleanValue apply(boolean bl) {
            return Value$BooleanValue$.MODULE$.apply(bl);
        }

        public static BooleanValue fromProduct(Product product) {
            return Value$BooleanValue$.MODULE$.fromProduct(product);
        }

        public static BooleanValue unapply(BooleanValue booleanValue) {
            return Value$BooleanValue$.MODULE$.unapply(booleanValue);
        }

        public BooleanValue(boolean v) {
            this.v = v;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.v() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BooleanValue)) return false;
            BooleanValue booleanValue = (BooleanValue)object;
            if (this.v() != booleanValue.v()) return false;
            if (!booleanValue.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof BooleanValue;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "BooleanValue";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToBoolean((boolean)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "v";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean v() {
            return this.v;
        }

        @Override
        public String toJson() {
            if (this.v()) {
                return "true";
            }
            return "false";
        }

        @Override
        public ValueType valueType() {
            return ValueType$BOOLEAN$.MODULE$;
        }

        @Override
        public void writeTo(Packer packer) {
            packer.packBoolean(this.v());
        }

        public BooleanValue copy(boolean v) {
            return new BooleanValue(v);
        }

        public boolean copy$default$1() {
            return this.v();
        }

        public boolean _1() {
            return this.v();
        }
    }

    public static class DoubleValue
    implements Value,
    Product,
    Serializable {
        private final double v;

        public static DoubleValue apply(double d) {
            return Value$DoubleValue$.MODULE$.apply(d);
        }

        public static DoubleValue fromProduct(Product product) {
            return Value$DoubleValue$.MODULE$.fromProduct(product);
        }

        public static DoubleValue unapply(DoubleValue doubleValue) {
            return Value$DoubleValue$.MODULE$.unapply(doubleValue);
        }

        public DoubleValue(double v) {
            this.v = v;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.v()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DoubleValue)) return false;
            DoubleValue doubleValue = (DoubleValue)object;
            if (this.v() != doubleValue.v()) return false;
            if (!doubleValue.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof DoubleValue;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DoubleValue";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToDouble((double)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "v";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double v() {
            return this.v;
        }

        @Override
        public String toJson() {
            if (Predef$.MODULE$.double2Double(this.v()).isNaN() || Predef$.MODULE$.double2Double(this.v()).isInfinite()) {
                return "null";
            }
            return BoxesRunTime.boxToDouble((double)this.v()).toString();
        }

        @Override
        public ValueType valueType() {
            return ValueType$FLOAT$.MODULE$;
        }

        @Override
        public void writeTo(Packer packer) {
            packer.packDouble(this.v());
        }

        public DoubleValue copy(double v) {
            return new DoubleValue(v);
        }

        public double copy$default$1() {
            return this.v();
        }

        public double _1() {
            return this.v();
        }
    }

    public static class ExtensionValue
    implements Value,
    Product,
    Serializable {
        private final byte extType;
        private final byte[] v;

        public static ExtensionValue apply(byte by, byte[] byArray) {
            return Value$ExtensionValue$.MODULE$.apply(by, byArray);
        }

        public static ExtensionValue fromProduct(Product product) {
            return Value$ExtensionValue$.MODULE$.fromProduct(product);
        }

        public static ExtensionValue unapply(ExtensionValue extensionValue) {
            return Value$ExtensionValue$.MODULE$.unapply(extensionValue);
        }

        public ExtensionValue(byte extType, byte[] v) {
            this.extType = extType;
            this.v = v;
        }

        public boolean canEqual(Object that) {
            return that instanceof ExtensionValue;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ExtensionValue";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToByte((byte)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "extType";
            }
            if (1 == n2) {
                return "v";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public byte extType() {
            return this.extType;
        }

        public byte[] v() {
            return this.v;
        }

        @Override
        public String toJson() {
            String base64 = Base64.getEncoder().encodeToString(this.v());
            return new java.lang.StringBuilder(5).append("[").append(this.extType()).append(",\"").append(base64).append("\"]").toString();
        }

        @Override
        public ValueType valueType() {
            return ValueType$EXTENSION$.MODULE$;
        }

        @Override
        public void writeTo(Packer packer) {
            packer.packExtensionTypeHeader(this.extType(), this.v().length);
            packer.writePayload(this.v());
        }

        public boolean equals(Object obj) {
            Object object = obj;
            if (object instanceof ExtensionValue) {
                ExtensionValue other = (ExtensionValue)object;
                return this.extType() == other.extType() && Predef$.MODULE$.wrapByteArray(this.v()).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(other.v()));
            }
            return false;
        }

        public int hashCode() {
            int h = this.extType() * 31 + Arrays.hashCode(this.v());
            return h;
        }

        public ExtensionValue copy(byte extType, byte[] v) {
            return new ExtensionValue(extType, v);
        }

        public byte copy$default$1() {
            return this.extType();
        }

        public byte[] copy$default$2() {
            return this.v();
        }

        public byte _1() {
            return this.extType();
        }

        public byte[] _2() {
            return this.v();
        }
    }

    public static interface IntegerValue
    extends Value {
        public static ValueType valueType$(IntegerValue $this) {
            return $this.valueType();
        }

        @Override
        default public ValueType valueType() {
            return ValueType$INTEGER$.MODULE$;
        }

        public boolean isValidByte();

        public boolean isValidShort();

        public boolean isValidInt();

        public boolean isValidLong();

        public static MessageFormat mostSuccinctMessageFormat$(IntegerValue $this) {
            return $this.mostSuccinctMessageFormat();
        }

        default public MessageFormat mostSuccinctMessageFormat() {
            if (this.isValidByte()) {
                return MessageFormat$INT8$.MODULE$;
            }
            if (this.isValidShort()) {
                return MessageFormat$INT16$.MODULE$;
            }
            if (this.isValidInt()) {
                return MessageFormat$INT32$.MODULE$;
            }
            return this.isValidLong() ? MessageFormat$INT64$.MODULE$ : MessageFormat$UINT64$.MODULE$;
        }
    }

    public static class LongValue
    implements Value,
    IntegerValue,
    Product,
    Serializable {
        private final long v;

        public static LongValue apply(long l) {
            return Value$LongValue$.MODULE$.apply(l);
        }

        public static LongValue fromProduct(Product product) {
            return Value$LongValue$.MODULE$.fromProduct(product);
        }

        public static LongValue unapply(LongValue longValue) {
            return Value$LongValue$.MODULE$.unapply(longValue);
        }

        public LongValue(long v) {
            this.v = v;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.v()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LongValue)) return false;
            LongValue longValue = (LongValue)object;
            if (this.v() != longValue.v()) return false;
            if (!longValue.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof LongValue;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "LongValue";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToLong((long)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "v";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long v() {
            return this.v;
        }

        @Override
        public String toJson() {
            return BoxesRunTime.boxToLong((long)this.v()).toString();
        }

        @Override
        public void writeTo(Packer packer) {
            packer.packLong(this.v());
        }

        @Override
        public boolean isValidByte() {
            return RichLong$.MODULE$.isValidByte$extension(Predef$.MODULE$.longWrapper(this.v()));
        }

        @Override
        public boolean isValidShort() {
            return RichLong$.MODULE$.isValidShort$extension(Predef$.MODULE$.longWrapper(this.v()));
        }

        @Override
        public boolean isValidInt() {
            return RichLong$.MODULE$.isValidInt$extension(Predef$.MODULE$.longWrapper(this.v()));
        }

        @Override
        public boolean isValidLong() {
            return RichLong$.MODULE$.isValidLong$extension(Predef$.MODULE$.longWrapper(this.v()));
        }

        public byte asByte() {
            if (this.isValidByte()) {
                return (byte)this.v();
            }
            throw MessageException$.MODULE$.overflowU64(this.v());
        }

        public short asShort() {
            if (this.isValidShort()) {
                return (short)this.v();
            }
            throw MessageException$.MODULE$.overflowU64(this.v());
        }

        public int asInt() {
            if (this.isValidInt()) {
                return (int)this.v();
            }
            throw MessageException$.MODULE$.overflowU64(this.v());
        }

        public long asLong() {
            return this.v();
        }

        public BigInteger asBigInteger() {
            return BigInteger.valueOf(this.v());
        }

        public LongValue copy(long v) {
            return new LongValue(v);
        }

        public long copy$default$1() {
            return this.v();
        }

        public long _1() {
            return this.v();
        }
    }

    public static class MapValue
    implements Value,
    Product,
    Serializable {
        private final Map entries;

        public static MapValue fromProduct(Product product) {
            return Value$MapValue$.MODULE$.fromProduct(product);
        }

        public static MapValue unapply(MapValue mapValue) {
            return Value$MapValue$.MODULE$.unapply(mapValue);
        }

        public MapValue(Map<Value, Value> entries) {
            this.entries = entries;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MapValue)) return false;
            MapValue mapValue = (MapValue)object;
            Map<Value, Value> map = this.entries();
            Map<Value, Value> map2 = mapValue.entries();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!mapValue.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof MapValue;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MapValue";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "entries";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<Value, Value> entries() {
            return this.entries;
        }

        public Value apply(Value key) {
            return (Value)this.entries().apply((Object)key);
        }

        public Option<Value> get(Value key) {
            return this.entries().get((Object)key);
        }

        public int size() {
            return this.entries().size();
        }

        public boolean isEmpty() {
            return this.entries().isEmpty();
        }

        public boolean nonEmpty() {
            return this.entries().nonEmpty();
        }

        @Override
        public String toJson() {
            return new java.lang.StringBuilder(2).append("{").append(((IterableOnceOps)this.entries().map((Function1 & Serializable)x -> new java.lang.StringBuilder(1).append(((Value)x._1()).toJson()).append(":").append(((Value)x._2()).toJson()).toString())).mkString(",")).append("}").toString();
        }

        @Override
        public ValueType valueType() {
            return ValueType$MAP$.MODULE$;
        }

        @Override
        public void writeTo(Packer packer) {
            packer.packMapHeader(this.entries().size());
            this.entries().toIndexedSeq().foreach((Function1)(JProcedure1 & Serializable)x -> {
                ((Value)x._1()).writeTo(packer);
                ((Value)x._2()).writeTo(packer);
            });
        }

        public MapValue copy(Map<Value, Value> entries) {
            return new MapValue(entries);
        }

        public Map<Value, Value> copy$default$1() {
            return this.entries();
        }

        public Map<Value, Value> _1() {
            return this.entries();
        }
    }

    public static abstract class RawValue
    implements Value {
        @Override
        public String toJson() {
            StringBuilder b = new StringBuilder();
            Value$.MODULE$.appendJsonString(b, this.toRawString());
            return b.result();
        }

        public abstract String toRawString();
    }

    public static class StringValue
    extends RawValue
    implements Product,
    Serializable {
        private final String v;

        public static StringValue apply(String string) {
            return Value$StringValue$.MODULE$.apply(string);
        }

        public static StringValue fromProduct(Product product) {
            return Value$StringValue$.MODULE$.fromProduct(product);
        }

        public static StringValue unapply(StringValue stringValue) {
            return Value$StringValue$.MODULE$.unapply(stringValue);
        }

        public StringValue(String v) {
            this.v = v;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StringValue)) return false;
            StringValue stringValue = (StringValue)object;
            String string = this.v();
            String string2 = stringValue.v();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!stringValue.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof StringValue;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "StringValue";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "v";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String v() {
            return this.v;
        }

        @Override
        public String toString() {
            return this.v();
        }

        @Override
        public String toRawString() {
            return this.v();
        }

        @Override
        public ValueType valueType() {
            return ValueType$STRING$.MODULE$;
        }

        @Override
        public void writeTo(Packer packer) {
            packer.packString(this.v());
        }

        public StringValue copy(String v) {
            return new StringValue(v);
        }

        public String copy$default$1() {
            return this.v();
        }

        public String _1() {
            return this.v();
        }
    }

    public static class TimestampValue
    implements Value,
    Product,
    Serializable {
        private final Instant v;

        public static TimestampValue apply(Instant instant) {
            return Value$TimestampValue$.MODULE$.apply(instant);
        }

        public static TimestampValue fromProduct(Product product) {
            return Value$TimestampValue$.MODULE$.fromProduct(product);
        }

        public static TimestampValue unapply(TimestampValue timestampValue) {
            return Value$TimestampValue$.MODULE$.unapply(timestampValue);
        }

        public TimestampValue(Instant v) {
            this.v = v;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TimestampValue)) return false;
            TimestampValue timestampValue = (TimestampValue)object;
            Instant instant = this.v();
            Instant instant2 = timestampValue.v();
            if (instant == null) {
                if (instant2 != null) {
                    return false;
                }
            } else if (!((Object)instant).equals(instant2)) return false;
            if (!timestampValue.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof TimestampValue;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "TimestampValue";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "v";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Instant v() {
            return this.v;
        }

        @Override
        public String toJson() {
            StringBuilder b = new StringBuilder();
            Value$.MODULE$.appendJsonString(b, this.toRawString());
            return b.result();
        }

        public String toRawString() {
            return this.v().toString();
        }

        @Override
        public ValueType valueType() {
            return ValueType$EXTENSION$.MODULE$;
        }

        @Override
        public void writeTo(Packer packer) {
            packer.packTimestamp(this.v());
        }

        public TimestampValue copy(Instant v) {
            return new TimestampValue(v);
        }

        public Instant copy$default$1() {
            return this.v();
        }

        public Instant _1() {
            return this.v();
        }
    }
}

