/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.msgpack.spi;

import wvlet.airframe.msgpack.spi.Buffer;
import wvlet.airframe.msgpack.spi.Compat$;
import wvlet.airframe.msgpack.spi.ReadBuffer;

public interface WriteBuffer
extends Buffer {
    public int writeByte(int var1, byte var2);

    public int writeShort(int var1, short var2);

    public int writeInt(int var1, int var2);

    public int writeLong(int var1, long var2);

    public static int writeFloat$(WriteBuffer $this, int position, float v) {
        return $this.writeFloat(position, v);
    }

    default public int writeFloat(int position, float v) {
        return this.writeInt(position, Compat$.MODULE$.floatToIntBits(v));
    }

    public static int writeDouble$(WriteBuffer $this, int position, double v) {
        return $this.writeDouble(position, v);
    }

    default public int writeDouble(int position, double v) {
        return this.writeLong(position, Compat$.MODULE$.doubleToLongBits(v));
    }

    public static int writeBytes$(WriteBuffer $this, int position, byte[] src) {
        return $this.writeBytes(position, src);
    }

    default public int writeBytes(int position, byte[] src) {
        return this.writeBytes(position, src, 0, src.length);
    }

    public int writeBytes(int var1, byte[] var2, int var3, int var4);

    public int writeBytes(int var1, ReadBuffer var2, int var3, int var4);

    public static int writeByteAndByte$(WriteBuffer $this, int position, byte b, byte v) {
        return $this.writeByteAndByte(position, b, v);
    }

    default public int writeByteAndByte(int position, byte b, byte v) {
        this.ensureCapacity(position, 2);
        this.writeByte(position, b);
        return 1 + this.writeByte(position + 1, v);
    }

    public static int writeByteAndShort$(WriteBuffer $this, int position, byte b, short v) {
        return $this.writeByteAndShort(position, b, v);
    }

    default public int writeByteAndShort(int position, byte b, short v) {
        this.ensureCapacity(position, 2);
        this.writeByte(position, b);
        return 1 + this.writeShort(position + 1, v);
    }

    public static int writeByteAndInt$(WriteBuffer $this, int position, byte b, int v) {
        return $this.writeByteAndInt(position, b, v);
    }

    default public int writeByteAndInt(int position, byte b, int v) {
        this.ensureCapacity(position, 5);
        this.writeByte(position, b);
        return 1 + this.writeInt(position + 1, v);
    }

    public static int writeByteAndLong$(WriteBuffer $this, int position, byte b, long v) {
        return $this.writeByteAndLong(position, b, v);
    }

    default public int writeByteAndLong(int position, byte b, long v) {
        this.ensureCapacity(position, 9);
        this.writeByte(position, b);
        return 1 + this.writeLong(position + 1, v);
    }

    public static int writeByteAndFloat$(WriteBuffer $this, int position, byte b, float v) {
        return $this.writeByteAndFloat(position, b, v);
    }

    default public int writeByteAndFloat(int position, byte b, float v) {
        return this.writeByteAndInt(position, b, Compat$.MODULE$.floatToIntBits(v));
    }

    public static int writeByteAndDouble$(WriteBuffer $this, int position, byte b, double v) {
        return $this.writeByteAndDouble(position, b, v);
    }

    default public int writeByteAndDouble(int position, byte b, double v) {
        return this.writeByteAndLong(position, b, Compat$.MODULE$.doubleToLongBits(v));
    }
}

