/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.control;

import java.io.Serializable;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class CommandLineTokenizer$
implements LoggingMethods,
LazyLogger,
LogSupport,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(CommandLineTokenizer$.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private static final Regex DOUBLE_QUOTED_LITERAL;
    private static final Regex SINGLE_QUOTED_LITERAL;
    private static final Regex REGULAR_TOKEN;
    public static final CommandLineTokenizer$ MODULE$;

    private CommandLineTokenizer$() {
    }

    static {
        MODULE$ = new CommandLineTokenizer$();
        DOUBLE_QUOTED_LITERAL = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"([^\"\\p{Cntrl}\\\\]|\\\\[\\\\/\\\\\"bfnrt]|\\\\u[a-fA-F0-9]{4})*\""));
        SINGLE_QUOTED_LITERAL = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("'([^'\\p{Cntrl}\\\\]|\\\\[\\\\/\\\\\"bfnrt]|\\\\u[a-fA-F0-9]{4})*'"));
        REGULAR_TOKEN = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([^\\\"'\\s]+)"));
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CommandLineTokenizer$.class);
    }

    private String unquote(String s) {
        return s.substring(1, s.length() - 1);
    }

    public String[] tokenize(String line) {
        return (String[])this.parse(0, line).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    private List<String> parse(int pos, String line) {
        IntRef cursor = IntRef.create((int)pos);
        this.skipWhiteSpaces$1(line, cursor);
        if (cursor.elem >= line.length()) {
            return package$.MODULE$.Nil();
        }
        char ch = line.charAt(cursor.elem);
        char c = ch;
        if ('\'' == c) {
            Option option = SINGLE_QUOTED_LITERAL.findPrefixMatchOf((CharSequence)line.substring(cursor.elem));
            if (option instanceof Some) {
                Regex.Match m = (Regex.Match)((Some)option).value();
                String token = m.matched();
                String string = this.unquote(token);
                return this.parse(cursor.elem + token.length(), line).$colon$colon((Object)string);
            }
            if (None$.MODULE$.equals(option)) {
                return this.parseToken$1(pos, line, cursor);
            }
            throw new MatchError((Object)option);
        }
        if ('\"' == c) {
            Option option = DOUBLE_QUOTED_LITERAL.findPrefixMatchOf((CharSequence)line.substring(cursor.elem));
            if (option instanceof Some) {
                Regex.Match m = (Regex.Match)((Some)option).value();
                String token = m.matched();
                String string = this.unquote(token);
                return this.parse(cursor.elem + token.length(), line).$colon$colon((Object)string);
            }
            if (None$.MODULE$.equals(option)) {
                return this.parseToken$1(pos, line, cursor);
            }
            throw new MatchError((Object)option);
        }
        return this.parseToken$1(pos, line, cursor);
    }

    private final void skipWhiteSpaces$1(String line$1, IntRef cursor$1) {
        boolean toContinue = true;
        block3: while (toContinue && cursor$1.elem < line$1.length()) {
            char ch;
            char c = ch = line$1.charAt(cursor$1.elem);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    int n;
                    cursor$1.elem = n = cursor$1.elem + 1;
                    continue block3;
                }
            }
            toContinue = false;
        }
    }

    private final List parseToken$1(int pos$1, String line$2, IntRef cursor$2) {
        Option option = REGULAR_TOKEN.findPrefixMatchOf((CharSequence)line$2.substring(cursor$2.elem));
        if (option instanceof Some) {
            Regex.Match m = (Regex.Match)((Some)option).value();
            String token = m.matched();
            return this.parse(cursor$2.elem + token.length(), line$2).$colon$colon((Object)token);
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Failed to parse token. pos:").append(pos$1).append("\n").append(line$2).toString());
        }
        throw new MatchError((Object)option);
    }
}

