/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.control;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicLong;
import scala.Array$;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction1;
import wvlet.airframe.control.HealthCheckPolicy;
import wvlet.airframe.control.util.ExponentialMovingAverage;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class HealthCheckPolicy$
implements LoggingMethods,
LazyLogger,
LogSupport,
Serializable {
    private volatile Object logger$lzy1;
    public static final HealthCheckPolicy$ MODULE$ = new HealthCheckPolicy$();

    private HealthCheckPolicy$() {
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, HealthCheckPolicy.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, HealthCheckPolicy.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, HealthCheckPolicy.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, HealthCheckPolicy.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HealthCheckPolicy$.class);
    }

    public HealthCheckPolicy alwaysHealthy() {
        return new HealthCheckPolicy(){

            public boolean isMarkedDead() {
                return false;
            }

            public void recordSuccess() {
            }

            public void recordFailure() {
            }

            public void recovered() {
            }
        };
    }

    public HealthCheckPolicy markDeadOnConsecutiveFailures(int numFailures) {
        return new HealthCheckPolicy(numFailures){
            private final int numFailures$1;
            private final AtomicLong consecutiveFailures;
            {
                this.numFailures$1 = numFailures$5;
                this.consecutiveFailures = new AtomicLong(0L);
            }

            public boolean isMarkedDead() {
                return this.consecutiveFailures.get() >= (long)this.numFailures$1;
            }

            public void recordSuccess() {
                this.consecutiveFailures.set(0L);
            }

            public void recordFailure() {
                this.consecutiveFailures.incrementAndGet();
            }

            public void recovered() {
                this.consecutiveFailures.set(0L);
            }
        };
    }

    public HealthCheckPolicy markDeadOnRecentFailureRate(double failureRate, long timeWindowMillis) {
        return new HealthCheckPolicy(failureRate, timeWindowMillis){
            private final double failureRate$2;
            private final ExponentialMovingAverage failureRateEMA;
            {
                this.failureRate$2 = failureRate$1;
                this.failureRateEMA = new ExponentialMovingAverage(timeWindowMillis$1);
            }

            public boolean isMarkedDead() {
                return this.failureRateEMA.last() > this.failureRate$2;
            }

            public void recordSuccess() {
                this.failureRateEMA.update(System.currentTimeMillis(), 0.0);
            }

            public void recordFailure() {
                this.failureRateEMA.update(System.currentTimeMillis(), 1.0);
            }

            public void recovered() {
                this.failureRateEMA.reset();
            }
        };
    }

    public HealthCheckPolicy markDeadOnFailureThreshold(int numFailures, int numExecutions) {
        Predef$.MODULE$.require(numExecutions > 0, () -> this.markDeadOnFailureThreshold$$anonfun$1(numExecutions));
        Predef$.MODULE$.require(numFailures <= numExecutions, () -> this.markDeadOnFailureThreshold$$anonfun$2(numFailures, numExecutions));
        return new HealthCheckPolicy(numFailures, numExecutions){
            private final int numFailures$4;
            private final int numExecutions$4;
            private final long[] executionHistory;
            private long executionCount;
            {
                this.numFailures$4 = numFailures$3;
                this.numExecutions$4 = numExecutions$3;
                int arraySize = (numExecutions$3 + 64 - 1) / 64;
                this.executionHistory = (long[])Array$.MODULE$.fill(arraySize, HealthCheckPolicy$::wvlet$airframe$control$HealthCheckPolicy$$anon$4$$_$$lessinit$greater$$anonfun$1, ClassTag$.MODULE$.apply(Long.TYPE));
                this.executionCount = 0L;
            }

            private int failureCount() {
                Object object = Predef$.MODULE$.longArrayOps(this.executionHistory);
                return BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(object, (Function1)((JFunction1.mcIJ.sp & Serializable)HealthCheckPolicy$::wvlet$airframe$control$HealthCheckPolicy$$anon$4$$_$failureCount$$anonfun$1), ClassTag$.MODULE$.apply(Integer.TYPE))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }

            public boolean isMarkedDead() {
                if (this.executionCount < (long)this.numExecutions$4) {
                    return false;
                }
                return this.failureCount() >= this.numFailures$4;
            }

            private void setAndMove(boolean v) {
                int i = (int)(this.executionCount % (long)this.numExecutions$4);
                long mask = 1L << 63 - i % 64;
                if (v) {
                    int n = i / 64;
                    this.executionHistory[n] = this.executionHistory[n] | mask;
                } else {
                    int n = i / 64;
                    this.executionHistory[n] = this.executionHistory[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                }
                ++this.executionCount;
                if (this.executionCount < 0L) {
                    this.executionCount = Int$.MODULE$.int2long(this.numExecutions$4);
                    return;
                }
            }

            public void recordSuccess() {
                this.setAndMove(false);
            }

            public void recordFailure() {
                this.setAndMove(true);
            }

            public void recovered() {
                this.executionCount = 0L;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{wvlet$airframe$control$HealthCheckPolicy$$anon$4$$_$$lessinit$greater$$anonfun$1(), wvlet$airframe$control$HealthCheckPolicy$$anon$4$$_$failureCount$$anonfun$1(long )}, serializedLambda);
            }
        };
    }

    private final Object markDeadOnFailureThreshold$$anonfun$1(int numExecutions$1) {
        return new StringBuilder(38).append("numExecusions ").append(numExecutions$1).append(" should be larger than 0").toString();
    }

    private final Object markDeadOnFailureThreshold$$anonfun$2(int numFailures$2, int numExecutions$2) {
        return new StringBuilder(47).append("numFailures ").append(numFailures$2).append(" should be less than numExections(").append(numExecutions$2).append(")").toString();
    }

    public static final long wvlet$airframe$control$HealthCheckPolicy$$anon$4$$_$$lessinit$greater$$anonfun$1() {
        return 0L;
    }

    public static final /* synthetic */ int wvlet$airframe$control$HealthCheckPolicy$$anon$4$$_$failureCount$$anonfun$1(long _$1) {
        return Long.bitCount(_$1);
    }
}

