/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.control;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction1;
import wvlet.airframe.control.Parallel;
import wvlet.airframe.control.Parallel$ParallelExecutionStats$;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource$;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Parallel$
implements LoggingMethods,
LazyLogger,
LogSupport,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Parallel$.class.getDeclaredField("logger$lzy2"));
    private volatile Object logger$lzy2;
    private static final Parallel.ParallelExecutionStats stats;
    public static final Parallel$ParallelExecutionStats$ ParallelExecutionStats;
    public static final Parallel$ MODULE$;

    private Parallel$() {
    }

    static {
        MODULE$ = new Parallel$();
        stats = new Parallel.ParallelExecutionStats(Parallel$ParallelExecutionStats$.MODULE$.$lessinit$greater$default$1(), Parallel$ParallelExecutionStats$.MODULE$.$lessinit$greater$default$2(), Parallel$ParallelExecutionStats$.MODULE$.$lessinit$greater$default$3(), Parallel$ParallelExecutionStats$.MODULE$.$lessinit$greater$default$4());
    }

    public Logger logger() {
        Object object = this.logger$lzy2;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT2();
    }

    private Object logger$lzyINIT2() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy2) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy2;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Parallel$.class);
    }

    public void break() {
        throw new Parallel.BreakException();
    }

    public Parallel.ParallelExecutionStats stats() {
        return stats;
    }

    public <T, R> Seq<R> run(Seq<T> source, int parallelism, Function1<T, R> f, ClassTag<R> evidence$1) {
        Seq seq;
        String executionId = UUID.randomUUID().toString();
        Parallel$ LoggingMethods_this = this;
        if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
            LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.TRACE$.MODULE$, LogSource$.MODULE$.apply("", "Parallel.scala", 74, 78), (Object)new StringBuilder(38).append(executionId).append(" - Begin Parallel.run (parallelism = ").append(parallelism).append(")").toString());
        }
        LinkedBlockingQueue<Parallel.Worker> requestQueue = new LinkedBlockingQueue<Parallel.Worker>(parallelism);
        LinkedBlockingQueue resultQueue = new LinkedBlockingQueue();
        AtomicBoolean interrupted = new AtomicBoolean(false);
        package$.MODULE$.Range().apply(0, parallelism).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Parallel.Worker worker = new Parallel.Worker(executionId, BoxesRunTime.boxToInteger((int)i).toString(), requestQueue, resultQueue, interrupted, f);
            requestQueue.put(worker);
        });
        ExecutorService executor = Executors.newFixedThreadPool(parallelism);
        this.stats().totalThreads().addAndGet(Int$.MODULE$.int2long(parallelism));
        try {
            try {
                Iterator it = source.iterator();
                while (it.hasNext() && !interrupted.get()) {
                    Parallel.Worker worker = (Parallel.Worker)requestQueue.take();
                    if (!interrupted.get()) {
                        worker.message().set(it.next());
                        executor.execute(worker);
                        continue;
                    }
                    requestQueue.put(worker);
                }
                while (requestQueue.size() != parallelism) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                seq = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(resultQueue).asScala().flatten(Predef$.MODULE$.$conforms())).toSeq();
            }
            catch (InterruptedException interruptedException) {
                throw new TimeoutException();
            }
        }
        finally {
            executor.shutdown();
            requestQueue.clear();
            this.stats().totalThreads().addAndGet(Int$.MODULE$.int2long(parallelism * -1));
        }
        return seq;
    }

    public int run$default$2() {
        return Runtime.getRuntime().availableProcessors();
    }

    public <T, R> Iterator<R> iterate(Iterator<T> source, int parallelism, Function1<T, R> f) {
        String executionId = UUID.randomUUID().toString();
        Parallel$ LoggingMethods_this = this;
        if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
            LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.TRACE$.MODULE$, LogSource$.MODULE$.apply("", "Parallel.scala", 139, 82), (Object)new StringBuilder(42).append(executionId).append(" - Begin Parallel.iterate (parallelism = ").append(parallelism).append(")").toString());
        }
        LinkedBlockingQueue requestQueue = new LinkedBlockingQueue(parallelism);
        LinkedBlockingQueue resultQueue = new LinkedBlockingQueue();
        AtomicBoolean interrupted = new AtomicBoolean(false);
        package$.MODULE$.Range().apply(0, parallelism).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Parallel.Worker worker = new Parallel.Worker(executionId, BoxesRunTime.boxToInteger((int)i).toString(), requestQueue, resultQueue, interrupted, f);
            requestQueue.put(worker);
        });
        new Thread(source, parallelism, requestQueue, resultQueue, interrupted){
            private final Iterator source$1;
            private final int parallelism$1;
            private final LinkedBlockingQueue requestQueue$3;
            private final LinkedBlockingQueue resultQueue$3;
            private final AtomicBoolean interrupted$3;
            {
                this.source$1 = source$2;
                this.parallelism$1 = parallelism$2;
                this.requestQueue$3 = requestQueue$4;
                this.resultQueue$3 = resultQueue$4;
                this.interrupted$3 = interrupted$4;
            }

            public void run() {
                ExecutorService executor = Executors.newFixedThreadPool(this.parallelism$1);
                Parallel$.MODULE$.stats().totalThreads().addAndGet(Int$.MODULE$.int2long(this.parallelism$1));
                try {
                    try {
                        while (this.source$1.hasNext() && !this.interrupted$3.get()) {
                            Parallel.Worker worker = (Parallel.Worker)this.requestQueue$3.take();
                            if (!this.interrupted$3.get()) {
                                worker.message().set(this.source$1.next());
                                executor.execute(worker);
                                continue;
                            }
                            this.requestQueue$3.put(worker);
                        }
                        while (this.requestQueue$3.size() != this.parallelism$1) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        throw new TimeoutException();
                    }
                }
                finally {
                    this.resultQueue$3.put(None$.MODULE$);
                    executor.shutdown();
                    this.requestQueue$3.clear();
                    Parallel$.MODULE$.stats().totalThreads().addAndGet(Int$.MODULE$.int2long(this.parallelism$1 * -1));
                }
            }
        }.start();
        return new Parallel.ResultIterator(resultQueue);
    }

    public int iterate$default$2() {
        return Runtime.getRuntime().availableProcessors();
    }
}

