/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.control.util;

import scala.math.package$;
import scala.runtime.Scala3RunTime$;

public class ExponentialMovingAverage {
    private final long windowSize;
    private long time;
    private volatile double ema;

    public ExponentialMovingAverage(long windowSize) {
        this.windowSize = windowSize;
        this.time = Long.MIN_VALUE;
        this.ema = 0.0;
    }

    public double update(long timeStamp, double x) {
        double newEma;
        if (this.time == Long.MIN_VALUE) {
            this.time = timeStamp;
            this.ema = x;
            return x;
        }
        long td = timeStamp - this.time;
        if (td < 0L) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"Nonmonotonic timestamp");
        }
        this.time = timeStamp;
        double w = (double)this.windowSize == 0.0 ? 0.0 : package$.MODULE$.exp(-((double)td) / (double)this.windowSize);
        this.ema = newEma = x * (1.0 - w) + this.ema * w;
        return newEma;
    }

    public double last() {
        return this.ema;
    }

    public void reset() {
        this.time = Long.MIN_VALUE;
        this.ema = 0.0;
    }
}

