/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.concurrent.Map;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ReusableBuilder;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import wvlet.airframe.http.HttpAccessLogWriter;
import wvlet.airframe.http.HttpAccessLogWriter$JSONHttpAccessLogWriter$;
import wvlet.airframe.http.HttpContext;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpServerException;
import wvlet.airframe.http.internal.RPCCallContext;
import wvlet.airframe.surface.MethodParameter;
import wvlet.airframe.surface.Parameter;
import wvlet.airframe.surface.Surface;
import wvlet.airframe.surface.TypeName$;
import wvlet.airframe.ulid.ULID;
import wvlet.log.LogTimestampFormatter$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class HttpAccessLogWriter$
implements Serializable {
    public static final HttpAccessLogWriter$JSONHttpAccessLogWriter$ JSONHttpAccessLogWriter;
    private static final Map<String, String> headerSanitizeCache;
    public static final HttpAccessLogWriter$ MODULE$;

    private HttpAccessLogWriter$() {
    }

    static {
        MODULE$ = new HttpAccessLogWriter$();
        headerSanitizeCache = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpAccessLogWriter$.class);
    }

    public HttpAccessLogWriter.JSONHttpAccessLogWriter default() {
        return new HttpAccessLogWriter.JSONHttpAccessLogWriter(HttpAccessLogWriter$JSONHttpAccessLogWriter$.MODULE$.$lessinit$greater$default$1());
    }

    public HttpAccessLogWriter.InMemoryAccessLogWriter inMemoryLogWriter() {
        return new HttpAccessLogWriter.InMemoryAccessLogWriter();
    }

    public ListMap<String, Object> errorLog(Throwable e) {
        BoxedUnit boxedUnit;
        ReusableBuilder m = ListMap$.MODULE$.newBuilder();
        Throwable throwable = this.findCause$1(e);
        if (throwable == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else if (throwable instanceof HttpServerException) {
            HttpServerException se = (HttpServerException)throwable;
            if (se.getCause() != null) {
                Throwable rootCause = this.findCause$1(se.getCause());
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"exception");
                m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)rootCause));
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"exception_message");
                m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)rootCause.getMessage()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            Throwable other = throwable;
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"exception");
            m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)other));
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"exception_message");
            boxedUnit = m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)other.getMessage()));
        }
        return (ListMap)m.result();
    }

    public ListMap<String, Object> rpcLog(RPCCallContext rpcContext) {
        ReusableBuilder m = ListMap$.MODULE$.newBuilder();
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"rpc_interface");
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)TypeName$.MODULE$.sanitizeTypeName(rpcContext.rpcInterfaceName())));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"rpc_class");
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)rpcContext.rpcMethodSurface().owner().fullName()));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"rpc_method");
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)rpcContext.rpcMethodSurface().name()));
        ListMap<String, Object> rpcArgs = this.extractRpcArgLog(rpcContext);
        if (rpcArgs.nonEmpty()) {
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"rpc_args");
            m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, rpcArgs));
        }
        return (ListMap)m.result();
    }

    public ListMap<String, Object> extractRpcArgLog(RPCCallContext rpcContext) {
        ReusableBuilder rpcArgsBuilder = ListMap$.MODULE$.newBuilder();
        ((IterableOps)rpcContext.rpcMethodSurface().args().zip(rpcContext.rpcArgs())).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                MethodParameter p = (MethodParameter)tuple2._1();
                Object arg = tuple2._2();
                return true;
            }
            return false;
        }).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                MethodParameter p = (MethodParameter)tuple2._1();
                Object arg = tuple2._2();
                return (ReusableBuilder)rpcArgsBuilder.$plus$plus$eq((IterableOnce)this.traverseParam$1((Parameter)p, arg));
            }
            throw new MatchError((Object)tuple2);
        });
        return (ListMap)rpcArgsBuilder.result();
    }

    public String sanitizeHeader(String h) {
        return (String)headerSanitizeCache.getOrElseUpdate((Object)h, () -> this.sanitizeHeader$$anonfun$1(h));
    }

    public String sanitize(String s) {
        return StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)x$1 -> this.sanitize$$anonfun$1(BoxesRunTime.unboxToChar((Object)x$1))).mkString();
    }

    public ListMap<String, Object> logUnixTime() {
        long currentTimeMillis = System.currentTimeMillis();
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"time");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToLong((long)(currentTimeMillis / 1000L)));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"event_time");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)LogTimestampFormatter$.MODULE$.formatTimestampWithNoSpaace(currentTimeMillis));
        return (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private final Throwable findCause$1(Throwable e) {
        while (true) {
            ExecutionException ee;
            InvocationTargetException i;
            Throwable throwable;
            if ((throwable = e) instanceof InvocationTargetException && (i = (InvocationTargetException)throwable).getTargetException() != null) {
                e = i.getTargetException();
                continue;
            }
            if (!(throwable instanceof ExecutionException) || (ee = (ExecutionException)throwable).getCause() == null) break;
            e = ee.getCause();
        }
        return e;
    }

    private final ReusableBuilder traverseObject$1$$anonfun$1$$anonfun$1(Object arg$2, ReusableBuilder builder$2, Parameter p$1) {
        return (ReusableBuilder)builder$2.$plus$plus$eq((IterableOnce)this.traverseParam$1(p$1, p$1.get(arg$2)));
    }

    private final ListMap traverseObject$1(Surface s, Object arg) {
        ReusableBuilder builder = ListMap$.MODULE$.newBuilder();
        s.params().foreach((Function1 & Serializable)p -> Try$.MODULE$.apply(() -> this.traverseObject$1$$anonfun$1$$anonfun$1(arg, builder, p)));
        return (ListMap)builder.result();
    }

    private final ListMap traverseParam$1(Parameter p, Object arg) {
        Object object = arg;
        if (object instanceof HttpMessage.Request) {
            HttpMessage.Request r = (HttpMessage.Request)object;
            return ListMap$.MODULE$.empty();
        }
        Object r = object;
        String string = p.surface().fullName();
        String string2 = "com.twitter.finagle.http.Request";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return ListMap$.MODULE$.empty();
        }
        if (object instanceof HttpContext) {
            HttpContext c = (HttpContext)object;
            return ListMap$.MODULE$.empty();
        }
        if (p.isSecret()) {
            return ListMap$.MODULE$.empty();
        }
        if (object instanceof ULID) {
            ULID u = (ULID)object;
            Object[] objectArray = new Tuple2[1];
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)p.name());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)u);
            return (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (p.surface().params().length() > 0) {
            Object[] objectArray = new Tuple2[1];
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)p.name());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)this.traverseObject$1(p.surface(), arg));
            return (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        Object[] objectArray = new Tuple2[1];
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)p.name());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, arg);
        return (ListMap)ListMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private final String sanitizeHeader$$anonfun$1(String h$1) {
        return h$1.replaceAll("-", "_").toLowerCase(Locale.ENGLISH);
    }

    private final /* synthetic */ Object sanitize$$anonfun$1(char x$1) {
        char c = x$1;
        switch (c) {
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
        }
        char c2 = c;
        return BoxesRunTime.boxToCharacter((char)c2);
    }
}

