/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import wvlet.airframe.codec.MessageCodec;
import wvlet.airframe.codec.MessageCodec$;
import wvlet.airframe.control.Retry;
import wvlet.airframe.control.Retry$;
import wvlet.airframe.http.HttpClient;
import wvlet.airframe.http.HttpClientException$;
import wvlet.airframe.http.HttpMultiMap;
import wvlet.airframe.http.HttpMultiMap$;
import wvlet.airframe.http.HttpRequestAdapter;
import wvlet.airframe.http.HttpResponseAdapter;
import wvlet.airframe.http.package$;
import wvlet.airframe.json.JSON;
import wvlet.airframe.surface.Surface;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource$;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class HttpClient$
implements LoggingMethods,
LazyLogger,
LogSupport,
Serializable {
    private volatile Object logger$lzy1;
    public static final HttpClient$ MODULE$ = new HttpClient$();

    private HttpClient$() {
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, HttpClient.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogger.logger$((LazyLogger)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, HttpClient.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, HttpClient.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, HttpClient.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpClient$.class);
    }

    public <Req, Resp> Retry.RetryContext baseHttpClientRetry(HttpRequestAdapter<Req> evidence$1, ClassTag<Req> evidence$2, HttpResponseAdapter<Resp> evidence$3) {
        return Retry$.MODULE$.withJitter(15, Retry$.MODULE$.withJitter$default$2(), Retry$.MODULE$.withJitter$default$3(), Retry$.MODULE$.withJitter$default$4()).withResultClassifier((Function1 & Serializable)response -> HttpClientException$.MODULE$.classifyHttpResponse(response, evidence$3)).beforeRetry((Function1 & Serializable)ctx -> this.defaultBeforeRetryAction((Retry.RetryContext)ctx, evidence$1, evidence$2));
    }

    public <Req, Resp> Retry.RetryContext defaultHttpClientRetry(HttpRequestAdapter<Req> evidence$4, ClassTag<Req> evidence$5, HttpResponseAdapter<Resp> evidence$6) {
        return this.baseHttpClientRetry(evidence$4, evidence$5, evidence$6).withErrorClassifier((Function1 & Serializable)ex -> HttpClientException$.MODULE$.classifyExecutionFailure((Throwable)ex));
    }

    public <Req> Object defaultBeforeRetryAction(Retry.RetryContext ctx, HttpRequestAdapter<Req> evidence$7, ClassTag<Req> evidence$8) {
        String string;
        Object r;
        Class cls = ((ClassTag)Predef$.MODULE$.implicitly(evidence$8)).runtimeClass();
        Option option = ctx.context();
        if (option instanceof Some && cls.isAssignableFrom((r = ((Some)option).value()).getClass())) {
            HttpRequestAdapter adapter = (HttpRequestAdapter)Predef$.MODULE$.implicitly(evidence$7);
            Object req = r;
            String path = adapter.pathOf(req);
            string = new java.lang.StringBuilder(23).append("Request to ").append(path).append(" is failed: ").append(ctx.lastError().getMessage()).toString();
        } else {
            string = new java.lang.StringBuilder(19).append("Request is failed: ").append(ctx.lastError().getMessage()).toString();
        }
        String errorMessage = string;
        int nextWaitMillis = ctx.nextWaitMillis();
        HttpClient$ LoggingMethods_this = this;
        if (LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
            LoggingMethods_this.wvlet$log$LoggingMethods$$inline$logger().log((LogLevel)LogLevel.WARN$.MODULE$, LogSource$.MODULE$.apply("", "HttpClient.scala", 182, 5), (Object)StringOps$.MODULE$.format$extension("[%s/%s] %s. Retry the request in %.3f sec.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ctx.retryCount()), BoxesRunTime.boxToInteger((int)ctx.maxRetry()), errorMessage, BoxesRunTime.boxToDouble((double)((double)nextWaitMillis / 1000.0))})));
        }
        return BoxedUnit.UNIT;
    }

    public String urlEncode(String s) {
        return package$.MODULE$.compat().urlEncode(s);
    }

    public <Resource> String buildResourceUri(String path, Resource resource, Surface resourceSurface) {
        HttpMultiMap queryParams = this.flattenResourceToQueryParams(resource, resourceSurface);
        StringBuilder pathWithParams = new StringBuilder();
        pathWithParams.append(path);
        if (queryParams.nonEmpty()) {
            String queryParamString = ((IterableOnceOps)queryParams.entries().map((Function1 & Serializable)x -> new java.lang.StringBuilder(1).append(x.key()).append("=").append(x.value()).toString())).mkString("&");
            pathWithParams.append("?");
            pathWithParams.append(queryParamString);
        }
        return pathWithParams.result();
    }

    public <Resource> HttpMultiMap flattenResourceToQueryParams(Resource resource, Surface resourceSurface) {
        MessageCodec resourceCodec = MessageCodec$.MODULE$.ofSurface(resourceSurface);
        JSON.JSONObject resourceJson = (JSON.JSONObject)Try$.MODULE$.apply(() -> this.$anonfun$3(resource, resourceCodec)).getOrElse(this::$anonfun$4);
        HttpMultiMap.HttpMultiMapBuilder queryParams = HttpMultiMap$.MODULE$.newBuilder();
        resourceJson.v().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                JSON.JSONValue jSONValue = (JSON.JSONValue)tuple2._2();
                String k = string;
                if (jSONValue instanceof JSON.JSONArray) {
                    JSON.JSONArray jSONArray = JSON.JSONArray$.MODULE$.unapply((JSON.JSONArray)jSONValue);
                    IndexedSeq indexedSeq = jSONArray._1();
                    JSON.JSONArray j = (JSON.JSONArray)jSONValue;
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.urlEncode(k));
                    return queryParams.$plus$eq((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.urlEncode(j.toJSON())));
                }
                String k2 = string;
                if (jSONValue instanceof JSON.JSONObject) {
                    JSON.JSONObject jSONObject = JSON.JSONObject$.MODULE$.unapply((JSON.JSONObject)jSONValue);
                    Seq seq = jSONObject._1();
                    JSON.JSONObject j = (JSON.JSONObject)jSONValue;
                    String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.urlEncode(k2));
                    return queryParams.$plus$eq((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)this.urlEncode(j.toJSON())));
                }
                String k3 = string;
                JSON.JSONValue other = jSONValue;
                String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.urlEncode(k3));
                return queryParams.$plus$eq((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)this.urlEncode(other.toString())));
            }
            throw new MatchError((Object)tuple2);
        });
        return queryParams.result();
    }

    private final JSON.JSONObject $anonfun$3(Object resource$1, MessageCodec resourceCodec$1) {
        return resourceCodec$1.toJSONObject(resource$1);
    }

    private final JSON.JSONObject $anonfun$4() {
        return JSON.JSONObject$.MODULE$.empty();
    }
}

